<?php
/**
 * Template functions used for the site header.
 *
 * @package shop-isle
 */

if ( ! function_exists( 'shop_isle_primary_navigation' ) ) {
	/**
	 * Display Primary Navigation
	 * @since  1.0.0
	 * @return void
	 */
	function shop_isle_primary_navigation() {

		?>
		<!-- Navigation start -->
		<nav class="navbar navbar-custom navbar-transparent navbar-fixed-top" role="navigation">

			<div class="container">				
				
				<!-- Socials icons -->

				<?php	$shop_isle_socials = get_theme_mod('shop_isle_socials');

					if( !empty( $shop_isle_socials ) ):

						$shop_isle_socials_decoded = json_decode($shop_isle_socials);

						if( !empty($shop_isle_socials_decoded) ):

							echo '<div class="col-sm-12 col-md-12 col-xs-12 col-lg-12 social-contenedor">';

								echo '<div class="header-social-links">';

									foreach($shop_isle_socials_decoded as $shop_isle_social):

										if( !empty($shop_isle_social->icon_value) && !empty($shop_isle_social->link) ) {
									
											if (function_exists ( 'icl_t' ) && !empty($shop_isle_social->id)){


											
												$shop_isle_social_icon_value = icl_t( 'Social '.$shop_isle_social->id, 'Social icon', $shop_isle_social->icon_value );
												
												$shop_isle_social_link = icl_t( 'Social '.$shop_isle_social->id, 'Social link', $shop_isle_social->link );
												
												
												
												echo '<a href="'. esc_url( $shop_isle_social_link ) .'"><span class="'.esc_attr($shop_isle_social_icon_value).'"></span></a>';
												
											} else {
												
												echo '<a href="'.esc_url($shop_isle_social->link).'"><span class="'.esc_attr($shop_isle_social->icon_value).'"></span></a>';
											}
									
										}

									endforeach;

								echo '</div>';

							echo '</div>';

						endif;

					endif; ?>

					<!-- FIN Socials icons -->
				
				<div class="header-container">

					<div class="navbar-header">

						<div class="shop_isle_header_title">

							<div class="shop-isle-header-title-inner">

							<?php

							/* Logo */
							if ( function_exists( 'the_custom_logo' ) ) {
								the_custom_logo();
							} else {
								$shop_isle_logo = get_theme_mod( 'shop_isle_logo' );

								if( !empty( $shop_isle_logo ) ) {
									echo '<a href="' . esc_url( home_url( '/' ) ) . '" class="custom-logo">';
										echo '<img src="' . esc_url($shop_isle_logo) . '" alt="' . esc_attr( get_bloginfo( 'name', 'display' ) ) . '">';
									echo '</a>';
								}
							}

							/* Title */
							?>
							<div class="header-title-wrap">
								<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php echo esc_attr(get_bloginfo( 'name' )); ?></a></h1>
							</div>

							<?php
							/* Tagline */
							$description = get_bloginfo( 'description', 'display' );
							if ( !empty( $description ) ) {
								echo '<h2 class="site-description"><a href="' . esc_url( home_url( '/' ) ) . '" title="' . esc_attr( get_bloginfo( 'name', 'display' ) ) . '" rel="home">' . esc_attr( $description ) . '</a></h2>';
							}
							?>

							</div><!-- .shop-isle-header-title-inner -->

						</div><!-- .shop_isle_header_title -->

						<div type="button" class="navbar-toggle" data-toggle="collapse" data-target="#custom-collapse">
							<span class="sr-only"><?php _e('Toggle navigation','shop-isle'); ?></span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
							<span class="icon-bar"></span>
						</div>
					</div>

					<div class="header-menu-wrap">
						<div class="collapse navbar-collapse" id="custom-collapse">

							<?php wp_nav_menu( array('theme_location' => 'primary', 'container' => false, 'menu_class' => 'nav navbar-nav navbar-right') ); ?>

						</div>
					</div>

					<?php if( class_exists( 'WooCommerce' ) ): ?>
						
					<?php endif; ?>
	
				</div>
			</div>

		</nav>
		<!-- Navigation end -->
		<?php
	}
}