<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-account-dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author      WooThemes
 * @package     WooCommerce/Templates
 * @version     2.6.0
 */
$current_user = wp_get_current_user();

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>


	<?php
		echo '<h1 style="margin-top: 0px;font-size: 28px;text-transform: capitalize;color: #000;">Hola '; 
		echo $current_user->display_name . ', bienvenid@</h1>';

	?>


<p>
	<?php
		echo sprintf( esc_attr__( 'From your account dashboard you can view your %1$srecent orders%2$s, manage your %3$sshipping and billing addresses%2$s and %4$sedit your password and account details%2$s.', 'woocommerce' ), '<a href="' . esc_url( wc_get_endpoint_url( 'orders' ) ) . '">', '</a>', '<a href="' . esc_url( wc_get_endpoint_url( 'edit-address' ) ) . '">', '<a href="' . esc_url( wc_get_endpoint_url( 'edit-account' ) ) . '">' );

		echo '<h1 style="margin-top: 0px;font-size: 16px;color: #000;font-weight:bold">¿Quieres ver el estatus de uno de tus pedidos directamente?</h1>';
		echo  do_shortcode('[woocommerce_order_tracking]');

		


	?>

	<?php 
		echo "<div class='col-sm-12 col-xs-12 col-md-12 visit-recent'>";
		dynamic_sidebar('visitados'); 
		echo "</div>";
	?>
</p>

<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );
?>
