<?php

return apply_filters( 'ninja_forms_available_actions', array(

    'mailchimp' => array(
        'name' => "mailchimp",
        'nicename' => "MailChimp",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/mail-chimp/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=MailChimp",
        'plugin_path' => "ninja-forms-mail-chimp/ninja-forms-mail-chimp.php"
    ),

    'campaignmonitor' => array(
        'name' => "campaignmonitor",
        'nicename' => "Campaign Monitor",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/campaign-monitor/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Campaign+Monitor",
        'plugin_path' => "ninja-forms-campaign-monitor/ninja-forms-campaign-monitor.php"
    ),

    'constantcontact' => array(
        'name' => "constantcontact",
        'nicename' => "Constant Contact",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/constant-contact/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Constant+Contact",
        'plugin_path' => "ninja-forms-constant-contact/ninja-forms-constant-contact.php"
    ),

    'aweber' => array(
        'name' => "aweber",
        'nicename' => "AWeber",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/aweber/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=AWeber",
        'plugin_path' => "ninja-forms-aweber/ninja-forms-aweber.php"
    ),

    'emma' => array(
        'name' => "emma",
        'nicename:' => "Emma",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/emma/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Emma",
        'plugin_path' => ""
    ),

    'slack' => array(
        'name' => "slack",
        'nicename' => "Slack",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/slack/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Slack",
        'plugin_path' => "ninja-forms-slack/ninja-forms-slack.php"
    ),

    'createposts' => array(
        'name' => "createposts",
        'nicename:' => "Front-End Posting",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/front-end-posting/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Front-End+Posting",
        'plugin_path' => "ninja-forms-post-creation/ninja-forms-post-creation.php"
    ),

    'webhook' => array(
        'name' => "webhook",
        'nicename' => "WebHook",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/webhooks/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Webhooks",
        'plugin_path' => "ninja-forms-webhooks/ninja-forms-webhooks.php"
    ),

    'webmerge' => array(
        'name' => "webmerge",
        'nicename' => "WebMerge",
        'image' => "data:image/png;base64,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",
        'link' => "https://ninjaforms.com/extensions/webmerge/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=WebMerge",
        'plugin_path' => "ninja-forms-webmerge/ninja-forms-webmerge.php"
    ),

    // 'helpscout' => array(
    //     'name' => "helpscout",
    //     'nicename' => "Help Scout",
    //     'image' => "",
    //     'link' => "https://ninjaforms.com/extensions/help-scout/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Help+Scout",
    //     'plugin_path' => ""
    // ),

    'zapier' => array(
        'name' => "zapier",
        'nicename' => "Zapier",
        'image' => "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAr0AAABkCAMAAAC8VHgkAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyRpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoTWFjaW50b3NoKSIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDpBNUY2QkI1MDY4OTgxMUU2OTI1M0Y0QzVBODg4MzE2NCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo5M0VBRjlFMDY4OUMxMUU2OTI1M0Y0QzVBODg4MzE2NCI+IDx4bXBNTTpEZXJpdmVkRnJvbSBzdFJlZjppbnN0YW5jZUlEPSJ4bXAuaWlkOkE1RjZCQjRFNjg5ODExRTY5MjUzRjRDNUE4ODgzMTY0IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOkE1RjZCQjRGNjg5ODExRTY5MjUzRjRDNUE4ODgzMTY0Ii8+IDwvcmRmOkRlc2NyaXB0aW9uPiA8L3JkZjpSREY+IDwveDp4bXBtZXRhPiA8P3hwYWNrZXQgZW5kPSJyIj8+mYKAKwAAAYBQTFRF///9/0MA/+LV/7qe/0UA//Tu/866/zoA/0cF/2st/1AW/z4A/76k/6+O/9bG/4td//Ts/10j/7ec/2sy/14Z/8y1/3Q+/8Kp/7aV//n1/8Gk/93P/zwA/5Fm/0oJ/4JM/4VZ//Hr/3I5/5p1/+XZ/+nd/3I8/+7m/3xE/2Is//Pq/7GP/9zN/1YV/9G6/5Nu/9C+/205/8Wt//v4/1IS/0cG/3VB/14k/557/0wS//fz/6R+/1Ua/31M/6qI/6yF/4FR//Ls/5Vw/zMA/1oh/0wJ/5Zy/1kW/04O/zgA/+vh/93L/9/R/8uz/5Zw/6eD/08W/9fJ/9PA/0YC/0AC/0cA/0wA/0kA/0AA/0EA/0YA//37//Xw/0EB/9C9/97N/0kN//z7//z6/0sQ/9vM/9bA//Dn/8ey/45p/8mv/0IE//76/0cM/0cB/0ID//f0/6qN//bx/9jG/8m0/97O/7aU/8Wq/+zi//Dp/9O+/7KX/6eJ/5hs/6Bx/////0gAbGcZOAAABTpJREFUeNrs3f1TE0ccx/GsJK5lQag8KYYI5UGhijxHECk1YH2sWnq9XGjrQ1v7ZLVPttW2uX/dy0Eut5fV/NS5ven7MwMDzP6085rvfHezu+R8QrKaHFNA0EsIeq3OZw5zgF70EvSiF70EvehFL0Evegl60Ytegl70opegF70EvehFL3oJetFL0Ite9BL0ovd/r9dx8I7eLOpVUqogwXcEozdbep2fhq/d7Rod7flgcnu3xtShN0t6a6tH6oc5VRZMHXqzpfd0U+8v6EVvZvV+jl70ZkBv3umoN88sotdKvaoknA56vV12INBro165eGtSOm/T68rh3/skOxDotU2vI8cL9dzVJl+TXle+N1fPXVbCZSrRa5NeR47tB1Ijvga9Ad7+xu+vPmUVh16b9AZ4cwdWLx7wbdcbVt4wJxRrN/RapFeO7x9aPay+bXpdOTPX/MtWkd4XvdboVYvP61FCvkm9cbz1+phkMtFriV6xcrMl86D6JvQGbUMhPmRGMZvotUNvrdRVjyfgq+tN4K3f32Hhhl5bOgdRPVnXq29e0ytnNLzHu6tsmqHXmlWb+OKkXn1vHIvprcR7XvCi1zK9bXwvyvOR3u7Ffg3vPfCi1yq9Sb65q8ebP57te0LlRa/Ven3h6dX3VPOH5WXwotdyvW18jQEveq3U29b7ghe92dHbmS940Wut3qB5eNGiujH1zZ0780cK4EWvtXqdWFofWzzv2p69LryqKO2c+/lJE6/SRnPLAr0p6xVVLx4le8Ojkr0VJfKBT6cmVOVMiPfoUym0sXxajN509aor80Navh963NjuXVOtHkFsTjT0/vqHPnL+3ypTit409cq7xuXZX5uxwuqIl+Y1nKB3QG+aeosvjDBv7cXPnxdfGQfdLnHHAr0p6nXUkhHmUvz8rlu8ZBx0doXOF70p6q2JT4wwu7TT58Ux46CJC+hFr/16+8zNMXrRm67eBSPMHr1z+Bi96LWx7x0xwnwZ305wi38bB01dZ9WG3lT3HN43wpzWYL5haXd/j4vx6E1Tr5zM7Wv5caPxssPyrNcak9+dCs89PNZH1kd4kQ+9qerNr7yjp/xPeBh9rFLzw0/bXN+5MfAofEKnrI8cGKRxQG+qev28qsZTGfgz7ApOL5ZUsagaX3uzoweXLb6raGMVazb0pqxXi9u6+p6b6rnUd+bc+OSJ89EdoWuSVgG91uqVw4W3nk6HL3qt1SuH+zvcDIIvei3V2xkvfNFrqd5ObQN80Wut3gTehei/DU6MwBe9dutNPLT35Xr0ls7E5lbyhUmmEr026U30vAtfVaNX+Ao7spfqi1579Sbxrqtj0St8hXerKsmXAw7otUavt5ZoGzwnrlfkk3yfUX3Ra4lecWFOr7yeW9P0+km+a7z8j15L9Do/XNYqb9X1E3oDvvGjlL895IAOem3pHGqxQ+pB2+D6bXq16vvgnsdkotcWva54OqThbdcb4ztdVjxnhl579hzc6vrRqOf1jXojvtOzRfCi1yK9vus9XGpVXqPeQ74PykVmEr1W6Q2ah2dbUeU16w35fttN24Be2/QGfNWVzeh9XqNeV9S2Szzhi1779Daux4tIplFvY3OiBl702qg3njfoJehFL0Hvf6l3NTrf+6iMXvRmSq+z1/v19IcbG4Wbt0d4rgy92dLr+97qykeDg4MrJY/jkOjNml4nL8LkOQyJ3szpJehFL0EvetGLXoJe9BL0ohe9BL3oRS9BL3oJetGLXoJe9KKXoBe9BL3oRS96CXoJQS9BLyEZyGsBBgAPS3YMn0FstAAAAABJRU5ErkJggg==",
        'link' => "https://ninjaforms.com/extensions/zapier/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=Zapier",
        'plugin_path' => "ninja-forms-zapier/ninja-forms-zapier.php"
    ),

    'file_uploads' => array(
        'name' => 'file_uploads',
        'nicename' => 'File Uploads',
        'image' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAr0AAABkCAMAAAC8VHgkAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA2hpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDo4Qzc4MkQxNjE5MjA2ODExODIyQTk4MjE5QjQ0QjIwMCIgeG1wTU06RG9jdW1lbnRJRD0ieG1wLmRpZDo3QzIwMkJFNjZBMkIxMUU2ODI1NkZBMDNCQTEwMDA0QiIgeG1wTU06SW5zdGFuY2VJRD0ieG1wLmlpZDo3QzIwMkJFNTZBMkIxMUU2ODI1NkZBMDNCQTEwMDA0QiIgeG1wOkNyZWF0b3JUb29sPSJBZG9iZSBQaG90b3Nob3AgQ1M2IChNYWNpbnRvc2gpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6OEM3ODJEMTYxOTIwNjgxMTgyMkE5ODIxOUI0NEIyMDAiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6OEM3ODJEMTYxOTIwNjgxMTgyMkE5ODIxOUI0NEIyMDAiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz5E3J7mAAABgFBMVEX+8eP95s7//fv71q7++PH70qb6yZX2nDz84ML3p1H3sGL4sGT6zp/1mDX6y5j6yJL++vT3qlj3qFT+9u35wIL5wYX97t75vn/1mjj83Lv71av5xY34tW33rmD5v4D2nT785Mr70KL6zJv5w4n5wof4smf84sb4uXb3q1r838D//v396NL++fT2oUb1ljH97Nr//fz+9/D2oEP1lzL///796tb1mTb/+/j2oUX2n0L96dT969j++PL+8+f72bT97Nn5vXz4unf6xo7+9ev2n0P2nj/+8+j+7+D2n0H2o0n3rV32okj83bz5u3r//Pn71a32pU7969f2pEv4uHP5vHv96tX2okf6xY34uXX1mDP84sX6x5H/+/f72LL95cz97dv2mzv+9On+9ez++fP/+vb2oET4t3H72rX3rl/3qVb706n716/827j6z6H848j959D4s2n2o0r3rFv1mzr2nDv+9u796NH5xIv70aT96dP3qFP+8OH4tm/3rV7////1ljBnwlPSAAAD3UlEQVR42uzdV1MTUQCG4YCAITSlSJVQRCBRCAklkkLvvSNNuiL2rujJX7fAQGRLguycsxnf90453HzzTCbs7CaOGFGq5mACQi8ReonQS+glQi8ReonQS+glQi8Regm9ROglQi8Regm9ROglQi+hlwi9ROhNveb7Mp09J8OO0Fa00lXGHuhNmW4W12yIuE5yjxgFvSlRWaVDXC598i7DoNf+uTqEXp7MbbZBr81bTxcGddxmHfTaubxjYVx4lYHQa2O85cIsTykTode2HQvzfAtshF6bViASFc5mJfTasgZPQr3C28lO6LVh7hGRROunhz9MjLmZDL22KT8ZvCI8FouNFWzt7G/shjJ/sBp6bZG/LSm94mVnfsb5RYgXswyHXhu0khxe8fFr/L+KqlgOvcoLLBlxzXhihrkrh+3Qq7pCnwHP1tnAZzO+u/OMh17F3TPCO/Hrh/VmfMsZD72KixrgXTa1/bv2JtZDr9JavLoyQ8Gzn5eY8M1lPvQq7X1E96bI4PkBE77eFvZDr8pG9a72dhzEnShuN9I74GY/9KpsMKyD1//XEUO+e372Q6/Sdw5FGpTdl1FWG10QfsR+6FXZeIYG76DmULX+TWh38tgPveryP+/S/Cmm94Jaqsv3KQOiV10LwyIpvAZ8D1kQvcrSeaTCO2pwtlfL9xMXzNCrrDot3tdDhqd7NfdDVAyyIXoVVX8lvLHYoubVt638e4Ad0augBu2nj6S5TX9jalrrPe0ZS6JXetvah9kiiS7fVurd5tvPluiVnc7DbN5Ev/NG96rv8WPWRK/UDnRub/B8WW08rS/uuYnRvrP/bCw1eNYiyrUH9Eoty/wZtlcXJ8cTP/GWxZ7olVhngo9waL442pRYr8/FouiVl0tYqVf08EE76LXNG4er6hXFTIpeaTVbrHeO6w7olVarxXrbx9kUvbKKWKxXFLApemU1YLXeSTZFr6yGrdbbw6boldWI1XojbIpeWdVYrXeATdErqwpee9Gbsk1ZrTfEpuiV1cQ+1xzQm7I5zTE6L04eJaV3hUnRK61Dc4xtVcGHfwq+vZEMXg9fZYxeeeV1J/C49+C0/aReer08nYleieW0CwtbZFD0yizXQrzdfKAZeuW+d1izDG/XO+ZEr9yG5qzSW8KY6JXd8pI1eOuYEr3yc09agbeWIdGropb+W9e1W1TNjOhV1LfN6evY9W3yhZnoVVhhbmv6P9rdmeH7BtGruEB2b39tdO3+VXLO5Je43GyHXkIvEXqJ0EuEXkIvEXqJ0EuEXkIvEXqJ0EvoJUIvEXqJ0EvoJUIvEXrp/+2nAAMA9OFUh0mE0o0AAAAASUVORK5CYII=',
        'link' => 'https://ninjaforms.com/extensions/file-uploads/?utm_medium=plugin&utm_source=plugin&utm_campaign=Ninja+Forms+Actions+Drawer&utm_content=File+Uploads',
        'plugin_path' => 'ninja-forms-uploads/file-uploads.php'
    ),

) );
