<?php
/**
 * Main file
 */

/**
 * Initialize all the things. 
 */
require get_template_directory() . '/inc/init.php';

/**
 * Note: Do not add any custom code here. Please use a child theme so that your customizations aren't lost during updates.
 * http://codex.wordpress.org/Child_Themes
 */

function my_init() {
	
	wp_deregister_script('jquery'); 
	wp_register_script('jquery', 'https://ajax.googleapis.com/ajax/libs/jquery/2.2.4/jquery.min.js', false, '2.2.4');
	wp_enqueue_script('jquery');

	wp_deregister_script('modernizr'); 
	wp_register_script('modernizr', 'https://cdnjs.cloudflare.com/ajax/libs/modernizr/2.8.3/modernizr.min.js', false, '2.8.3');
	wp_enqueue_script('modernizr');

	wp_deregister_script('jquery-confirm'); 
	wp_register_script('jquery-confirm', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/2.5.1/jquery-confirm.min.js', false, '2.5.1');
	wp_enqueue_script('jquery-confirm');

}
add_action('init', 'my_init');

function ecommerce_scripts() {

	

	wp_enqueue_style( 'font-awesome', get_template_directory_uri() . '/assets/font-awesome/css/font-awesome.min.css' );

	wp_enqueue_style( 'jquery-confirm', get_template_directory_uri() . '/assets/jquery-confirm/dist/jquery-confirm.min.css' );

	//wp_enqueue_style( 'jquery-confirm', get_template_directory_uri() . '/assets/js/jquery-confirm.js', array('jquery'), '', true );

	wp_enqueue_script( 'scrollreveal', get_template_directory_uri() . '/assets/js/scrollreveal/scrollreveal.min.js', array('jquery'), '', true );

	wp_enqueue_script( 'funciones', get_template_directory_uri() . '/assets/js/funciones.js', array('jquery'), '', true );


	

}
add_action( 'wp_enqueue_scripts', 'ecommerce_scripts' );


function ecommerce_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'visitados', 'ecommerce' ),
		'id'            => 'visitados',
		'description'   => '',
		'before_widget' => '<div">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4>',
	) );



}
add_action( 'widgets_init', 'ecommerce_widgets_init' );

/**
 * Use WC 2.0 variable price format, now include sale price strikeout
 *
 * @param  string $price
 * @param  object $product
 * @return string
 */

function wc_wc20_variation_price_format( $price, $product ) {
    // Main Price
    $prices = array( $product->get_variation_price( 'min', true ), $product->get_variation_price( 'max', true ) );
    $price = $prices[0] !== $prices[1] ? sprintf( __( 'Desde: %1$s No incluye IVA', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );

    // Sale Price
    $prices = array( $product->get_variation_regular_price( 'min', true ), $product->get_variation_regular_price( 'max', true ) );
    sort( $prices );
    $saleprice = $prices[0] !== $prices[1] ? sprintf( __( 'Desde: %1$s No incluye IVA', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );

    if ( $price !== $saleprice ) {
        $price = '<del>' . $saleprice . '</del> <ins>' . $price . '</ins>';
    }
    
    return $price;
}
add_filter( 'woocommerce_variable_sale_price_html', 'wc_wc20_variation_price_format', 10, 2 );
add_filter( 'woocommerce_variable_price_html', 'wc_wc20_variation_price_format', 10, 2 );


