<?php

/**
 * Template Name: Frontpage-2
 */
	get_header();

	/* Wrapper start */
	echo '<div class="main inicio-2">';

	$big_title = get_template_directory() . '/inc/big-title-section.php';

	load_template ( apply_filters( 'shop-isle-subheader', $big_title ) );

	/* Wrapper start */

	$shop_isle_bg = get_theme_mod('background_color');

	if( isset($shop_isle_bg) && $shop_isle_bg!='' ) {

		echo '<div class="main front-page-main inicio-2" style="background-color: #' . $shop_isle_bg . '">';

	} else {
	
		echo '<div class="main front-page-main inicio-2" style="background-color: #FFF">';
	
	}
	
	if( defined('WCCM_VERISON') ) {
	
		/* Woocommerce compare list plugin */
		echo '<section class="module-small wccm-frontpage-compare-list">';
			echo '<div class="container">';
				do_action( 'shop_isle_wccm_compare_list' );
			echo '</div>';
		echo '</section>';
		
	}


	/******************************/
	/**** Products slider *********/
	/******************************/
	
	$shop_isle_products_slider_hide = get_theme_mod('shop_isle_products_slider_hide');

	if ( isset($shop_isle_products_slider_hide) && $shop_isle_products_slider_hide != 1 ) {	
		echo '<section class="home-product-slider inicio-2">';
	} elseif ( is_customize_preview() ) {
		echo '<section class="home-product-slider shop_isle_hidden_if_not_customizer inicio-2">';
	}
	
	if ( ( isset($shop_isle_products_slider_hide) && $shop_isle_products_slider_hide != 1)  || is_customize_preview() ) {
	
			echo '<div class="container">';

				if(current_user_can( 'edit_theme_options')) {
					$shop_isle_products_slider_title = get_theme_mod( 'shop_isle_products_slider_title', __( 'Exclusive products', 'shop-isle' ) );
					$shop_isle_products_slider_subtitle = get_theme_mod( 'shop_isle_products_slider_subtitle',__( 'For this section to work, you first need to install the WooCommerce plugin , create some products, and select a product category in Customize -> Frontpage sections -> Products slider section', 'shop-isle' ) );
				}
				else {
					$shop_isle_products_slider_title = get_theme_mod( 'shop_isle_products_slider_title' );
					$shop_isle_products_slider_subtitle = get_theme_mod( 'shop_isle_products_slider_subtitle' );
				}

				if( !empty($shop_isle_products_slider_title) || !empty($shop_isle_products_slider_subtitle) ) {
					echo '<div class="row">';
						echo '<div class="col-sm-6 col-sm-offset-3">';
							if( !empty($shop_isle_products_slider_title) ) {
								echo '<h2 class="module-title font-alt home-prod-title">'.$shop_isle_products_slider_title.'</h2>';
							}
							if( !empty($shop_isle_products_slider_subtitle) ) {
								echo '<div class="module-subtitle font-serif home-prod-subtitle inicio-2">'.$shop_isle_products_slider_subtitle.'</div>';
							}	
						echo '</div>';
					echo '</div><!-- .row -->';
				}
				
				$shop_isle_products_slider_category = get_theme_mod('shop_isle_products_slider_category');
				
				if( !empty($shop_isle_products_slider_category) && ($shop_isle_products_slider_category != '-') ) {
			
					$shop_isle_products_slider_args = array(
						'post_type' => 'product',
						'posts_per_page' => 10,
					    'tax_query' => array(
						array(
							'taxonomy' => 'product_cat',
							'field'    => 'term_id',
							'terms'    => $shop_isle_products_slider_category,
						)),
						'meta_query' => array(
							array(
								'key' => '_visibility',
								'value' => 'hidden',
								'compare' => '!=',
							)),
						);

					$shop_isle_products_slider_loop = new WP_Query( $shop_isle_products_slider_args );

					if( $shop_isle_products_slider_loop->have_posts() ) {

						echo '<div class="row">';

							echo '<div class="owl-carousel text-center inicio-2" data-items="5" data-pagination="false" data-navigation="false">';
			
								while ( $shop_isle_products_slider_loop->have_posts() ) {
								
									$shop_isle_products_slider_loop->the_post(); 
									
									echo '<div class="owl-item inicio-2">';
										echo '<div class="col-sm-12">';
											echo '<div class="ex-product">';
												if( function_exists('woocommerce_get_product_thumbnail') ) {
													echo '<a href="'.esc_url(get_permalink()).'">' . woocommerce_get_product_thumbnail().'</a>';
												}
												echo '<h4 class="shop-item-title font-alt"><a href="'.esc_url(get_permalink()).'">'.get_the_title().'</a></h4>';

												$rating_html = '';
												if( function_exists( 'method_exists' ) && method_exists( $product, 'get_rating_html' ) && method_exists( $product, 'get_average_rating' ) ) {
													$shop_isle_avg = $product->get_average_rating();
													if( !empty($shop_isle_avg) ) {
														$rating_html = $product->get_rating_html( $shop_isle_avg );
													}
												}
												if ( !empty($rating_html) && get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) {
													echo '<div class="product-rating-home">' . $rating_html . '</div>';
												}
												$shop_isle_price = '';
												if( function_exists('method_exists') && method_exists( $product, 'get_display_price' ) ) {
													$shop_isle_price = $product->get_display_price();
												}
												if( function_exists('get_woocommerce_currency_symbol') && !empty($product) && !empty( $shop_isle_price ) ) {
													if( function_exists('get_woocommerce_price_format') ) {
														$format_string = get_woocommerce_price_format();
													}	
													if( !empty($format_string) ) {
														switch ( $format_string ) {
															case '%1$s%2$s' :
																echo '<span class="shop-item-price"><span class="shop-item-currency">'.get_woocommerce_currency_symbol().'</span>'.$shop_isle_price.'</span>';
																break;
															case '%2$s%1$s' :
																echo '<span class="shop-item-price">'.$shop_isle_price.'<span class="shop-item-currency">'.get_woocommerce_currency_symbol().'</span></span>';
																break;
															case '%1$s&nbsp;%2$s' :
																echo '<span class="shop-item-price"><span class="shop-item-currency">'.get_woocommerce_currency_symbol().'</span> '.$shop_isle_price.'</span>';
																break;
															case '%2$s&nbsp;%1$s' :
																echo '<span class="shop-item-price">'.$shop_isle_price.' <span class="shop-item-currency">'.get_woocommerce_currency_symbol().'</span></span>';
																break;
														}
													} else {
														echo get_woocommerce_currency_symbol().$shop_isle_price;
													}
												}
											echo '</div><!-- .ex-product -->';
										echo '</div><!-- .col-sm-12 -->';
									echo '</div><!-- .owl-item -->';

								}

								wp_reset_postdata();
								
							echo '</div><!-- .owl-carousel -->';

						echo '</div><!-- .row -->';	

					}
					
				} else {
					
					$shop_isle_products_slider_args = array(
						'post_type' => 'product',
						'posts_per_page' => 10,
						'meta_query' => array(
							array(
								'key' => '_visibility',
								'value' => 'hidden',
								'compare' => '!=',
							)),
						);

					$shop_isle_products_slider_loop = new WP_Query( $shop_isle_products_slider_args );

					if( $shop_isle_products_slider_loop->have_posts() ) {

						echo '<div class="row">';

							echo '<div class="owl-carousel text-center inicio-2" data-items="5" data-pagination="false" data-navigation="false">';
			
								while ( $shop_isle_products_slider_loop->have_posts() ) { 
								
									$shop_isle_products_slider_loop->the_post(); 
									
									echo '<div class="owl-item">';
										echo '<div class="col-sm-12">';
											echo '<div class="ex-product">';
												if( function_exists('woocommerce_get_product_thumbnail') ) {
													echo '<a href="'.esc_url(get_permalink()).'">' . woocommerce_get_product_thumbnail().'</a>';
												}
												echo '<h4 class="shop-item-title font-alt"><a href="'.esc_url(get_permalink()).'">'.get_the_title().'</a></h4>';

												$rating_html = '';
												if( function_exists( 'method_exists' ) && method_exists( $product, 'get_rating_html' ) && method_exists( $product, 'get_average_rating' ) ) {
													$shop_isle_avg = $product->get_average_rating();
													if( !empty($shop_isle_avg) ) {
														$rating_html = $product->get_rating_html( $shop_isle_avg );
													}
												}
												if ( !empty($rating_html) && get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) {
													echo '<div class="product-rating-home">' . $rating_html . '</div>';
												}
												$shop_isle_price = '';
												if( function_exists('method_exists') && method_exists( $product, 'get_display_price' ) ) {
													$shop_isle_price = $product->get_display_price();
												}
												if( function_exists('get_woocommerce_currency_symbol') && !empty($product) && !empty( $shop_isle_price ) ) {
													if( function_exists('get_woocommerce_price_format') ) {
														$format_string = get_woocommerce_price_format();
													}
													if( !empty($format_string) ) {
														switch ( $format_string ) {
															case '%1$s%2$s' :
																echo '<span class="shop-item-price"><span class="shop-item-currency">'.get_woocommerce_currency_symbol().'</span>'.$shop_isle_price.'</span>';
																break;
															case '%2$s%1$s' :
																echo '<span class="shop-item-price">'.$shop_isle_price.'<span class="shop-item-currency">'.get_woocommerce_currency_symbol().'</span></span>';
																break;
															case '%1$s&nbsp;%2$s' :
																echo '<span class="shop-item-price"><span class="shop-item-currency">'.get_woocommerce_currency_symbol().'</span> '.$shop_isle_price.'</span>';
																break;
															case '%2$s&nbsp;%1$s' :
																echo '<span class="shop-item-price">'.$shop_isle_price.' <span class="shop-item-currency">'.get_woocommerce_currency_symbol().'</span></span>';
																break;
														}
													} else {
														echo get_woocommerce_currency_symbol().$shop_isle_price;
													}
												}
											echo '</div><!-- .ex-product -->';
										echo '</div><!-- .col-sm-12 -->';
									echo '</div><!-- .owl-item -->';

								}

								wp_reset_postdata();
								
							echo '</div><!-- .owl-carousel -->';

						echo '</div><!-- .row -->';	
				
					}
					
				}
			
			echo '</div><!-- .container -->';
	
		echo '</section><!-- .home-product-slider -->';	
	}



	/**********************************/
	/*********    VIDEO **************/
	/*********************************/

	$shop_isle_video_hide = get_theme_mod('shop_isle_video_hide');
	$shop_isle_yt_link = get_theme_mod('shop_isle_yt_link');
	$shop_isle_yt_thumbnail = get_theme_mod('shop_isle_yt_thumbnail');

	if( empty($shop_isle_yt_thumbnail) ) {
		$shop_isle_do_video_thumbnail = preg_match( '/\/\/(www\.)?(youtu|youtube)\.(com|be)\/(watch|embed)?\/?(\?v=)?([a-zA-Z0-9\-\_]+)/', $shop_isle_yt_link, $shop_isle_youtube_matches );
		$shop_isle_youtube_id = ! empty( $shop_isle_youtube_matches ) ? $shop_isle_youtube_matches[6] : '';
		$shop_isle_yt_thumbnail = 'http://img.youtube.com/vi/' . $shop_isle_youtube_id . '/maxresdefault.jpg';
	}

	if( isset($shop_isle_video_hide) && $shop_isle_video_hide != 1 && !empty($shop_isle_yt_link) ) {
		echo '<section class="module module-video bg-dark-30 inicio-2">';
	} elseif ( !empty($shop_isle_yt_link) && is_customize_preview() ) {
		echo '<section class="module module-video bg-dark-30 shop_isle_hidden_if_not_customizer inicio-2">';
	}

	if( ( isset($shop_isle_video_hide) && $shop_isle_video_hide != 1 && !empty($shop_isle_yt_link) ) || ( !empty($shop_isle_yt_link) && is_customize_preview() )  ) {
		echo '<div class="module-video-thumbnail inicio-2"'. ( !empty( $shop_isle_yt_thumbnail ) ? ' style="background-image: url('.$shop_isle_yt_thumbnail.')' : '' ) .'"></div>';
			echo '<div>';

				$shop_isle_video_title = get_theme_mod('shop_isle_video_title');
				if( !empty($shop_isle_video_title) ):
					echo '<div class="container">';
						echo '<div class="row">';
							echo '<div class="col-sm-12">';
								echo '<h2 class="module-title font-alt mb-0 video-title">'.$shop_isle_video_title.'</h2>';
							echo '</div>';
						echo '</div>';
					echo '</div>';
				endif;
				?>
				<!-- Youtube player start-->
				<div class="video-player" data-property="{videoURL:'<?php echo $shop_isle_yt_link; ?>', containment:'.module-video', startAt:0, mute:true, autoPlay:true, loop:true, opacity:1, showControls:false, showYTLogo:false, vol:25}"></div>
				<!-- Youtube player end -->
				<?php
			echo '</div>';
		echo '</section><!-- .module-video -->';

	} /* END VIDEO */

		/***********************/
		/******  BANNERS *******/
		/***********************/
		
		$shop_isle_banners_hide = get_theme_mod('shop_isle_banners_hide');
		$shop_isle_banners_title = get_theme_mod('shop_isle_banners_title');
		
		if ( isset($shop_isle_banners_hide) && $shop_isle_banners_hide != 1 ) {
			echo '<section class="module-small home-banners">';
		} elseif ( is_customize_preview() ) {
			echo '<section class="module-small home-banners shop_isle_hidden_if_not_customizer">';
		}

		if( ( isset($shop_isle_banners_hide) && $shop_isle_banners_hide != 1) || is_customize_preview() ) {

			if(current_user_can( 'edit_theme_options')) {
				$shop_isle_banners = get_theme_mod( 'shop_isle_banners', json_encode( array(
					array(
						'image_url' => get_template_directory_uri() . '/assets/images/banner1.jpg',
						'link'      => '#'
					),
					array( 'image_url' => get_template_directory_uri() . '/assets/images/banner2.jpg', 'link' => '#' ),
					array( 'image_url' => get_template_directory_uri() . '/assets/images/banner3.jpg', 'link' => '#' )
				) ) );
			} else {
				$shop_isle_banners = get_theme_mod( 'shop_isle_banners' );
			}
					
			if( !empty( $shop_isle_banners ) ) {
						
				$shop_isle_banners_decoded = json_decode($shop_isle_banners);
						
				if( !empty($shop_isle_banners_decoded) ) {
							
						echo '<div class="container">';

							if ( !empty($shop_isle_banners_title) ) {
								echo '<div class="row">';
									echo '<div class="col-sm-6 col-sm-offset-3">';
										echo '<h2 class="module-title font-alt product-banners-title">'. $shop_isle_banners_title .'</h2>';
									echo '</div>';
								echo '</div>';

							} elseif ( is_customize_preview() ) {
								echo '<div class="row">';
									echo '<div class="col-sm-6 col-sm-offset-3">';
										echo '<h2 class="module-title font-alt product-banners-title shop_isle_hidden_if_not_customizer"></h2>';
									echo '</div>';
								echo '</div>';
							}

							echo '<div class="row shop_isle_bannerss_section">';
							
								foreach($shop_isle_banners_decoded as $shop_isle_banner) {
								
									if ( !empty($shop_isle_banner->image_url) ) {
									
										echo '<div class="col-sm-4"><div class="content-box mt-0 mb-0"><div class="content-box-image">';
										
										if ( !empty($shop_isle_banner->link) ) {
											
											if (function_exists ( 'icl_t' ) && !empty($shop_isle_banner->id)){
												$shop_isle_banner_link = icl_t( 'Banner '.$shop_isle_banner->id, 'Banner link', $shop_isle_banner->link );
												$shop_isle_banner_image_url = icl_t( 'Banner '.$shop_isle_banner->id, 'Banner image', $shop_isle_banner->image_url );
												echo '<a href="' . esc_url( $shop_isle_banner_link ) . '"><img src="' . esc_url( $shop_isle_banner_image_url ) . '"></a>';
											} else {					
												echo '<a href="' . esc_url( $shop_isle_banner->link ) . '"><img src="' . esc_url( $shop_isle_banner->image_url ) . '"></a>';
											}
										}
										else {
											if (function_exists ( 'icl_t' ) && !empty($shop_isle_banner->id)){
												$shop_isle_banner_image_url = icl_t( 'Banner '.$shop_isle_banner->id, 'Banner image', $shop_isle_banner->image_url );
												echo '<a><img src="' . esc_url( $shop_isle_banner_image_url ) . '"></a>';
											} else {
												echo '<a><img src="' . esc_url( $shop_isle_banner->image_url ) . '"></a>';
											}	
										}
										echo '</div></div></div>';
									
									}
								
								}
						
							echo '</div><!-- .shop_isle_bannerss_section -->';
							
						echo '</div><!-- .container -->';
													
				}
				
			}
			
			echo '</section>';

			echo '<hr class="divider-w">';

		}	/* END BANNERS */
		
		
		
	
	

	
	
	get_footer();
?>