DROP TABLE IF EXISTS `wp_commentmeta`;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_commentmeta` VALUES("1","25","rating","4");
INSERT INTO `wp_commentmeta` VALUES("2","25","verified","1");
INSERT INTO `wp_commentmeta` VALUES("3","26","rating","5");
INSERT INTO `wp_commentmeta` VALUES("4","26","verified","1");
INSERT INTO `wp_commentmeta` VALUES("5","27","rating","5");
INSERT INTO `wp_commentmeta` VALUES("6","27","verified","1");
INSERT INTO `wp_commentmeta` VALUES("7","28","rating","2");
INSERT INTO `wp_commentmeta` VALUES("8","28","verified","1");


DROP TABLE IF EXISTS `wp_comments`;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_comments` VALUES("1","1","Sr WordPress","","https://wordpress.org/","","2016-10-03 17:35:38","2016-10-03 17:35:38","Hola, esto es un comentario.
Para borrar un comentario simplemente accede y revisa los comentarios de la entrada. Ahí tendrás la opción de editarlo o borrarlo.","0","1","","","0","0");
INSERT INTO `wp_comments` VALUES("25","93","miguel","miguel.rodriguez11@hotmail.com","","::1","2016-10-25 15:23:19","2016-10-25 15:23:19","Excelente","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36","","0","1");
INSERT INTO `wp_comments` VALUES("26","93","miguel","miguel.rodriguez11@hotmail.com","","::1","2016-10-25 15:23:52","2016-10-25 15:23:52","Bueno","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36","","0","1");
INSERT INTO `wp_comments` VALUES("27","93","miguel","miguel.rodriguez11@hotmail.com","","::1","2016-10-31 15:37:43","2016-10-31 15:37:43","Bien","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36","","0","1");
INSERT INTO `wp_comments` VALUES("28","93","miguel","miguel.rodriguez11@hotmail.com","","::1","2016-10-31 15:38:07","2016-10-31 15:38:07","Regular","0","1","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/53.0.2785.143 Safari/537.36","","0","1");


DROP TABLE IF EXISTS `wp_gmp_icons`;

CREATE TABLE `wp_gmp_icons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `description` text,
  `path` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;

INSERT INTO `wp_gmp_icons` VALUES("1","marker","blue,white,star,pin","bblue.png");
INSERT INTO `wp_gmp_icons` VALUES("2","marker","green,white,star,pin","bgreen.png");
INSERT INTO `wp_gmp_icons` VALUES("3","marker","purple,white,star,pin","purple.png");
INSERT INTO `wp_gmp_icons` VALUES("4","marker","blue,white,star,pin","bred.png");
INSERT INTO `wp_gmp_icons` VALUES("5","marker","blue,pin","blue.png");
INSERT INTO `wp_gmp_icons` VALUES("6","marker","gray,pin","gray.png");
INSERT INTO `wp_gmp_icons` VALUES("7","marker","green,pin","green.png");
INSERT INTO `wp_gmp_icons` VALUES("8","marker","pin,yellow","orange.png");
INSERT INTO `wp_gmp_icons` VALUES("9","marker","pin,red","red.png");
INSERT INTO `wp_gmp_icons` VALUES("10","flag","gray","flag_black.png");
INSERT INTO `wp_gmp_icons` VALUES("11","flag","blue","flag_blue.png");
INSERT INTO `wp_gmp_icons` VALUES("12","flag","green","flag_green.png");
INSERT INTO `wp_gmp_icons` VALUES("13","flag","orange","flag_orange.png");
INSERT INTO `wp_gmp_icons` VALUES("14","flag","purple","flag_purple.png");
INSERT INTO `wp_gmp_icons` VALUES("15","flag","red","flag_red.png");
INSERT INTO `wp_gmp_icons` VALUES("16","marker","pin,cycle,blue","blue_circle.png");
INSERT INTO `wp_gmp_icons` VALUES("17","marker","white,blue,pin","blue_orifice.png");
INSERT INTO `wp_gmp_icons` VALUES("18","marker","blue,pin","blue_std.png");
INSERT INTO `wp_gmp_icons` VALUES("19","pin","green,marker,cycle","green_circle.png");
INSERT INTO `wp_gmp_icons` VALUES("20","pin","green,cycle","green_orifice.png");
INSERT INTO `wp_gmp_icons` VALUES("21","pin","green","green_std.png");
INSERT INTO `wp_gmp_icons` VALUES("22","pin","orange,cycle","orange_circle.png");
INSERT INTO `wp_gmp_icons` VALUES("23","pin","orange,cycle","orange_orifice.png");
INSERT INTO `wp_gmp_icons` VALUES("24","pin","orange","orange_std.png");
INSERT INTO `wp_gmp_icons` VALUES("25","pin","purple,cycle","purple_circle.png");
INSERT INTO `wp_gmp_icons` VALUES("26","pin","purple,cycle","purple_orifice.png");
INSERT INTO `wp_gmp_icons` VALUES("27","pin","purple","purple_std.png");
INSERT INTO `wp_gmp_icons` VALUES("28","pin","red,cycle","red_circle.png");
INSERT INTO `wp_gmp_icons` VALUES("29","pin","red,cycle","red_orifice.png");
INSERT INTO `wp_gmp_icons` VALUES("30","pin","red","red_std.png");
INSERT INTO `wp_gmp_icons` VALUES("31","star","black,dark,pin","star_pin_black.png");
INSERT INTO `wp_gmp_icons` VALUES("32","star","blue,pin","star_pin_blue.png");
INSERT INTO `wp_gmp_icons` VALUES("33","star","green,pin","star_pin_green.png");
INSERT INTO `wp_gmp_icons` VALUES("34","star","orange,pin","star_pin_orange.png");
INSERT INTO `wp_gmp_icons` VALUES("35","star","purple","star_pin_purple.png");
INSERT INTO `wp_gmp_icons` VALUES("36","star","red,pin","star_pin_red.png");
INSERT INTO `wp_gmp_icons` VALUES("37","pin","gray,white,cycle","white_circlepng.png");
INSERT INTO `wp_gmp_icons` VALUES("38","pin","gray,white,cycle","white_orifice.png");
INSERT INTO `wp_gmp_icons` VALUES("39","pin","white,gray","white_std.png");
INSERT INTO `wp_gmp_icons` VALUES("40","pin","yellow,cycle","yellow_circlepng.png");
INSERT INTO `wp_gmp_icons` VALUES("41","pin","yellow,cycle","yellow_orifice.png");
INSERT INTO `wp_gmp_icons` VALUES("42","pin","yellow","yellow_std.png");
INSERT INTO `wp_gmp_icons` VALUES("43","marker","red","marker.png");
INSERT INTO `wp_gmp_icons` VALUES("44","marker","blue","marker_blue.png");
INSERT INTO `wp_gmp_icons` VALUES("45","marker","red,letter","markerA.png");
INSERT INTO `wp_gmp_icons` VALUES("46","marker","orange","marker_orange.png");
INSERT INTO `wp_gmp_icons` VALUES("47","marker","green","marker_green.png");


DROP TABLE IF EXISTS `wp_gmp_maps`;

CREATE TABLE `wp_gmp_maps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(125) NOT NULL,
  `description` text,
  `params` text,
  `html_options` text NOT NULL,
  `create_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_gmp_marker_groups`;

CREATE TABLE `wp_gmp_marker_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(250) DEFAULT NULL,
  `description` text,
  `params` text,
  `sort_order` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_gmp_markers`;

CREATE TABLE `wp_gmp_markers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(125) NOT NULL,
  `description` text,
  `coord_x` varchar(30) NOT NULL,
  `coord_y` varchar(30) NOT NULL,
  `icon` int(11) DEFAULT NULL,
  `map_id` int(11) DEFAULT NULL,
  `marker_group_id` int(11) DEFAULT NULL,
  `address` text,
  `animation` int(1) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL,
  `params` text NOT NULL,
  `sort_order` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_gmp_modules`;

CREATE TABLE `wp_gmp_modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `type_id` smallint(3) NOT NULL DEFAULT '0',
  `params` text,
  `has_tab` tinyint(1) NOT NULL DEFAULT '0',
  `label` varchar(128) DEFAULT NULL,
  `description` text,
  `ex_plug_dir` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

INSERT INTO `wp_gmp_modules` VALUES("1","adminmenu","1","1","","0","Admin Menu","","");
INSERT INTO `wp_gmp_modules` VALUES("2","options","1","1","","1","Options","","");
INSERT INTO `wp_gmp_modules` VALUES("3","user","1","1","","1","Users","","");
INSERT INTO `wp_gmp_modules` VALUES("4","templates","1","1","","1","Templates for Plugin","","");
INSERT INTO `wp_gmp_modules` VALUES("5","shortcodes","1","6","","0","Shortcodes","Shortcodes data","");
INSERT INTO `wp_gmp_modules` VALUES("6","gmap","1","1","","1","Gmap","Gmap","");
INSERT INTO `wp_gmp_modules` VALUES("7","marker","1","1","","0","Markers","Google Maps Markers","");
INSERT INTO `wp_gmp_modules` VALUES("8","marker_groups","1","1","","0","Marker Gropus","Marker Groups","");
INSERT INTO `wp_gmp_modules` VALUES("9","supsystic_promo","1","1","","0","Promo","Promo","");
INSERT INTO `wp_gmp_modules` VALUES("10","icons","1","1","","1","Marker Icons","Marker Icons","");
INSERT INTO `wp_gmp_modules` VALUES("11","mail","1","1","","1","mail","mail","");
INSERT INTO `wp_gmp_modules` VALUES("12","csv","1","1","","0","csv","csv","");
INSERT INTO `wp_gmp_modules` VALUES("13","gmap_widget","1","1","","0","gmap_widget","gmap_widget","");


DROP TABLE IF EXISTS `wp_gmp_modules_type`;

CREATE TABLE `wp_gmp_modules_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO `wp_gmp_modules_type` VALUES("1","system");
INSERT INTO `wp_gmp_modules_type` VALUES("4","widget");
INSERT INTO `wp_gmp_modules_type` VALUES("6","addons");
INSERT INTO `wp_gmp_modules_type` VALUES("7","template");


DROP TABLE IF EXISTS `wp_gmp_options`;

CREATE TABLE `wp_gmp_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) CHARACTER SET latin1 NOT NULL,
  `value` text,
  `label` varchar(128) CHARACTER SET latin1 DEFAULT NULL,
  `description` text CHARACTER SET latin1,
  `htmltype_id` smallint(2) NOT NULL DEFAULT '1',
  `params` text,
  `cat_id` mediumint(3) DEFAULT '0',
  `sort_order` mediumint(3) DEFAULT '0',
  `value_type` varchar(16) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `wp_gmp_options` VALUES("1","save_statistic","0","Send statistic","","1","","0","0","");
INSERT INTO `wp_gmp_options` VALUES("2","infowindow_size","a:2:{s:5:\"width\";s:3:\"100\";s:6:\"height\";s:3:\"100\";}","Info Window Size","","1","","0","0","array");


DROP TABLE IF EXISTS `wp_gmp_options_categories`;

CREATE TABLE `wp_gmp_options_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` varchar(128) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `wp_gmp_options_categories` VALUES("1","General");
INSERT INTO `wp_gmp_options_categories` VALUES("2","Template");
INSERT INTO `wp_gmp_options_categories` VALUES("3","Subscribe");
INSERT INTO `wp_gmp_options_categories` VALUES("4","Social");


DROP TABLE IF EXISTS `wp_gmp_usage_stat`;

CREATE TABLE `wp_gmp_usage_stat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(64) NOT NULL,
  `visits` int(11) NOT NULL DEFAULT '0',
  `spent_time` int(11) NOT NULL DEFAULT '0',
  `modify_timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;



DROP TABLE IF EXISTS `wp_itsec_lockouts`;

CREATE TABLE `wp_itsec_lockouts` (
  `lockout_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lockout_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lockout_start` datetime NOT NULL,
  `lockout_start_gmt` datetime NOT NULL,
  `lockout_expire` datetime NOT NULL,
  `lockout_expire_gmt` datetime NOT NULL,
  `lockout_host` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockout_user` bigint(20) unsigned DEFAULT NULL,
  `lockout_username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lockout_active` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`lockout_id`),
  KEY `lockout_expire_gmt` (`lockout_expire_gmt`),
  KEY `lockout_host` (`lockout_host`),
  KEY `lockout_user` (`lockout_user`),
  KEY `lockout_username` (`lockout_username`),
  KEY `lockout_active` (`lockout_active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_itsec_log`;

CREATE TABLE `wp_itsec_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `log_function` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `log_priority` int(2) NOT NULL DEFAULT '1',
  `log_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `log_host` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_user` bigint(20) unsigned DEFAULT NULL,
  `log_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_referrer` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `log_data` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`log_id`),
  KEY `log_type` (`log_type`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_itsec_temp`;

CREATE TABLE `wp_itsec_temp` (
  `temp_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `temp_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `temp_date` datetime NOT NULL,
  `temp_date_gmt` datetime NOT NULL,
  `temp_host` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `temp_user` bigint(20) unsigned DEFAULT NULL,
  `temp_username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`temp_id`),
  KEY `temp_date_gmt` (`temp_date_gmt`),
  KEY `temp_host` (`temp_host`),
  KEY `temp_user` (`temp_user`),
  KEY `temp_username` (`temp_username`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_likebtn_item`;

CREATE TABLE `wp_likebtn_item` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `identifier` text NOT NULL,
  `identifier_hash` varchar(32) NOT NULL,
  `url` text,
  `title` text,
  `description` text,
  `image` text,
  `likes` int(11) NOT NULL DEFAULT '0',
  `dislikes` int(11) NOT NULL DEFAULT '0',
  `likes_minus_dislikes` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `identifier_hash` (`identifier_hash`),
  KEY `title` (`title`(1)),
  KEY `likes` (`likes`),
  KEY `dislikes` (`dislikes`),
  KEY `likes_minus_dislikes` (`likes_minus_dislikes`),
  KEY `identifier` (`identifier`(1))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `wp_likebtn_item` VALUES("1","product_demo","9a9441875cc6edbdfc206a3ac71b2940","http://cerere.manaprocloud.com/wp-admin/admin.php?page=likebtn_buttons&likebtn_subpage=product","","","","1","0","1");
INSERT INTO `wp_likebtn_item` VALUES("2","dslc_downloads_demo","6005be22a33aaf43d3efda3893c8e584","http://cerere.manaprocloud.com/wp-admin/admin.php?page=likebtn_buttons&likebtn_subpage=dslc_downloads","","","","0","0","0");


DROP TABLE IF EXISTS `wp_likebtn_vote`;

CREATE TABLE `wp_likebtn_vote` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `identifier` text NOT NULL,
  `identifier_hash` varchar(32) NOT NULL,
  `client_identifier` varchar(32) NOT NULL,
  `type` tinyint(1) NOT NULL,
  `user_id` bigint(20) DEFAULT '0',
  `ip` varchar(40) NOT NULL,
  `lat` float(10,6) DEFAULT NULL,
  `lng` float(10,6) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `identifiers` (`identifier_hash`,`client_identifier`,`user_id`),
  KEY `identifier` (`identifier`(7)),
  KEY `created_at` (`created_at`),
  KEY `user_id` (`user_id`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=latin1;

INSERT INTO `wp_likebtn_vote` VALUES("3","product_108","b03fb38820e8cfaeed4cecfbc6ffe58f","f330c7cd66c010008b00c9c3af04f9fc","1","1","190.216.244.46","10.500000","-66.916702","2017-01-31 15:21:38");
INSERT INTO `wp_likebtn_vote` VALUES("27","product_68","e58c83de92e6c1f1fcdc0e946ebd760e","f330c7cd66c010008b00c9c3af04f9fc","1","1","190.216.244.46","10.500000","-66.916702","2017-01-31 18:10:33");
INSERT INTO `wp_likebtn_vote` VALUES("11","product_68","e58c83de92e6c1f1fcdc0e946ebd760e","f330c7cd66c010008b00c9c3af04f9fc","1","0","190.216.244.46","10.500000","-66.916702","2017-01-31 18:11:03");
INSERT INTO `wp_likebtn_vote` VALUES("30","product_93","52cc42c8b80d18fb705a10137b263076","f330c7cd66c010008b00c9c3af04f9fc","1","1","190.216.244.46","10.500000","-66.916702","2017-02-03 19:19:52");
INSERT INTO `wp_likebtn_vote` VALUES("31","product_251","788e248f9472a37e05493a91e104415d","f330c7cd66c010008b00c9c3af04f9fc","1","1","190.216.244.46","10.500000","-66.916702","2017-02-03 19:20:00");
INSERT INTO `wp_likebtn_vote` VALUES("33","product_246","115854c12374a883faa9afa1c88fb69a","f330c7cd66c010008b00c9c3af04f9fc","1","1","190.216.244.46","10.500000","-66.916702","2017-02-03 19:48:41");
INSERT INTO `wp_likebtn_vote` VALUES("34","product_98","abaeaa7cc064979bbdc73f9e80242e58","f330c7cd66c010008b00c9c3af04f9fc","1","1","190.216.244.46","10.500000","-66.916702","2017-02-08 12:33:03");
INSERT INTO `wp_likebtn_vote` VALUES("35","product_510","3876e832079f866a7b3869f92a92fbd5","28665489b50d85e4d8fed5d417d61bfc","1","0","190.216.244.46","10.500000","-66.916702","2017-02-10 18:07:20");
INSERT INTO `wp_likebtn_vote` VALUES("36","product_452","31cf0310d6b7c0380b3b64a86295e01c","a7e74c8b15afb53ee2e4a0df2af313d1","1","0","201.242.171.178","11.095600","-63.943298","2017-02-14 15:02:39");
INSERT INTO `wp_likebtn_vote` VALUES("37","product_68","e58c83de92e6c1f1fcdc0e946ebd760e","a7e74c8b15afb53ee2e4a0df2af313d1","1","0","201.242.171.178","11.095600","-63.943298","2017-02-14 15:07:02");
INSERT INTO `wp_likebtn_vote` VALUES("38","product_68","e58c83de92e6c1f1fcdc0e946ebd760e","a1be6e01a8a825503b33a2b355a617d4","1","0","190.216.244.46","25.788799","-80.360802","2017-02-21 14:57:06");


DROP TABLE IF EXISTS `wp_links`;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_nf3_action_meta`;

CREATE TABLE `wp_nf3_action_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `key` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_nf3_action_meta` VALUES("1","1","label","Success Message");
INSERT INTO `wp_nf3_action_meta` VALUES("2","1","message","Thank you {field:name} for filling out my form!");
INSERT INTO `wp_nf3_action_meta` VALUES("3","1","objectType","Action");
INSERT INTO `wp_nf3_action_meta` VALUES("4","1","objectDomain","actions");
INSERT INTO `wp_nf3_action_meta` VALUES("5","1","editActive","");
INSERT INTO `wp_nf3_action_meta` VALUES("6","1","conditions","a:6:{s:9:\"collapsed\";s:0:\"\";s:7:\"process\";s:1:\"1\";s:9:\"connector\";s:3:\"all\";s:4:\"when\";a:1:{i:0;a:6:{s:9:\"connector\";s:3:\"AND\";s:3:\"key\";s:0:\"\";s:10:\"comparator\";s:0:\"\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"field\";s:9:\"modelType\";s:4:\"when\";}}s:4:\"then\";a:1:{i:0;a:5:{s:3:\"key\";s:0:\"\";s:7:\"trigger\";s:0:\"\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"field\";s:9:\"modelType\";s:4:\"then\";}}s:4:\"else\";a:0:{}}");
INSERT INTO `wp_nf3_action_meta` VALUES("7","1","payment_gateways","");
INSERT INTO `wp_nf3_action_meta` VALUES("8","1","payment_total","");
INSERT INTO `wp_nf3_action_meta` VALUES("9","1","tag","");
INSERT INTO `wp_nf3_action_meta` VALUES("10","1","to","");
INSERT INTO `wp_nf3_action_meta` VALUES("11","1","email_subject","");
INSERT INTO `wp_nf3_action_meta` VALUES("12","1","email_message","");
INSERT INTO `wp_nf3_action_meta` VALUES("13","1","from_name","");
INSERT INTO `wp_nf3_action_meta` VALUES("14","1","from_address","");
INSERT INTO `wp_nf3_action_meta` VALUES("15","1","reply_to","");
INSERT INTO `wp_nf3_action_meta` VALUES("16","1","email_format","html");
INSERT INTO `wp_nf3_action_meta` VALUES("17","1","cc","");
INSERT INTO `wp_nf3_action_meta` VALUES("18","1","bcc","");
INSERT INTO `wp_nf3_action_meta` VALUES("19","1","attach_csv","");
INSERT INTO `wp_nf3_action_meta` VALUES("20","1","redirect_url","");
INSERT INTO `wp_nf3_action_meta` VALUES("21","1","success_msg","<p>Form submitted successfully.</p><p>A confirmation email was sent to {field:e-mail}.</p>");
INSERT INTO `wp_nf3_action_meta` VALUES("22","1","email_message_plain","");
INSERT INTO `wp_nf3_action_meta` VALUES("23","2","objectType","Action");
INSERT INTO `wp_nf3_action_meta` VALUES("24","2","objectDomain","actions");
INSERT INTO `wp_nf3_action_meta` VALUES("25","2","editActive","");
INSERT INTO `wp_nf3_action_meta` VALUES("26","2","label","Email Notification");
INSERT INTO `wp_nf3_action_meta` VALUES("27","2","conditions","a:6:{s:9:\"collapsed\";s:0:\"\";s:7:\"process\";s:1:\"1\";s:9:\"connector\";s:3:\"all\";s:4:\"when\";a:1:{i:0;a:6:{s:9:\"connector\";s:3:\"AND\";s:3:\"key\";s:0:\"\";s:10:\"comparator\";s:0:\"\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"field\";s:9:\"modelType\";s:4:\"when\";}}s:4:\"then\";a:1:{i:0;a:5:{s:3:\"key\";s:0:\"\";s:7:\"trigger\";s:0:\"\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"field\";s:9:\"modelType\";s:4:\"then\";}}s:4:\"else\";a:0:{}}");
INSERT INTO `wp_nf3_action_meta` VALUES("28","2","payment_gateways","");
INSERT INTO `wp_nf3_action_meta` VALUES("29","2","payment_total","");
INSERT INTO `wp_nf3_action_meta` VALUES("30","2","tag","");
INSERT INTO `wp_nf3_action_meta` VALUES("31","2","to","{system:admin_email}");
INSERT INTO `wp_nf3_action_meta` VALUES("32","2","email_subject","New message from {field:nombre}");
INSERT INTO `wp_nf3_action_meta` VALUES("33","2","email_message","<p>{field:comentario}</p><p>- {field:nombre} ( {field:e-mail} )</p>");
INSERT INTO `wp_nf3_action_meta` VALUES("34","2","from_name","");
INSERT INTO `wp_nf3_action_meta` VALUES("35","2","from_address","");
INSERT INTO `wp_nf3_action_meta` VALUES("36","2","reply_to","{field:e-mail}");
INSERT INTO `wp_nf3_action_meta` VALUES("37","2","email_format","html");
INSERT INTO `wp_nf3_action_meta` VALUES("38","2","cc","");
INSERT INTO `wp_nf3_action_meta` VALUES("39","2","bcc","");
INSERT INTO `wp_nf3_action_meta` VALUES("40","2","attach_csv","0");
INSERT INTO `wp_nf3_action_meta` VALUES("41","2","email_message_plain","");
INSERT INTO `wp_nf3_action_meta` VALUES("42","3","label","Save to Database");
INSERT INTO `wp_nf3_action_meta` VALUES("43","3","objectType","Action");
INSERT INTO `wp_nf3_action_meta` VALUES("44","3","objectDomain","actions");
INSERT INTO `wp_nf3_action_meta` VALUES("45","3","editActive","");
INSERT INTO `wp_nf3_action_meta` VALUES("46","3","conditions","a:6:{s:9:\"collapsed\";s:0:\"\";s:7:\"process\";s:1:\"1\";s:9:\"connector\";s:3:\"all\";s:4:\"when\";a:1:{i:0;a:6:{s:9:\"connector\";s:3:\"AND\";s:3:\"key\";s:0:\"\";s:10:\"comparator\";s:0:\"\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"field\";s:9:\"modelType\";s:4:\"when\";}}s:4:\"then\";a:1:{i:0;a:5:{s:3:\"key\";s:0:\"\";s:7:\"trigger\";s:0:\"\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"field\";s:9:\"modelType\";s:4:\"then\";}}s:4:\"else\";a:0:{}}");
INSERT INTO `wp_nf3_action_meta` VALUES("47","3","payment_gateways","");
INSERT INTO `wp_nf3_action_meta` VALUES("48","3","payment_total","");
INSERT INTO `wp_nf3_action_meta` VALUES("49","3","tag","");
INSERT INTO `wp_nf3_action_meta` VALUES("50","3","to","");
INSERT INTO `wp_nf3_action_meta` VALUES("51","3","email_subject","");
INSERT INTO `wp_nf3_action_meta` VALUES("52","3","email_message","");
INSERT INTO `wp_nf3_action_meta` VALUES("53","3","from_name","");
INSERT INTO `wp_nf3_action_meta` VALUES("54","3","from_address","");
INSERT INTO `wp_nf3_action_meta` VALUES("55","3","reply_to","");
INSERT INTO `wp_nf3_action_meta` VALUES("56","3","email_format","html");
INSERT INTO `wp_nf3_action_meta` VALUES("57","3","cc","");
INSERT INTO `wp_nf3_action_meta` VALUES("58","3","bcc","");
INSERT INTO `wp_nf3_action_meta` VALUES("59","3","attach_csv","");
INSERT INTO `wp_nf3_action_meta` VALUES("60","3","redirect_url","");
INSERT INTO `wp_nf3_action_meta` VALUES("61","3","email_message_plain","");
INSERT INTO `wp_nf3_action_meta` VALUES("62","4","label","Email Confirmation");
INSERT INTO `wp_nf3_action_meta` VALUES("63","4","to","{field:e-mail}");
INSERT INTO `wp_nf3_action_meta` VALUES("64","4","subject","This is an email action.");
INSERT INTO `wp_nf3_action_meta` VALUES("65","4","message","Hello, Ninja Forms!");
INSERT INTO `wp_nf3_action_meta` VALUES("66","4","objectType","Action");
INSERT INTO `wp_nf3_action_meta` VALUES("67","4","objectDomain","actions");
INSERT INTO `wp_nf3_action_meta` VALUES("68","4","editActive","");
INSERT INTO `wp_nf3_action_meta` VALUES("69","4","conditions","a:6:{s:9:\"collapsed\";s:0:\"\";s:7:\"process\";s:1:\"1\";s:9:\"connector\";s:3:\"all\";s:4:\"when\";a:0:{}s:4:\"then\";a:1:{i:0;a:5:{s:3:\"key\";s:0:\"\";s:7:\"trigger\";s:0:\"\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"field\";s:9:\"modelType\";s:4:\"then\";}}s:4:\"else\";a:0:{}}");
INSERT INTO `wp_nf3_action_meta` VALUES("70","4","payment_gateways","");
INSERT INTO `wp_nf3_action_meta` VALUES("71","4","payment_total","");
INSERT INTO `wp_nf3_action_meta` VALUES("72","4","tag","");
INSERT INTO `wp_nf3_action_meta` VALUES("73","4","email_subject","Submission Confirmation ");
INSERT INTO `wp_nf3_action_meta` VALUES("74","4","email_message","<p>{field:all_fields}<br></p>");
INSERT INTO `wp_nf3_action_meta` VALUES("75","4","from_name","");
INSERT INTO `wp_nf3_action_meta` VALUES("76","4","from_address","");
INSERT INTO `wp_nf3_action_meta` VALUES("77","4","reply_to","");
INSERT INTO `wp_nf3_action_meta` VALUES("78","4","email_format","html");
INSERT INTO `wp_nf3_action_meta` VALUES("79","4","cc","");
INSERT INTO `wp_nf3_action_meta` VALUES("80","4","bcc","");
INSERT INTO `wp_nf3_action_meta` VALUES("81","4","attach_csv","");
INSERT INTO `wp_nf3_action_meta` VALUES("82","4","email_message_plain","");


DROP TABLE IF EXISTS `wp_nf3_actions`;

CREATE TABLE `wp_nf3_actions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `key` longtext COLLATE utf8mb4_unicode_ci,
  `type` longtext COLLATE utf8mb4_unicode_ci,
  `active` tinyint(1) DEFAULT '1',
  `parent_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_nf3_actions` VALUES("1","","","successmessage","1","1","2016-08-24 13:39:20","");
INSERT INTO `wp_nf3_actions` VALUES("2","","","email","1","1","2016-08-24 13:47:39","");
INSERT INTO `wp_nf3_actions` VALUES("3","","","save","1","1","2016-08-24 13:39:20","");
INSERT INTO `wp_nf3_actions` VALUES("4","","","email","1","1","2016-08-24 13:39:20","");


DROP TABLE IF EXISTS `wp_nf3_field_meta`;

CREATE TABLE `wp_nf3_field_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `key` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=300 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_nf3_field_meta` VALUES("66","2","label_pos","above");
INSERT INTO `wp_nf3_field_meta` VALUES("67","2","required","1");
INSERT INTO `wp_nf3_field_meta` VALUES("68","2","order","3");
INSERT INTO `wp_nf3_field_meta` VALUES("69","2","placeholder","email@domain.com");
INSERT INTO `wp_nf3_field_meta` VALUES("70","2","default","");
INSERT INTO `wp_nf3_field_meta` VALUES("71","2","wrapper_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("72","2","element_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("73","2","objectType","Field");
INSERT INTO `wp_nf3_field_meta` VALUES("74","2","objectDomain","fields");
INSERT INTO `wp_nf3_field_meta` VALUES("75","2","editActive","");
INSERT INTO `wp_nf3_field_meta` VALUES("76","2","container_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("77","2","admin_label","");
INSERT INTO `wp_nf3_field_meta` VALUES("78","2","help_text","");
INSERT INTO `wp_nf3_field_meta` VALUES("79","2","desc_text","");
INSERT INTO `wp_nf3_field_meta` VALUES("80","2","wrap_styles_background-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("81","2","wrap_styles_border","");
INSERT INTO `wp_nf3_field_meta` VALUES("82","2","wrap_styles_border-style","");
INSERT INTO `wp_nf3_field_meta` VALUES("83","2","wrap_styles_border-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("84","2","wrap_styles_color","");
INSERT INTO `wp_nf3_field_meta` VALUES("85","2","wrap_styles_height","");
INSERT INTO `wp_nf3_field_meta` VALUES("86","2","wrap_styles_width","");
INSERT INTO `wp_nf3_field_meta` VALUES("87","2","wrap_styles_font-size","");
INSERT INTO `wp_nf3_field_meta` VALUES("88","2","wrap_styles_margin","");
INSERT INTO `wp_nf3_field_meta` VALUES("89","2","wrap_styles_padding","");
INSERT INTO `wp_nf3_field_meta` VALUES("90","2","wrap_styles_display","");
INSERT INTO `wp_nf3_field_meta` VALUES("91","2","wrap_styles_float","");
INSERT INTO `wp_nf3_field_meta` VALUES("92","2","wrap_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_field_meta` VALUES("93","2","wrap_styles_advanced","");
INSERT INTO `wp_nf3_field_meta` VALUES("94","2","label_styles_background-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("95","2","label_styles_border","");
INSERT INTO `wp_nf3_field_meta` VALUES("96","2","label_styles_border-style","");
INSERT INTO `wp_nf3_field_meta` VALUES("97","2","label_styles_border-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("98","2","label_styles_color","");
INSERT INTO `wp_nf3_field_meta` VALUES("99","2","label_styles_height","");
INSERT INTO `wp_nf3_field_meta` VALUES("100","2","label_styles_width","");
INSERT INTO `wp_nf3_field_meta` VALUES("101","2","label_styles_font-size","");
INSERT INTO `wp_nf3_field_meta` VALUES("102","2","label_styles_margin","");
INSERT INTO `wp_nf3_field_meta` VALUES("103","2","label_styles_padding","");
INSERT INTO `wp_nf3_field_meta` VALUES("104","2","label_styles_display","");
INSERT INTO `wp_nf3_field_meta` VALUES("105","2","label_styles_float","");
INSERT INTO `wp_nf3_field_meta` VALUES("106","2","label_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_field_meta` VALUES("107","2","label_styles_advanced","");
INSERT INTO `wp_nf3_field_meta` VALUES("108","2","element_styles_background-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("109","2","element_styles_border","");
INSERT INTO `wp_nf3_field_meta` VALUES("110","2","element_styles_border-style","");
INSERT INTO `wp_nf3_field_meta` VALUES("111","2","element_styles_border-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("112","2","element_styles_color","");
INSERT INTO `wp_nf3_field_meta` VALUES("113","2","element_styles_height","");
INSERT INTO `wp_nf3_field_meta` VALUES("114","2","element_styles_width","");
INSERT INTO `wp_nf3_field_meta` VALUES("115","2","element_styles_font-size","");
INSERT INTO `wp_nf3_field_meta` VALUES("116","2","element_styles_margin","");
INSERT INTO `wp_nf3_field_meta` VALUES("117","2","element_styles_padding","");
INSERT INTO `wp_nf3_field_meta` VALUES("118","2","element_styles_display","");
INSERT INTO `wp_nf3_field_meta` VALUES("119","2","element_styles_float","");
INSERT INTO `wp_nf3_field_meta` VALUES("120","2","element_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_field_meta` VALUES("121","2","element_styles_advanced","");
INSERT INTO `wp_nf3_field_meta` VALUES("122","2","cellcid","c3281");
INSERT INTO `wp_nf3_field_meta` VALUES("123","3","label_pos","above");
INSERT INTO `wp_nf3_field_meta` VALUES("124","3","required","0");
INSERT INTO `wp_nf3_field_meta` VALUES("125","3","order","5");
INSERT INTO `wp_nf3_field_meta` VALUES("126","3","placeholder","");
INSERT INTO `wp_nf3_field_meta` VALUES("127","3","default","");
INSERT INTO `wp_nf3_field_meta` VALUES("128","3","wrapper_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("129","3","element_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("130","3","objectType","Field");
INSERT INTO `wp_nf3_field_meta` VALUES("131","3","objectDomain","fields");
INSERT INTO `wp_nf3_field_meta` VALUES("132","3","editActive","");
INSERT INTO `wp_nf3_field_meta` VALUES("133","3","container_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("134","3","input_limit","");
INSERT INTO `wp_nf3_field_meta` VALUES("135","3","input_limit_type","characters");
INSERT INTO `wp_nf3_field_meta` VALUES("136","3","input_limit_msg","Character(s) left");
INSERT INTO `wp_nf3_field_meta` VALUES("137","3","manual_key","");
INSERT INTO `wp_nf3_field_meta` VALUES("138","3","disable_input","");
INSERT INTO `wp_nf3_field_meta` VALUES("139","3","admin_label","");
INSERT INTO `wp_nf3_field_meta` VALUES("140","3","help_text","");
INSERT INTO `wp_nf3_field_meta` VALUES("141","3","desc_text","");
INSERT INTO `wp_nf3_field_meta` VALUES("142","3","disable_browser_autocomplete","");
INSERT INTO `wp_nf3_field_meta` VALUES("143","3","textarea_rte","");
INSERT INTO `wp_nf3_field_meta` VALUES("144","3","disable_rte_mobile","");
INSERT INTO `wp_nf3_field_meta` VALUES("145","3","textarea_media","");
INSERT INTO `wp_nf3_field_meta` VALUES("146","3","wrap_styles_background-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("147","3","wrap_styles_border","");
INSERT INTO `wp_nf3_field_meta` VALUES("148","3","wrap_styles_border-style","");
INSERT INTO `wp_nf3_field_meta` VALUES("149","3","wrap_styles_border-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("150","3","wrap_styles_color","");
INSERT INTO `wp_nf3_field_meta` VALUES("151","3","wrap_styles_height","");
INSERT INTO `wp_nf3_field_meta` VALUES("152","3","wrap_styles_width","");
INSERT INTO `wp_nf3_field_meta` VALUES("153","3","wrap_styles_font-size","");
INSERT INTO `wp_nf3_field_meta` VALUES("154","3","wrap_styles_margin","");
INSERT INTO `wp_nf3_field_meta` VALUES("155","3","wrap_styles_padding","");
INSERT INTO `wp_nf3_field_meta` VALUES("156","3","wrap_styles_display","");
INSERT INTO `wp_nf3_field_meta` VALUES("157","3","wrap_styles_float","");
INSERT INTO `wp_nf3_field_meta` VALUES("158","3","wrap_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_field_meta` VALUES("159","3","wrap_styles_advanced","");
INSERT INTO `wp_nf3_field_meta` VALUES("160","3","label_styles_background-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("161","3","label_styles_border","");
INSERT INTO `wp_nf3_field_meta` VALUES("162","3","label_styles_border-style","");
INSERT INTO `wp_nf3_field_meta` VALUES("163","3","label_styles_border-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("164","3","label_styles_color","");
INSERT INTO `wp_nf3_field_meta` VALUES("165","3","label_styles_height","");
INSERT INTO `wp_nf3_field_meta` VALUES("166","3","label_styles_width","");
INSERT INTO `wp_nf3_field_meta` VALUES("167","3","label_styles_font-size","");
INSERT INTO `wp_nf3_field_meta` VALUES("168","3","label_styles_margin","");
INSERT INTO `wp_nf3_field_meta` VALUES("169","3","label_styles_padding","");
INSERT INTO `wp_nf3_field_meta` VALUES("170","3","label_styles_display","");
INSERT INTO `wp_nf3_field_meta` VALUES("171","3","label_styles_float","");
INSERT INTO `wp_nf3_field_meta` VALUES("172","3","label_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_field_meta` VALUES("173","3","label_styles_advanced","");
INSERT INTO `wp_nf3_field_meta` VALUES("174","3","element_styles_background-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("175","3","element_styles_border","");
INSERT INTO `wp_nf3_field_meta` VALUES("176","3","element_styles_border-style","");
INSERT INTO `wp_nf3_field_meta` VALUES("177","3","element_styles_border-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("178","3","element_styles_color","");
INSERT INTO `wp_nf3_field_meta` VALUES("179","3","element_styles_height","");
INSERT INTO `wp_nf3_field_meta` VALUES("180","3","element_styles_width","");
INSERT INTO `wp_nf3_field_meta` VALUES("181","3","element_styles_font-size","");
INSERT INTO `wp_nf3_field_meta` VALUES("182","3","element_styles_margin","");
INSERT INTO `wp_nf3_field_meta` VALUES("183","3","element_styles_padding","");
INSERT INTO `wp_nf3_field_meta` VALUES("184","3","element_styles_display","");
INSERT INTO `wp_nf3_field_meta` VALUES("185","3","element_styles_float","");
INSERT INTO `wp_nf3_field_meta` VALUES("186","3","element_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_field_meta` VALUES("187","3","element_styles_advanced","");
INSERT INTO `wp_nf3_field_meta` VALUES("188","3","cellcid","c3284");
INSERT INTO `wp_nf3_field_meta` VALUES("189","4","processing_label","Procesando");
INSERT INTO `wp_nf3_field_meta` VALUES("190","4","order","6");
INSERT INTO `wp_nf3_field_meta` VALUES("191","4","objectType","Field");
INSERT INTO `wp_nf3_field_meta` VALUES("192","4","objectDomain","fields");
INSERT INTO `wp_nf3_field_meta` VALUES("193","4","editActive","");
INSERT INTO `wp_nf3_field_meta` VALUES("194","4","container_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("195","4","element_class","boton-enviar");
INSERT INTO `wp_nf3_field_meta` VALUES("196","4","wrap_styles_background-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("197","4","wrap_styles_border","");
INSERT INTO `wp_nf3_field_meta` VALUES("198","4","wrap_styles_border-style","");
INSERT INTO `wp_nf3_field_meta` VALUES("199","4","wrap_styles_border-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("200","4","wrap_styles_color","");
INSERT INTO `wp_nf3_field_meta` VALUES("201","4","wrap_styles_height","");
INSERT INTO `wp_nf3_field_meta` VALUES("202","4","wrap_styles_width","");
INSERT INTO `wp_nf3_field_meta` VALUES("203","4","wrap_styles_font-size","");
INSERT INTO `wp_nf3_field_meta` VALUES("204","4","wrap_styles_margin","");
INSERT INTO `wp_nf3_field_meta` VALUES("205","4","wrap_styles_padding","");
INSERT INTO `wp_nf3_field_meta` VALUES("206","4","wrap_styles_display","");
INSERT INTO `wp_nf3_field_meta` VALUES("207","4","wrap_styles_float","");
INSERT INTO `wp_nf3_field_meta` VALUES("208","4","wrap_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_field_meta` VALUES("209","4","wrap_styles_advanced","");
INSERT INTO `wp_nf3_field_meta` VALUES("210","4","label_styles_background-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("211","4","label_styles_border","");
INSERT INTO `wp_nf3_field_meta` VALUES("212","4","label_styles_border-style","");
INSERT INTO `wp_nf3_field_meta` VALUES("213","4","label_styles_border-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("214","4","label_styles_color","");
INSERT INTO `wp_nf3_field_meta` VALUES("215","4","label_styles_height","");
INSERT INTO `wp_nf3_field_meta` VALUES("216","4","label_styles_width","");
INSERT INTO `wp_nf3_field_meta` VALUES("217","4","label_styles_font-size","");
INSERT INTO `wp_nf3_field_meta` VALUES("218","4","label_styles_margin","");
INSERT INTO `wp_nf3_field_meta` VALUES("219","4","label_styles_padding","");
INSERT INTO `wp_nf3_field_meta` VALUES("220","4","label_styles_display","");
INSERT INTO `wp_nf3_field_meta` VALUES("221","4","label_styles_float","");
INSERT INTO `wp_nf3_field_meta` VALUES("222","4","label_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_field_meta` VALUES("223","4","label_styles_advanced","");
INSERT INTO `wp_nf3_field_meta` VALUES("224","4","element_styles_background-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("225","4","element_styles_border","");
INSERT INTO `wp_nf3_field_meta` VALUES("226","4","element_styles_border-style","");
INSERT INTO `wp_nf3_field_meta` VALUES("227","4","element_styles_border-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("228","4","element_styles_color","");
INSERT INTO `wp_nf3_field_meta` VALUES("229","4","element_styles_height","");
INSERT INTO `wp_nf3_field_meta` VALUES("230","4","element_styles_width","");
INSERT INTO `wp_nf3_field_meta` VALUES("231","4","element_styles_font-size","");
INSERT INTO `wp_nf3_field_meta` VALUES("232","4","element_styles_margin","");
INSERT INTO `wp_nf3_field_meta` VALUES("233","4","element_styles_padding","");
INSERT INTO `wp_nf3_field_meta` VALUES("234","4","element_styles_display","");
INSERT INTO `wp_nf3_field_meta` VALUES("235","4","element_styles_float","");
INSERT INTO `wp_nf3_field_meta` VALUES("236","4","element_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_field_meta` VALUES("237","4","element_styles_advanced","");
INSERT INTO `wp_nf3_field_meta` VALUES("238","4","submit_element_hover_styles_background-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("239","4","submit_element_hover_styles_border","");
INSERT INTO `wp_nf3_field_meta` VALUES("240","4","submit_element_hover_styles_border-style","");
INSERT INTO `wp_nf3_field_meta` VALUES("241","4","submit_element_hover_styles_border-color","");
INSERT INTO `wp_nf3_field_meta` VALUES("242","4","submit_element_hover_styles_color","");
INSERT INTO `wp_nf3_field_meta` VALUES("243","4","submit_element_hover_styles_height","");
INSERT INTO `wp_nf3_field_meta` VALUES("244","4","submit_element_hover_styles_width","");
INSERT INTO `wp_nf3_field_meta` VALUES("245","4","submit_element_hover_styles_font-size","");
INSERT INTO `wp_nf3_field_meta` VALUES("246","4","submit_element_hover_styles_margin","");
INSERT INTO `wp_nf3_field_meta` VALUES("247","4","submit_element_hover_styles_padding","");
INSERT INTO `wp_nf3_field_meta` VALUES("248","4","submit_element_hover_styles_display","");
INSERT INTO `wp_nf3_field_meta` VALUES("249","4","submit_element_hover_styles_float","");
INSERT INTO `wp_nf3_field_meta` VALUES("250","4","submit_element_hover_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_field_meta` VALUES("251","4","submit_element_hover_styles_advanced","");
INSERT INTO `wp_nf3_field_meta` VALUES("252","4","cellcid","c3287");
INSERT INTO `wp_nf3_field_meta` VALUES("253","5","objectType","Field");
INSERT INTO `wp_nf3_field_meta` VALUES("254","5","objectDomain","fields");
INSERT INTO `wp_nf3_field_meta` VALUES("255","5","editActive","");
INSERT INTO `wp_nf3_field_meta` VALUES("256","5","order","1");
INSERT INTO `wp_nf3_field_meta` VALUES("257","5","label_pos","above");
INSERT INTO `wp_nf3_field_meta` VALUES("258","5","required","1");
INSERT INTO `wp_nf3_field_meta` VALUES("259","5","default","");
INSERT INTO `wp_nf3_field_meta` VALUES("260","5","placeholder","Nombre");
INSERT INTO `wp_nf3_field_meta` VALUES("261","5","container_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("262","5","element_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("263","5","admin_label","");
INSERT INTO `wp_nf3_field_meta` VALUES("264","5","help_text","");
INSERT INTO `wp_nf3_field_meta` VALUES("265","5","desc_text","");
INSERT INTO `wp_nf3_field_meta` VALUES("266","6","objectType","Field");
INSERT INTO `wp_nf3_field_meta` VALUES("267","6","objectDomain","fields");
INSERT INTO `wp_nf3_field_meta` VALUES("268","6","editActive","");
INSERT INTO `wp_nf3_field_meta` VALUES("269","6","order","2");
INSERT INTO `wp_nf3_field_meta` VALUES("270","6","label_pos","above");
INSERT INTO `wp_nf3_field_meta` VALUES("271","6","required","1");
INSERT INTO `wp_nf3_field_meta` VALUES("272","6","default","");
INSERT INTO `wp_nf3_field_meta` VALUES("273","6","placeholder","Apellido");
INSERT INTO `wp_nf3_field_meta` VALUES("274","6","container_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("275","6","element_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("276","6","admin_label","");
INSERT INTO `wp_nf3_field_meta` VALUES("277","6","help_text","");
INSERT INTO `wp_nf3_field_meta` VALUES("278","6","desc_text","");
INSERT INTO `wp_nf3_field_meta` VALUES("279","7","objectType","Field");
INSERT INTO `wp_nf3_field_meta` VALUES("280","7","objectDomain","fields");
INSERT INTO `wp_nf3_field_meta` VALUES("281","7","editActive","");
INSERT INTO `wp_nf3_field_meta` VALUES("282","7","order","4");
INSERT INTO `wp_nf3_field_meta` VALUES("283","7","label_pos","above");
INSERT INTO `wp_nf3_field_meta` VALUES("284","7","required","0");
INSERT INTO `wp_nf3_field_meta` VALUES("285","7","placeholder","(416) 588-9988");
INSERT INTO `wp_nf3_field_meta` VALUES("286","7","default","");
INSERT INTO `wp_nf3_field_meta` VALUES("287","7","container_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("288","7","element_class","");
INSERT INTO `wp_nf3_field_meta` VALUES("289","7","input_limit","");
INSERT INTO `wp_nf3_field_meta` VALUES("290","7","input_limit_type","characters");
INSERT INTO `wp_nf3_field_meta` VALUES("291","7","input_limit_msg","Caracteres restantes");
INSERT INTO `wp_nf3_field_meta` VALUES("292","7","manual_key","");
INSERT INTO `wp_nf3_field_meta` VALUES("293","7","disable_input","");
INSERT INTO `wp_nf3_field_meta` VALUES("294","7","admin_label","");
INSERT INTO `wp_nf3_field_meta` VALUES("295","7","help_text","");
INSERT INTO `wp_nf3_field_meta` VALUES("296","7","desc_text","");
INSERT INTO `wp_nf3_field_meta` VALUES("297","7","disable_browser_autocomplete","");
INSERT INTO `wp_nf3_field_meta` VALUES("298","7","mask","(999) 999-9999");
INSERT INTO `wp_nf3_field_meta` VALUES("299","7","custom_mask","");


DROP TABLE IF EXISTS `wp_nf3_fields`;

CREATE TABLE `wp_nf3_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `label` longtext COLLATE utf8mb4_unicode_ci,
  `key` longtext COLLATE utf8mb4_unicode_ci,
  `type` longtext COLLATE utf8mb4_unicode_ci,
  `parent_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_nf3_fields` VALUES("2","E-mail","e-mail","email","1","2016-08-24 13:39:20","");
INSERT INTO `wp_nf3_fields` VALUES("3","Comentario","comentario","textarea","1","2016-08-24 13:39:20","");
INSERT INTO `wp_nf3_fields` VALUES("4","ENVIAR","enviar_1","submit","1","2016-08-24 13:39:20","");
INSERT INTO `wp_nf3_fields` VALUES("5","Nombre","nombre","firstname","1","0000-00-00 00:00:00","");
INSERT INTO `wp_nf3_fields` VALUES("6","Apellido","lastname","lastname","1","0000-00-00 00:00:00","");
INSERT INTO `wp_nf3_fields` VALUES("7","Teléfono","phone","phone","1","0000-00-00 00:00:00","");


DROP TABLE IF EXISTS `wp_nf3_form_meta`;

CREATE TABLE `wp_nf3_form_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `key` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_nf3_form_meta` VALUES("1","1","default_label_pos","above");
INSERT INTO `wp_nf3_form_meta` VALUES("2","1","_seq_num","4");
INSERT INTO `wp_nf3_form_meta` VALUES("3","1","conditions","a:0:{}");
INSERT INTO `wp_nf3_form_meta` VALUES("4","1","objectType","Form Setting");
INSERT INTO `wp_nf3_form_meta` VALUES("5","1","editActive","1");
INSERT INTO `wp_nf3_form_meta` VALUES("6","1","show_title","0");
INSERT INTO `wp_nf3_form_meta` VALUES("7","1","clear_complete","1");
INSERT INTO `wp_nf3_form_meta` VALUES("8","1","hide_complete","0");
INSERT INTO `wp_nf3_form_meta` VALUES("9","1","wrapper_class","formulario-contacto");
INSERT INTO `wp_nf3_form_meta` VALUES("10","1","element_class","");
INSERT INTO `wp_nf3_form_meta` VALUES("11","1","add_submit","1");
INSERT INTO `wp_nf3_form_meta` VALUES("12","1","logged_in","");
INSERT INTO `wp_nf3_form_meta` VALUES("13","1","not_logged_in_msg","");
INSERT INTO `wp_nf3_form_meta` VALUES("14","1","sub_limit_number","");
INSERT INTO `wp_nf3_form_meta` VALUES("15","1","sub_limit_msg","");
INSERT INTO `wp_nf3_form_meta` VALUES("16","1","calculations","a:0:{}");
INSERT INTO `wp_nf3_form_meta` VALUES("17","1","formContentData","a:6:{i:0;s:6:\"nombre\";i:1;s:8:\"lastname\";i:2;s:6:\"e-mail\";i:3;s:5:\"phone\";i:4;s:10:\"comentario\";i:5;s:6:\"enviar\";}");
INSERT INTO `wp_nf3_form_meta` VALUES("98","1","currency","");
INSERT INTO `wp_nf3_form_meta` VALUES("99","1","fieldContentsData","a:6:{i:0;a:19:{s:5:\"label\";s:6:\"Nombre\";s:3:\"key\";s:6:\"nombre\";s:9:\"parent_id\";i:1;s:4:\"type\";s:9:\"firstname\";s:10:\"created_at\";s:19:\"0000-00-00 00:00:00\";s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:5:\"order\";i:1;s:9:\"label_pos\";s:5:\"above\";s:8:\"required\";i:1;s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:6:\"Nombre\";s:15:\"container_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:9:\"desc_text\";s:0:\"\";s:2:\"id\";i:5;}i:1;a:19:{s:5:\"label\";s:8:\"Apellido\";s:3:\"key\";s:8:\"lastname\";s:9:\"parent_id\";i:1;s:4:\"type\";s:8:\"lastname\";s:10:\"created_at\";s:19:\"0000-00-00 00:00:00\";s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:5:\"order\";i:2;s:9:\"label_pos\";s:5:\"above\";s:8:\"required\";i:1;s:7:\"default\";s:0:\"\";s:11:\"placeholder\";s:8:\"Apellido\";s:15:\"container_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:9:\"desc_text\";s:0:\"\";s:2:\"id\";i:6;}i:2;a:63:{s:5:\"label\";s:6:\"E-mail\";s:3:\"key\";s:6:\"e-mail\";s:9:\"parent_id\";i:1;s:4:\"type\";s:5:\"email\";s:10:\"created_at\";s:19:\"2016-08-24 16:39:20\";s:9:\"label_pos\";s:5:\"above\";s:8:\"required\";i:1;s:5:\"order\";i:3;s:11:\"placeholder\";s:16:\"email@domain.com\";s:7:\"default\";s:0:\"\";s:13:\"wrapper_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:15:\"container_class\";s:0:\"\";s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:9:\"desc_text\";s:0:\"\";s:28:\"wrap_styles_background-color\";s:0:\"\";s:18:\"wrap_styles_border\";s:0:\"\";s:24:\"wrap_styles_border-style\";s:0:\"\";s:24:\"wrap_styles_border-color\";s:0:\"\";s:17:\"wrap_styles_color\";s:0:\"\";s:18:\"wrap_styles_height\";s:0:\"\";s:17:\"wrap_styles_width\";s:0:\"\";s:21:\"wrap_styles_font-size\";s:0:\"\";s:18:\"wrap_styles_margin\";s:0:\"\";s:19:\"wrap_styles_padding\";s:0:\"\";s:19:\"wrap_styles_display\";s:0:\"\";s:17:\"wrap_styles_float\";s:0:\"\";s:29:\"wrap_styles_show_advanced_css\";i:0;s:20:\"wrap_styles_advanced\";s:0:\"\";s:29:\"label_styles_background-color\";s:0:\"\";s:19:\"label_styles_border\";s:0:\"\";s:25:\"label_styles_border-style\";s:0:\"\";s:25:\"label_styles_border-color\";s:0:\"\";s:18:\"label_styles_color\";s:0:\"\";s:19:\"label_styles_height\";s:0:\"\";s:18:\"label_styles_width\";s:0:\"\";s:22:\"label_styles_font-size\";s:0:\"\";s:19:\"label_styles_margin\";s:0:\"\";s:20:\"label_styles_padding\";s:0:\"\";s:20:\"label_styles_display\";s:0:\"\";s:18:\"label_styles_float\";s:0:\"\";s:30:\"label_styles_show_advanced_css\";i:0;s:21:\"label_styles_advanced\";s:0:\"\";s:31:\"element_styles_background-color\";s:0:\"\";s:21:\"element_styles_border\";s:0:\"\";s:27:\"element_styles_border-style\";s:0:\"\";s:27:\"element_styles_border-color\";s:0:\"\";s:20:\"element_styles_color\";s:0:\"\";s:21:\"element_styles_height\";s:0:\"\";s:20:\"element_styles_width\";s:0:\"\";s:24:\"element_styles_font-size\";s:0:\"\";s:21:\"element_styles_margin\";s:0:\"\";s:22:\"element_styles_padding\";s:0:\"\";s:22:\"element_styles_display\";s:0:\"\";s:20:\"element_styles_float\";s:0:\"\";s:32:\"element_styles_show_advanced_css\";i:0;s:23:\"element_styles_advanced\";s:0:\"\";s:7:\"cellcid\";s:5:\"c3281\";s:2:\"id\";i:2;}i:3;a:27:{s:5:\"label\";s:9:\"Teléfono\";s:3:\"key\";s:5:\"phone\";s:9:\"parent_id\";i:1;s:4:\"type\";s:5:\"phone\";s:10:\"created_at\";s:19:\"0000-00-00 00:00:00\";s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:5:\"order\";i:4;s:9:\"label_pos\";s:5:\"above\";s:8:\"required\";i:0;s:11:\"placeholder\";s:14:\"(416) 588-9988\";s:7:\"default\";s:0:\"\";s:15:\"container_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:11:\"input_limit\";s:0:\"\";s:16:\"input_limit_type\";s:10:\"characters\";s:15:\"input_limit_msg\";s:20:\"Caracteres restantes\";s:10:\"manual_key\";s:0:\"\";s:13:\"disable_input\";s:0:\"\";s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:9:\"desc_text\";s:0:\"\";s:28:\"disable_browser_autocomplete\";s:0:\"\";s:4:\"mask\";s:14:\"(999) 999-9999\";s:11:\"custom_mask\";s:0:\"\";s:2:\"id\";i:7;}i:4;a:72:{s:5:\"label\";s:10:\"Comentario\";s:3:\"key\";s:10:\"comentario\";s:9:\"parent_id\";i:1;s:4:\"type\";s:8:\"textarea\";s:10:\"created_at\";s:19:\"2016-08-24 16:39:20\";s:9:\"label_pos\";s:5:\"above\";s:8:\"required\";i:0;s:5:\"order\";i:5;s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"wrapper_class\";s:0:\"\";s:13:\"element_class\";s:0:\"\";s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:15:\"container_class\";s:0:\"\";s:11:\"input_limit\";s:0:\"\";s:16:\"input_limit_type\";s:10:\"characters\";s:15:\"input_limit_msg\";s:17:\"Character(s) left\";s:10:\"manual_key\";s:0:\"\";s:13:\"disable_input\";s:0:\"\";s:11:\"admin_label\";s:0:\"\";s:9:\"help_text\";s:0:\"\";s:9:\"desc_text\";s:0:\"\";s:28:\"disable_browser_autocomplete\";s:0:\"\";s:12:\"textarea_rte\";s:0:\"\";s:18:\"disable_rte_mobile\";s:0:\"\";s:14:\"textarea_media\";s:0:\"\";s:28:\"wrap_styles_background-color\";s:0:\"\";s:18:\"wrap_styles_border\";s:0:\"\";s:24:\"wrap_styles_border-style\";s:0:\"\";s:24:\"wrap_styles_border-color\";s:0:\"\";s:17:\"wrap_styles_color\";s:0:\"\";s:18:\"wrap_styles_height\";s:0:\"\";s:17:\"wrap_styles_width\";s:0:\"\";s:21:\"wrap_styles_font-size\";s:0:\"\";s:18:\"wrap_styles_margin\";s:0:\"\";s:19:\"wrap_styles_padding\";s:0:\"\";s:19:\"wrap_styles_display\";s:0:\"\";s:17:\"wrap_styles_float\";s:0:\"\";s:29:\"wrap_styles_show_advanced_css\";i:0;s:20:\"wrap_styles_advanced\";s:0:\"\";s:29:\"label_styles_background-color\";s:0:\"\";s:19:\"label_styles_border\";s:0:\"\";s:25:\"label_styles_border-style\";s:0:\"\";s:25:\"label_styles_border-color\";s:0:\"\";s:18:\"label_styles_color\";s:0:\"\";s:19:\"label_styles_height\";s:0:\"\";s:18:\"label_styles_width\";s:0:\"\";s:22:\"label_styles_font-size\";s:0:\"\";s:19:\"label_styles_margin\";s:0:\"\";s:20:\"label_styles_padding\";s:0:\"\";s:20:\"label_styles_display\";s:0:\"\";s:18:\"label_styles_float\";s:0:\"\";s:30:\"label_styles_show_advanced_css\";i:0;s:21:\"label_styles_advanced\";s:0:\"\";s:31:\"element_styles_background-color\";s:0:\"\";s:21:\"element_styles_border\";s:0:\"\";s:27:\"element_styles_border-style\";s:0:\"\";s:27:\"element_styles_border-color\";s:0:\"\";s:20:\"element_styles_color\";s:0:\"\";s:21:\"element_styles_height\";s:0:\"\";s:20:\"element_styles_width\";s:0:\"\";s:24:\"element_styles_font-size\";s:0:\"\";s:21:\"element_styles_margin\";s:0:\"\";s:22:\"element_styles_padding\";s:0:\"\";s:22:\"element_styles_display\";s:0:\"\";s:20:\"element_styles_float\";s:0:\"\";s:32:\"element_styles_show_advanced_css\";i:0;s:23:\"element_styles_advanced\";s:0:\"\";s:7:\"cellcid\";s:5:\"c3284\";s:2:\"id\";i:3;}i:5;a:70:{s:5:\"label\";s:6:\"ENVIAR\";s:3:\"key\";s:8:\"enviar_1\";s:9:\"parent_id\";i:1;s:4:\"type\";s:6:\"submit\";s:10:\"created_at\";s:19:\"2016-08-24 16:39:20\";s:16:\"processing_label\";s:10:\"Procesando\";s:5:\"order\";i:6;s:10:\"objectType\";s:5:\"Field\";s:12:\"objectDomain\";s:6:\"fields\";s:10:\"editActive\";b:0;s:15:\"container_class\";s:0:\"\";s:13:\"element_class\";s:12:\"boton-enviar\";s:28:\"wrap_styles_background-color\";s:0:\"\";s:18:\"wrap_styles_border\";s:0:\"\";s:24:\"wrap_styles_border-style\";s:0:\"\";s:24:\"wrap_styles_border-color\";s:0:\"\";s:17:\"wrap_styles_color\";s:0:\"\";s:18:\"wrap_styles_height\";s:0:\"\";s:17:\"wrap_styles_width\";s:0:\"\";s:21:\"wrap_styles_font-size\";s:0:\"\";s:18:\"wrap_styles_margin\";s:0:\"\";s:19:\"wrap_styles_padding\";s:0:\"\";s:19:\"wrap_styles_display\";s:0:\"\";s:17:\"wrap_styles_float\";s:0:\"\";s:29:\"wrap_styles_show_advanced_css\";i:0;s:20:\"wrap_styles_advanced\";s:0:\"\";s:29:\"label_styles_background-color\";s:0:\"\";s:19:\"label_styles_border\";s:0:\"\";s:25:\"label_styles_border-style\";s:0:\"\";s:25:\"label_styles_border-color\";s:0:\"\";s:18:\"label_styles_color\";s:0:\"\";s:19:\"label_styles_height\";s:0:\"\";s:18:\"label_styles_width\";s:0:\"\";s:22:\"label_styles_font-size\";s:0:\"\";s:19:\"label_styles_margin\";s:0:\"\";s:20:\"label_styles_padding\";s:0:\"\";s:20:\"label_styles_display\";s:0:\"\";s:18:\"label_styles_float\";s:0:\"\";s:30:\"label_styles_show_advanced_css\";i:0;s:21:\"label_styles_advanced\";s:0:\"\";s:31:\"element_styles_background-color\";s:0:\"\";s:21:\"element_styles_border\";s:0:\"\";s:27:\"element_styles_border-style\";s:0:\"\";s:27:\"element_styles_border-color\";s:0:\"\";s:20:\"element_styles_color\";s:0:\"\";s:21:\"element_styles_height\";s:0:\"\";s:20:\"element_styles_width\";s:0:\"\";s:24:\"element_styles_font-size\";s:0:\"\";s:21:\"element_styles_margin\";s:0:\"\";s:22:\"element_styles_padding\";s:0:\"\";s:22:\"element_styles_display\";s:0:\"\";s:20:\"element_styles_float\";s:0:\"\";s:32:\"element_styles_show_advanced_css\";i:0;s:23:\"element_styles_advanced\";s:0:\"\";s:44:\"submit_element_hover_styles_background-color\";s:0:\"\";s:34:\"submit_element_hover_styles_border\";s:0:\"\";s:40:\"submit_element_hover_styles_border-style\";s:0:\"\";s:40:\"submit_element_hover_styles_border-color\";s:0:\"\";s:33:\"submit_element_hover_styles_color\";s:0:\"\";s:34:\"submit_element_hover_styles_height\";s:0:\"\";s:33:\"submit_element_hover_styles_width\";s:0:\"\";s:37:\"submit_element_hover_styles_font-size\";s:0:\"\";s:34:\"submit_element_hover_styles_margin\";s:0:\"\";s:35:\"submit_element_hover_styles_padding\";s:0:\"\";s:35:\"submit_element_hover_styles_display\";s:0:\"\";s:33:\"submit_element_hover_styles_float\";s:0:\"\";s:45:\"submit_element_hover_styles_show_advanced_css\";i:0;s:36:\"submit_element_hover_styles_advanced\";s:0:\"\";s:7:\"cellcid\";s:5:\"c3287\";s:2:\"id\";i:4;}}");
INSERT INTO `wp_nf3_form_meta` VALUES("18","1","container_styles_background-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("19","1","container_styles_border","");
INSERT INTO `wp_nf3_form_meta` VALUES("20","1","container_styles_border-style","");
INSERT INTO `wp_nf3_form_meta` VALUES("21","1","container_styles_border-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("22","1","container_styles_color","");
INSERT INTO `wp_nf3_form_meta` VALUES("23","1","container_styles_height","");
INSERT INTO `wp_nf3_form_meta` VALUES("24","1","container_styles_width","");
INSERT INTO `wp_nf3_form_meta` VALUES("25","1","container_styles_font-size","");
INSERT INTO `wp_nf3_form_meta` VALUES("26","1","container_styles_margin","");
INSERT INTO `wp_nf3_form_meta` VALUES("27","1","container_styles_padding","");
INSERT INTO `wp_nf3_form_meta` VALUES("28","1","container_styles_display","");
INSERT INTO `wp_nf3_form_meta` VALUES("29","1","container_styles_float","");
INSERT INTO `wp_nf3_form_meta` VALUES("30","1","container_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_form_meta` VALUES("31","1","container_styles_advanced","");
INSERT INTO `wp_nf3_form_meta` VALUES("32","1","title_styles_background-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("33","1","title_styles_border","");
INSERT INTO `wp_nf3_form_meta` VALUES("34","1","title_styles_border-style","");
INSERT INTO `wp_nf3_form_meta` VALUES("35","1","title_styles_border-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("36","1","title_styles_color","");
INSERT INTO `wp_nf3_form_meta` VALUES("37","1","title_styles_height","");
INSERT INTO `wp_nf3_form_meta` VALUES("38","1","title_styles_width","");
INSERT INTO `wp_nf3_form_meta` VALUES("39","1","title_styles_font-size","");
INSERT INTO `wp_nf3_form_meta` VALUES("40","1","title_styles_margin","");
INSERT INTO `wp_nf3_form_meta` VALUES("41","1","title_styles_padding","");
INSERT INTO `wp_nf3_form_meta` VALUES("42","1","title_styles_display","");
INSERT INTO `wp_nf3_form_meta` VALUES("43","1","title_styles_float","");
INSERT INTO `wp_nf3_form_meta` VALUES("44","1","title_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_form_meta` VALUES("45","1","title_styles_advanced","");
INSERT INTO `wp_nf3_form_meta` VALUES("46","1","row_styles_background-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("47","1","row_styles_border","");
INSERT INTO `wp_nf3_form_meta` VALUES("48","1","row_styles_border-style","");
INSERT INTO `wp_nf3_form_meta` VALUES("49","1","row_styles_border-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("50","1","row_styles_color","");
INSERT INTO `wp_nf3_form_meta` VALUES("51","1","row_styles_height","");
INSERT INTO `wp_nf3_form_meta` VALUES("52","1","row_styles_width","");
INSERT INTO `wp_nf3_form_meta` VALUES("53","1","row_styles_font-size","");
INSERT INTO `wp_nf3_form_meta` VALUES("54","1","row_styles_margin","");
INSERT INTO `wp_nf3_form_meta` VALUES("55","1","row_styles_padding","");
INSERT INTO `wp_nf3_form_meta` VALUES("56","1","row_styles_display","");
INSERT INTO `wp_nf3_form_meta` VALUES("57","1","row_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_form_meta` VALUES("58","1","row_styles_advanced","");
INSERT INTO `wp_nf3_form_meta` VALUES("59","1","row-odd_styles_background-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("60","1","row-odd_styles_border","");
INSERT INTO `wp_nf3_form_meta` VALUES("61","1","row-odd_styles_border-style","");
INSERT INTO `wp_nf3_form_meta` VALUES("62","1","row-odd_styles_border-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("63","1","row-odd_styles_color","");
INSERT INTO `wp_nf3_form_meta` VALUES("64","1","row-odd_styles_height","");
INSERT INTO `wp_nf3_form_meta` VALUES("65","1","row-odd_styles_width","");
INSERT INTO `wp_nf3_form_meta` VALUES("66","1","row-odd_styles_font-size","");
INSERT INTO `wp_nf3_form_meta` VALUES("67","1","row-odd_styles_margin","");
INSERT INTO `wp_nf3_form_meta` VALUES("68","1","row-odd_styles_padding","");
INSERT INTO `wp_nf3_form_meta` VALUES("69","1","row-odd_styles_display","");
INSERT INTO `wp_nf3_form_meta` VALUES("70","1","row-odd_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_form_meta` VALUES("71","1","row-odd_styles_advanced","");
INSERT INTO `wp_nf3_form_meta` VALUES("72","1","success-msg_styles_background-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("73","1","success-msg_styles_border","");
INSERT INTO `wp_nf3_form_meta` VALUES("74","1","success-msg_styles_border-style","");
INSERT INTO `wp_nf3_form_meta` VALUES("75","1","success-msg_styles_border-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("76","1","success-msg_styles_color","");
INSERT INTO `wp_nf3_form_meta` VALUES("77","1","success-msg_styles_height","");
INSERT INTO `wp_nf3_form_meta` VALUES("78","1","success-msg_styles_width","");
INSERT INTO `wp_nf3_form_meta` VALUES("79","1","success-msg_styles_font-size","");
INSERT INTO `wp_nf3_form_meta` VALUES("80","1","success-msg_styles_margin","");
INSERT INTO `wp_nf3_form_meta` VALUES("81","1","success-msg_styles_padding","");
INSERT INTO `wp_nf3_form_meta` VALUES("82","1","success-msg_styles_display","");
INSERT INTO `wp_nf3_form_meta` VALUES("83","1","success-msg_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_form_meta` VALUES("84","1","success-msg_styles_advanced","");
INSERT INTO `wp_nf3_form_meta` VALUES("85","1","error_msg_styles_background-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("86","1","error_msg_styles_border","");
INSERT INTO `wp_nf3_form_meta` VALUES("87","1","error_msg_styles_border-style","");
INSERT INTO `wp_nf3_form_meta` VALUES("88","1","error_msg_styles_border-color","");
INSERT INTO `wp_nf3_form_meta` VALUES("89","1","error_msg_styles_color","");
INSERT INTO `wp_nf3_form_meta` VALUES("90","1","error_msg_styles_height","");
INSERT INTO `wp_nf3_form_meta` VALUES("91","1","error_msg_styles_width","");
INSERT INTO `wp_nf3_form_meta` VALUES("92","1","error_msg_styles_font-size","");
INSERT INTO `wp_nf3_form_meta` VALUES("93","1","error_msg_styles_margin","");
INSERT INTO `wp_nf3_form_meta` VALUES("94","1","error_msg_styles_padding","");
INSERT INTO `wp_nf3_form_meta` VALUES("95","1","error_msg_styles_display","");
INSERT INTO `wp_nf3_form_meta` VALUES("96","1","error_msg_styles_show_advanced_css","0");
INSERT INTO `wp_nf3_form_meta` VALUES("97","1","error_msg_styles_advanced","");


DROP TABLE IF EXISTS `wp_nf3_forms`;

CREATE TABLE `wp_nf3_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `key` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `views` int(11) DEFAULT NULL,
  `subs` int(11) DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_nf3_forms` VALUES("1","Contacto","","2016-08-24 13:39:20","","","");


DROP TABLE IF EXISTS `wp_nf3_object_meta`;

CREATE TABLE `wp_nf3_object_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `key` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_ci,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_nf3_objects`;

CREATE TABLE `wp_nf3_objects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` longtext COLLATE utf8mb4_unicode_ci,
  `title` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_nf3_relationships`;

CREATE TABLE `wp_nf3_relationships` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child_id` int(11) NOT NULL,
  `child_type` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int(11) NOT NULL,
  `parent_type` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;



DROP TABLE IF EXISTS `wp_options`;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=8954 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `wp_options` VALUES("1","siteurl","http://cerere.manaprocloud.com/","yes");
INSERT INTO `wp_options` VALUES("2","home","http://cerere.manaprocloud.com/","yes");
INSERT INTO `wp_options` VALUES("3","blogname","CERERE","yes");
INSERT INTO `wp_options` VALUES("4","blogdescription","","yes");
INSERT INTO `wp_options` VALUES("5","users_can_register","0","yes");
INSERT INTO `wp_options` VALUES("6","admin_email","miguel.rodriguez11@hotmail.com","yes");
INSERT INTO `wp_options` VALUES("7","start_of_week","1","yes");
INSERT INTO `wp_options` VALUES("8","use_balanceTags","0","yes");
INSERT INTO `wp_options` VALUES("9","use_smilies","1","yes");
INSERT INTO `wp_options` VALUES("10","require_name_email","1","yes");
INSERT INTO `wp_options` VALUES("11","comments_notify","1","yes");
INSERT INTO `wp_options` VALUES("12","posts_per_rss","10","yes");
INSERT INTO `wp_options` VALUES("13","rss_use_excerpt","0","yes");
INSERT INTO `wp_options` VALUES("14","mailserver_url","mail.example.com","yes");
INSERT INTO `wp_options` VALUES("15","mailserver_login","login@example.com","yes");
INSERT INTO `wp_options` VALUES("16","mailserver_pass","password","yes");
INSERT INTO `wp_options` VALUES("17","mailserver_port","110","yes");
INSERT INTO `wp_options` VALUES("18","default_category","1","yes");
INSERT INTO `wp_options` VALUES("19","default_comment_status","open","yes");
INSERT INTO `wp_options` VALUES("20","default_ping_status","open","yes");
INSERT INTO `wp_options` VALUES("21","default_pingback_flag","1","yes");
INSERT INTO `wp_options` VALUES("22","posts_per_page","10","yes");
INSERT INTO `wp_options` VALUES("23","date_format","j F, Y","yes");
INSERT INTO `wp_options` VALUES("24","time_format","g:i a","yes");
INSERT INTO `wp_options` VALUES("25","links_updated_date_format","j F, Y g:i a","yes");
INSERT INTO `wp_options` VALUES("26","comment_moderation","0","yes");
INSERT INTO `wp_options` VALUES("27","moderation_notify","1","yes");
INSERT INTO `wp_options` VALUES("28","permalink_structure","/%postname%/","yes");
INSERT INTO `wp_options` VALUES("29","rewrite_rules","a:447:{s:21:\"^aftership-api\\/v1/?$\";s:31:\"index.php?aftership-api-route=/\";s:23:\"^aftership-api\\/v1(.*)?\";s:41:\"index.php?aftership-api-route=$matches[1]\";s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:9:\"nf_sub/?$\";s:26:\"index.php?post_type=nf_sub\";s:39:\"nf_sub/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=nf_sub&feed=$matches[1]\";s:34:\"nf_sub/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?post_type=nf_sub&feed=$matches[1]\";s:26:\"nf_sub/page/([0-9]{1,})/?$\";s:44:\"index.php?post_type=nf_sub&paged=$matches[1]\";s:12:\"productos/?$\";s:27:\"index.php?post_type=product\";s:42:\"productos/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:37:\"productos/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:29:\"productos/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:39:\"category/(.+?)/aftership-api(/(.*))?/?$\";s:61:\"index.php?category_name=$matches[1]&aftership-api=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:36:\"tag/([^/]+)/aftership-api(/(.*))?/?$\";s:51:\"index.php?tag=$matches[1]&aftership-api=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:34:\"nf_sub/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"nf_sub/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"nf_sub/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"nf_sub/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"nf_sub/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"nf_sub/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"nf_sub/([^/]+)/embed/?$\";s:39:\"index.php?nf_sub=$matches[1]&embed=true\";s:27:\"nf_sub/([^/]+)/trackback/?$\";s:33:\"index.php?nf_sub=$matches[1]&tb=1\";s:47:\"nf_sub/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?nf_sub=$matches[1]&feed=$matches[2]\";s:42:\"nf_sub/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:45:\"index.php?nf_sub=$matches[1]&feed=$matches[2]\";s:35:\"nf_sub/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?nf_sub=$matches[1]&paged=$matches[2]\";s:42:\"nf_sub/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?nf_sub=$matches[1]&cpage=$matches[2]\";s:39:\"nf_sub/([^/]+)/aftership-api(/(.*))?/?$\";s:54:\"index.php?nf_sub=$matches[1]&aftership-api=$matches[3]\";s:32:\"nf_sub/([^/]+)/wc-api(/(.*))?/?$\";s:47:\"index.php?nf_sub=$matches[1]&wc-api=$matches[3]\";s:45:\"nf_sub/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:56:\"nf_sub/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:38:\"nf_sub/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:49:\"nf_sub/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:31:\"nf_sub/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?nf_sub=$matches[1]&page=$matches[2]\";s:23:\"nf_sub/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"nf_sub/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"nf_sub/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"nf_sub/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"nf_sub/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"nf_sub/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"categoria-producto/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:52:\"categoria-producto/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:33:\"categoria-producto/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:45:\"categoria-producto/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:27:\"categoria-producto/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:58:\"etiqueta-producto/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:53:\"etiqueta-producto/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:34:\"etiqueta-producto/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:46:\"etiqueta-producto/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:28:\"etiqueta-producto/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:36:\"producto/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"producto/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"producto/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"producto/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"producto/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"producto/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"producto/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:29:\"producto/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:49:\"producto/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:44:\"producto/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:37:\"producto/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:44:\"producto/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:41:\"producto/([^/]+)/aftership-api(/(.*))?/?$\";s:55:\"index.php?product=$matches[1]&aftership-api=$matches[3]\";s:34:\"producto/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:47:\"producto/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:58:\"producto/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:40:\"producto/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"producto/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:33:\"producto/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:25:\"producto/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"producto/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"producto/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"producto/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"producto/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"producto/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"product_variation/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"product_variation/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"product_variation/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"product_variation/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"product_variation/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"product_variation/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"product_variation/([^/]+)/embed/?$\";s:50:\"index.php?product_variation=$matches[1]&embed=true\";s:38:\"product_variation/([^/]+)/trackback/?$\";s:44:\"index.php?product_variation=$matches[1]&tb=1\";s:46:\"product_variation/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?product_variation=$matches[1]&paged=$matches[2]\";s:53:\"product_variation/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?product_variation=$matches[1]&cpage=$matches[2]\";s:50:\"product_variation/([^/]+)/aftership-api(/(.*))?/?$\";s:65:\"index.php?product_variation=$matches[1]&aftership-api=$matches[3]\";s:43:\"product_variation/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?product_variation=$matches[1]&wc-api=$matches[3]\";s:56:\"product_variation/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:67:\"product_variation/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:49:\"product_variation/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:60:\"product_variation/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"product_variation/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?product_variation=$matches[1]&page=$matches[2]\";s:34:\"product_variation/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"product_variation/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"product_variation/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"product_variation/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"product_variation/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"product_variation/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"shop_order_refund/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"shop_order_refund/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"shop_order_refund/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"shop_order_refund/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"shop_order_refund/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"shop_order_refund/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"shop_order_refund/([^/]+)/embed/?$\";s:50:\"index.php?shop_order_refund=$matches[1]&embed=true\";s:38:\"shop_order_refund/([^/]+)/trackback/?$\";s:44:\"index.php?shop_order_refund=$matches[1]&tb=1\";s:46:\"shop_order_refund/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?shop_order_refund=$matches[1]&paged=$matches[2]\";s:53:\"shop_order_refund/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?shop_order_refund=$matches[1]&cpage=$matches[2]\";s:50:\"shop_order_refund/([^/]+)/aftership-api(/(.*))?/?$\";s:65:\"index.php?shop_order_refund=$matches[1]&aftership-api=$matches[3]\";s:43:\"shop_order_refund/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?shop_order_refund=$matches[1]&wc-api=$matches[3]\";s:56:\"shop_order_refund/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:67:\"shop_order_refund/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:49:\"shop_order_refund/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:60:\"shop_order_refund/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"shop_order_refund/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?shop_order_refund=$matches[1]&page=$matches[2]\";s:34:\"shop_order_refund/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"shop_order_refund/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"shop_order_refund/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"shop_order_refund/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"shop_order_refund/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"shop_order_refund/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"download-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"download-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"download-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"download-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"download-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"download-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"download-view/([^/]+)/embed/?$\";s:47:\"index.php?dslc_downloads=$matches[1]&embed=true\";s:34:\"download-view/([^/]+)/trackback/?$\";s:41:\"index.php?dslc_downloads=$matches[1]&tb=1\";s:42:\"download-view/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?dslc_downloads=$matches[1]&paged=$matches[2]\";s:49:\"download-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?dslc_downloads=$matches[1]&cpage=$matches[2]\";s:46:\"download-view/([^/]+)/aftership-api(/(.*))?/?$\";s:62:\"index.php?dslc_downloads=$matches[1]&aftership-api=$matches[3]\";s:39:\"download-view/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?dslc_downloads=$matches[1]&wc-api=$matches[3]\";s:52:\"download-view/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:63:\"download-view/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:45:\"download-view/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"download-view/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"download-view/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?dslc_downloads=$matches[1]&page=$matches[2]\";s:30:\"download-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"download-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"download-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"download-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"download-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"download-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"dslc_downloads_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_downloads_cats=$matches[1]&feed=$matches[2]\";s:54:\"dslc_downloads_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_downloads_cats=$matches[1]&feed=$matches[2]\";s:35:\"dslc_downloads_cat/([^/]+)/embed/?$\";s:52:\"index.php?dslc_downloads_cats=$matches[1]&embed=true\";s:47:\"dslc_downloads_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?dslc_downloads_cats=$matches[1]&paged=$matches[2]\";s:29:\"dslc_downloads_cat/([^/]+)/?$\";s:41:\"index.php?dslc_downloads_cats=$matches[1]\";s:59:\"dslc_downloads_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_downloads_tags=$matches[1]&feed=$matches[2]\";s:54:\"dslc_downloads_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_downloads_tags=$matches[1]&feed=$matches[2]\";s:35:\"dslc_downloads_tag/([^/]+)/embed/?$\";s:52:\"index.php?dslc_downloads_tags=$matches[1]&embed=true\";s:47:\"dslc_downloads_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?dslc_downloads_tags=$matches[1]&paged=$matches[2]\";s:29:\"dslc_downloads_tag/([^/]+)/?$\";s:41:\"index.php?dslc_downloads_tags=$matches[1]\";s:40:\"gallery-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"gallery-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"gallery-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"gallery-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"gallery-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"gallery-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"gallery-view/([^/]+)/embed/?$\";s:47:\"index.php?dslc_galleries=$matches[1]&embed=true\";s:33:\"gallery-view/([^/]+)/trackback/?$\";s:41:\"index.php?dslc_galleries=$matches[1]&tb=1\";s:41:\"gallery-view/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?dslc_galleries=$matches[1]&paged=$matches[2]\";s:48:\"gallery-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?dslc_galleries=$matches[1]&cpage=$matches[2]\";s:45:\"gallery-view/([^/]+)/aftership-api(/(.*))?/?$\";s:62:\"index.php?dslc_galleries=$matches[1]&aftership-api=$matches[3]\";s:38:\"gallery-view/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?dslc_galleries=$matches[1]&wc-api=$matches[3]\";s:51:\"gallery-view/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:62:\"gallery-view/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:44:\"gallery-view/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"gallery-view/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"gallery-view/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?dslc_galleries=$matches[1]&page=$matches[2]\";s:29:\"gallery-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"gallery-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"gallery-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"gallery-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"gallery-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"gallery-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:60:\"dslc_galleries_cats/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_galleries_cats=$matches[1]&feed=$matches[2]\";s:55:\"dslc_galleries_cats/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_galleries_cats=$matches[1]&feed=$matches[2]\";s:36:\"dslc_galleries_cats/([^/]+)/embed/?$\";s:52:\"index.php?dslc_galleries_cats=$matches[1]&embed=true\";s:48:\"dslc_galleries_cats/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?dslc_galleries_cats=$matches[1]&paged=$matches[2]\";s:30:\"dslc_galleries_cats/([^/]+)/?$\";s:41:\"index.php?dslc_galleries_cats=$matches[1]\";s:40:\"partner-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"partner-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"partner-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"partner-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"partner-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"partner-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"partner-view/([^/]+)/embed/?$\";s:46:\"index.php?dslc_partners=$matches[1]&embed=true\";s:33:\"partner-view/([^/]+)/trackback/?$\";s:40:\"index.php?dslc_partners=$matches[1]&tb=1\";s:41:\"partner-view/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?dslc_partners=$matches[1]&paged=$matches[2]\";s:48:\"partner-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?dslc_partners=$matches[1]&cpage=$matches[2]\";s:45:\"partner-view/([^/]+)/aftership-api(/(.*))?/?$\";s:61:\"index.php?dslc_partners=$matches[1]&aftership-api=$matches[3]\";s:38:\"partner-view/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?dslc_partners=$matches[1]&wc-api=$matches[3]\";s:51:\"partner-view/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:62:\"partner-view/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:44:\"partner-view/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"partner-view/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"partner-view/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?dslc_partners=$matches[1]&page=$matches[2]\";s:29:\"partner-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"partner-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"partner-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"partner-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"partner-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"partner-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"dslc_partners_cats/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?dslc_partners_cats=$matches[1]&feed=$matches[2]\";s:54:\"dslc_partners_cats/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?dslc_partners_cats=$matches[1]&feed=$matches[2]\";s:35:\"dslc_partners_cats/([^/]+)/embed/?$\";s:51:\"index.php?dslc_partners_cats=$matches[1]&embed=true\";s:47:\"dslc_partners_cats/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?dslc_partners_cats=$matches[1]&paged=$matches[2]\";s:29:\"dslc_partners_cats/([^/]+)/?$\";s:40:\"index.php?dslc_partners_cats=$matches[1]\";s:40:\"project-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"project-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"project-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"project-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"project-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"project-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"project-view/([^/]+)/embed/?$\";s:46:\"index.php?dslc_projects=$matches[1]&embed=true\";s:33:\"project-view/([^/]+)/trackback/?$\";s:40:\"index.php?dslc_projects=$matches[1]&tb=1\";s:41:\"project-view/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?dslc_projects=$matches[1]&paged=$matches[2]\";s:48:\"project-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?dslc_projects=$matches[1]&cpage=$matches[2]\";s:45:\"project-view/([^/]+)/aftership-api(/(.*))?/?$\";s:61:\"index.php?dslc_projects=$matches[1]&aftership-api=$matches[3]\";s:38:\"project-view/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?dslc_projects=$matches[1]&wc-api=$matches[3]\";s:51:\"project-view/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:62:\"project-view/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:44:\"project-view/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"project-view/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"project-view/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?dslc_projects=$matches[1]&page=$matches[2]\";s:29:\"project-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"project-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"project-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"project-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"project-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"project-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"dslc_projects_cats/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?dslc_projects_cats=$matches[1]&feed=$matches[2]\";s:54:\"dslc_projects_cats/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?dslc_projects_cats=$matches[1]&feed=$matches[2]\";s:35:\"dslc_projects_cats/([^/]+)/embed/?$\";s:51:\"index.php?dslc_projects_cats=$matches[1]&embed=true\";s:47:\"dslc_projects_cats/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?dslc_projects_cats=$matches[1]&paged=$matches[2]\";s:29:\"dslc_projects_cats/([^/]+)/?$\";s:40:\"index.php?dslc_projects_cats=$matches[1]\";s:38:\"staff-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"staff-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"staff-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"staff-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"staff-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"staff-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"staff-view/([^/]+)/embed/?$\";s:43:\"index.php?dslc_staff=$matches[1]&embed=true\";s:31:\"staff-view/([^/]+)/trackback/?$\";s:37:\"index.php?dslc_staff=$matches[1]&tb=1\";s:39:\"staff-view/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?dslc_staff=$matches[1]&paged=$matches[2]\";s:46:\"staff-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?dslc_staff=$matches[1]&cpage=$matches[2]\";s:43:\"staff-view/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?dslc_staff=$matches[1]&aftership-api=$matches[3]\";s:36:\"staff-view/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?dslc_staff=$matches[1]&wc-api=$matches[3]\";s:49:\"staff-view/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:60:\"staff-view/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:42:\"staff-view/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"staff-view/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"staff-view/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?dslc_staff=$matches[1]&page=$matches[2]\";s:27:\"staff-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"staff-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"staff-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"staff-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"staff-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"staff-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"dslc_staff_cats/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?dslc_staff_cats=$matches[1]&feed=$matches[2]\";s:51:\"dslc_staff_cats/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?dslc_staff_cats=$matches[1]&feed=$matches[2]\";s:32:\"dslc_staff_cats/([^/]+)/embed/?$\";s:48:\"index.php?dslc_staff_cats=$matches[1]&embed=true\";s:44:\"dslc_staff_cats/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?dslc_staff_cats=$matches[1]&paged=$matches[2]\";s:26:\"dslc_staff_cats/([^/]+)/?$\";s:37:\"index.php?dslc_staff_cats=$matches[1]\";s:44:\"testimonial-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"testimonial-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"testimonial-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"testimonial-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"testimonial-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"testimonial-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"testimonial-view/([^/]+)/embed/?$\";s:50:\"index.php?dslc_testimonials=$matches[1]&embed=true\";s:37:\"testimonial-view/([^/]+)/trackback/?$\";s:44:\"index.php?dslc_testimonials=$matches[1]&tb=1\";s:45:\"testimonial-view/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?dslc_testimonials=$matches[1]&paged=$matches[2]\";s:52:\"testimonial-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?dslc_testimonials=$matches[1]&cpage=$matches[2]\";s:49:\"testimonial-view/([^/]+)/aftership-api(/(.*))?/?$\";s:65:\"index.php?dslc_testimonials=$matches[1]&aftership-api=$matches[3]\";s:42:\"testimonial-view/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?dslc_testimonials=$matches[1]&wc-api=$matches[3]\";s:55:\"testimonial-view/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:66:\"testimonial-view/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:48:\"testimonial-view/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"testimonial-view/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"testimonial-view/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?dslc_testimonials=$matches[1]&page=$matches[2]\";s:33:\"testimonial-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"testimonial-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"testimonial-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"testimonial-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"testimonial-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"testimonial-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"dslc_testimonials_cats/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?dslc_testimonials_cats=$matches[1]&feed=$matches[2]\";s:58:\"dslc_testimonials_cats/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?dslc_testimonials_cats=$matches[1]&feed=$matches[2]\";s:39:\"dslc_testimonials_cats/([^/]+)/embed/?$\";s:55:\"index.php?dslc_testimonials_cats=$matches[1]&embed=true\";s:51:\"dslc_testimonials_cats/([^/]+)/page/?([0-9]{1,})/?$\";s:62:\"index.php?dslc_testimonials_cats=$matches[1]&paged=$matches[2]\";s:33:\"dslc_testimonials_cats/([^/]+)/?$\";s:44:\"index.php?dslc_testimonials_cats=$matches[1]\";s:42:\"dslc_templates/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"dslc_templates/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"dslc_templates/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"dslc_templates/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"dslc_templates/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"dslc_templates/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"dslc_templates/([^/]+)/embed/?$\";s:47:\"index.php?dslc_templates=$matches[1]&embed=true\";s:35:\"dslc_templates/([^/]+)/trackback/?$\";s:41:\"index.php?dslc_templates=$matches[1]&tb=1\";s:43:\"dslc_templates/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?dslc_templates=$matches[1]&paged=$matches[2]\";s:50:\"dslc_templates/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?dslc_templates=$matches[1]&cpage=$matches[2]\";s:47:\"dslc_templates/([^/]+)/aftership-api(/(.*))?/?$\";s:62:\"index.php?dslc_templates=$matches[1]&aftership-api=$matches[3]\";s:40:\"dslc_templates/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?dslc_templates=$matches[1]&wc-api=$matches[3]\";s:53:\"dslc_templates/[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:64:\"dslc_templates/[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:46:\"dslc_templates/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"dslc_templates/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"dslc_templates/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?dslc_templates=$matches[1]&page=$matches[2]\";s:31:\"dslc_templates/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"dslc_templates/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"dslc_templates/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"dslc_templates/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"dslc_templates/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"dslc_templates/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:40:\"index.php?&page_id=162&cpage=$matches[1]\";s:24:\"aftership-api(/(.*))?/?$\";s:36:\"index.php?&aftership-api=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:33:\"comments/aftership-api(/(.*))?/?$\";s:36:\"index.php?&aftership-api=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:36:\"search/(.+)/aftership-api(/(.*))?/?$\";s:49:\"index.php?s=$matches[1]&aftership-api=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:39:\"author/([^/]+)/aftership-api(/(.*))?/?$\";s:59:\"index.php?author_name=$matches[1]&aftership-api=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/aftership-api(/(.*))?/?$\";s:89:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&aftership-api=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:48:\"([0-9]{4})/([0-9]{1,2})/aftership-api(/(.*))?/?$\";s:73:\"index.php?year=$matches[1]&monthnum=$matches[2]&aftership-api=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:35:\"([0-9]{4})/aftership-api(/(.*))?/?$\";s:52:\"index.php?year=$matches[1]&aftership-api=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:32:\"(.?.+?)/aftership-api(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&aftership-api=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:38:\".?.+?/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:49:\".?.+?/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:32:\"([^/]+)/aftership-api(/(.*))?/?$\";s:52:\"index.php?name=$matches[1]&aftership-api=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:38:\"[^/]+/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:49:\"[^/]+/attachment/([^/]+)/aftership-api(/(.*))?/?$\";s:58:\"index.php?attachment=$matches[1]&aftership-api=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes");
INSERT INTO `wp_options` VALUES("3990","wpseo_permalinks","a:9:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("3991","wpseo_titles","a:159:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:23:\"content-analysis-active\";b:1;s:23:\"keyword-analysis-active\";b:1;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:0;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:40:\"%%name%%, autor en %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:58:\"Has buscado %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:42:\"Página no encontrada %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:0;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:13:\"title-product\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-product\";s:0:\"\";s:15:\"metakey-product\";s:0:\"\";s:15:\"noindex-product\";b:0;s:16:\"showdate-product\";b:0;s:19:\"hideeditbox-product\";b:0;s:20:\"title-dslc_downloads\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-dslc_downloads\";s:0:\"\";s:22:\"metakey-dslc_downloads\";s:0:\"\";s:22:\"noindex-dslc_downloads\";b:0;s:23:\"showdate-dslc_downloads\";b:0;s:26:\"hideeditbox-dslc_downloads\";b:0;s:20:\"title-dslc_galleries\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-dslc_galleries\";s:0:\"\";s:22:\"metakey-dslc_galleries\";s:0:\"\";s:22:\"noindex-dslc_galleries\";b:0;s:23:\"showdate-dslc_galleries\";b:0;s:26:\"hideeditbox-dslc_galleries\";b:0;s:19:\"title-dslc_partners\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-dslc_partners\";s:0:\"\";s:21:\"metakey-dslc_partners\";s:0:\"\";s:21:\"noindex-dslc_partners\";b:0;s:22:\"showdate-dslc_partners\";b:0;s:25:\"hideeditbox-dslc_partners\";b:0;s:19:\"title-dslc_projects\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-dslc_projects\";s:0:\"\";s:21:\"metakey-dslc_projects\";s:0:\"\";s:21:\"noindex-dslc_projects\";b:0;s:22:\"showdate-dslc_projects\";b:0;s:25:\"hideeditbox-dslc_projects\";b:0;s:16:\"title-dslc_staff\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-dslc_staff\";s:0:\"\";s:18:\"metakey-dslc_staff\";s:0:\"\";s:18:\"noindex-dslc_staff\";b:0;s:19:\"showdate-dslc_staff\";b:0;s:22:\"hideeditbox-dslc_staff\";b:0;s:23:\"title-dslc_testimonials\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-dslc_testimonials\";s:0:\"\";s:25:\"metakey-dslc_testimonials\";s:0:\"\";s:25:\"noindex-dslc_testimonials\";b:0;s:26:\"showdate-dslc_testimonials\";b:0;s:29:\"hideeditbox-dslc_testimonials\";b:0;s:20:\"title-dslc_templates\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-dslc_templates\";s:0:\"\";s:22:\"metakey-dslc_templates\";s:0:\"\";s:22:\"noindex-dslc_templates\";b:0;s:23:\"showdate-dslc_templates\";b:0;s:26:\"hideeditbox-dslc_templates\";b:0;s:23:\"title-ptarchive-product\";s:51:\"%%pt_plural%% archivo %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-product\";s:0:\"\";s:25:\"metakey-ptarchive-product\";s:0:\"\";s:25:\"bctitle-ptarchive-product\";s:0:\"\";s:25:\"noindex-ptarchive-product\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:21:\"title-tax-product_cat\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_cat\";s:0:\"\";s:23:\"metakey-tax-product_cat\";s:0:\"\";s:27:\"hideeditbox-tax-product_cat\";b:0;s:23:\"noindex-tax-product_cat\";b:0;s:21:\"title-tax-product_tag\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_tag\";s:0:\"\";s:23:\"metakey-tax-product_tag\";s:0:\"\";s:27:\"hideeditbox-tax-product_tag\";b:0;s:23:\"noindex-tax-product_tag\";b:0;s:32:\"title-tax-product_shipping_class\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-tax-product_shipping_class\";s:0:\"\";s:34:\"metakey-tax-product_shipping_class\";s:0:\"\";s:38:\"hideeditbox-tax-product_shipping_class\";b:0;s:34:\"noindex-tax-product_shipping_class\";b:0;s:29:\"title-tax-dslc_downloads_cats\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:32:\"metadesc-tax-dslc_downloads_cats\";s:0:\"\";s:31:\"metakey-tax-dslc_downloads_cats\";s:0:\"\";s:35:\"hideeditbox-tax-dslc_downloads_cats\";b:0;s:31:\"noindex-tax-dslc_downloads_cats\";b:0;s:29:\"title-tax-dslc_downloads_tags\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:32:\"metadesc-tax-dslc_downloads_tags\";s:0:\"\";s:31:\"metakey-tax-dslc_downloads_tags\";s:0:\"\";s:35:\"hideeditbox-tax-dslc_downloads_tags\";b:0;s:31:\"noindex-tax-dslc_downloads_tags\";b:0;s:29:\"title-tax-dslc_galleries_cats\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:32:\"metadesc-tax-dslc_galleries_cats\";s:0:\"\";s:31:\"metakey-tax-dslc_galleries_cats\";s:0:\"\";s:35:\"hideeditbox-tax-dslc_galleries_cats\";b:0;s:31:\"noindex-tax-dslc_galleries_cats\";b:0;s:28:\"title-tax-dslc_partners_cats\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-dslc_partners_cats\";s:0:\"\";s:30:\"metakey-tax-dslc_partners_cats\";s:0:\"\";s:34:\"hideeditbox-tax-dslc_partners_cats\";b:0;s:30:\"noindex-tax-dslc_partners_cats\";b:0;s:28:\"title-tax-dslc_projects_cats\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-dslc_projects_cats\";s:0:\"\";s:30:\"metakey-tax-dslc_projects_cats\";s:0:\"\";s:34:\"hideeditbox-tax-dslc_projects_cats\";b:0;s:30:\"noindex-tax-dslc_projects_cats\";b:0;s:25:\"title-tax-dslc_staff_cats\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-dslc_staff_cats\";s:0:\"\";s:27:\"metakey-tax-dslc_staff_cats\";s:0:\"\";s:31:\"hideeditbox-tax-dslc_staff_cats\";b:0;s:27:\"noindex-tax-dslc_staff_cats\";b:0;s:32:\"title-tax-dslc_testimonials_cats\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-tax-dslc_testimonials_cats\";s:0:\"\";s:34:\"metakey-tax-dslc_testimonials_cats\";s:0:\"\";s:38:\"hideeditbox-tax-dslc_testimonials_cats\";b:0;s:34:\"noindex-tax-dslc_testimonials_cats\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("30","hack_file","0","yes");
INSERT INTO `wp_options` VALUES("31","blog_charset","UTF-8","yes");
INSERT INTO `wp_options` VALUES("32","moderation_keys","","no");
INSERT INTO `wp_options` VALUES("33","active_plugins","a:30:{i:0;s:41:\"admin-custom-login/admin-custom-login.php\";i:1;s:33:\"admin-menu-editor/menu-editor.php\";i:2;s:44:\"aftership-woocommerce-tracking/aftership.php\";i:3;s:54:\"authorizenet-payment-gateway-for-woocommerce/index.php\";i:4;s:41:\"better-wp-security/better-wp-security.php\";i:5;s:79:\"custom-related-products-for-woocommerce/woocommerce-custom-related-products.php\";i:6;s:50:\"google-analytics-for-wordpress/googleanalytics.php\";i:7;s:29:\"image-widget/image-widget.php\";i:8;s:21:\"launcher/launcher.php\";i:9;s:43:\"likebtn-like-button/likebtn_like_button.php\";i:10;s:47:\"live-composer-page-builder/ds-live-composer.php\";i:11;s:35:\"nav-menu-images/nav-menu-images.php\";i:12;s:27:\"ninja-forms/ninja-forms.php\";i:13;s:43:\"simple-image-widget/simple-image-widget.php\";i:14;s:53:\"stripe-woocommerce-addon/stripe-woocommerce-addon.php\";i:15;s:29:\"use-any-font/use-any-font.php\";i:16;s:35:\"wc-cancel-order/wc-cancel-order.php\";i:17;s:61:\"woocommerce-checkout-manager/woocommerce-checkout-manager.php\";i:18;s:77:\"woocommerce-custom-product-tabs-lite/woocommerce-custom-product-tabs-lite.php\";i:19;s:49:\"woocommerce-customizer/woocommerce-customizer.php\";i:20;s:62:\"woocommerce-dynamic-gallery/wc_dynamic_gallery_woocommerce.php\";i:21;s:51:\"woocommerce-mercadopago/woocommerce-mercadopago.php\";i:22;s:65:\"woocommerce-multiple-addresses/woocommerce-multiple-addresses.php\";i:23;s:43:\"woocommerce-new-product-badge/new-badge.php\";i:24;s:65:\"woocommerce-photos-product-tab/woocommerce-photos-product-tab.php\";i:25;s:61:\"woocommerce-product-details-customiser/details-customiser.php\";i:26;s:61:\"woocommerce-smart-sale-badge/woocommerce-smart-sale-badge.php\";i:27;s:27:\"woocommerce/woocommerce.php\";i:28;s:24:\"wordpress-seo/wp-seo.php\";i:29;s:38:\"yith-woocommerce-catalog-mode/init.php\";}","yes");
INSERT INTO `wp_options` VALUES("34","category_base","","yes");
INSERT INTO `wp_options` VALUES("35","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO `wp_options` VALUES("36","comment_max_links","2","yes");
INSERT INTO `wp_options` VALUES("37","gmt_offset","0","yes");
INSERT INTO `wp_options` VALUES("38","default_email_category","1","yes");
INSERT INTO `wp_options` VALUES("39","recently_edited","a:5:{i:0;s:79:\"/home/ebaquerob/public_html/cerere/wp-content/themes/EcommerceManapro/style.css\";i:2;s:80:\"/home/ebaquerob/public_html/cerere/wp-content/themes/EcommerceManapro/footer.php\";i:3;s:78:\"/home/ebaquerob/public_html/cerere/wp-content/themes/EcommerceManapro/home.php\";i:4;s:80:\"/home/ebaquerob/public_html/cerere/wp-content/themes/EcommerceManapro/header.php\";i:5;s:79:\"/home/ebaquerob/public_html/sentra/wp-content/themes/EcommerceManapro/style.css\";}","no");
INSERT INTO `wp_options` VALUES("40","template","EcommerceManapro","yes");
INSERT INTO `wp_options` VALUES("41","stylesheet","EcommerceManapro","yes");
INSERT INTO `wp_options` VALUES("42","comment_whitelist","1","yes");
INSERT INTO `wp_options` VALUES("43","blacklist_keys","","no");
INSERT INTO `wp_options` VALUES("44","comment_registration","0","yes");
INSERT INTO `wp_options` VALUES("45","html_type","text/html","yes");
INSERT INTO `wp_options` VALUES("46","use_trackback","0","yes");
INSERT INTO `wp_options` VALUES("47","default_role","subscriber","yes");
INSERT INTO `wp_options` VALUES("48","db_version","36686","yes");
INSERT INTO `wp_options` VALUES("49","uploads_use_yearmonth_folders","1","yes");
INSERT INTO `wp_options` VALUES("50","upload_path","","yes");
INSERT INTO `wp_options` VALUES("51","blog_public","1","yes");
INSERT INTO `wp_options` VALUES("52","default_link_category","2","yes");
INSERT INTO `wp_options` VALUES("53","show_on_front","page","yes");
INSERT INTO `wp_options` VALUES("54","tag_base","","yes");
INSERT INTO `wp_options` VALUES("55","show_avatars","1","yes");
INSERT INTO `wp_options` VALUES("56","avatar_rating","G","yes");
INSERT INTO `wp_options` VALUES("57","upload_url_path","","yes");
INSERT INTO `wp_options` VALUES("58","thumbnail_size_w","150","yes");
INSERT INTO `wp_options` VALUES("59","thumbnail_size_h","150","yes");
INSERT INTO `wp_options` VALUES("60","thumbnail_crop","1","yes");
INSERT INTO `wp_options` VALUES("61","medium_size_w","300","yes");
INSERT INTO `wp_options` VALUES("62","medium_size_h","300","yes");
INSERT INTO `wp_options` VALUES("63","avatar_default","mystery","yes");
INSERT INTO `wp_options` VALUES("64","large_size_w","1024","yes");
INSERT INTO `wp_options` VALUES("65","large_size_h","1024","yes");
INSERT INTO `wp_options` VALUES("66","image_default_link_type","none","yes");
INSERT INTO `wp_options` VALUES("67","image_default_size","","yes");
INSERT INTO `wp_options` VALUES("68","image_default_align","","yes");
INSERT INTO `wp_options` VALUES("69","close_comments_for_old_posts","0","yes");
INSERT INTO `wp_options` VALUES("70","close_comments_days_old","14","yes");
INSERT INTO `wp_options` VALUES("71","thread_comments","1","yes");
INSERT INTO `wp_options` VALUES("72","thread_comments_depth","5","yes");
INSERT INTO `wp_options` VALUES("73","page_comments","0","yes");
INSERT INTO `wp_options` VALUES("74","comments_per_page","50","yes");
INSERT INTO `wp_options` VALUES("75","default_comments_page","newest","yes");
INSERT INTO `wp_options` VALUES("76","comment_order","asc","yes");
INSERT INTO `wp_options` VALUES("77","sticky_posts","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("78","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("79","widget_text","a:8:{i:1;a:0:{}i:3;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:0:\"\";s:6:\"filter\";b:0;}i:4;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:1258:\"<h2 class=\"black top-full\">TITULO</h2><p class=\"black text-info-left\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat.</p>

<p class=\"black text-info-left\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat.</p>

<div class=\"col-sm-12 align-center inicio-2 text-align-right\"><a href=\"#\" class=\"btn btn-b btn-round\">VER MÁS</a></div>\";s:6:\"filter\";b:0;}i:5;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:584:\"<h4 class=\"black top-full\">TITULO</h4><p class=\"black text-info-left\">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat.</p>\";s:6:\"filter\";b:0;}i:6;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:233:\"<div class=\"white\" style=\"font-size:28px; text-align:center\"><i class=\"fa fa-phone\" aria-hidden=\"true\"></i></div>

<p class=\"text-info-center white italic\">+58 5889988</p>

<p class=\"text-info-center white italic\">+58 5669955</p>\";s:6:\"filter\";b:0;}i:8;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:247:\"<div class=\"white\" style=\"font-size:28px; text-align:center\"><i class=\"fa fa-envelope\" aria-hidden=\"true\"></i></div>

<p class=\"text-info-center white italic\">email@domain.com</p>

<p class=\"text-info-center white italic\">email2@domain.com</p>\";s:6:\"filter\";b:0;}i:10;a:3:{s:5:\"title\";s:0:\"\";s:4:\"text\";s:175:\"<div class=\"white\" style=\"font-size:28px; text-align:center\"><i class=\"fa fa-map-marker\" aria-hidden=\"true\"></i></div>

<p class=\"text-info-center white italic\">New York</p>\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("80","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("81","uninstall_plugins","a:4:{s:59:\"order-delivery-date-for-woocommerce/order_delivery_date.php\";s:21:\"orddd_lite_deactivate\";s:27:\"ninja-forms/ninja-forms.php\";s:21:\"ninja_forms_uninstall\";s:24:\"google-maps-easy/gmp.php\";a:2:{i:0;s:8:\"utilsGmp\";i:1;s:12:\"deletePlugin\";}s:41:\"better-wp-security/better-wp-security.php\";a:2:{i:0;s:10:\"ITSEC_Core\";i:1;s:12:\"on_uninstall\";}}","no");
INSERT INTO `wp_options` VALUES("82","timezone_string","","yes");
INSERT INTO `wp_options` VALUES("83","page_for_posts","0","yes");
INSERT INTO `wp_options` VALUES("84","page_on_front","162","yes");
INSERT INTO `wp_options` VALUES("85","default_post_format","0","yes");
INSERT INTO `wp_options` VALUES("86","link_manager_enabled","0","yes");
INSERT INTO `wp_options` VALUES("87","finished_splitting_shared_terms","1","yes");
INSERT INTO `wp_options` VALUES("88","site_icon","418","yes");
INSERT INTO `wp_options` VALUES("89","medium_large_size_w","768","yes");
INSERT INTO `wp_options` VALUES("90","medium_large_size_h","0","yes");
INSERT INTO `wp_options` VALUES("91","initial_db_version","36686","yes");
INSERT INTO `wp_options` VALUES("92","wp_user_roles","a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:133:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:16:\"manage_aftership\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop Manager\";s:12:\"capabilities\";a:111:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:15:\"unfiltered_html\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:17:\"edit_shop_webhook\";b:1;s:17:\"read_shop_webhook\";b:1;s:19:\"delete_shop_webhook\";b:1;s:18:\"edit_shop_webhooks\";b:1;s:25:\"edit_others_shop_webhooks\";b:1;s:21:\"publish_shop_webhooks\";b:1;s:26:\"read_private_shop_webhooks\";b:1;s:20:\"delete_shop_webhooks\";b:1;s:28:\"delete_private_shop_webhooks\";b:1;s:30:\"delete_published_shop_webhooks\";b:1;s:27:\"delete_others_shop_webhooks\";b:1;s:26:\"edit_private_shop_webhooks\";b:1;s:28:\"edit_published_shop_webhooks\";b:1;s:25:\"manage_shop_webhook_terms\";b:1;s:23:\"edit_shop_webhook_terms\";b:1;s:25:\"delete_shop_webhook_terms\";b:1;s:25:\"assign_shop_webhook_terms\";b:1;s:14:\"manage_options\";b:1;}}}","yes");
INSERT INTO `wp_options` VALUES("93","WPLANG","es_ES","yes");
INSERT INTO `wp_options` VALUES("94","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("95","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("96","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("97","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("98","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("99","sidebars_widgets","a:14:{s:16:\"text-banner-home\";a:1:{i:0;s:6:\"text-4\";}s:16:\"text-latest-home\";a:1:{i:0;s:6:\"text-5\";}s:13:\"mas_visitados\";a:1:{i:0;s:38:\"woocommerce_recently_viewed_products-2\";}s:19:\"wp_inactive_widgets\";a:1:{i:0;s:6:\"text-3\";}s:16:\"dslc_formcontact\";a:1:{i:0;s:20:\"ninja_forms_widget-2\";}s:15:\"dslc_productos2\";a:2:{i:0;s:32:\"woocommerce_product_categories-3\";i:1;s:26:\"woocommerce_price_filter-3\";}s:9:\"sidebar-1\";a:0:{}s:21:\"sidebar-footer-area-1\";a:1:{i:0;s:6:\"text-6\";}s:21:\"sidebar-footer-area-2\";a:1:{i:0;s:6:\"text-8\";}s:21:\"sidebar-footer-area-3\";a:1:{i:0;s:7:\"text-10\";}s:21:\"sidebar-footer-area-4\";a:1:{i:0;s:17:\"widget_sp_image-9\";}s:30:\"shop-isle-sidebar-shop-archive\";a:4:{i:0;s:32:\"woocommerce_product_categories-2\";i:1;s:28:\"woocommerce_product_search-2\";i:2;s:34:\"likebtnlikebuttonmostlikedwidget-2\";i:3;s:38:\"woocommerce_recently_viewed_products-4\";}s:9:\"visitados\";a:1:{i:0;s:38:\"woocommerce_recently_viewed_products-3\";}s:13:\"array_version\";i:3;}","yes");
INSERT INTO `wp_options` VALUES("100","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("101","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("102","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("103","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("104","cron","a:12:{i:1491981507;a:1:{s:29:\"wp_session_garbage_collection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1491985010;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1491987085;a:1:{s:30:\"um_twicedaily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1492018540;a:3:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1492018593;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1492020182;a:2:{s:16:\"itsec_purge_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"itsec_purge_lockouts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1492020279;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1492028210;a:1:{s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1492030285;a:1:{s:25:\"um_daily_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1492059085;a:1:{s:26:\"um_hourly_scheduled_events\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1493769600;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:7:\"monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2635200;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO `wp_options` VALUES("117","_site_transient_timeout_browser_a73daf7c9c646899b1f75c4f801fa1ee","1476120995","yes");
INSERT INTO `wp_options` VALUES("118","_site_transient_browser_a73daf7c9c646899b1f75c4f801fa1ee","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"53.0.2785.116\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("119","can_compress_scripts","1","yes");
INSERT INTO `wp_options` VALUES("8065","_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109","1487723902","no");
INSERT INTO `wp_options` VALUES("8066","_transient_feed_b9388c83948825c1edaef0d856b7b109","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"
	
\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"
		
		
		
		
		
		
				

		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		

	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Feb 2017 12:05:40 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"363@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"UpdraftPlus WordPress Backup Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"6743@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5790@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"Secure your website with the most comprehensive WordPress security plugin. Firewall, malware scan, blocking, live traffic, login security &#38; more.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:118:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using the Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Extends and enhances TinyMCE, the WordPress Visual Editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"47509@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:139:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical login experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"The one plugin you need for stats, related posts, search engine optimization, social sharing, protection, backups, speed, and email list management.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Automattic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"NextGEN Gallery - WordPress Gallery Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 16 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"The original SEO plugin for WordPress, downloaded over 30,000,000 times since 2007.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2646@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"9542@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Google Analytics for WordPress by MonsterInsights\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"The best Google Analytics plugin for WordPress. See how visitors find and use your website, so you can keep them coming back.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Syed Balkhi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12073@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:144:\"Search Engine (SEO) &#38; Performance Optimization (WPO) via caching. Integrated caching: CDN, Minify, Page, Object, Fragment, Database support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"Displays Google Analytics stats in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly. Provides tool t\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"SiteOrigin Widgets Bundle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/so-widgets-bundle/#post-67824\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 24 May 2014 14:27:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"67824@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:128:\"A collection of all widgets, neatly bundled into a single plugin. It&#039;s also a framework to code your own widgets on top of.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"
			
			
			
			
			
			
					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:146:\"Take the guesswork out of WordPress security. iThemes Security offers 30+ ways to lock down WordPress in an easy-to-use WordPress security plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"iThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 21 Feb 2017 12:38:22 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Tue, 21 Feb 2017 12:40:40 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Tue, 21 Feb 2017 12:05:40 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20170109145931\";}","no");
INSERT INTO `wp_options` VALUES("8037","_transient_timeout_plugin_slugs","1487699203","no");
INSERT INTO `wp_options` VALUES("8038","_transient_plugin_slugs","a:34:{i:0;s:41:\"admin-custom-login/admin-custom-login.php\";i:1;s:33:\"admin-menu-editor/menu-editor.php\";i:2;s:44:\"aftership-woocommerce-tracking/aftership.php\";i:3;s:19:\"akismet/akismet.php\";i:4;s:54:\"authorizenet-payment-gateway-for-woocommerce/index.php\";i:5;s:79:\"custom-related-products-for-woocommerce/woocommerce-custom-related-products.php\";i:6;s:50:\"google-analytics-for-wordpress/googleanalytics.php\";i:7;s:29:\"image-widget/image-widget.php\";i:8;s:41:\"better-wp-security/better-wp-security.php\";i:9;s:21:\"launcher/launcher.php\";i:10;s:43:\"likebtn-like-button/likebtn_like_button.php\";i:11;s:35:\"nav-menu-images/nav-menu-images.php\";i:12;s:27:\"ninja-forms/ninja-forms.php\";i:13;s:59:\"order-delivery-date-for-woocommerce/order_delivery_date.php\";i:14;s:47:\"live-composer-page-builder/ds-live-composer.php\";i:15;s:43:\"simple-image-widget/simple-image-widget.php\";i:16;s:53:\"stripe-woocommerce-addon/stripe-woocommerce-addon.php\";i:17;s:29:\"use-any-font/use-any-font.php\";i:18;s:35:\"wc-cancel-order/wc-cancel-order.php\";i:19;s:27:\"woocommerce/woocommerce.php\";i:20;s:61:\"woocommerce-checkout-manager/woocommerce-checkout-manager.php\";i:21;s:49:\"woocommerce-customizer/woocommerce-customizer.php\";i:22;s:77:\"woocommerce-custom-product-tabs-lite/woocommerce-custom-product-tabs-lite.php\";i:23;s:62:\"woocommerce-dynamic-gallery/wc_dynamic_gallery_woocommerce.php\";i:24;s:51:\"woocommerce-mercadopago/woocommerce-mercadopago.php\";i:25;s:65:\"woocommerce-multiple-addresses/woocommerce-multiple-addresses.php\";i:26;s:43:\"woocommerce-new-product-badge/new-badge.php\";i:27;s:65:\"woocommerce-photos-product-tab/woocommerce-photos-product-tab.php\";i:28;s:61:\"woocommerce-product-details-customiser/details-customiser.php\";i:29;s:61:\"woocommerce-smart-sale-badge/woocommerce-smart-sale-badge.php\";i:30;s:41:\"yith-woocommerce-ajax-navigation/init.php\";i:31;s:38:\"yith-woocommerce-catalog-mode/init.php\";i:32;s:40:\"yith-woocommerce-zoom-magnifier/init.php\";i:33;s:24:\"wordpress-seo/wp-seo.php\";}","no");
INSERT INTO `wp_options` VALUES("136","recently_activated","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("4961","likebtn_settings_counter_frmt_post_likebtn_list","","yes");
INSERT INTO `wp_options` VALUES("4962","likebtn_settings_counter_padding_post_likebtn_list","","yes");
INSERT INTO `wp_options` VALUES("4963","likebtn_settings_counter_zero_show_post_likebtn_list","0","yes");
INSERT INTO `wp_options` VALUES("4964","likebtn_settings_voting_enabled_post_likebtn_list","1","yes");
INSERT INTO `wp_options` VALUES("4965","likebtn_settings_voting_cancelable_post_likebtn_list","1","yes");
INSERT INTO `wp_options` VALUES("4966","likebtn_settings_voting_both_post_likebtn_list","0","yes");
INSERT INTO `wp_options` VALUES("4967","likebtn_settings_voting_frequency_post_likebtn_list","","yes");
INSERT INTO `wp_options` VALUES("4968","likebtn_settings_addthis_pubid_post_likebtn_list","","yes");
INSERT INTO `wp_options` VALUES("4969","likebtn_settings_addthis_service_codes_post_likebtn_list","","yes");
INSERT INTO `wp_options` VALUES("4970","likebtn_settings_share_size_post_likebtn_list","medium","yes");
INSERT INTO `wp_options` VALUES("141","woocommerce_default_country","VE","yes");
INSERT INTO `wp_options` VALUES("142","woocommerce_allowed_countries","all","yes");
INSERT INTO `wp_options` VALUES("143","woocommerce_all_except_countries","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("144","woocommerce_specific_allowed_countries","a:1:{i:0;s:2:\"VE\";}","yes");
INSERT INTO `wp_options` VALUES("145","woocommerce_ship_to_countries","","yes");
INSERT INTO `wp_options` VALUES("146","woocommerce_specific_ship_to_countries","a:1:{i:0;s:2:\"VE\";}","yes");
INSERT INTO `wp_options` VALUES("147","woocommerce_default_customer_address","geolocation","yes");
INSERT INTO `wp_options` VALUES("148","woocommerce_calc_taxes","yes","yes");
INSERT INTO `wp_options` VALUES("149","woocommerce_demo_store","no","yes");
INSERT INTO `wp_options` VALUES("150","woocommerce_demo_store_notice","This is a demo store for testing purposes &mdash; no orders shall be fulfilled.","no");
INSERT INTO `wp_options` VALUES("151","woocommerce_currency","USD","yes");
INSERT INTO `wp_options` VALUES("152","woocommerce_currency_pos","left","yes");
INSERT INTO `wp_options` VALUES("153","woocommerce_price_thousand_sep",",","yes");
INSERT INTO `wp_options` VALUES("154","woocommerce_price_decimal_sep",".","yes");
INSERT INTO `wp_options` VALUES("155","woocommerce_price_num_decimals","2","yes");
INSERT INTO `wp_options` VALUES("156","woocommerce_weight_unit","g","yes");
INSERT INTO `wp_options` VALUES("157","woocommerce_dimension_unit","cm","yes");
INSERT INTO `wp_options` VALUES("158","woocommerce_enable_review_rating","no","yes");
INSERT INTO `wp_options` VALUES("159","woocommerce_review_rating_required","yes","no");
INSERT INTO `wp_options` VALUES("160","woocommerce_review_rating_verification_label","yes","no");
INSERT INTO `wp_options` VALUES("161","woocommerce_review_rating_verification_required","yes","no");
INSERT INTO `wp_options` VALUES("162","woocommerce_shop_page_id","5","yes");
INSERT INTO `wp_options` VALUES("163","woocommerce_shop_page_display","","yes");
INSERT INTO `wp_options` VALUES("164","woocommerce_category_archive_display","","yes");
INSERT INTO `wp_options` VALUES("165","woocommerce_default_catalog_orderby","menu_order","yes");
INSERT INTO `wp_options` VALUES("166","woocommerce_cart_redirect_after_add","no","yes");
INSERT INTO `wp_options` VALUES("167","woocommerce_enable_ajax_add_to_cart","yes","yes");
INSERT INTO `wp_options` VALUES("168","shop_catalog_image_size","a:3:{s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"300\";s:4:\"crop\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("169","shop_single_image_size","a:3:{s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:4:\"crop\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("170","shop_thumbnail_image_size","a:3:{s:5:\"width\";s:3:\"180\";s:6:\"height\";s:3:\"180\";s:4:\"crop\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("171","woocommerce_enable_lightbox","yes","yes");
INSERT INTO `wp_options` VALUES("172","woocommerce_manage_stock","yes","yes");
INSERT INTO `wp_options` VALUES("173","woocommerce_hold_stock_minutes","","no");
INSERT INTO `wp_options` VALUES("174","woocommerce_notify_low_stock","yes","no");
INSERT INTO `wp_options` VALUES("175","woocommerce_notify_no_stock","yes","no");
INSERT INTO `wp_options` VALUES("176","woocommerce_stock_email_recipient","miguel.rodriguez11@hotmail.com","no");
INSERT INTO `wp_options` VALUES("177","woocommerce_notify_low_stock_amount","2","no");
INSERT INTO `wp_options` VALUES("178","woocommerce_notify_no_stock_amount","0","yes");
INSERT INTO `wp_options` VALUES("179","woocommerce_hide_out_of_stock_items","no","yes");
INSERT INTO `wp_options` VALUES("180","woocommerce_stock_format","","yes");
INSERT INTO `wp_options` VALUES("181","woocommerce_file_download_method","force","no");
INSERT INTO `wp_options` VALUES("182","woocommerce_downloads_require_login","no","no");
INSERT INTO `wp_options` VALUES("183","woocommerce_downloads_grant_access_after_payment","no","no");
INSERT INTO `wp_options` VALUES("184","woocommerce_prices_include_tax","no","yes");
INSERT INTO `wp_options` VALUES("185","woocommerce_tax_based_on","base","yes");
INSERT INTO `wp_options` VALUES("186","woocommerce_shipping_tax_class","","yes");
INSERT INTO `wp_options` VALUES("187","woocommerce_tax_round_at_subtotal","no","yes");
INSERT INTO `wp_options` VALUES("188","woocommerce_tax_classes","","yes");
INSERT INTO `wp_options` VALUES("189","woocommerce_tax_display_shop","excl","yes");
INSERT INTO `wp_options` VALUES("190","woocommerce_tax_display_cart","incl","no");
INSERT INTO `wp_options` VALUES("191","woocommerce_price_display_suffix","No incluye IVA","yes");
INSERT INTO `wp_options` VALUES("192","woocommerce_tax_total_display","itemized","no");
INSERT INTO `wp_options` VALUES("193","woocommerce_enable_shipping_calc","no","no");
INSERT INTO `wp_options` VALUES("194","woocommerce_shipping_cost_requires_address","yes","no");
INSERT INTO `wp_options` VALUES("195","woocommerce_ship_to_destination","shipping","no");
INSERT INTO `wp_options` VALUES("196","woocommerce_enable_coupons","yes","yes");
INSERT INTO `wp_options` VALUES("197","woocommerce_calc_discounts_sequentially","yes","no");
INSERT INTO `wp_options` VALUES("198","woocommerce_enable_guest_checkout","no","no");
INSERT INTO `wp_options` VALUES("199","woocommerce_force_ssl_checkout","no","yes");
INSERT INTO `wp_options` VALUES("200","woocommerce_unforce_ssl_checkout","no","yes");
INSERT INTO `wp_options` VALUES("201","woocommerce_cart_page_id","6","yes");
INSERT INTO `wp_options` VALUES("202","woocommerce_checkout_page_id","7","yes");
INSERT INTO `wp_options` VALUES("203","woocommerce_terms_page_id","147","no");
INSERT INTO `wp_options` VALUES("204","woocommerce_checkout_pay_endpoint","order-pay","yes");
INSERT INTO `wp_options` VALUES("205","woocommerce_checkout_order_received_endpoint","order-received","yes");
INSERT INTO `wp_options` VALUES("206","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","yes");
INSERT INTO `wp_options` VALUES("207","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","yes");
INSERT INTO `wp_options` VALUES("208","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","yes");
INSERT INTO `wp_options` VALUES("209","woocommerce_myaccount_page_id","8","yes");
INSERT INTO `wp_options` VALUES("210","woocommerce_enable_signup_and_login_from_checkout","yes","no");
INSERT INTO `wp_options` VALUES("211","woocommerce_enable_myaccount_registration","yes","no");
INSERT INTO `wp_options` VALUES("212","woocommerce_enable_checkout_login_reminder","yes","no");
INSERT INTO `wp_options` VALUES("213","woocommerce_registration_generate_username","no","no");
INSERT INTO `wp_options` VALUES("214","woocommerce_registration_generate_password","no","no");
INSERT INTO `wp_options` VALUES("215","woocommerce_myaccount_orders_endpoint","orders","yes");
INSERT INTO `wp_options` VALUES("216","woocommerce_myaccount_view_order_endpoint","view-order","yes");
INSERT INTO `wp_options` VALUES("217","woocommerce_myaccount_downloads_endpoint","downloads","yes");
INSERT INTO `wp_options` VALUES("218","woocommerce_myaccount_edit_account_endpoint","edit-account","yes");
INSERT INTO `wp_options` VALUES("219","woocommerce_myaccount_edit_address_endpoint","edit-address","yes");
INSERT INTO `wp_options` VALUES("220","woocommerce_myaccount_payment_methods_endpoint","payment-methods","yes");
INSERT INTO `wp_options` VALUES("221","woocommerce_myaccount_lost_password_endpoint","lost-password","yes");
INSERT INTO `wp_options` VALUES("222","woocommerce_logout_endpoint","customer-logout","yes");
INSERT INTO `wp_options` VALUES("223","woocommerce_email_from_name","Ecommerce","no");
INSERT INTO `wp_options` VALUES("224","woocommerce_email_from_address","miguel.rodriguez11@hotmail.com","no");
INSERT INTO `wp_options` VALUES("225","woocommerce_email_header_image","","no");
INSERT INTO `wp_options` VALUES("226","woocommerce_email_footer_text","MANAPRO","no");
INSERT INTO `wp_options` VALUES("227","woocommerce_email_base_color","#000000","no");
INSERT INTO `wp_options` VALUES("228","woocommerce_email_background_color","#f5f5f5","no");
INSERT INTO `wp_options` VALUES("229","woocommerce_email_body_background_color","#fdfdfd","no");
INSERT INTO `wp_options` VALUES("230","woocommerce_email_text_color","#505050","no");
INSERT INTO `wp_options` VALUES("231","woocommerce_api_enabled","yes","yes");
INSERT INTO `wp_options` VALUES("237","woocommerce_admin_notices","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("239","_transient_woocommerce_webhook_ids","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("240","widget_woocommerce_widget_cart","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("241","widget_woocommerce_layered_nav_filters","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("242","widget_woocommerce_layered_nav","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("243","widget_woocommerce_price_filter","a:2:{i:3;a:1:{s:5:\"title\";s:18:\"Filtrar por precio\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("244","widget_woocommerce_product_categories","a:3:{i:2;a:7:{s:5:\"title\";s:11:\"Categorías\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:1;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}i:3;a:7:{s:5:\"title\";s:28:\"Categorías de los productos\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:1;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("245","widget_woocommerce_product_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("246","widget_woocommerce_product_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("247","widget_woocommerce_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("248","widget_woocommerce_rating_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("249","widget_woocommerce_recent_reviews","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("250","widget_woocommerce_recently_viewed_products","a:4:{i:2;a:2:{s:5:\"title\";s:30:\"Productos vistos recientemente\";s:6:\"number\";i:10;}i:3;a:2:{s:5:\"title\";s:30:\"Productos vistos recientemente\";s:6:\"number\";i:10;}i:4;a:2:{s:5:\"title\";s:30:\"Productos vistos recientemente\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("251","widget_woocommerce_top_rated_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("259","_transient_timeout_geoip_::1","1476121686","no");
INSERT INTO `wp_options` VALUES("260","_transient_geoip_::1","","no");
INSERT INTO `wp_options` VALUES("2417","_transient_timeout_external_ip_address_::1","1479736610","no");
INSERT INTO `wp_options` VALUES("2418","_transient_external_ip_address_::1","190.216.244.46","no");
INSERT INTO `wp_options` VALUES("263","_transient_timeout_geoip_503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.","1476121689","no");
INSERT INTO `wp_options` VALUES("264","_transient_geoip_503 Over Quota Error &nbsp; Over Quota This application is temporarily over its serving quota. Please try again later.","","no");
INSERT INTO `wp_options` VALUES("265","woocommerce_paypal-ec_settings","a:1:{s:7:\"enabled\";s:2:\"no\";}","yes");
INSERT INTO `wp_options` VALUES("266","woocommerce_stripe_settings","a:14:{s:7:\"enabled\";s:3:\"yes\";s:12:\"stripe_title\";s:19:\"Tarjeta de crédito\";s:18:\"stripe_description\";s:77:\"All cards are stored by &copy;Stripe servers we do not store any card details\";s:20:\"stripe_testsecretkey\";s:0:\"\";s:20:\"stripe_testpublickey\";s:0:\"\";s:20:\"stripe_livesecretkey\";s:0:\"\";s:20:\"stripe_livepublickey\";s:0:\"\";s:14:\"stripe_sandbox\";s:2:\"no\";s:21:\"stripe_authorize_only\";s:2:\"no\";s:16:\"stripe_cardtypes\";a:4:{i:0;s:10:\"mastercard\";i:1;s:4:\"visa\";i:2;s:8:\"discover\";i:3;s:4:\"amex\";}s:20:\"stripe_meta_cartspan\";s:2:\"no\";s:20:\"stripe_receipt_email\";s:2:\"no\";s:21:\"stripe_createcustomer\";s:2:\"no\";s:23:\"stripe_shipping_address\";s:2:\"no\";}","yes");
INSERT INTO `wp_options` VALUES("267","woocommerce_paypal_settings","a:16:{s:7:\"enabled\";s:3:\"yes\";s:5:\"email\";s:30:\"miguel.rodriguez11@hotmail.com\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:92:\"Pagar con PayPal; puedes pagar con tu tarjeta de crédito si no tienes una cuenta de PayPal.\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:14:\"receiver_email\";s:30:\"miguel.rodriguez11@hotmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:10:\"page_style\";s:0:\"\";s:12:\"api_username\";s:6:\"miguel\";s:12:\"api_password\";s:8:\"mi123456\";s:13:\"api_signature\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("268","woocommerce_cheque_settings","a:4:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:15:\"Pago por cheque\";s:11:\"description\";s:150:\"Por favor, envía un cheque a Nombre de la tienda, Calle de la tienda, Ciudad de la tienda, Provincia/País de la tienda, Código postal de la tienda.\";s:12:\"instructions\";s:150:\"Por favor, envía un cheque a Nombre de la tienda, Calle de la tienda, Ciudad de la tienda, Provincia/País de la tienda, Código postal de la tienda.\";}","yes");
INSERT INTO `wp_options` VALUES("269","woocommerce_bacs_settings","a:5:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:22:\"Transferencia bancaria\";s:11:\"description\";s:218:\"Realiza tu pago directamente en nuestras cuentas bancarias. Por favor usa la referencia del pedido como referencia de pago. El pedido no será enviado hasta que el importe completo haya sido recibido en nuestra cuenta.\";s:12:\"instructions\";s:218:\"Realiza tu pago directamente en nuestras cuentas bancarias. Por favor usa la referencia del pedido como referencia de pago. El pedido no será enviado hasta que el importe completo haya sido recibido en nuestra cuenta.\";s:15:\"account_details\";s:0:\"\";}","yes");
INSERT INTO `wp_options` VALUES("270","woocommerce_cod_settings","a:6:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:17:\"Efectivo o debito\";s:11:\"description\";s:78:\"Pagar en efectivo o debito al momento de la entrega directamente en la tienda.\";s:12:\"instructions\";s:78:\"Pagar en efectivo o debito al momento de la entrega directamente en la tienda.\";s:18:\"enable_for_methods\";a:1:{i:0;s:12:\"local_pickup\";}s:18:\"enable_for_virtual\";s:3:\"yes\";}","yes");
INSERT INTO `wp_options` VALUES("271","woocommerce_allow_tracking","no","yes");
INSERT INTO `wp_options` VALUES("272","_transient_shipping-transient-version","1478204245","yes");
INSERT INTO `wp_options` VALUES("502","_transient_orders-transient-version","1487682467","yes");
INSERT INTO `wp_options` VALUES("2904","_site_transient_timeout_wporg_theme_feature_list","1480188663","yes");
INSERT INTO `wp_options` VALUES("2905","_site_transient_wporg_theme_feature_list","a:4:{s:6:\"Colors\";a:15:{i:0;s:5:\"black\";i:1;s:4:\"blue\";i:2;s:5:\"brown\";i:3;s:4:\"gray\";i:4;s:5:\"green\";i:5;s:6:\"orange\";i:6;s:4:\"pink\";i:7;s:6:\"purple\";i:8;s:3:\"red\";i:9;s:6:\"silver\";i:10;s:3:\"tan\";i:11;s:5:\"white\";i:12;s:6:\"yellow\";i:13;s:4:\"dark\";i:14;s:5:\"light\";}s:6:\"Layout\";a:9:{i:0;s:12:\"fixed-layout\";i:1;s:12:\"fluid-layout\";i:2;s:17:\"responsive-layout\";i:3;s:10:\"one-column\";i:4;s:11:\"two-columns\";i:5;s:13:\"three-columns\";i:6;s:12:\"four-columns\";i:7;s:12:\"left-sidebar\";i:8;s:13:\"right-sidebar\";}s:8:\"Features\";a:20:{i:0;s:19:\"accessibility-ready\";i:1;s:8:\"blavatar\";i:2;s:10:\"buddypress\";i:3;s:17:\"custom-background\";i:4;s:13:\"custom-colors\";i:5;s:13:\"custom-header\";i:6;s:11:\"custom-menu\";i:7;s:12:\"editor-style\";i:8;s:21:\"featured-image-header\";i:9;s:15:\"featured-images\";i:10;s:15:\"flexible-header\";i:11;s:20:\"front-page-post-form\";i:12;s:19:\"full-width-template\";i:13;s:12:\"microformats\";i:14;s:12:\"post-formats\";i:15;s:20:\"rtl-language-support\";i:16;s:11:\"sticky-post\";i:17;s:13:\"theme-options\";i:18;s:17:\"threaded-comments\";i:19;s:17:\"translation-ready\";}s:7:\"Subject\";a:3:{i:0;s:7:\"holiday\";i:1;s:13:\"photoblogging\";i:2;s:8:\"seasonal\";}}","yes");
INSERT INTO `wp_options` VALUES("287","theme_mods_twentysixteen","a:2:{s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:6;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1475525703;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}","yes");
INSERT INTO `wp_options` VALUES("288","current_theme","EcommerceManapro","yes");
INSERT INTO `wp_options` VALUES("289","theme_mods_shop-isle","a:7:{i:0;b:0;s:17:\"shop_isle_banners\";s:460:\"[{\"image_url\":\"http:\\/\\/localhost:8080\\/ecommerce\\/wp-content\\/themes\\/shop-isle\\/assets\\/images\\/banner1.jpg\",\"link\":\"#\",\"id\":\"shop_isle_57f29c0478435\"},{\"image_url\":\"http:\\/\\/localhost:8080\\/ecommerce\\/wp-content\\/themes\\/shop-isle\\/assets\\/images\\/banner2.jpg\",\"link\":\"#\",\"id\":\"shop_isle_57f29c0478435\"},{\"image_url\":\"http:\\/\\/localhost:8080\\/ecommerce\\/wp-content\\/themes\\/shop-isle\\/assets\\/images\\/banner3.jpg\",\"link\":\"#\",\"id\":\"shop_isle_57f29c0478435\"}]\";s:22:\"shop_isle_team_members\";s:1110:\"[{\"image_url\":\"http:\\/\\/localhost:8080\\/ecommerce\\/wp-content\\/themes\\/shop-isle\\/assets\\/images\\/team1.jpg\",\"text\":\"Eva Bean\",\"subtext\":\"Developer\",\"description\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit lacus, a iaculis diam.\",\"id\":\"shop_isle_57f29c0485340\"},{\"image_url\":\"http:\\/\\/localhost:8080\\/ecommerce\\/wp-content\\/themes\\/shop-isle\\/assets\\/images\\/team2.jpg\",\"text\":\"Maria Woods\",\"subtext\":\"Designer\",\"description\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit lacus, a iaculis diam.\",\"id\":\"shop_isle_57f29c0485340\"},{\"image_url\":\"http:\\/\\/localhost:8080\\/ecommerce\\/wp-content\\/themes\\/shop-isle\\/assets\\/images\\/team3.jpg\",\"text\":\"Booby Stone\",\"subtext\":\"Director\",\"description\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit lacus, a iaculis diam.\",\"id\":\"shop_isle_57f29c0485340\"},{\"image_url\":\"http:\\/\\/localhost:8080\\/ecommerce\\/wp-content\\/themes\\/shop-isle\\/assets\\/images\\/team4.jpg\",\"text\":\"Anna Neaga\",\"subtext\":\"Art Director\",\"description\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit lacus, a iaculis diam.\",\"id\":\"shop_isle_57f29c0485340\"}]\";s:20:\"shop_isle_advantages\";s:623:\"[{\"icon_value\":\"icon_lightbulb\",\"text\":\"Ideas and concepts\",\"subtext\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\",\"id\":\"shop_isle_57f29c04aef42\"},{\"icon_value\":\"icon_tools\",\"text\":\"Designs & interfaces\",\"subtext\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\",\"id\":\"shop_isle_57f29c04aef42\"},{\"icon_value\":\"icon_cogs\",\"text\":\"Highly customizable\",\"subtext\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\",\"id\":\"shop_isle_57f29c04aef42\"},{\"icon_value\":\"icon_like\",\"text\":\"Easy to use\",\"subtext\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit.\",\"id\":\"shop_isle_57f29c04aef42\"}]\";s:19:\"shop_isle_font_size\";s:4:\"13px\";s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:6;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1475525693;s:4:\"data\";a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:21:\"sidebar-footer-area-1\";N;s:21:\"sidebar-footer-area-2\";N;s:21:\"sidebar-footer-area-3\";N;s:21:\"sidebar-footer-area-4\";N;s:30:\"shop-isle-sidebar-shop-archive\";N;}}}","yes");
INSERT INTO `wp_options` VALUES("290","theme_switched","","yes");
INSERT INTO `wp_options` VALUES("291","shop_isle_wporg_flag","true","yes");
INSERT INTO `wp_options` VALUES("292","shop_isle_migrate_translation","1","yes");
INSERT INTO `wp_options` VALUES("296","_transient_timeout_wc_upgrade_notice_2.6.2","1475604214","no");
INSERT INTO `wp_options` VALUES("297","_transient_wc_upgrade_notice_2.6.2","","no");
INSERT INTO `wp_options` VALUES("299","dslc_version","a:1:{i:0;s:5:\"1.1.4\";}","yes");
INSERT INTO `wp_options` VALUES("306","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO `wp_options` VALUES("315","theme_mods_EcommerceManapro","a:38:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:6;}s:11:\"custom_logo\";i:393;s:25:\"shop_isle_big_title_image\";s:72:\"http://cerere.manaprocloud.com/wp-content/uploads/2017/01/84828742_M.jpg\";s:25:\"shop_isle_big_title_title\";s:21:\"accesorios y carteras\";s:28:\"shop_isle_big_title_subtitle\";s:8:\"de mujer\";s:32:\"shop_isle_big_title_button_label\";s:3:\"ver\";s:17:\"shop_isle_banners\";s:467:\"[{\"link\":\"\\/categoria-producto\\/ellas\\/casual-ellas\\/\",\"image_url\":\"http:\\/\\/cerere.manaprocloud.com\\/wp-content\\/uploads\\/2017\\/01\\/casual-1.jpg\",\"id\":\"\"},{\"link\":\"\\/categoria-producto\\/ellas\\/accesorios-ellas\\/\",\"image_url\":\"http:\\/\\/cerere.manaprocloud.com\\/wp-content\\/uploads\\/2017\\/01\\/acc-2.jpg\",\"id\":\"\"},{\"link\":\"\\/categoria-producto\\/ellos\\/confort-ellos\\/\",\"image_url\":\"http:\\/\\/cerere.manaprocloud.com\\/wp-content\\/uploads\\/2017\\/02\\/confort.jpg\",\"id\":\"\"}]\";s:17:\"shop_isle_socials\";s:277:\"[{\"icon_value\":\"social_youtube\",\"link\":\"#\",\"id\":\"\"},{\"icon_value\":\"social_facebook\",\"link\":\"#\",\"id\":\"shop_isle_57f2c29fd4a12\"},{\"icon_value\":\"social_instagram\",\"link\":\"#\",\"id\":\"shop_isle_57f2c2a7d4a13\"},{\"icon_value\":\"social_twitter\",\"link\":\"#\",\"id\":\"shop_isle_57f2c2b3d4a14\"}]\";s:19:\"shop_isle_copyright\";s:32:\"TODOS LOS DERECHOS RESERVADOS ©\";s:24:\"shop_isle_site_info_hide\";s:1:\"1\";s:24:\"shop_isle_products_title\";s:14:\"más recientes\";s:31:\"shop_isle_products_slider_title\";s:10:\"destacados\";s:34:\"shop_isle_products_slider_subtitle\";s:26:\"Nuestros mejores productos\";s:27:\"shop_isle_products_category\";s:1:\"-\";s:34:\"shop_isle_products_slider_category\";s:1:\"9\";s:23:\"shop_isle_products_hide\";s:0:\"\";s:17:\"shop_isle_yt_link\";s:0:\"\";s:12:\"header_image\";s:111:\"http://localhost:8080/ecommerce/wp-content/uploads/2016/10/cropped-red_converse_shoes-wallpaper-2560x1440-1.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:152;s:3:\"url\";s:111:\"http://localhost:8080/ecommerce/wp-content/uploads/2016/10/cropped-red_converse_shoes-wallpaper-2560x1440-1.jpg\";s:13:\"thumbnail_url\";s:111:\"http://localhost:8080/ecommerce/wp-content/uploads/2016/10/cropped-red_converse_shoes-wallpaper-2560x1440-1.jpg\";s:6:\"height\";i:675;s:5:\"width\";i:1200;}s:23:\"shop_isle_banners_title\";s:0:\"\";s:21:\"shop_isle_video_title\";s:0:\"\";s:22:\"shop_isle_yt_thumbnail\";s:73:\"http://cerere.manaprocloud.com/wp-content/uploads/2017/01/105548396_M.jpg\";s:28:\"shop_isle_products_shortcode\";s:17:\"[recent_products]\";s:27:\"shop_isle_disable_preloader\";s:0:\"\";s:26:\"shop_isle_big_title_image2\";s:72:\"http://cerere.manaprocloud.com/wp-content/uploads/2017/01/92382087_M.jpg\";s:26:\"shop_isle_big_title_image3\";s:72:\"http://cerere.manaprocloud.com/wp-content/uploads/2017/01/89952178_M.jpg\";s:26:\"shop_isle_big_title_title2\";s:21:\"accesorios y carteras\";s:26:\"shop_isle_big_title_title3\";s:15:\"Tips de cuidado\";s:29:\"shop_isle_big_title_subtitle2\";s:9:\"de hombre\";s:29:\"shop_isle_big_title_subtitle3\";s:11:\"del calzado\";s:33:\"shop_isle_big_title_button_label2\";s:3:\"Ver\";s:33:\"shop_isle_big_title_button_label3\";s:3:\"Ver\";s:31:\"shop_isle_big_title_button_link\";s:43:\"/categoria-producto/mujer/accesorios-mujer/\";s:32:\"shop_isle_big_title_button_link3\";s:17:\"/tips-de-cuidado/\";s:30:\"shop_isle_products_slider_hide\";s:1:\"1\";s:32:\"shop_isle_big_title_button_link2\";s:45:\"/categoria-producto/hombre/accesorios-hombre/\";s:37:\"shop_isle_products_slider_single_hide\";s:1:\"1\";}","yes");
INSERT INTO `wp_options` VALUES("317","woocommerce_db_version","2.6.4","yes");
INSERT INTO `wp_options` VALUES("318","woocommerce_version","2.6.4","yes");
INSERT INTO `wp_options` VALUES("321","_transient_wc_attribute_taxonomies","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("573","wooccm_update_notice","1","yes");
INSERT INTO `wp_options` VALUES("574","wccs_settings","a:2:{s:7:\"buttons\";a:0:{}s:9:\"checkness\";a:25:{s:12:\"upload_title\";s:0:\"\";s:25:\"wooccm_notification_email\";s:30:\"miguel.rodriguez11@hotmail.com\";s:17:\"allow_file_upload\";s:0:\"\";s:16:\"deny_file_upload\";s:0:\"\";s:21:\"allow_file_upload_cat\";s:0:\"\";s:20:\"deny_file_upload_cat\";s:0:\"\";s:15:\"picture_success\";s:14:\"Picture Saved!\";s:11:\"file_delete\";s:6:\"Delete\";s:10:\"file_types\";s:0:\"\";s:18:\"file_upload_number\";s:0:\"\";s:9:\"upload_os\";s:0:\"\";s:12:\"productssave\";s:0:\"\";s:10:\"noteslabel\";s:0:\"\";s:16:\"notesplaceholder\";s:0:\"\";s:16:\"time_stamp_title\";s:10:\"Order Time\";s:12:\"set_timezone\";s:0:\"\";s:16:\"payment_method_d\";s:14:\"Payment Method\";s:16:\"payment_method_t\";s:4:\"true\";s:17:\"shipping_method_d\";s:15:\"Shipping Method\";s:17:\"shipping_method_t\";s:4:\"true\";s:9:\"per_state\";s:0:\"\";s:12:\"custom_css_w\";s:0:\"\";s:5:\"text1\";s:0:\"\";s:5:\"text2\";s:0:\"\";s:8:\"position\";s:17:\"after_order_notes\";}}","yes");
INSERT INTO `wp_options` VALUES("588","orddd_lite_enable_delivery_date","","yes");
INSERT INTO `wp_options` VALUES("949","widget_widget_sp_image","a:4:{i:3;a:14:{s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"link\";s:1:\"#\";s:6:\"linkid\";s:0:\"\";s:10:\"linktarget\";s:5:\"_self\";s:5:\"width\";i:80;s:6:\"height\";i:24;s:4:\"size\";s:25:\"tribe_image_widget_custom\";s:5:\"align\";s:6:\"center\";s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:8:\"imageurl\";s:73:\"http://sentra.manaprocloud.com/wp-content/uploads/2016/10/Paypal.svg_.png\";s:12:\"aspect_ratio\";d:3.333333333333333481363069950020872056484222412109375;s:13:\"attachment_id\";i:190;}i:6;a:14:{s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"link\";s:1:\"#\";s:6:\"linkid\";s:0:\"\";s:10:\"linktarget\";s:5:\"_self\";s:5:\"width\";i:80;s:6:\"height\";i:80;s:4:\"size\";s:25:\"tribe_image_widget_custom\";s:5:\"align\";s:6:\"center\";s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:8:\"imageurl\";s:66:\"http://sentra.manaprocloud.com/wp-content/uploads/2016/10/zoom.png\";s:12:\"aspect_ratio\";i:1;s:13:\"attachment_id\";i:207;}i:9;a:14:{s:5:\"title\";s:0:\"\";s:11:\"description\";s:0:\"\";s:4:\"link\";s:0:\"\";s:6:\"linkid\";s:0:\"\";s:10:\"linktarget\";s:5:\"_self\";s:5:\"width\";i:230;s:6:\"height\";i:55;s:4:\"size\";s:25:\"tribe_image_widget_custom\";s:5:\"align\";s:6:\"center\";s:3:\"alt\";s:0:\"\";s:3:\"rel\";s:0:\"\";s:8:\"imageurl\";s:70:\"http://cerere.manaprocloud.com/wp-content/uploads/2016/10/manaproB.png\";s:12:\"aspect_ratio\";d:4.2075471698113204865876468829810619354248046875;s:13:\"attachment_id\";i:150;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("8063","_transient_timeout_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1487723902","no");
INSERT INTO `wp_options` VALUES("8064","_transient_feed_mod_d117b5738fbd35bd8c0391cda1f2b5d9","1487680702","no");
INSERT INTO `wp_options` VALUES("1873","inc_popup-config","a:2:{s:13:\"loadingmethod\";s:4:\"ajax\";s:5:\"rules\";a:7:{i:0;s:28:\"class-popup-rule-browser.php\";i:1;s:24:\"class-popup-rule-geo.php\";i:2;s:26:\"class-popup-rule-popup.php\";i:3;s:29:\"class-popup-rule-referrer.php\";i:4;s:24:\"class-popup-rule-url.php\";i:5;s:25:\"class-popup-rule-user.php\";i:6;s:28:\"class-popup-rule-prosite.php\";}}","yes");
INSERT INTO `wp_options` VALUES("331","theme_mods_west","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:6;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1475526250;s:4:\"data\";a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:8:\"footer-1\";N;s:8:\"footer-2\";N;s:8:\"footer-3\";N;}}}","yes");
INSERT INTO `wp_options` VALUES("332","widget_west_social_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("575","wccs_settings2","a:1:{s:16:\"shipping_buttons\";a:9:{i:0;a:35:{s:5:\"order\";s:1:\"1\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-wide\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:5:\"País\";s:11:\"placeholder\";s:0:\"\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:13:\"wooccmcountry\";s:3:\"cow\";s:7:\"country\";}i:1;a:35:{s:5:\"order\";s:1:\"2\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:14:\"form-row-first\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:6:\"Nombre\";s:11:\"placeholder\";s:6:\"Nombre\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:10:\"first_name\";}i:2;a:36:{s:5:\"order\";s:1:\"3\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-last\";s:9:\"clear_row\";s:4:\"true\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:8:\"Apellido\";s:11:\"placeholder\";s:8:\"Apellido\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:9:\"last_name\";}i:3;a:34:{s:5:\"order\";s:1:\"4\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"position\";s:13:\"form-row-wide\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:19:\"Nombre de compañia\";s:11:\"placeholder\";s:9:\"Compañia\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:7:\"company\";}i:4;a:35:{s:5:\"order\";s:1:\"5\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-wide\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:10:\"Dirección\";s:11:\"placeholder\";s:10:\"Dirección\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:9:\"address_1\";}i:5;a:35:{s:5:\"order\";s:1:\"6\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-wide\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"placeholder\";s:37:\"Apartamento, habitación, undad, etc.\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:9:\"address_2\";}i:6;a:35:{s:5:\"order\";s:1:\"7\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-wide\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:17:\"Localidad/ Ciudad\";s:11:\"placeholder\";s:17:\"Localidad/ Ciudad\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:4:\"city\";}i:7;a:35:{s:5:\"order\";s:1:\"8\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:14:\"form-row-first\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:6:\"Estado\";s:11:\"placeholder\";s:0:\"\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:11:\"wooccmstate\";s:3:\"cow\";s:5:\"state\";}i:8;a:36:{s:5:\"order\";s:1:\"9\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-last\";s:9:\"clear_row\";s:4:\"true\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:14:\"Código Postal\";s:11:\"placeholder\";s:14:\"Código Postal\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:8:\"postcode\";}}}","yes");
INSERT INTO `wp_options` VALUES("589","orddd_lite_weekday_0","checked","yes");
INSERT INTO `wp_options` VALUES("590","orddd_lite_weekday_1","checked","yes");
INSERT INTO `wp_options` VALUES("591","orddd_lite_weekday_2","checked","yes");
INSERT INTO `wp_options` VALUES("592","orddd_lite_weekday_3","checked","yes");
INSERT INTO `wp_options` VALUES("593","orddd_lite_weekday_4","checked","yes");
INSERT INTO `wp_options` VALUES("594","orddd_lite_weekday_5","checked","yes");
INSERT INTO `wp_options` VALUES("595","orddd_lite_weekday_6","checked","yes");
INSERT INTO `wp_options` VALUES("596","orddd_lite_minimumOrderDays","0","yes");
INSERT INTO `wp_options` VALUES("597","orddd_lite_number_of_dates","30","yes");
INSERT INTO `wp_options` VALUES("598","orddd_lite_date_field_mandatory","","yes");
INSERT INTO `wp_options` VALUES("599","orddd_lite_lockout_date_after_orders","","yes");
INSERT INTO `wp_options` VALUES("600","orddd_lite_lockout_days","[]","yes");
INSERT INTO `wp_options` VALUES("601","orddd_lite_update_value","yes","yes");
INSERT INTO `wp_options` VALUES("602","orddd_lite_abp_hrs","HOURS","yes");
INSERT INTO `wp_options` VALUES("343","_transient_product_query-transient-version","1487685184","yes");
INSERT INTO `wp_options` VALUES("344","_transient_product-transient-version","1487685184","yes");
INSERT INTO `wp_options` VALUES("3580","_transient_wc_product_children_231","a:2:{s:7:\"visible\";a:4:{i:0;i:232;i:1;i:233;i:2;i:234;i:3;i:235;}s:3:\"all\";a:4:{i:0;i:232;i:1;i:233;i:2;i:234;i:3;i:235;}}","no");
INSERT INTO `wp_options` VALUES("3581","_transient_timeout_wc_var_prices_231","1486643423","no");
INSERT INTO `wp_options` VALUES("3582","_transient_wc_var_prices_231","{\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"232\":\"35000.00\",\"233\":\"40000.00\",\"234\":\"50000.00\",\"235\":\"60000.00\"},\"regular_price\":{\"232\":\"35000.00\",\"233\":\"40000.00\",\"234\":\"50000.00\",\"235\":\"60000.00\"},\"sale_price\":{\"232\":\"35000.00\",\"233\":\"40000.00\",\"234\":\"50000.00\",\"235\":\"60000.00\"}},\"1d9311a4f2a82a4411fffa652c03a780\":{\"price\":{\"232\":\"35000.00\",\"233\":\"40000.00\",\"234\":\"50000.00\",\"235\":\"60000.00\"},\"regular_price\":{\"232\":\"35000.00\",\"233\":\"40000.00\",\"234\":\"50000.00\",\"235\":\"60000.00\"},\"sale_price\":{\"232\":\"35000.00\",\"233\":\"40000.00\",\"234\":\"50000.00\",\"235\":\"60000.00\"}}}","no");
INSERT INTO `wp_options` VALUES("4284","wpseo_sitemap_78_cache_validator","56yGQ","no");
INSERT INTO `wp_options` VALUES("4625","_site_transient_timeout_browser_e8aa320ddb6983ade426fcffe3af7f1f","1486320851","yes");
INSERT INTO `wp_options` VALUES("8367","_transient_wc_related_452","a:9:{i:0;s:3:\"500\";i:1;s:3:\"113\";i:2;s:3:\"118\";i:3;s:3:\"454\";i:4;s:3:\"505\";i:5;s:3:\"479\";i:6;s:3:\"481\";i:7;s:3:\"261\";i:8;s:3:\"478\";}","no");
INSERT INTO `wp_options` VALUES("4485","wpseo_sitemap_dslc_templates_cache_validator","5I8Sl","no");
INSERT INTO `wp_options` VALUES("3603","_transient_wc_product_children_63","a:2:{s:7:\"visible\";a:4:{i:0;i:64;i:1;i:65;i:2;i:66;i:3;i:67;}s:3:\"all\";a:4:{i:0;i:64;i:1;i:65;i:2;i:66;i:3;i:67;}}","no");
INSERT INTO `wp_options` VALUES("3604","_transient_timeout_wc_var_prices_63","1486643483","no");
INSERT INTO `wp_options` VALUES("3605","_transient_wc_var_prices_63","{\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"67\":\"35000.00\",\"64\":\"40000.00\",\"65\":\"50000.00\",\"66\":\"60000.00\"},\"regular_price\":{\"67\":\"35000.00\",\"64\":\"40000.00\",\"65\":\"50000.00\",\"66\":\"60000.00\"},\"sale_price\":{\"67\":\"35000.00\",\"64\":\"40000.00\",\"65\":\"50000.00\",\"66\":\"60000.00\"}},\"1d9311a4f2a82a4411fffa652c03a780\":{\"price\":{\"67\":\"35000.00\",\"64\":\"40000.00\",\"65\":\"50000.00\",\"66\":\"60000.00\"},\"regular_price\":{\"67\":\"35000.00\",\"64\":\"40000.00\",\"65\":\"50000.00\",\"66\":\"60000.00\"},\"sale_price\":{\"67\":\"35000.00\",\"64\":\"40000.00\",\"65\":\"50000.00\",\"66\":\"60000.00\"}}}","no");
INSERT INTO `wp_options` VALUES("3321","_transient_timeout_wc_product_children_43","1486643483","no");
INSERT INTO `wp_options` VALUES("3322","_transient_wc_product_children_43","a:2:{s:3:\"all\";a:3:{i:0;i:60;i:1;i:61;i:2;i:62;}s:7:\"visible\";a:3:{i:0;i:60;i:1;i:61;i:2;i:62;}}","no");
INSERT INTO `wp_options` VALUES("3600","_transient_timeout_wc_var_prices_43","1486643483","no");
INSERT INTO `wp_options` VALUES("3601","_transient_wc_var_prices_43","{\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"62\":\"40000.00\",\"61\":\"50000.00\",\"60\":\"60000.00\"},\"regular_price\":{\"62\":\"40000.00\",\"61\":\"50000.00\",\"60\":\"60000.00\"},\"sale_price\":{\"62\":\"40000.00\",\"61\":\"50000.00\",\"60\":\"60000.00\"}},\"1d9311a4f2a82a4411fffa652c03a780\":{\"price\":{\"62\":\"40000.00\",\"61\":\"50000.00\",\"60\":\"60000.00\"},\"regular_price\":{\"62\":\"40000.00\",\"61\":\"50000.00\",\"60\":\"60000.00\"},\"sale_price\":{\"62\":\"40000.00\",\"61\":\"50000.00\",\"60\":\"60000.00\"}}}","no");
INSERT INTO `wp_options` VALUES("3719","_transient_timeout_wc_product_children_236","1486841212","no");
INSERT INTO `wp_options` VALUES("3720","_transient_wc_product_children_236","a:2:{s:7:\"visible\";a:4:{i:0;i:237;i:1;i:238;i:2;i:239;i:3;i:240;}s:3:\"all\";a:4:{i:0;i:237;i:1;i:238;i:2;i:239;i:3;i:240;}}","no");
INSERT INTO `wp_options` VALUES("3721","_transient_timeout_wc_var_prices_236","1486841212","no");
INSERT INTO `wp_options` VALUES("3722","_transient_wc_var_prices_236","{\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"237\":\"35000.00\",\"238\":\"40000.00\",\"239\":\"50000.00\",\"240\":\"60000.00\"},\"regular_price\":{\"237\":\"35000.00\",\"238\":\"40000.00\",\"239\":\"50000.00\",\"240\":\"60000.00\"},\"sale_price\":{\"237\":\"35000.00\",\"238\":\"40000.00\",\"239\":\"50000.00\",\"240\":\"60000.00\"}},\"1d9311a4f2a82a4411fffa652c03a780\":{\"price\":{\"237\":\"35000.00\",\"238\":\"40000.00\",\"239\":\"50000.00\",\"240\":\"60000.00\"},\"regular_price\":{\"237\":\"35000.00\",\"238\":\"40000.00\",\"239\":\"50000.00\",\"240\":\"60000.00\"},\"sale_price\":{\"237\":\"35000.00\",\"238\":\"40000.00\",\"239\":\"50000.00\",\"240\":\"60000.00\"}}}","no");
INSERT INTO `wp_options` VALUES("519","woocommerce_meta_box_errors","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("803","widget_ninja_forms_widget","a:2:{i:2;a:2:{s:7:\"form_id\";s:1:\"1\";s:13:\"display_title\";s:1:\"0\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("807","ninja_forms_do_not_allow_tracking","1","yes");
INSERT INTO `wp_options` VALUES("3566","_transient_timeout_wc_var_prices_88","1486587830","no");
INSERT INTO `wp_options` VALUES("3567","_transient_wc_var_prices_88","{\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"89\":\"35000.00\",\"90\":\"40000.00\",\"91\":\"50000.00\",\"92\":\"60000.00\"},\"regular_price\":{\"89\":\"35000.00\",\"90\":\"40000.00\",\"91\":\"50000.00\",\"92\":\"60000.00\"},\"sale_price\":{\"89\":\"35000.00\",\"90\":\"40000.00\",\"91\":\"50000.00\",\"92\":\"60000.00\"}},\"1d9311a4f2a82a4411fffa652c03a780\":{\"price\":{\"89\":\"35000.00\",\"90\":\"40000.00\",\"91\":\"50000.00\",\"92\":\"60000.00\"},\"regular_price\":{\"89\":\"35000.00\",\"90\":\"40000.00\",\"91\":\"50000.00\",\"92\":\"60000.00\"},\"sale_price\":{\"89\":\"35000.00\",\"90\":\"40000.00\",\"91\":\"50000.00\",\"92\":\"60000.00\"}}}","no");
INSERT INTO `wp_options` VALUES("7678","wpseo_sitemap_434_cache_validator","55TYC","no");
INSERT INTO `wp_options` VALUES("2873","_site_transient_timeout_browser_2bf78cb2f6f0604d5d237b451fa3d2f4","1480782439","yes");
INSERT INTO `wp_options` VALUES("2874","_site_transient_browser_2bf78cb2f6f0604d5d237b451fa3d2f4","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"49.0.2623.112\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("3564","_transient_timeout_wc_product_children_88","1486587830","no");
INSERT INTO `wp_options` VALUES("3565","_transient_wc_product_children_88","a:2:{s:7:\"visible\";a:4:{i:0;i:89;i:1;i:90;i:2;i:91;i:3;i:92;}s:3:\"all\";a:4:{i:0;i:89;i:1;i:90;i:2;i:91;i:3;i:92;}}","no");
INSERT INTO `wp_options` VALUES("8944","_site_transient_timeout_theme_roots","1491981164","yes");
INSERT INTO `wp_options` VALUES("8945","_site_transient_theme_roots","a:5:{s:16:\"EcommerceManapro\";s:7:\"/themes\";s:13:\"twentyfifteen\";s:7:\"/themes\";s:14:\"twentyfourteen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";s:4:\"west\";s:7:\"/themes\";}","yes");
INSERT INTO `wp_options` VALUES("4317","wpseo_sitemap_43_cache_validator","5PnfX","no");
INSERT INTO `wp_options` VALUES("4318","wpseo_sitemap_63_cache_validator","5PnfU","no");
INSERT INTO `wp_options` VALUES("4319","wpseo_sitemap_88_cache_validator","5PnfS","no");
INSERT INTO `wp_options` VALUES("4228","wpseo_sitemap_113_cache_validator","56jEr","no");
INSERT INTO `wp_options` VALUES("8668","_transient_timeout_wc_related_68","1490536316","no");
INSERT INTO `wp_options` VALUES("7867","_transient_wc_related_73","a:3:{i:0;s:2:\"83\";i:1;s:3:\"530\";i:2;s:3:\"540\";}","no");
INSERT INTO `wp_options` VALUES("3549","_transient_timeout_wc_product_children_256","1486587823","no");
INSERT INTO `wp_options` VALUES("3550","_transient_wc_product_children_256","a:2:{s:7:\"visible\";a:4:{i:0;i:257;i:1;i:258;i:2;i:259;i:3;i:260;}s:3:\"all\";a:4:{i:0;i:257;i:1;i:258;i:2;i:259;i:3;i:260;}}","no");
INSERT INTO `wp_options` VALUES("3551","_transient_timeout_wc_var_prices_256","1486587823","no");
INSERT INTO `wp_options` VALUES("3552","_transient_wc_var_prices_256","{\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"257\":\"35000.00\",\"258\":\"40000.00\",\"259\":\"50000.00\",\"260\":\"60000.00\"},\"regular_price\":{\"257\":\"35000.00\",\"258\":\"40000.00\",\"259\":\"50000.00\",\"260\":\"60000.00\"},\"sale_price\":{\"257\":\"35000.00\",\"258\":\"40000.00\",\"259\":\"50000.00\",\"260\":\"60000.00\"}},\"1d9311a4f2a82a4411fffa652c03a780\":{\"price\":{\"257\":\"35000.00\",\"258\":\"40000.00\",\"259\":\"50000.00\",\"260\":\"60000.00\"},\"regular_price\":{\"257\":\"35000.00\",\"258\":\"40000.00\",\"259\":\"50000.00\",\"260\":\"60000.00\"},\"sale_price\":{\"257\":\"35000.00\",\"258\":\"40000.00\",\"259\":\"50000.00\",\"260\":\"60000.00\"}}}","no");
INSERT INTO `wp_options` VALUES("450","dslc_module_id_count","179","yes");
INSERT INTO `wp_options` VALUES("462","_site_transient_timeout_browser_6a89f46f9fedac51174ac55fe62408d8","1476193007","yes");
INSERT INTO `wp_options` VALUES("463","_site_transient_browser_6a89f46f9fedac51174ac55fe62408d8","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"53.0.2785.116\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("4288","wpseo_sitemap_73_cache_validator","56AzO","no");
INSERT INTO `wp_options` VALUES("7677","wpseo_sitemap_452_cache_validator","55QSJ","no");
INSERT INTO `wp_options` VALUES("580","wc_nb_newness","30","yes");
INSERT INTO `wp_options` VALUES("586","woocommerce_custom_product_tabs_lite_db_version","1.5.0","yes");
INSERT INTO `wp_options` VALUES("801","ninja_forms_version","3.0.6","yes");
INSERT INTO `wp_options` VALUES("576","wccs_settings3","a:1:{s:15:\"billing_buttons\";a:11:{i:0;a:35:{s:5:\"order\";s:1:\"1\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-wide\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:5:\"País\";s:11:\"placeholder\";s:0:\"\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:13:\"wooccmcountry\";s:3:\"cow\";s:7:\"country\";}i:1;a:35:{s:5:\"order\";s:1:\"2\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:14:\"form-row-first\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:6:\"Nombre\";s:11:\"placeholder\";s:6:\"Nombre\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:10:\"first_name\";}i:2;a:36:{s:5:\"order\";s:1:\"3\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-last\";s:9:\"clear_row\";s:4:\"true\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:8:\"Apellido\";s:11:\"placeholder\";s:8:\"Apellido\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:9:\"last_name\";}i:3;a:34:{s:5:\"order\";s:1:\"4\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"position\";s:13:\"form-row-wide\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:20:\"Nombre de compañía\";s:11:\"placeholder\";s:10:\"Compañía\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:7:\"company\";}i:4;a:35:{s:5:\"order\";s:1:\"5\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-wide\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:10:\"Dirección\";s:11:\"placeholder\";s:30:\"Apartamento, edificio, casa...\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:9:\"address_1\";}i:5;a:35:{s:5:\"order\";s:1:\"6\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-wide\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:0:\"\";s:11:\"placeholder\";s:17:\"Calle, Avenida...\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:9:\"address_2\";}i:6;a:34:{s:5:\"order\";s:1:\"7\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"position\";s:13:\"form-row-wide\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:17:\"Localidad/ Ciudad\";s:11:\"placeholder\";s:17:\"Localidad/ Ciudad\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:4:\"city\";}i:7;a:35:{s:5:\"order\";s:1:\"8\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:14:\"form-row-first\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:6:\"Estado\";s:11:\"placeholder\";s:0:\"\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:11:\"wooccmstate\";s:3:\"cow\";s:5:\"state\";}i:8;a:36:{s:5:\"order\";s:1:\"9\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-last\";s:9:\"clear_row\";s:4:\"true\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:14:\"Código Postal\";s:11:\"placeholder\";s:14:\"Código Postal\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:8:\"postcode\";}i:9;a:35:{s:5:\"order\";s:2:\"10\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:14:\"form-row-first\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:6:\"E-mail\";s:11:\"placeholder\";s:16:\"email@domain.com\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:5:\"email\";}i:10;a:36:{s:5:\"order\";s:2:\"11\";s:8:\"single_p\";s:0:\"\";s:9:\"single_px\";s:0:\"\";s:12:\"single_p_cat\";s:0:\"\";s:13:\"single_px_cat\";s:0:\"\";s:10:\"start_hour\";s:0:\"\";s:8:\"end_hour\";s:0:\"\";s:12:\"interval_min\";s:0:\"\";s:10:\"manual_min\";s:0:\"\";s:11:\"format_date\";s:0:\"\";s:10:\"min_before\";s:0:\"\";s:9:\"max_after\";s:0:\"\";s:9:\"single_yy\";s:0:\"\";s:9:\"single_mm\";s:0:\"\";s:9:\"single_dd\";s:0:\"\";s:13:\"single_max_yy\";s:0:\"\";s:13:\"single_max_mm\";s:0:\"\";s:13:\"single_max_dd\";s:0:\"\";s:8:\"checkbox\";s:4:\"true\";s:8:\"position\";s:13:\"form-row-last\";s:9:\"clear_row\";s:4:\"true\";s:8:\"fee_name\";s:0:\"\";s:16:\"add_amount_field\";s:0:\"\";s:5:\"label\";s:9:\"Teléfono\";s:11:\"placeholder\";s:11:\"04165889988\";s:11:\"chosen_valt\";s:0:\"\";s:15:\"conditional_tie\";s:0:\"\";s:12:\"colorpickerd\";s:0:\"\";s:15:\"colorpickertype\";s:10:\"farbtastic\";s:12:\"role_options\";s:0:\"\";s:13:\"role_options2\";s:0:\"\";s:11:\"extra_class\";s:0:\"\";s:12:\"force_title2\";s:0:\"\";s:12:\"option_array\";s:0:\"\";s:4:\"type\";s:10:\"wooccmtext\";s:3:\"cow\";s:5:\"phone\";}}}","yes");
INSERT INTO `wp_options` VALUES("603","orddd_lite_default_appearance_settings","yes","yes");
INSERT INTO `wp_options` VALUES("604","orddd_lite_enable_default_sorting_of_column","","yes");
INSERT INTO `wp_options` VALUES("605","orddd_lite_enable_delivery_date_enabled","yes","yes");
INSERT INTO `wp_options` VALUES("606","orddd_lite_delivery_date_format","d MM, yy","yes");
INSERT INTO `wp_options` VALUES("607","orddd_lite_delivery_date_field_label","Delivery Date","yes");
INSERT INTO `wp_options` VALUES("608","orddd_lite_delivery_date_field_placeholder","Choose a Date","yes");
INSERT INTO `wp_options` VALUES("609","orddd_lite_delivery_date_field_note","We will try our best to deliver your order on the specified date.","yes");
INSERT INTO `wp_options` VALUES("610","orddd_lite_number_of_months","1","yes");
INSERT INTO `wp_options` VALUES("611","orddd_lite_calendar_theme","smoothness","yes");
INSERT INTO `wp_options` VALUES("612","orddd_lite_calendar_theme_name","Smoothness","yes");
INSERT INTO `wp_options` VALUES("613","orddd_lite_language_selected","en-GB","yes");
INSERT INTO `wp_options` VALUES("614","orddd_lite_delivery_date_fields_on_checkout_page","billing_section","yes");
INSERT INTO `wp_options` VALUES("615","orddd_lite_no_fields_for_virtual_product","","yes");
INSERT INTO `wp_options` VALUES("616","orddd_lite_no_fields_for_featured_product","","yes");
INSERT INTO `wp_options` VALUES("653","wc_customizer_version","2.3.1","yes");
INSERT INTO `wp_options` VALUES("804","nf_admin_notice","a:2:{s:16:\"one_week_support\";a:3:{s:5:\"start\";s:10:\"10/12/2016\";s:3:\"int\";i:7;s:9:\"dismissed\";i:1;}s:14:\"allow_tracking\";a:2:{s:5:\"start\";s:9:\"10/5/2016\";s:3:\"int\";i:0;}}","yes");
INSERT INTO `wp_options` VALUES("845","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:30:\"miguel.rodriguez11@hotmail.com\";s:7:\"version\";s:5:\"4.5.7\";s:9:\"timestamp\";i:1488836943;}","yes");
INSERT INTO `wp_options` VALUES("618","orddd_lite_db_version","2.6","yes");
INSERT INTO `wp_options` VALUES("619","orddd_lite_delivery_date_on_checkout_page_enabled","yes","yes");
INSERT INTO `wp_options` VALUES("620","orddd_update_admin_notice","yes","yes");
INSERT INTO `wp_options` VALUES("802","ninja_forms_settings","a:8:{s:11:\"date_format\";s:5:\"m/d/Y\";s:8:\"currency\";s:3:\"USD\";s:18:\"recaptcha_site_key\";s:0:\"\";s:20:\"recaptcha_secret_key\";s:0:\"\";s:14:\"recaptcha_lang\";s:0:\"\";s:19:\"delete_on_uninstall\";i:0;s:21:\"disable_admin_notices\";i:0;s:15:\"currency_symbol\";s:1:\"$\";}","yes");
INSERT INTO `wp_options` VALUES("621","wooccm_beta_notice","1","yes");
INSERT INTO `wp_options` VALUES("627","yit_recently_activated","a:2:{i:0;s:41:\"yith-woocommerce-ajax-navigation/init.php\";i:1;s:38:\"yith-woocommerce-catalog-mode/init.php\";}","yes");
INSERT INTO `wp_options` VALUES("894","_transient_timeout_yit_panel_sidebar_remote_widgets","1490069557","no");
INSERT INTO `wp_options` VALUES("895","_transient_yit_panel_sidebar_remote_widgets","a:0:{}","no");
INSERT INTO `wp_options` VALUES("632","yith_wcmg_slider_direction","left","yes");
INSERT INTO `wp_options` VALUES("633","yith_wcas_general_videobox","a:7:{s:11:\"plugin_name\";s:31:\"YITH WooCommerce Zoom Magnifier\";s:18:\"title_first_column\";s:39:\"Descubre las características avanzadas\";s:24:\"description_first_column\";s:117:\"¡Actualiza a la VERSIÓN PREMIUM de YITH WOOCOMMERCE ZOOM MAGNIFIER para beneficiarte de todas las características!\";s:5:\"video\";a:3:{s:8:\"video_id\";s:9:\"122436840\";s:15:\"video_image_url\";s:138:\"http://localhost:8080/ecommerce/wp-content/plugins/yith-woocommerce-zoom-magnifier/assets/images/yith-woocommerce-zoom-magnifier-video.jpg\";s:17:\"video_description\";s:104:\"Ver cómo es el plugin YITH WooCommerce Zoom Magnifier con todas sus características premium en acción\";}s:19:\"title_second_column\";s:40:\"Hazte con Características Pro y Soporte\";s:25:\"description_second_column\";s:206:\"By purchasing the premium version of the plugin, you will take advantage of the advanced features of the product, and you will get one year of free updates and support through our platform available 24h/24.\";s:6:\"button\";a:2:{s:4:\"href\";s:84:\"http://yithemes.com/themes/plugins/yith-woocommerce-zoom-magnifier/?refer_id=1030585\";s:5:\"title\";s:28:\"Get Support and Pro Features\";}}","yes");
INSERT INTO `wp_options` VALUES("634","yith_wcmg_enable_plugin","yes","yes");
INSERT INTO `wp_options` VALUES("635","yith_wcmg_enable_mobile","yes","yes");
INSERT INTO `wp_options` VALUES("636","yith_wcmg_force_sizes","yes","yes");
INSERT INTO `wp_options` VALUES("637","yith_wcmg_zoom_width","auto","yes");
INSERT INTO `wp_options` VALUES("638","yith_wcmg_zoom_height","auto","yes");
INSERT INTO `wp_options` VALUES("639","woocommerce_magnifier_image","a:3:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"crop\";b:1;}","yes");
INSERT INTO `wp_options` VALUES("640","yith_wcmg_zoom_position","right","yes");
INSERT INTO `wp_options` VALUES("641","yith_wcmg_zoom_mobile_position","inside","yes");
INSERT INTO `wp_options` VALUES("642","yith_wcmg_loading_label","Cargando...","yes");
INSERT INTO `wp_options` VALUES("643","yith_wcmg_lens_opacity","0.5","yes");
INSERT INTO `wp_options` VALUES("644","yith_wcmg_softfocus","no","yes");
INSERT INTO `wp_options` VALUES("645","yith_wcmg_enableslider","yes","yes");
INSERT INTO `wp_options` VALUES("646","yith_wcmg_slider_responsive","yes","yes");
INSERT INTO `wp_options` VALUES("647","yith_wcmg_slider_items","3","yes");
INSERT INTO `wp_options` VALUES("648","yith_wcmg_slider_circular","yes","yes");
INSERT INTO `wp_options` VALUES("649","yith_wcmg_slider_infinite","yes","yes");
INSERT INTO `wp_options` VALUES("656","product_gift_wrap_enabled","no","yes");
INSERT INTO `wp_options` VALUES("657","product_gift_wrap_cost","2000","yes");
INSERT INTO `wp_options` VALUES("658","product_gift_wrap_message","{checkbox} Gift wrap this item for {price}?","yes");
INSERT INTO `wp_options` VALUES("662","wc_pdc_columns","2","yes");
INSERT INTO `wp_options` VALUES("663","wc_pdc_product_images","yes","yes");
INSERT INTO `wp_options` VALUES("664","wc_pdc_upsells","yes","yes");
INSERT INTO `wp_options` VALUES("665","wc_pdc_related","yes","yes");
INSERT INTO `wp_options` VALUES("666","wc_pdc_tabs","yes","yes");
INSERT INTO `wp_options` VALUES("704","_transient_timeout_wc_cbp_68bbe462a9c9234665d866da152fc632","1478271429","no");
INSERT INTO `wp_options` VALUES("684","orddd_admin_notices","yes","yes");
INSERT INTO `wp_options` VALUES("685","orddd_lite_steps_for_script","1","yes");
INSERT INTO `wp_options` VALUES("686","orddd_lite_orders_script_updated","a:3:{i:0;s:3:\"123\";i:1;s:3:\"130\";i:2;s:3:\"145\";}","yes");
INSERT INTO `wp_options` VALUES("687","orddd_update_minimum_delivery_notice","yes","yes");
INSERT INTO `wp_options` VALUES("688","orddd_timestamp_update_script","yes","yes");
INSERT INTO `wp_options` VALUES("2285","_transient_timeout_wc_addons_section_featured","1478805817","no");
INSERT INTO `wp_options` VALUES("2286","_transient_wc_addons_section_featured","O:8:\"stdClass\":1:{s:8:\"products\";a:4:{i:0;O:8:\"stdClass\":5:{s:5:\"title\";s:27:\"PayPal Powered by Braintree\";s:5:\"image\";s:72:\"https://woocommerce.com/wp-content/uploads/2016/02/pp_bt_v_rgb_150px.png\";s:7:\"excerpt\";s:115:\"Accept PayPal, credit cards and debit cards with a single payment gateway solution — PayPal Powered by Braintree.\";s:4:\"link\";s:140:\"https://woocommerce.com/products/woocommerce-gateway-paypal-powered-by-braintree/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:1;O:8:\"stdClass\":5:{s:5:\"title\";s:20:\"WooCommerce Bookings\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:108:\"Sell your time or date based bookings! Perfect for those wanting to offer appointments, services or rentals.\";s:4:\"link\";s:113:\"https://woocommerce.com/products/woocommerce-bookings/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:11:\"&#36;249.00\";}i:2;O:8:\"stdClass\":5:{s:5:\"title\";s:15:\"Product Add-Ons\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:104:\"Allow your customers to customize products by adding input boxes, dropdowns, file uploads or checkboxes.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/product-add-ons/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:3;O:8:\"stdClass\":5:{s:5:\"title\";s:25:\"WooCommerce Subscriptions\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2012/09/woosubs.png\";s:7:\"excerpt\";s:85:\"WC Subscriptions makes it easy to create and manage products with recurring payments.\";s:4:\"link\";s:118:\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:11:\"&#36;199.00\";}}}","no");
INSERT INTO `wp_options` VALUES("705","_transient_wc_cbp_68bbe462a9c9234665d866da152fc632","a:6:{i:0;i:43;i:1;i:43;i:2;i:88;i:3;i:91;i:4;i:88;i:5;i:91;}","no");
INSERT INTO `wp_options` VALUES("4278","wpseo_sitemap_98_cache_validator","56snq","no");
INSERT INTO `wp_options` VALUES("707","woocommerce_gateway_order","a:7:{s:4:\"bacs\";i:0;s:6:\"cheque\";i:1;s:3:\"cod\";i:2;s:6:\"paypal\";i:3;s:9:\"authorize\";i:4;s:6:\"stripe\";i:5;s:11:\"mercadopago\";i:6;}","yes");
INSERT INTO `wp_options` VALUES("710","wc_customizer_active_customizations","a:0:{}","yes");
INSERT INTO `wp_options` VALUES("4240","wpseo_sitemap_category_cache_validator","4Q9h8","no");
INSERT INTO `wp_options` VALUES("716","_transient_timeout_wc_cbp_b879d3127e3ab5415fd8b4c881747b03","1478272682","no");
INSERT INTO `wp_options` VALUES("717","_transient_wc_cbp_b879d3127e3ab5415fd8b4c881747b03","a:0:{}","no");
INSERT INTO `wp_options` VALUES("733","_transient_timeout_wc_cbp_4ecbe58086c965c7636ef2f73d817d09","1478273427","no");
INSERT INTO `wp_options` VALUES("734","_transient_wc_cbp_4ecbe58086c965c7636ef2f73d817d09","a:6:{i:0;i:43;i:1;i:43;i:2;i:88;i:3;i:91;i:4;i:88;i:5;i:91;}","no");
INSERT INTO `wp_options` VALUES("2283","_transient_timeout_wc_addons_sections","1478805815","no");
INSERT INTO `wp_options` VALUES("2284","_transient_wc_addons_sections","O:8:\"stdClass\":10:{s:8:\"featured\";O:8:\"stdClass\":2:{s:5:\"title\";s:8:\"Featured\";s:8:\"endpoint\";s:59:\"https://d3t0oesq8995hv.cloudfront.net/section/featured.json\";}s:7:\"popular\";O:8:\"stdClass\":2:{s:5:\"title\";s:7:\"Popular\";s:8:\"endpoint\";s:58:\"https://d3t0oesq8995hv.cloudfront.net/section/popular.json\";}s:16:\"payment_gateways\";O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Payment Gateways\";s:8:\"endpoint\";s:67:\"https://d3t0oesq8995hv.cloudfront.net/section/payment_gateways.json\";}s:16:\"shipping_methods\";O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Shipping Methods\";s:8:\"endpoint\";s:67:\"https://d3t0oesq8995hv.cloudfront.net/section/shipping_methods.json\";}s:13:\"import_export\";O:8:\"stdClass\":2:{s:5:\"title\";s:13:\"Import/Export\";s:8:\"endpoint\";s:64:\"https://d3t0oesq8995hv.cloudfront.net/section/import_export.json\";}s:10:\"accounting\";O:8:\"stdClass\":2:{s:5:\"title\";s:10:\"Accounting\";s:8:\"endpoint\";s:61:\"https://d3t0oesq8995hv.cloudfront.net/section/accounting.json\";}s:9:\"marketing\";O:8:\"stdClass\":2:{s:5:\"title\";s:9:\"Marketing\";s:8:\"endpoint\";s:60:\"https://d3t0oesq8995hv.cloudfront.net/section/marketing.json\";}s:7:\"product\";O:8:\"stdClass\":2:{s:5:\"title\";s:8:\"Products\";s:8:\"endpoint\";s:58:\"https://d3t0oesq8995hv.cloudfront.net/section/product.json\";}s:4:\"free\";O:8:\"stdClass\":2:{s:5:\"title\";s:4:\"Free\";s:8:\"endpoint\";s:55:\"https://d3t0oesq8995hv.cloudfront.net/section/free.json\";}s:11:\"third_party\";O:8:\"stdClass\":2:{s:5:\"title\";s:11:\"Third-party\";s:8:\"endpoint\";s:62:\"https://d3t0oesq8995hv.cloudfront.net/section/third_party.json\";}}","no");
INSERT INTO `wp_options` VALUES("2287","_transient_timeout_wc_addons_section_popular","1478805930","no");
INSERT INTO `wp_options` VALUES("2288","_transient_wc_addons_section_popular","O:8:\"stdClass\":1:{s:8:\"products\";a:25:{i:0;O:8:\"stdClass\":5:{s:5:\"title\";s:19:\"WooCommerce iOS App\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:217:\"Keep your finger on the pulse of your online shop with WooCommerce iOS. All of your shop\'s catalog & performance reports are now just a tap away - quickly accessible & beautifully presented right there on your iPhone.\";s:4:\"link\";s:100:\"http://www.woothemes.com/woocommerce-ios/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;4.99\";}i:1;O:8:\"stdClass\":5:{s:5:\"title\";s:6:\"Stripe\";s:5:\"image\";s:61:\"https://woocommerce.com/wp-content/uploads/2016/08/stripe.png\";s:7:\"excerpt\";s:103:\"Accept Visa, MasterCard, American Express, Discover, JCB, and Diners Club cards directly on your store.\";s:4:\"link\";s:99:\"https://woocommerce.com/products/stripe/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:2;O:8:\"stdClass\":5:{s:5:\"title\";s:15:\"Pay with Amazon\";s:5:\"image\";s:114:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2013/08/AP_HLogo_215x35-3012530377._V360408447_.png\";s:7:\"excerpt\";s:136:\"Pay with Amazon is embedded in your WooCommerce store. Transactions take place via Amazon widgets, so the buyer never leaves your site.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/pay-with-amazon/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:3;O:8:\"stdClass\":5:{s:5:\"title\";s:15:\"Product Add-Ons\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:104:\"Allow your customers to customize products by adding input boxes, dropdowns, file uploads or checkboxes.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/product-add-ons/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:4;O:8:\"stdClass\":5:{s:5:\"title\";s:25:\"WooCommerce Subscriptions\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2012/09/woosubs.png\";s:7:\"excerpt\";s:85:\"WC Subscriptions makes it easy to create and manage products with recurring payments.\";s:4:\"link\";s:118:\"https://woocommerce.com/products/woocommerce-subscriptions/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:11:\"&#36;199.00\";}i:5;O:8:\"stdClass\":5:{s:5:\"title\";s:20:\"USPS Shipping Method\";s:5:\"image\";s:59:\"https://woocommerce.com/wp-content/uploads/2012/09/usps.jpg\";s:7:\"excerpt\";s:91:\"Get shipping rates from the USPS API which handles both domestic and international parcels.\";s:4:\"link\";s:113:\"https://woocommerce.com/products/usps-shipping-method/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:6;O:8:\"stdClass\":5:{s:5:\"title\";s:23:\"PayFast Payment Gateway\";s:5:\"image\";s:84:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2011/09/payfast2x.png\";s:7:\"excerpt\";s:70:\"Take payments on your WooCommerce store via PayFast (redirect method).\";s:4:\"link\";s:116:\"https://woocommerce.com/products/payfast-payment-gateway/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:7;O:8:\"stdClass\":5:{s:5:\"title\";s:17:\"Authorize.Net AIM\";s:5:\"image\";s:80:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2011/09/auth1.png\";s:7:\"excerpt\";s:112:\"Take credit card payments direct on your checkout using the Authorize.net (AIM) payment gateway for WooCommerce.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/authorize-net-aim/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:8;O:8:\"stdClass\":5:{s:5:\"title\";s:19:\"UPS Shipping Method\";s:5:\"image\";s:58:\"https://woocommerce.com/wp-content/uploads/2012/09/ups.jpg\";s:7:\"excerpt\";s:90:\"Get shipping rates from the UPS API which handles both domestic and international parcels.\";s:4:\"link\";s:112:\"https://woocommerce.com/products/ups-shipping-method/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:9;O:8:\"stdClass\":5:{s:5:\"title\";s:25:\"Order/Customer CSV Export\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:69:\"Export orders and customers from WooCommerce to a CSV file with ease.\";s:4:\"link\";s:117:\"https://woocommerce.com/products/ordercustomer-csv-export/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:10;O:8:\"stdClass\":5:{s:5:\"title\";s:23:\"ShipStation Integration\";s:5:\"image\";s:90:\"https://woocommerce.com/wp-content/uploads/2012/08/shipstation-highres2-e1416473201345.png\";s:7:\"excerpt\";s:161:\"Fulfill all your Woo orders (and wherever else you sell) quickly and easily using ShipStation, the #1 choice for online retailers. Try it free for 30 days today!\";s:4:\"link\";s:116:\"https://woocommerce.com/products/shipstation-integration/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:11;O:8:\"stdClass\":5:{s:5:\"title\";s:19:\"Table Rate Shipping\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:123:\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count.\";s:4:\"link\";s:112:\"https://woocommerce.com/products/table-rate-shipping/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;99.00\";}i:12;O:8:\"stdClass\":5:{s:5:\"title\";s:15:\"Dynamic Pricing\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:48:\"Bulk discounts, role-based pricing and much more\";s:4:\"link\";s:108:\"https://woocommerce.com/products/dynamic-pricing/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:11:\"&#36;129.00\";}i:13;O:8:\"stdClass\":5:{s:5:\"title\";s:10:\"PayPal Pro\";s:5:\"image\";s:84:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2011/09/paypalpro.png\";s:7:\"excerpt\";s:69:\"Take credit card payments directly on your checkout using PayPal Pro.\";s:4:\"link\";s:103:\"https://woocommerce.com/products/paypal-pro/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:14;O:8:\"stdClass\":5:{s:5:\"title\";s:35:\"Print Invoices &#038; Packing lists\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:49:\"Print your WooCommerce invoices and packing lists\";s:4:\"link\";s:121:\"https://woocommerce.com/products/print-invoices-packing-lists/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:15;O:8:\"stdClass\":5:{s:5:\"title\";s:15:\"Product Bundles\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:116:\"Create and offer highly configurable product bundles, kits and assemblies that consist of simple and variable items.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/product-bundles/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:16;O:8:\"stdClass\":5:{s:5:\"title\";s:21:\"Checkout Field Editor\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:128:\"The checkout field editor provides you with an interface to add, edit and remove fields shown on your WooCommerce checkout page.\";s:4:\"link\";s:126:\"https://woocommerce.com/products/woocommerce-checkout-field-editor/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:17;O:8:\"stdClass\":5:{s:5:\"title\";s:17:\"Authorize.Net CIM\";s:5:\"image\";s:73:\"https://woocommerce.com/wp-content/uploads/2013/04/authorize-net-logo.png\";s:7:\"excerpt\";s:68:\"Authorize CIM gateway with support for pre-orders and subscriptions.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/authorize-net-cim/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:18;O:8:\"stdClass\":5:{s:5:\"title\";s:24:\"Product CSV Import Suite\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:91:\"Import, merge, and export products and variations to and from WooCommerce using a CSV file.\";s:4:\"link\";s:117:\"https://woocommerce.com/products/product-csv-import-suite/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:11:\"&#36;199.00\";}i:19;O:8:\"stdClass\":5:{s:5:\"title\";s:13:\"Smart Coupons\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:119:\"Everyone&#039;s favorite “all in one” solution for store credits, gift certificates, discount coupons and vouchers.\";s:4:\"link\";s:106:\"https://woocommerce.com/products/smart-coupons/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;99.00\";}i:20;O:8:\"stdClass\":5:{s:5:\"title\";s:29:\"Gravity Forms Product Add-ons\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:39:\"Powerful product add-ons, Gravity style\";s:4:\"link\";s:114:\"https://woocommerce.com/products/gravity-forms-add-ons/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;99.00\";}i:21;O:8:\"stdClass\":5:{s:5:\"title\";s:26:\"Catalog Visibility Options\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:80:\"Transform WooCommerce into an online catalog by removing eCommerce functionality\";s:4:\"link\";s:119:\"https://woocommerce.com/products/catalog-visibility-options/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:22;O:8:\"stdClass\":5:{s:5:\"title\";s:17:\"Shipment Tracking\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:48:\"Add shipment tracking information to your orders\";s:4:\"link\";s:110:\"https://woocommerce.com/products/shipment-tracking/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:23;O:8:\"stdClass\":5:{s:5:\"title\";s:21:\"FedEx Shipping Method\";s:5:\"image\";s:96:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2013/01/FedEx_Logo_Wallpaper.jpeg\";s:7:\"excerpt\";s:92:\"Get shipping rates from the FedEx API which handles both domestic and international parcels.\";s:4:\"link\";s:114:\"https://woocommerce.com/products/fedex-shipping-module/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:24;O:8:\"stdClass\":5:{s:5:\"title\";s:20:\"WooCommerce Bookings\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:108:\"Sell your time or date based bookings! Perfect for those wanting to offer appointments, services or rentals.\";s:4:\"link\";s:113:\"https://woocommerce.com/products/woocommerce-bookings/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:11:\"&#36;249.00\";}}}","no");
INSERT INTO `wp_options` VALUES("742","_transient_timeout_wc_addons_section_payment_gateways","1476286988","no");
INSERT INTO `wp_options` VALUES("743","_transient_wc_addons_section_payment_gateways","O:8:\"stdClass\":1:{s:8:\"products\";a:24:{i:0;O:8:\"stdClass\":5:{s:5:\"title\";s:6:\"Stripe\";s:5:\"image\";s:61:\"https://woocommerce.com/wp-content/uploads/2016/08/stripe.png\";s:7:\"excerpt\";s:103:\"Accept Visa, MasterCard, American Express, Discover, JCB, and Diners Club cards directly on your store.\";s:4:\"link\";s:99:\"https://woocommerce.com/products/stripe/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:1;O:8:\"stdClass\":5:{s:5:\"title\";s:15:\"Pay with Amazon\";s:5:\"image\";s:114:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2013/08/AP_HLogo_215x35-3012530377._V360408447_.png\";s:7:\"excerpt\";s:136:\"Pay with Amazon is embedded in your WooCommerce store. Transactions take place via Amazon widgets, so the buyer never leaves your site.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/pay-with-amazon/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:2;O:8:\"stdClass\":5:{s:5:\"title\";s:23:\"PayFast Payment Gateway\";s:5:\"image\";s:84:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2011/09/payfast2x.png\";s:7:\"excerpt\";s:70:\"Take payments on your WooCommerce store via PayFast (redirect method).\";s:4:\"link\";s:116:\"https://woocommerce.com/products/payfast-payment-gateway/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:3;O:8:\"stdClass\":5:{s:5:\"title\";s:17:\"Authorize.Net AIM\";s:5:\"image\";s:80:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2011/09/auth1.png\";s:7:\"excerpt\";s:112:\"Take credit card payments direct on your checkout using the Authorize.net (AIM) payment gateway for WooCommerce.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/authorize-net-aim/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:4;O:8:\"stdClass\":5:{s:5:\"title\";s:10:\"PayPal Pro\";s:5:\"image\";s:84:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2011/09/paypalpro.png\";s:7:\"excerpt\";s:69:\"Take credit card payments directly on your checkout using PayPal Pro.\";s:4:\"link\";s:103:\"https://woocommerce.com/products/paypal-pro/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:5;O:8:\"stdClass\":5:{s:5:\"title\";s:17:\"Authorize.Net CIM\";s:5:\"image\";s:73:\"https://woocommerce.com/wp-content/uploads/2013/04/authorize-net-logo.png\";s:7:\"excerpt\";s:68:\"Authorize CIM gateway with support for pre-orders and subscriptions.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/authorize-net-cim/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:6;O:8:\"stdClass\":5:{s:5:\"title\";s:15:\"PayPal Advanced\";s:5:\"image\";s:89:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2012/09/paypaladvanced.png\";s:7:\"excerpt\";s:105:\"Take credit card payments securely via Paypal Payments Advanced (Payflow) keeping customers on your site.\";s:4:\"link\";s:108:\"https://woocommerce.com/products/paypal-advanced/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;99.00\";}i:7;O:8:\"stdClass\":5:{s:5:\"title\";s:9:\"FirstData\";s:5:\"image\";s:64:\"https://woocommerce.com/wp-content/uploads/2012/09/firstdata.jpg\";s:7:\"excerpt\";s:33:\"FirstData gateway for WooCommerce\";s:4:\"link\";s:102:\"https://woocommerce.com/products/firstdata/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:8;O:8:\"stdClass\":5:{s:5:\"title\";s:6:\"Klarna\";s:5:\"image\";s:91:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2011/12/klarna_main-logo.png\";s:7:\"excerpt\";s:103:\"Give your customers the simplest buying experience with Klarna and achieve amazing checkout conversions\";s:4:\"link\";s:99:\"https://woocommerce.com/products/klarna/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:9;O:8:\"stdClass\":5:{s:5:\"title\";s:8:\"WorldPay\";s:5:\"image\";s:63:\"https://woocommerce.com/wp-content/uploads/2012/09/worldpay.jpg\";s:7:\"excerpt\";s:26:\"Take payments via WorldPay\";s:4:\"link\";s:101:\"https://woocommerce.com/products/worldpay/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:10;O:8:\"stdClass\":5:{s:5:\"title\";s:17:\"Authorize.Net DPM\";s:5:\"image\";s:82:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2012/02/authdpm.png\";s:7:\"excerpt\";s:123:\"Take credit card payments safely and securely using the Authorize.net (Direct Post Method) payment gateway for WooCommerce.\";s:4:\"link\";s:110:\"https://woocommerce.com/products/authorize-net-dpm/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:11;O:8:\"stdClass\":5:{s:5:\"title\";s:29:\"SagePay Form / SagePay Direct\";s:5:\"image\";s:67:\"https://woocommerce.com/wp-content/uploads/2011/10/sage-cropped.png\";s:7:\"excerpt\";s:61:\"Take payments on your WooCommerce store via SagePay. UK only.\";s:4:\"link\";s:106:\"https://woocommerce.com/products/sage-pay-form/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:12;O:8:\"stdClass\":5:{s:5:\"title\";s:9:\"Braintree\";s:5:\"image\";s:64:\"https://woocommerce.com/wp-content/uploads/2012/09/braintree.png\";s:7:\"excerpt\";s:27:\"Take payments via Braintree\";s:4:\"link\";s:102:\"https://woocommerce.com/products/braintree/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:13;O:8:\"stdClass\":5:{s:5:\"title\";s:4:\"eWAY\";s:5:\"image\";s:59:\"https://woocommerce.com/wp-content/uploads/2012/09/eway.gif\";s:7:\"excerpt\";s:96:\"Take credit card payments securely via eWay (UK, US, AU, and NZ) keeping customers on your site.\";s:4:\"link\";s:97:\"https://woocommerce.com/products/eway/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:14;O:8:\"stdClass\":5:{s:5:\"title\";s:28:\"Intuit Payments/QBMS Gateway\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:95:\"Allow customers to securely save multiple payment methods to their account for faster checkout.\";s:4:\"link\";s:104:\"https://woocommerce.com/products/intuit-qbms/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:15;O:8:\"stdClass\":5:{s:5:\"title\";s:18:\"WooCommerce Mollie\";s:5:\"image\";s:61:\"https://woocommerce.com/wp-content/uploads/2012/09/mollie.png\";s:7:\"excerpt\";s:106:\"Process secure iDEAL, credit card, Mister Cash, PayPal, and paysafecard payments using WooCommerce Mollie.\";s:4:\"link\";s:111:\"https://woocommerce.com/products/woocommerce-mollie/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:16;O:8:\"stdClass\":5:{s:5:\"title\";s:31:\"Simplify Commerce by MasterCard\";s:5:\"image\";s:63:\"https://woocommerce.com/wp-content/uploads/2014/09/simplify.jpg\";s:7:\"excerpt\";s:164:\"<span style=\"font-weight: 400;\">Simplify Commerce’s technology helps you sell more by enabling you to accept payments quickly from your WooCommerce store. </span>\";s:4:\"link\";s:124:\"https://woocommerce.com/products/simplify-commerce-by-mastercard/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:17;O:8:\"stdClass\":5:{s:5:\"title\";s:31:\"Elavon Converge Payment Gateway\";s:5:\"image\";s:82:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2012/07/images.jpeg\";s:7:\"excerpt\";s:93:\"Take credit card payments with Elavon, the fourth largest merchant acquirer in North America.\";s:4:\"link\";s:118:\"https://woocommerce.com/products/elavon-vm-payment-gateway/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:18;O:8:\"stdClass\":5:{s:5:\"title\";s:37:\"Role-Based Payment / Shipping Methods\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:67:\"Limit different user roles to specific payment and shipping methods\";s:4:\"link\";s:128:\"https://woocommerce.com/products/role-based-payment-shipping-methods/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:19;O:8:\"stdClass\":5:{s:5:\"title\";s:45:\"WooCommerce Conditional Shipping and Payments\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:116:\"Use advanced rules to control the countries/states, payment gateways and shipping methods available during checkout.\";s:4:\"link\";s:126:\"https://woocommerce.com/products/conditional-shipping-and-payments/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:20;O:8:\"stdClass\":5:{s:5:\"title\";s:15:\"Moneris Gateway\";s:5:\"image\";s:62:\"https://woocommerce.com/wp-content/uploads/2012/09/moneris.gif\";s:7:\"excerpt\";s:32:\"Take payments online via Moneris\";s:4:\"link\";s:108:\"https://woocommerce.com/products/moneris-gateway/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:21;O:8:\"stdClass\":5:{s:5:\"title\";s:22:\"Sofort Payment Gateway\";s:5:\"image\";s:81:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2012/06/200x75.png\";s:7:\"excerpt\";s:60:\"Online bank transfer powered by the Sofort payment provider.\";s:4:\"link\";s:115:\"https://woocommerce.com/products/sofort-payment-gateway/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:22;O:8:\"stdClass\":5:{s:5:\"title\";s:31:\"Realex Redirect Payment Gateway\";s:5:\"image\";s:81:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2012/09/realex.png\";s:7:\"excerpt\";s:106:\"Accept credit card payments via Realex (redirect) and WooCommerce without the need for an SSL certificate.\";s:4:\"link\";s:124:\"https://woocommerce.com/products/realex-redirect-payment-gateway/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:23;O:8:\"stdClass\":5:{s:5:\"title\";s:11:\"Payson Form\";s:5:\"image\";s:61:\"https://woocommerce.com/wp-content/uploads/2012/09/payson.png\";s:7:\"excerpt\";s:69:\"Take payments on your WooCommerce store via Payson (redirect method).\";s:4:\"link\";s:104:\"https://woocommerce.com/products/payson-form/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}}}","no");
INSERT INTO `wp_options` VALUES("744","_transient_timeout_wc_addons_section_shipping_methods","1476287027","no");
INSERT INTO `wp_options` VALUES("745","_transient_wc_addons_section_shipping_methods","O:8:\"stdClass\":1:{s:8:\"products\";a:24:{i:0;O:8:\"stdClass\":5:{s:5:\"title\";s:20:\"USPS Shipping Method\";s:5:\"image\";s:59:\"https://woocommerce.com/wp-content/uploads/2012/09/usps.jpg\";s:7:\"excerpt\";s:91:\"Get shipping rates from the USPS API which handles both domestic and international parcels.\";s:4:\"link\";s:113:\"https://woocommerce.com/products/usps-shipping-method/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:1;O:8:\"stdClass\":5:{s:5:\"title\";s:19:\"UPS Shipping Method\";s:5:\"image\";s:58:\"https://woocommerce.com/wp-content/uploads/2012/09/ups.jpg\";s:7:\"excerpt\";s:90:\"Get shipping rates from the UPS API which handles both domestic and international parcels.\";s:4:\"link\";s:112:\"https://woocommerce.com/products/ups-shipping-method/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:2;O:8:\"stdClass\":5:{s:5:\"title\";s:23:\"ShipStation Integration\";s:5:\"image\";s:90:\"https://woocommerce.com/wp-content/uploads/2012/08/shipstation-highres2-e1416473201345.png\";s:7:\"excerpt\";s:161:\"Fulfill all your Woo orders (and wherever else you sell) quickly and easily using ShipStation, the #1 choice for online retailers. Try it free for 30 days today!\";s:4:\"link\";s:116:\"https://woocommerce.com/products/shipstation-integration/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:3;O:8:\"stdClass\":5:{s:5:\"title\";s:19:\"Table Rate Shipping\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:123:\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count.\";s:4:\"link\";s:112:\"https://woocommerce.com/products/table-rate-shipping/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;99.00\";}i:4;O:8:\"stdClass\":5:{s:5:\"title\";s:35:\"Print Invoices &#038; Packing lists\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:49:\"Print your WooCommerce invoices and packing lists\";s:4:\"link\";s:121:\"https://woocommerce.com/products/print-invoices-packing-lists/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:5;O:8:\"stdClass\":5:{s:5:\"title\";s:17:\"Shipment Tracking\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:48:\"Add shipment tracking information to your orders\";s:4:\"link\";s:110:\"https://woocommerce.com/products/shipment-tracking/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:6;O:8:\"stdClass\":5:{s:5:\"title\";s:21:\"FedEx Shipping Method\";s:5:\"image\";s:96:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2013/01/FedEx_Logo_Wallpaper.jpeg\";s:7:\"excerpt\";s:92:\"Get shipping rates from the FedEx API which handles both domestic and international parcels.\";s:4:\"link\";s:114:\"https://woocommerce.com/products/fedex-shipping-module/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:7;O:8:\"stdClass\":5:{s:5:\"title\";s:24:\"WooCommerce ShippingEasy\";s:5:\"image\";s:92:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2015/05/ShippingEasy_Logo.png\";s:7:\"excerpt\";s:129:\"Fast USPS, UPS and FedEx label printing for online sellers. Discounted rates, shipping rules, automation and FREE plan available.\";s:4:\"link\";s:117:\"https://woocommerce.com/products/woocommerce-shippingeasy/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:9:\"&#36;0.00\";}i:8;O:8:\"stdClass\":5:{s:5:\"title\";s:22:\"Advanced Notifications\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:96:\"Easily setup \"new order\" and stock email notifications for multiple recipients of your choosing.\";s:4:\"link\";s:115:\"https://woocommerce.com/products/advanced-notifications/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;29.00\";}i:9;O:8:\"stdClass\":5:{s:5:\"title\";s:20:\"Per Product Shipping\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:107:\"Define separate shipping costs per product which are combined at checkout to provide a total shipping cost.\";s:4:\"link\";s:113:\"https://woocommerce.com/products/per-product-shipping/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:10;O:8:\"stdClass\":5:{s:5:\"title\";s:30:\"Australia Post Shipping Method\";s:5:\"image\";s:69:\"https://woocommerce.com/wp-content/uploads/2012/09/australia-post.gif\";s:7:\"excerpt\";s:101:\"Get shipping rates from the Australia Post API which handles both domestic and international parcels.\";s:4:\"link\";s:123:\"https://woocommerce.com/products/australia-post-shipping-method/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:11;O:8:\"stdClass\":5:{s:5:\"title\";s:27:\"Canada Post Shipping Method\";s:5:\"image\";s:66:\"https://woocommerce.com/wp-content/uploads/2012/09/canada-post.png\";s:7:\"excerpt\";s:106:\"Get shipping rates from the Canada Post Ratings API which handles both domestic and international parcels.\";s:4:\"link\";s:120:\"https://woocommerce.com/products/canada-post-shipping-method/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:12;O:8:\"stdClass\":5:{s:5:\"title\";s:17:\"Local Pickup Plus\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:54:\"Let customers pick up products from specific locations\";s:4:\"link\";s:110:\"https://woocommerce.com/products/local-pickup-plus/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:13;O:8:\"stdClass\":5:{s:5:\"title\";s:26:\"WooCommerce Stamps.com API\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:129:\"With the Stamps.com integration you can automatically create ready-to-print shipping labels for USPS, based on items in an order.\";s:4:\"link\";s:120:\"https://woocommerce.com/products/woocommerce-shipping-stamps/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;59.00\";}i:14;O:8:\"stdClass\":5:{s:5:\"title\";s:37:\"Role-Based Payment / Shipping Methods\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:67:\"Limit different user roles to specific payment and shipping methods\";s:4:\"link\";s:128:\"https://woocommerce.com/products/role-based-payment-shipping-methods/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:15;O:8:\"stdClass\":5:{s:5:\"title\";s:45:\"WooCommerce Conditional Shipping and Payments\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:116:\"Use advanced rules to control the countries/states, payment gateways and shipping methods available during checkout.\";s:4:\"link\";s:126:\"https://woocommerce.com/products/conditional-shipping-and-payments/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:16;O:8:\"stdClass\":5:{s:5:\"title\";s:27:\"Shipping Multiple Addresses\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:86:\"Allow your customers to ship individual items in a single order to multiple addresses.\";s:4:\"link\";s:120:\"https://woocommerce.com/products/shipping-multiple-addresses/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:17;O:8:\"stdClass\":5:{s:5:\"title\";s:27:\"Postcode/Address Validation\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:104:\"Simplify your checkout process by having your customer validate or lookup their address during checkout.\";s:4:\"link\";s:119:\"https://woocommerce.com/products/postcodeaddress-validation/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:18;O:8:\"stdClass\":5:{s:5:\"title\";s:10:\"Royal Mail\";s:5:\"image\";s:84:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2013/04/royalmail.png\";s:7:\"excerpt\";s:49:\"Offer Royal Mail shipping rates to your customers\";s:4:\"link\";s:103:\"https://woocommerce.com/products/royal-mail/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:19;O:8:\"stdClass\":5:{s:5:\"title\";s:26:\"Stamps.com XML File Export\";s:5:\"image\";s:109:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2012/10/Screen-Shot-2012-10-10-at-17.05.22.png\";s:7:\"excerpt\";s:132:\"The WooCommerce Stamps.com extension allows you to select orders to export into an XML format for import into the Stamps.com client.\";s:4:\"link\";s:119:\"https://woocommerce.com/products/stamps-com-xml-file-export/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:20;O:8:\"stdClass\":5:{s:5:\"title\";s:8:\"Shipwire\";s:5:\"image\";s:101:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2013/04/shipwire_logo_blue-310x100.png\";s:7:\"excerpt\";s:152:\"A full-featured Shipwire integration, including real-time shipping rates, automatic order fulfillment processing, and live inventory / tracking updates.\";s:4:\"link\";s:101:\"https://woocommerce.com/products/shipwire/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:11:\"&#36;129.00\";}i:21;O:8:\"stdClass\":5:{s:5:\"title\";s:22:\"Flat Rate Box Shipping\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:60:\"Pack items into boxes with pre-defined costs per destination\";s:4:\"link\";s:115:\"https://woocommerce.com/products/flat-rate-box-shipping/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;49.00\";}i:22;O:8:\"stdClass\":5:{s:5:\"title\";s:34:\"WooCommerce Distance Rate Shipping\";s:5:\"image\";s:0:\"\";s:7:\"excerpt\";s:88:\"Easily offer shipping rates based on the distance or total travel time to your customer.\";s:4:\"link\";s:127:\"https://woocommerce.com/products/woocommerce-distance-rate-shipping/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}i:23;O:8:\"stdClass\":5:{s:5:\"title\";s:25:\"Purolator Shipping Method\";s:5:\"image\";s:79:\"https://woocommerce.com/wp-content/uploads/woocommerce_uploads/2012/08/puro.png\";s:7:\"excerpt\";s:69:\"Calculate order shipping costs automatically using the Purolator API.\";s:4:\"link\";s:118:\"https://woocommerce.com/products/purolator-shipping-method/?utm_source=product&utm_medium=upsell&utm_campaign=wcaddons\";s:5:\"price\";s:10:\"&#36;79.00\";}}}","no");
INSERT INTO `wp_options` VALUES("8016","_transient_yit_panel_sidebar_remote_widgets_update","1","no");
INSERT INTO `wp_options` VALUES("898","_site_transient_timeout_browser_a577a018a38e33733b85874abbc32db6","1476801536","yes");
INSERT INTO `wp_options` VALUES("899","_site_transient_browser_a577a018a38e33733b85874abbc32db6","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"53.0.2785.143\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("819","_transient_timeout_ninja-forms-builder-actions-feed","1476363960","no");
INSERT INTO `wp_options` VALUES("820","_transient_ninja-forms-builder-actions-feed","a:8:{i:0;a:5:{s:4:\"name\";s:0:\"\";s:8:\"nicename\";s:0:\"\";s:5:\"image\";s:0:\"\";s:4:\"link\";s:167:\"https://ninjaforms.com/extensions/conditional-logic/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Conditional+Logic\";s:11:\"plugin_path\";s:46:\"ninja-forms-conditional-logic/conditionals.php\";}i:1;a:5:{s:4:\"name\";s:9:\"mailchimp\";s:8:\"nicename\";s:10:\"Mail Chimp\";s:5:\"image\";s:5982:\"data:image/png;base64,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\";s:4:\"link\";s:152:\"https://ninjaforms.com/extensions/mail-chimp/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=MailChimp\";s:11:\"plugin_path\";s:49:\"ninja-forms-mail-chimp/ninja-forms-mail-chimp.php\";}i:2;a:5:{s:4:\"name\";s:12:\"text_message\";s:8:\"nicename\";s:13:\"Text Messages\";s:5:\"image\";s:4046:\"data:image/png;base64,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\";s:4:\"link\";s:185:\"https://ninjaforms.com/extensions/text-message-notifications/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Text+Message+Notifications\";s:11:\"plugin_path\";s:72:\"ninja-forms-text-message-notifications/nf-text-message-notifications.php\";}i:3;a:5:{s:4:\"name\";s:5:\"slack\";s:8:\"nicename\";s:5:\"Slack\";s:5:\"image\";s:4618:\"data:image/png;base64,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\";s:4:\"link\";s:143:\"https://ninjaforms.com/extensions/slack/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Slack\";s:11:\"plugin_path\";s:0:\"\";}i:4;a:5:{s:4:\"name\";s:7:\"webhook\";s:8:\"nicename\";s:7:\"WebHook\";s:5:\"image\";s:8954:\"data:image/png;base64,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\";s:4:\"link\";s:149:\"https://ninjaforms.com/extensions/webhooks/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Webhooks\";s:11:\"plugin_path\";s:0:\"\";}i:5;a:5:{s:4:\"name\";s:8:\"webmerge\";s:8:\"nicename\";s:8:\"WebMerge\";s:5:\"image\";s:5026:\"data:image/png;base64,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\";s:4:\"link\";s:149:\"https://ninjaforms.com/extensions/webmerge/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=WebMerge\";s:11:\"plugin_path\";s:0:\"\";}i:6;a:5:{s:4:\"name\";s:9:\"helpscout\";s:8:\"nicename\";s:10:\"Help Scout\";s:5:\"image\";s:12034:\"data:image/png;base64,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\";s:4:\"link\";s:153:\"https://ninjaforms.com/extensions/help-scout/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Help+Scout\";s:11:\"plugin_path\";s:0:\"\";}i:7;a:5:{s:4:\"name\";s:4:\"emma\";s:8:\"nicename\";s:4:\"Emma\";s:5:\"image\";s:5494:\"data:image/png;base64,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\";s:4:\"link\";s:141:\"https://ninjaforms.com/extensions/emma/?utm_medium=plugin&utm_source=plugin-addons-page&utm_campaign=Ninja+Forms+Addons+Page&utm_content=Emma\";s:11:\"plugin_path\";s:0:\"\";}}","no");
INSERT INTO `wp_options` VALUES("821","dslc_plugin_options","a:65:{s:12:\"lc_max_width\";s:0:\"\";s:22:\"lc_force_important_css\";s:8:\"disabled\";s:15:\"lc_css_position\";s:4:\"head\";s:16:\"lc_gfont_subsets\";a:4:{i:0;s:5:\"latin\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:12:\"cyrillic-ext\";}s:14:\"lc_editor_type\";s:4:\"both\";s:23:\"lc_default_opts_section\";s:13:\"functionality\";s:29:\"lc_module_activate_button_pos\";s:5:\"right\";s:5:\"menus\";s:0:\"\";s:8:\"sidebars\";s:23:\"FormContact,Productos2,\";s:22:\"lc_min_capability_page\";s:13:\"publish_posts\";s:28:\"lc_min_capability_projects_m\";s:13:\"publish_posts\";s:29:\"lc_min_capability_galleries_m\";s:13:\"publish_posts\";s:25:\"lc_min_capability_staff_m\";s:13:\"publish_posts\";s:29:\"lc_min_capability_downloads_m\";s:13:\"publish_posts\";s:32:\"lc_min_capability_testimonials_m\";s:13:\"publish_posts\";s:28:\"lc_min_capability_partners_m\";s:13:\"publish_posts\";s:9:\"DSLC_Html\";s:7:\"enabled\";s:16:\"DSLC_Text_Simple\";s:7:\"enabled\";s:10:\"DSLC_Image\";s:7:\"enabled\";s:11:\"DSLC_Button\";s:7:\"enabled\";s:9:\"DSLC_Icon\";s:7:\"enabled\";s:13:\"DSLC_Info_Box\";s:7:\"enabled\";s:11:\"DSLC_Social\";s:7:\"enabled\";s:14:\"DSLC_Separator\";s:7:\"enabled\";s:9:\"DSLC_Tabs\";s:7:\"enabled\";s:14:\"DSLC_Accordion\";s:7:\"enabled\";s:18:\"DSLC_Progress_Bars\";s:7:\"enabled\";s:17:\"DSLC_Notification\";s:7:\"enabled\";s:9:\"DSLC_Blog\";s:7:\"enabled\";s:10:\"DSLC_Posts\";s:7:\"enabled\";s:13:\"DSLC_Projects\";s:7:\"enabled\";s:25:\"DSLC_WooCommerce_Products\";s:7:\"enabled\";s:17:\"DSLC_Testimonials\";s:7:\"enabled\";s:13:\"DSLC_Partners\";s:7:\"enabled\";s:14:\"DSLC_Galleries\";s:7:\"enabled\";s:14:\"DSLC_Downloads\";s:7:\"enabled\";s:10:\"DSLC_Staff\";s:7:\"enabled\";s:12:\"DSLC_Widgets\";s:7:\"enabled\";s:15:\"DSLC_Navigation\";s:7:\"enabled\";s:12:\"DSLC_Sliders\";s:7:\"enabled\";s:17:\"DSLC_TP_Thumbnail\";s:7:\"enabled\";s:13:\"DSLC_TP_Title\";s:7:\"enabled\";s:15:\"DSLC_TP_Content\";s:7:\"enabled\";s:15:\"DSLC_TP_Excerpt\";s:7:\"enabled\";s:12:\"DSLC_TP_Meta\";s:7:\"enabled\";s:24:\"DSLC_TP_Downloads_Button\";s:7:\"enabled\";s:22:\"DSLC_TP_Gallery_Slider\";s:7:\"enabled\";s:22:\"DSLC_TP_Project_Slider\";s:7:\"enabled\";s:16:\"DSLC_TP_Comments\";s:7:\"enabled\";s:21:\"DSLC_TP_Comments_Form\";s:7:\"enabled\";s:20:\"DSLC_TP_Staff_Social\";s:7:\"enabled\";s:10:\"with_front\";s:7:\"enabled\";s:13:\"projects_slug\";s:12:\"project-view\";s:18:\"projects_cats_slug\";s:18:\"dslc_projects_cats\";s:14:\"galleries_slug\";s:12:\"gallery-view\";s:19:\"galleries_cats_slug\";s:19:\"dslc_galleries_cats\";s:14:\"downloads_slug\";s:13:\"download-view\";s:19:\"downloads_cats_slug\";s:18:\"dslc_downloads_cat\";s:19:\"downloads_tags_slug\";s:18:\"dslc_downloads_tag\";s:10:\"staff_slug\";s:10:\"staff-view\";s:15:\"staff_cats_slug\";s:15:\"dslc_staff_cats\";s:13:\"partners_slug\";s:12:\"partner-view\";s:18:\"partners_cats_slug\";s:18:\"dslc_partners_cats\";s:17:\"testimonials_slug\";s:16:\"testimonial-view\";s:22:\"testimonials_cats_slug\";s:22:\"dslc_testimonials_cats\";}","yes");
INSERT INTO `wp_options` VALUES("3579","_transient_timeout_wc_product_children_231","1486643423","no");
INSERT INTO `wp_options` VALUES("7302","product_cat_children","a:2:{i:7;a:4:{i:0;i:14;i:1;i:16;i:2;i:17;i:3;i:23;}i:8;a:4:{i:0;i:15;i:1;i:18;i:2;i:19;i:3;i:22;}}","yes");
INSERT INTO `wp_options` VALUES("1277","wc_dgallery_product_gallery_width_fixed","320","yes");
INSERT INTO `wp_options` VALUES("953","_image_widget_version","4.2.2","yes");
INSERT INTO `wp_options` VALUES("1045","_transient_timeout_wc_cbp_ddfd5acb974a4e752d8f7b421635e832","1478963320","no");
INSERT INTO `wp_options` VALUES("1046","_transient_wc_cbp_ddfd5acb974a4e752d8f7b421635e832","a:6:{i:0;i:43;i:1;i:43;i:2;i:88;i:3;i:91;i:4;i:88;i:5;i:91;}","no");
INSERT INTO `wp_options` VALUES("1279","wc_dgallery_product_gallery_height","215","yes");
INSERT INTO `wp_options` VALUES("3051","_transient_timeout_wc_cbp_87d134628b26e873dace9f940eb73c65","1483130114","no");
INSERT INTO `wp_options` VALUES("3052","_transient_wc_cbp_87d134628b26e873dace9f940eb73c65","a:16:{i:0;i:43;i:1;i:88;i:2;i:108;i:3;i:93;i:4;i:231;i:5;i:88;i:6;i:93;i:7;i:93;i:8;i:103;i:9;i:68;i:10;i:91;i:11;i:111;i:12;i:234;i:13;i:91;i:14;i:106;i:15;i:71;}","no");
INSERT INTO `wp_options` VALUES("4705","_site_transient_timeout_browser_844f7ae4d251b2e6e152fdd13ef479f6","1486473192","yes");
INSERT INTO `wp_options` VALUES("4706","_site_transient_browser_844f7ae4d251b2e6e152fdd13ef479f6","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"55.0.2883.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO `wp_options` VALUES("8057","_transient_timeout_feed_ef605fdbfbba53a6c98437c00d402dfe","1487723901","no");
INSERT INTO `wp_options` VALUES("8058","_transient_feed_ef605fdbfbba53a6c98437c00d402dfe","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"
	
	
	
	
	
	
	
	
	
	
		
		
		
		
		
		
		
		
		
	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Español\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://es.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Español\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Feb 2017 09:07:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"es-ES\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=4.8-alpha-40089\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Eventos para la semana\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://es.wordpress.org/2017/02/20/eventos-wordpress-para-la-semana-08-17/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://es.wordpress.org/2017/02/20/eventos-wordpress-para-la-semana-08-17/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Feb 2017 09:17:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://es.wordpress.org/?p=1157\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:430:\"¡Buenos días a todos! Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps. Meetups 21/02 &#8211; Majadahona &#8211; Pesadilla después de Navidad (Seguridad WordPress) 23/02 &#8211; Málaga &#8211; Seguridad en WordPress para evitar ataques de bots 23/02 &#8211; Sevilla  &#8211; CPT: el primer paso hacia la personalización 23/02 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Mauricio Gelves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6295:\"<p><img class=\"aligncenter size-full wp-image-1150\" src=\"https://es.wordpress.org/files/2017/02/eventos-wordpress-semana-espana.png\" alt=\"Eventos WordPress para esta semana en españa\" width=\"1280\" height=\"476\" srcset=\"https://es.wordpress.org/files/2017/02/eventos-wordpress-semana-espana.png 1280w, https://es.wordpress.org/files/2017/02/eventos-wordpress-semana-espana-300x112.png 300w, https://es.wordpress.org/files/2017/02/eventos-wordpress-semana-espana-768x286.png 768w, https://es.wordpress.org/files/2017/02/eventos-wordpress-semana-espana-1024x381.png 1024w\" sizes=\"(max-width: 1280px) 100vw, 1280px\" /></p>
<p><strong>¡Buenos días a todos!</strong> Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps.</p>
<hr />
<h2>Meetups</h2>
<ul>
<li>21/02 &#8211; <strong>Majadahona</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Majadahonda/events/237660965/\" target=\"_blank\">Pesadilla después de Navidad (Seguridad WordPress)</a></li>
<li>23/02 &#8211; <strong>Málaga</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Malaga/events/237603137/\" target=\"_blank\">Seguridad en WordPress para evitar ataques de bots</a></li>
<li>23/02 &#8211; <strong>Sevilla </strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Sevilla/events/237613439/\">CPT: el primer paso hacia la personalización</a></li>
<li>23/02 &#8211; <strong>Zaragoza </strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Zaragoza/events/237703566/\" target=\"_blank\">Coloquio abierto</a></li>
<li>23/02 &#8211; <strong>Valladolid</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Valladolid-WordPress-Meetup/events/236839196/\" target=\"_blank\">Usar WP desde cero y &#8220;meter mano&#8221; al código sin tener mucha idea.By Kike García</a></li>
<li>24/02 &#8211; <strong>Pontevedra</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Pontevedra-WordPress-Meetup/events/237481054/\" target=\"_blank\">Preguntas y respuestas sobre WordPress</a></li>
<li>24/02 &#8211; <strong>Bilbao</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Bilbao/events/237754299/\" target=\"_blank\">WordCamp Europe en Bilbao</a></li>
<li>24/02 &#8211; <strong>Palmas de Gran Canaria</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Las-Palmas-de-Gran-Canaria-WordPress-Meetup/events/237671816/\" target=\"_blank\">WorkShop: Aprende todo sobre formularios en WordPress y ContactForm7</a></li>
</ul>
<h3>Fotos de las Meetups de la semana anterior</h3>
<a href=\"https://es.wordpress.org/2017/02/20/eventos-wordpress-para-la-semana-08-17/#gallery-1157-1-slideshow\">Haga click para ver el pase de diapositivas.</a>
<hr />
<h2>WordCamps</h2>
<p>Sigue de cerca la organización de los próximos WordCamps que se celebrarán en España durante el 2017.</p>
<ul>
<li><strong>WordCamp Alicante 4 de Marzo 2017</strong><br />
<a href=\"https://2017.alicante.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.alicante.wordcamp.org/programa/\" target=\"_blank\">Programa</a> | <a href=\"https://2017.alicante.wordcamp.org/patrocina-el-evento/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.alicante.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"https://2017.alicante.wordcamp.org/llamada-a-voluntarios/\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.alicante.wordcamp.org/tickets-wordcamp-alicante-2017/\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"alignnone wp-image-1091\" src=\"https://es.wordpress.org/files/2017/01/wordcamp-alicante-2017.png\" alt=\"WordCamp Alicante 2017\" width=\"312\" height=\"156\" /></li>
<li><strong>WordCamp Madrid 22-23 de Abril 2017<br />
</strong><a href=\"https://2017.madrid.wordcamp.org/\" target=\"_blank\">Web</a> | Programa | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-patrocinadores-call-for-sponsors/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-ponentes-call-for-speakers/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-voluntarios-call-for-volunteers/\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.madrid.wordcamp.org/entradas/\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"wp-image-1088\" src=\"https://es.wordpress.org/files/2017/01/wordcamp-madrid-2017-1024x341.png\" alt=\"WordCamp Madrid 2017\" width=\"308\" height=\"72\" /></li>
<li><strong>WordCamp Bilbao 12-14 de Mayo 2017<br />
</strong><a href=\"https://2017.bilbao.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.bilbao.wordcamp.org/programa/\" target=\"_blank\">Programa</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-patrocinadores/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"http://2017.bilbao.wordcamp.org/llamada-voluntarios\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.bilbao.wordcamp.org/compra-tu-entrada\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"alignnone wp-image-1090\" src=\"https://es.wordpress.org/files/2017/01/wordpress-bilbao-2017.jpg\" alt=\"WordCamp Bilbao 2017\" width=\"311\" height=\"159\" /></li>
</ul>
<hr />
<h2>Otros eventos WordPress</h2>
<p>Aquí podrás encontrar otros eventos interesantes en torno al mundo WordPress.</p>
<ul>
<li><strong>WPCampus Bilbao 24 de Marzo 2017<br />
</strong><a href=\"https://2017.campuswp.es/\" target=\"_blank\">Web</a> | <a href=\"https://2017.campuswp.es/horario-academico/\" target=\"_blank\">Horario Académico</a> | <a href=\"https://2017.campuswp.es/patrocina-wpcampus-2017/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.campuswp.es/horario-academico/profesores/\" target=\"_blank\">Llamada a profesores</a></li>
</ul>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://es.wordpress.org/2017/02/20/eventos-wordpress-para-la-semana-08-17/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Eventos para la semana\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://es.wordpress.org/2017/02/13/eventos-wordpress-para-la-semana-07-17/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://es.wordpress.org/2017/02/13/eventos-wordpress-para-la-semana-07-17/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Feb 2017 11:14:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://es.wordpress.org/?p=1144\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"¡Buenos días a todos! Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps. Meetups 13/02 &#8211; Mallorca &#8211; Plugins para Backup / HotJar (Conversión) 16/02 &#8211; Madrid &#8211; Muestra campos de ACF en tu web sin programar 16/02 &#8211; Collado de Villalba &#8211; Tipos de contenidos personalizados [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Mauricio Gelves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5670:\"<p><img class=\"aligncenter size-full wp-image-1150\" src=\"https://es.wordpress.org/files/2017/02/eventos-wordpress-semana-espana.png\" alt=\"Eventos WordPress para esta semana en españa\" width=\"1280\" height=\"476\" srcset=\"https://es.wordpress.org/files/2017/02/eventos-wordpress-semana-espana.png 1280w, https://es.wordpress.org/files/2017/02/eventos-wordpress-semana-espana-300x112.png 300w, https://es.wordpress.org/files/2017/02/eventos-wordpress-semana-espana-768x286.png 768w, https://es.wordpress.org/files/2017/02/eventos-wordpress-semana-espana-1024x381.png 1024w\" sizes=\"(max-width: 1280px) 100vw, 1280px\" /></p>
<p><strong>¡Buenos días a todos!</strong> Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps.</p>
<hr />
<h2>Meetups</h2>
<ul>
<li>13/02 &#8211; <strong>Mallorca</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Mallorca-WordPress-Meetup/events/237094695/\" target=\"_blank\">Plugins para Backup / HotJar (Conversión)</a></li>
<li>16/02 &#8211; <strong>Madrid</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Madrid/events/237188153/\" target=\"_blank\">Muestra campos de ACF en tu web sin programar</a></li>
<li>16/02 &#8211; <strong>Collado de Villalba</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Collado-Villalba-Meetup/events/237221273/\" target=\"_blank\">Tipos de contenidos personalizados (custom post types)</a></li>
<li>17/02 &#8211; <strong>Bilbao </strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Bilbao/events/237240501/\" target=\"_blank\">SEO, Analítica y CRO: Puesta a punto express de tu WordPress</a></li>
<li>17/02 &#8211; <strong>Chiclana</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Meetup-Chiclana/events/237605539/\">Email Marketing con WordPress: Crea tu newsletter</a></li>
<li>18/02 &#8211; <strong>Valencia</strong> &#8211; <a href=\"https://www.meetup.com/wordpress-valencia-meetup/events/237671103/?_locale=es-ES\">WP CLI: la navaja suiza para WordPress que te da superpoderes</a></li>
</ul>
<hr />
<h2>WordCamps</h2>
<p>Sigue de cerca la organización de los próximos WordCamps que se celebrarán en España durante el 2017.</p>
<ul>
<li><strong>WordCamp Alicante 4 de Marzo 2017</strong><br />
<a href=\"https://2017.alicante.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.alicante.wordcamp.org/programa/\" target=\"_blank\">Programa</a> | <a href=\"https://2017.alicante.wordcamp.org/patrocina-el-evento/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.alicante.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"https://2017.alicante.wordcamp.org/llamada-a-voluntarios/\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.alicante.wordcamp.org/tickets-wordcamp-alicante-2017/\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"alignnone wp-image-1091\" src=\"https://es.wordpress.org/files/2017/01/wordcamp-alicante-2017.png\" alt=\"WordCamp Alicante 2017\" width=\"312\" height=\"156\" /></li>
<li><strong>WordCamp Madrid 22-23 de Abril 2017<br />
</strong><a href=\"https://2017.madrid.wordcamp.org/\" target=\"_blank\">Web</a> | Programa | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-patrocinadores-call-for-sponsors/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-ponentes-call-for-speakers/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-voluntarios-call-for-volunteers/\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.madrid.wordcamp.org/entradas/\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"wp-image-1088\" src=\"https://es.wordpress.org/files/2017/01/wordcamp-madrid-2017-1024x341.png\" alt=\"WordCamp Madrid 2017\" width=\"308\" height=\"72\" /></li>
<li><strong>WordCamp Bilbao 12-14 de Mayo 2017<br />
</strong><a href=\"https://2017.bilbao.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.bilbao.wordcamp.org/programa/\" target=\"_blank\">Programa</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-patrocinadores/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"http://2017.bilbao.wordcamp.org/llamada-voluntarios\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.bilbao.wordcamp.org/compra-tu-entrada\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"alignnone wp-image-1090\" src=\"https://es.wordpress.org/files/2017/01/wordpress-bilbao-2017.jpg\" alt=\"WordCamp Bilbao 2017\" width=\"311\" height=\"159\" /></li>
</ul>
<hr />
<h2>Otros eventos WordPress</h2>
<p>Aquí podrás encontrar otros eventos interesantes en torno al mundo WordPress.</p>
<ul>
<li><strong>WPCampus Bilbao 24 de Marzo 2017<br />
</strong><a href=\"https://2017.campuswp.es/\" target=\"_blank\">Web</a> | <a href=\"https://2017.campuswp.es/horario-academico/\" target=\"_blank\">Horario Académico</a> | <a href=\"https://2017.campuswp.es/patrocina-wpcampus-2017/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.campuswp.es/horario-academico/profesores/\" target=\"_blank\">Llamada a profesores</a></li>
</ul>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://es.wordpress.org/2017/02/13/eventos-wordpress-para-la-semana-07-17/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Eventos para la semana\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://es.wordpress.org/2017/02/05/eventos-wordpress-para-la-semana-06-17/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://es.wordpress.org/2017/02/05/eventos-wordpress-para-la-semana-06-17/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 05 Feb 2017 08:30:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://es.wordpress.org/?p=1127\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:420:\"¡Buenos días a todos! Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps. Meetups 09/02 &#8211; Granollers &#8211; Page Builders en WordPress, Conoce sus Pros y Contras. 09/02 &#8211; Alicante &#8211; Información y dudas sobre la WordCamp Alicante 10/02 &#8211; Marbella  &#8211; ¿Está mi WordPress preparado para los [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Mauricio Gelves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4649:\"<p><strong>¡Buenos días a todos!</strong> Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps.</p>
<hr />
<h2>Meetups</h2>
<ul>
<li>09/02 &#8211; <strong>Granollers</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPressGranollers/events/235753674/\" target=\"_blank\">Page Builders en WordPress, Conoce sus Pros y Contras.</a></li>
<li>09/02 &#8211; <strong>Alicante</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Alicante/events/237299428/\" target=\"_blank\">Información y dudas sobre la WordCamp Alicante</a></li>
<li>10/02 &#8211; <strong>Marbella </strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Meetup-Marbella/events/237319250/\" target=\"_blank\">¿Está mi WordPress preparado para los nuevos cambios con la LOPD?</a></li>
</ul>
<h3>Fotos de las Meetups de la semana anterior</h3>
<a href=\"https://es.wordpress.org/2017/02/05/eventos-wordpress-para-la-semana-06-17/#gallery-1127-2-slideshow\">Haga click para ver el pase de diapositivas.</a>
<hr />
<h2>WordCamps</h2>
<p>Sigue de cerca la organización de los próximos WordCamps que se celebrarán en España durante el 2017.</p>
<ul>
<li><strong>WordCamp Alicante 4 de Marzo 2017</strong><br />
<a href=\"https://2017.alicante.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.alicante.wordcamp.org/programa/\" target=\"_blank\">Programa</a> | <a href=\"https://2017.alicante.wordcamp.org/patrocina-el-evento/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.alicante.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"https://2017.alicante.wordcamp.org/llamada-a-voluntarios/\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.alicante.wordcamp.org/tickets-wordcamp-alicante-2017/\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"alignnone wp-image-1091\" src=\"https://es.wordpress.org/files/2017/01/wordcamp-alicante-2017.png\" alt=\"WordCamp Alicante 2017\" width=\"312\" height=\"156\" /></li>
<li><strong>WordCamp Madrid 22-23 de Abril 2017<br />
</strong><a href=\"https://2017.madrid.wordcamp.org/\" target=\"_blank\">Web</a> | Programa | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-patrocinadores-call-for-sponsors/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-ponentes-call-for-speakers/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-voluntarios-call-for-volunteers/\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.madrid.wordcamp.org/entradas/\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"wp-image-1088\" src=\"https://es.wordpress.org/files/2017/01/wordcamp-madrid-2017-1024x341.png\" alt=\"WordCamp Madrid 2017\" width=\"308\" height=\"72\" /></li>
<li><strong>WordCamp Bilbao 12-14 de Mayo 2017<br />
</strong><a href=\"https://2017.bilbao.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.bilbao.wordcamp.org/programa/\" target=\"_blank\">Programa</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-patrocinadores/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"http://2017.bilbao.wordcamp.org/llamada-voluntarios\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.bilbao.wordcamp.org/compra-tu-entrada\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"alignnone wp-image-1090\" src=\"https://es.wordpress.org/files/2017/01/wordpress-bilbao-2017.jpg\" alt=\"WordCamp Bilbao 2017\" width=\"311\" height=\"159\" /></li>
</ul>
<hr />
<h2>Otros eventos WordPress</h2>
<p>Aquí podrás encontrar otros eventos interesantes en torno al mundo WordPress.</p>
<ul>
<li><strong>WPCampus Bilbao 24 de Marzo 2017<br />
</strong><a href=\"https://2017.campuswp.es/\" target=\"_blank\">Web</a> | <a href=\"https://2017.campuswp.es/horario-academico/\" target=\"_blank\">Horario Académico</a> | <a href=\"https://2017.campuswp.es/patrocina-wpcampus-2017/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.campuswp.es/horario-academico/profesores/\" target=\"_blank\">Llamada a profesores</a></li>
</ul>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://es.wordpress.org/2017/02/05/eventos-wordpress-para-la-semana-06-17/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Eventos para la semana\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://es.wordpress.org/2017/01/30/eventos-wordpress-para-la-semana-05-17/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://es.wordpress.org/2017/01/30/eventos-wordpress-para-la-semana-05-17/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 30 Jan 2017 09:10:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://es.wordpress.org/?p=1098\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:407:\"¡Buenos días a todos! Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps. También aprovechamos para darle la bienvenida al nuevo grupo de Meetup de Granada, ¡Enhorabuena! Meetups 31/01 &#8211; Chiclana &#8211; Email Marketing con WordPress 31/01 &#8211; Las Palmas &#8211; Ampliando WordPress. Publicación de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Mauricio Gelves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5603:\"<p><strong>¡Buenos días a todos!</strong> Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps.<br />
También aprovechamos para darle la bienvenida al nuevo grupo de <a href=\"https://www.meetup.com/es-ES/Granada-WordPress-Meetup/\" target=\"_blank\">Meetup de Granada</a>, ¡Enhorabuena!</p>
<hr />
<h2>Meetups</h2>
<ul>
<li>31/01 &#8211; <strong>Chiclana</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Meetup-Chiclana/events/237160891/\" target=\"_blank\">Email Marketing con WordPress</a></li>
<li>31/01 &#8211; <strong>Las Palmas</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Las-Palmas-de-Gran-Canaria-WordPress-Meetup/events/236851686/\" target=\"_blank\">Ampliando WordPress. Publicación de contenidos enfocado a resultados</a></li>
<li>01/02 &#8211; <strong>Granada </strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Granada-WordPress-Meetup/events/237139740/\" target=\"_blank\">Comunidad WordPress ¡Aparece!</a> (nuevo Meetup <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f44f.png\" alt=\"👏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f3fb.png\" alt=\"🏻\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />)</li>
<li>01/02 &#8211; <strong>Rivas Vaciamadrid</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Rivas-WordPress-Meetup/events/237017936/\" target=\"_blank\">Tu tienda on-line desde 0 . WordPress te ayuda con WooCommerce</a></li>
<li>02/02 &#8211; <strong>Barcelona</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/wordpressbcn/events/237309696/?eventId=237309696\" target=\"_blank\">Todo sobre el equipo de Comunidad de WordPress.org, Meetups y WordCamps</a></li>
<li>02/02 &#8211; <strong>Madrid</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Madrid/events/236912586/\" target=\"_blank\">Creación de shortcodes para que lo use “El Cliente”</a></li>
</ul>
<h3>Fotos de las Meetups de la semana anterior</h3>
<a href=\"https://es.wordpress.org/2017/01/30/eventos-wordpress-para-la-semana-05-17/#gallery-1098-3-slideshow\">Haga click para ver el pase de diapositivas.</a>
<hr />
<h2>WordCamps</h2>
<p>Sigue de cerca la organización de los próximos WordCamps que se celebrarán en España durante el 2017.</p>
<ul>
<li><strong>WordCamp Alicante 4 de Marzo 2017</strong><br />
<a href=\"https://2017.alicante.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.alicante.wordcamp.org/patrocina-el-evento/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.alicante.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"https://2017.alicante.wordcamp.org/llamada-a-voluntarios/\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.alicante.wordcamp.org/tickets-wordcamp-alicante-2017/\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"alignnone wp-image-1091\" src=\"https://es.wordpress.org/files/2017/01/wordcamp-alicante-2017.png\" alt=\"WordCamp Alicante 2017\" width=\"312\" height=\"156\" /></li>
<li><strong>WordCamp Madrid 22-23 de Abril 2017<br />
</strong><a href=\"https://2017.madrid.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-patrocinadores-call-for-sponsors/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-ponentes-call-for-speakers/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"https://2017.madrid.wordcamp.org/entradas/\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"wp-image-1088\" src=\"https://es.wordpress.org/files/2017/01/wordcamp-madrid-2017-1024x341.png\" alt=\"WordCamp Madrid 2017\" width=\"308\" height=\"72\" /></li>
<li><strong>WordCamp Bilbao 12-14 de Mayo 2017<br />
</strong><a href=\"https://2017.bilbao.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.bilbao.wordcamp.org/programa/\" target=\"_blank\">Programa</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-patrocinadores/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"http://2017.bilbao.wordcamp.org/llamada-voluntarios\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.bilbao.wordcamp.org/compra-tu-entrada\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"alignnone wp-image-1090\" src=\"https://es.wordpress.org/files/2017/01/wordpress-bilbao-2017.jpg\" alt=\"WordCamp Bilbao 2017\" width=\"311\" height=\"159\" /></li>
</ul>
<hr />
<h2>Otros eventos WordPress</h2>
<p>Aquí podrás encontrar otros eventos interesantes en torno al mundo WordPress.</p>
<ul>
<li><strong>WPCampus Bilbao 24 de Marzo 2017<br />
</strong><a href=\"https://2017.campuswp.es/\" target=\"_blank\">Web</a> | <a href=\"https://2017.campuswp.es/patrocina-wpcampus-2017/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.campuswp.es/horario-academico/profesores/\" target=\"_blank\">Llamada a profesores</a></li>
</ul>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://es.wordpress.org/2017/01/30/eventos-wordpress-para-la-semana-05-17/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:51:\"
		
		
		
		
		
				
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress 4.7.2 – Actualización de seguridad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://es.wordpress.org/2017/01/27/wordpress-4-7-2-actualizacion-de-seguridad/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://es.wordpress.org/2017/01/27/wordpress-4-7-2-actualizacion-de-seguridad/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 Jan 2017 11:35:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:15:\"Actualizaciones\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"Seguridad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:5:\"4.7.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://es.wordpress.org/?p=1095\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:376:\"Ya está disponible WordPress 4.7.2. Es una actualización de seguridad para todas las versiones y te animamos encarecidamente a actualizar tus sitios de inmediato. Las versiones de WordPress 4.7.1 y anteriores están afectadas por estos tres problemas de seguridad: La interfaz de usuario en la que se asignan términos a taxonomías en Publicar esto se muestra a [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Fernando Tellado\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1650:\"<p>Ya está disponible WordPress 4.7.2. Es una <strong>actualización de seguridad</strong> para todas las versiones y te animamos encarecidamente a actualizar tus sitios de inmediato.</p>
<p>Las versiones de WordPress 4.7.1 y anteriores están afectadas por estos tres problemas de seguridad:</p>
<ol>
<li>La interfaz de usuario en la que se asignan términos a taxonomías en Publicar esto se muestra a usuarios que no tienen permisos para usarlas. Informado por David Herrera de <a href=\"https://www.alleyinteractive.com/\">Alley Interactive</a>.</li>
<li><code>WP_Query</code> rs vulnerable a una inyección SQL (SQLi) al pasar datos no seguros. El núcleo de WordPress no es vulnerable directamente a este problema pero hemos añadido refuerzo para evitar que plugins y temas puedan provocar accidentalmente una vulnerabilidad. Informado por <a href=\"https://github.com/mjangda\">Mo Jangda</a> (batmoo).</li>
<li>Se ha descubierto una vulnerabilidad de cross-site scripting (XSS) en la tabla de lista de entradas. Informado por <a href=\"https://iandunn.name/\">Ian Dunn</a> del equipo de seguridad de WordPress.</li>
</ol>
<p>Gracias a los que informaron de estos problemas practicando la <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">revelación responsable</a>.</p>
<p><a href=\"https://es.wordpress.org/releases/\">Descarga WordPress 4.7.2</a> o pásate por el escritorio de WordPress → Actualizaciones y simplemente haz clic en “Actualizar ahora”Los sitios compatibles con las actualizaciones automáticas en segundo plano ya se están actualizando solos a WordPress 4.7.2.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://es.wordpress.org/2017/01/27/wordpress-4-7-2-actualizacion-de-seguridad/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Eventos para la semana\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://es.wordpress.org/2017/01/20/eventos-wordpress-para-la-semana-04-17/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://es.wordpress.org/2017/01/20/eventos-wordpress-para-la-semana-04-17/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jan 2017 10:42:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://es.wordpress.org/?p=1079\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"¡Buenos días a todos! Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps. Enhorabuena al nuevo grupo de Meetup de Valladolid y a los organizadores de la reciente publicada WordCamp Alicante. Meetups 24/01 &#8211; Madrid &#8211; Haciendo un buen uso de los campos personalizados [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Mauricio Gelves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5668:\"<p><strong>¡Buenos días a todos!</strong> Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps.<br />
Enhorabuena al nuevo grupo de <a href=\"https://www.meetup.com/es-ES/Valladolid-WordPress-Meetup/\" target=\"_blank\">Meetup de Valladolid</a> y a los organizadores de la reciente publicada <a href=\"https://2017.alicante.wordcamp.org/\" target=\"_blank\">WordCamp Alicante</a>.</p>
<hr />
<h2>Meetups</h2>
<ul>
<li>24/01 &#8211; <strong>Madrid</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Madrid/events/236911916/\" target=\"_blank\">Haciendo un buen uso de los campos personalizados con ACF</a></li>
<li>24/01 &#8211; <strong>Sevilla</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Sevilla/events/221757477/\" target=\"_blank\">Control de versiones: Git</a></li>
<li>24/01 &#8211; <strong>Majadahonda</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Majadahonda/events/236813537/\" target=\"_blank\">Dale a tu contenido el espacio que se merece &#8211; WordPress Custom Post Types</a></li>
<li>25/01 &#8211; <strong>Zaragoza</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Zaragoza/events/236815141/\" target=\"_blank\">Iniciación a Gravity Forms</a></li>
<li>26/01 &#8211; <strong>Alcalá de Henares</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Alcala-de-Henares-WordPress-Meetup/events/236024376/\" target=\"_blank\">Quedada para puesta en común de ideas, dudas e inquietudes sobre WordPress</a></li>
<li>26/01 &#8211; <strong>Collado Villalba</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Collado-Villalba-Meetup/events/236804775/\" target=\"_blank\">Trucos ocultos para convertirte en un Ninja de WordPress</a></li>
<li>26/01 &#8211; <strong>Málaga</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Malaga/events/236959119/\" target=\"_blank\">Comenzando con WordPress. Instalación y configuración. Trucos y consejos.</a></li>
<li>26/01 &#8211; <strong>Valladolid</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Valladolid-WordPress-Meetup/events/236821199/\" target=\"_blank\">Presentación Comunidad WordPress</a> (nuevo Meetup <strong><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></strong>)</li>
<li>27/01 &#8211; <strong>Granollers</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPressGranollers/events/236897558/\" target=\"_blank\">Taller Práctico, Ven con Tu Portátil <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a></li>
</ul>
<hr />
<h2>WordCamps</h2>
<p>Sigue de cerca la organización de los próximos WordCamps que se celebrarán en España durante el 2017.</p>
<ul>
<li><strong>WordCamp Madrid 22-23 de Abril 2017<br />
</strong><a href=\"https://2017.madrid.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-patrocinadores-call-for-sponsors/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-ponentes-call-for-speakers/\" target=\"_blank\">Llamada a ponentes<br />
</a><img class=\"wp-image-1088\" src=\"https://es.wordpress.org/files/2017/01/wordcamp-madrid-2017-1024x341.png\" alt=\"WordCamp Madrid 2017\" width=\"308\" height=\"72\" /></li>
<li><strong>WordCamp Bilbao 12-14 de Mayo 2017<br />
</strong><a href=\"https://2017.bilbao.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-patrocinadores/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"http://2017.bilbao.wordcamp.org/llamada-voluntarios\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.bilbao.wordcamp.org/compra-tu-entrada\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"alignnone wp-image-1090\" src=\"https://es.wordpress.org/files/2017/01/wordpress-bilbao-2017.jpg\" alt=\"WordCamp Bilbao 2017\" width=\"311\" height=\"159\" /></li>
<li><strong>WordCamp Alicante 4 de Marzo 2017</strong><br />
<a href=\"https://2017.alicante.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.alicante.wordcamp.org/patrocina-el-evento/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.alicante.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a> | <a href=\"https://2017.alicante.wordcamp.org/llamada-a-voluntarios/\" target=\"_blank\">Llamada a voluntarios</a> | <a href=\"https://2017.alicante.wordcamp.org/tickets-wordcamp-alicante-2017/\" target=\"_blank\">Tickets <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a><br />
<img class=\"alignnone wp-image-1091\" src=\"https://es.wordpress.org/files/2017/01/wordcamp-alicante-2017.png\" alt=\"WordCamp Alicante 2017\" width=\"312\" height=\"156\" /></li>
</ul>
<hr />
<h2>Otros eventos WordPress</h2>
<p>Aquí podrás encontrar otros eventos interesantes en torno al mundo WordPress.</p>
<ul>
<li><strong>WPCampus Bilbao 24 de Marzo 2017<br />
</strong><a href=\"https://2017.campuswp.es/\" target=\"_blank\">Web</a> | <a href=\"https://2017.campuswp.es/patrocina-wpcampus-2017/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.campuswp.es/horario-academico/profesores/\" target=\"_blank\">Llamada a profesores</a></li>
</ul>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://es.wordpress.org/2017/01/20/eventos-wordpress-para-la-semana-04-17/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Eventos para la semana\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://es.wordpress.org/2017/01/16/eventos-wordpress-para-la-semana-03-17/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://es.wordpress.org/2017/01/16/eventos-wordpress-para-la-semana-03-17/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 Jan 2017 11:17:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://es.wordpress.org/?p=1074\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"¡Buenos días a todos! Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps. Meetups 20/01 &#8211; Bilbao &#8211; El Negocio de la Web 20/01 &#8211; Pontevedra &#8211; Web con happy ending: Estrategias y consejos en el posicionamiento SEO WordCamps Sigue de cerca la organización [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Mauricio Gelves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1526:\"<p><strong>¡Buenos días a todos!</strong> Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps.</p>
<hr />
<h2>Meetups</h2>
<ul>
<li>20/01 &#8211; <strong>Bilbao</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Bilbao/events/236317068/\" target=\"_blank\">El Negocio de la Web</a></li>
<li>20/01 &#8211; <strong>Pontevedra</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Pontevedra-WordPress-Meetup/events/236566684/\" target=\"_blank\">Web con happy ending: Estrategias y consejos en el posicionamiento SEO</a></li>
</ul>
<hr />
<h2>WordCamps</h2>
<p>Sigue de cerca la organización de los próximos WordCamps que se celebrarán en España durante el 2017.</p>
<ul>
<li><strong>WordCamp Madrid 22-23 de Abril 2017<br />
</strong><a href=\"https://2017.madrid.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-patrocinadores-call-for-sponsors/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-ponentes-call-for-speakers/\" target=\"_blank\">Llamada a ponentes</a></li>
<li><strong>WordCamp Bilbao 12-14 de Mayo 2017<br />
</strong><a href=\"https://2017.bilbao.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-patrocinadores/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a></li>
</ul>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://es.wordpress.org/2017/01/16/eventos-wordpress-para-la-semana-03-17/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:60:\"
		
		
		
		
		
				
		
		
		
		
		
		

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WordPress 4.7.1 Actualización de  mantenimiento y seguridad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://es.wordpress.org/2017/01/12/wordpress-4-7-1-actualizacion-de-mantenimiento-y-seguridad/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://es.wordpress.org/2017/01/12/wordpress-4-7-1-actualizacion-de-mantenimiento-y-seguridad/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Jan 2017 07:50:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:7:{i:0;a:5:{s:4:\"data\";s:15:\"Actualizaciones\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Mantenimiento\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:9:\"Seguridad\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:3:\"4.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:5:\"4.7.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:14:\"actualización\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:6;a:5:{s:4:\"data\";s:13:\"mantenimiento\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://es.wordpress.org/?p=1070\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:372:\"WordPress 4.7 se ha descargado ya más de 10 millones de veces desde su lanzamiento el 6 de diciembre de 2016, y estamos encantados de anunciar la disponibilidad inmediata de WordPress 4.7.1. Esta es una actualización de seguridad de todas las versiones anteriores y te animamos encarecidamente a actualizar tus sitios de inmediato. Las versiones de WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Fernando Tellado\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6606:\"<p>WordPress 4.7 se ha <a href=\"https://wordpress.org/download/counter/\">descargado ya más de 10 millones de veces</a> desde su lanzamiento el 6 de diciembre de 2016, y estamos encantados de anunciar la disponibilidad inmediata de WordPress 4.7.1. Esta es una <strong>actualización de seguridad</strong> de todas las versiones anteriores y te animamos encarecidamente a actualizar tus sitios de inmediato.</p>
<p>Las versiones de WordPress 4.7 y anteriores están afectadas por ocho problemas de seguridad:</p>
<ol>
<li>Ejecución de código remoto en PHPMailer – <em>No hay ningún problema específico que afecte a WordPress</em> o a los principales plugins que hemos investigado pero, por precaución, hemos actualizado PHPMailer en esta versión Este problema lo informaron a PHPMailer <a href=\"https://legalhackers.com/\">Dawid Golunski</a> y <a href=\"https://twitter.com/Zenexer\">Paul Buonopane</a>.</li>
<li>La REST API exponía datos de usuario de todos los usuarios autores de una entrada o un tipo de contenido público. WordPress 4.7.1 limita esto solo a los tipos de contenido que se especifique que deban mostrarse en la REST API. Informaron <a href=\"https://poststatus.com/\">Krogsgard</a> y <a href=\"https://ithemes.com/\">Chris Jean</a>.</li>
<li>Vulnerabilidad XSS a través del nombre del plugin o la cabecera de la versión en <code>update-core.php</code>. Informado por <a href=\"https://dominikschilling.de/\">Dominik Schilling</a>, del equipo de seguridad de WordPress.</li>
<li>Vulnerabilidad CSRF al subir un archivo flash. Informado por <a href=\"https://twitter.com/Abdulahhusam\">Abdullah Hussam</a>.</li>
<li>Vulnerabilidad XSS mediante la retirada del nombre del tema. Informado por <a href=\"https://pentest.blog/\">Mehmet Ince</a>.</li>
<li>La publicación por correo electrónico revisa <code>mail.example.com</code> si no han cambiado los ajustes por defecto. Informado por John Blackbourn, del equipo de seguridad de WordPress.</li>
<li>Vulnerabilidad CSRF descubierta en e modo de accesibilidad de la edición de widgets. Informada por <a href=\"https://dk.linkedin.com/in/ronni-skansing-36143b65\">Ronnie Skansing</a>.</li>
<li>Seguridad criptográfica débil en la clave de activación de multisitio. Informado por <a href=\"https://itsjack.cc/\">Jack</a>.</li>
</ol>
<p>Gracias a todos los que han informado por practicar la <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">revelación responsable</a>.</p>
<p>Además de los anteriores problemas de seguridad, WordPress 4.7.1 soluciona 62 fallos desde la versión 4.7. Para más información revisa las <a href=\"https://codex.wordpress.org/Version_4.7.1\">notas de la versión</a> o consulta la <a href=\"https://core.trac.wordpress.org/query?milestone=4.7.1\">lista completa de cambios</a>.</p>
<p><a href=\"https://es.wordpress.org/releases/\">Descarga WordPress 4.7.1</a> o pásate por tu Escritorio → Actualizar y simplemente haz cic en &#8220;Actualizar ahora&#8221;. Los sitios compatibles con las actualizaciones automáticas en segundo plano ya se están actualizando solos a WordPress 4.7.1.</p>
<p>Gracias a todos los que han colaborado con la versión 4.7.1: <a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel/\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dreamon11/\">DreamOn11</a>, <a href=\"https://profiles.wordpress.org/chopinbach/\">Edwin Cromley</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Dorpe</a>, <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/jnylen0/\">James Nylen</a>, <a href=\"https://profiles.wordpress.org/jblz/\">Jeff Bowen</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/jpry/\">Jeremy Pry</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/kkoppenhaver/\">Keanan Koppenhaver</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/mattyrob/\">mattyrob</a>, <a href=\"https://profiles.wordpress.org/monikarao/\">monikarao</a>, <a href=\"https://profiles.wordpress.org/natereist/\">Nate Reist</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/nikschavan/\">Nikhil Chavan</a>, <a href=\"https://profiles.wordpress.org/nullvariable/\">nullvariable</a>, <a href=\"https://profiles.wordpress.org/sirbrillig/\">Payton Swick</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a>, <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/sanketparmar/\">Sanket Parmar</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/sfpt/\">sfpt</a>, <a href=\"https://profiles.wordpress.org/shazahm1hotmailcom/\">shazahm1</a>, <a href=\"https://profiles.wordpress.org/sstoqnov/\">Stanimir Stoyanov</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/szaqal21/\">szaqal21</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/voldemortensen/\">voldemortensen</a>, <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> y <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://es.wordpress.org/2017/01/12/wordpress-4-7-1-actualizacion-de-mantenimiento-y-seguridad/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Eventos para la semana\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://es.wordpress.org/2017/01/09/eventos-wordpress-para-la-semana-02-17/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://es.wordpress.org/2017/01/09/eventos-wordpress-para-la-semana-02-17/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Jan 2017 08:42:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://es.wordpress.org/?p=1062\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"🎉🍾¡Feliz 2017 para todos! 🍾🎉 Comenzamos a transitar un nuevo año y empiezan de a poco a surgir las distintas reuniones a lo largo de todo el país. Vamos, que se nota muchísimo que hay que emplear un esfuerzo extra post-fiestas para retomar las actividades 😂. Os dejamos el listado de las Meetups para esta semana como [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Mauricio Gelves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2482:\"<p><strong><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f37e.png\" alt=\"🍾\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />¡Feliz 2017 para todos!</strong> <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f37e.png\" alt=\"🍾\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>
<p>Comenzamos a transitar un nuevo año y empiezan de a poco a surgir las distintas reuniones a lo largo de todo el país. Vamos, que se nota muchísimo que hay que emplear un esfuerzo extra post-fiestas para retomar las actividades <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f602.png\" alt=\"😂\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />. </p>
<p>Os dejamos el listado de las Meetups para esta semana como así también el avance de las organizaciones de las distintas WordCamps.</p>
<hr />
<h2>Meetups</h2>
<ul>
<li>12/01 &#8211; <strong>Alcalá de Henares</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Alcala-de-Henares-WordPress-Meetup/events/236022086/\" target=\"_blank\">Cómo empezar con WordPress</a></li>
<li>12/01 &#8211; <strong>Granollers</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPressGranollers/events/235642938/\" target=\"_blank\">Atrae Visitas a tu WordPress, el Email Marketing es tu Gran Aliado</a></li>
</ul>
<hr />
<h2>WordCamps</h2>
<p>Sigue de cerca la organización de los próximos WordCamps que se celebrarán en España durante el 2017.</p>
<ul>
<li><strong>WordCamp Madrid 22-23 de Abril 2017<br />
</strong><a href=\"https://2017.madrid.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-patrocinadores-call-for-sponsors/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-ponentes-call-for-speakers/\" target=\"_blank\">Llamada a ponentes</a></li>
<li><strong>WordCamp Bilbao 12-14 de Mayo 2017<br />
</strong><a href=\"https://2017.bilbao.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-patrocinadores/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a></li>
</ul>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://es.wordpress.org/2017/01/09/eventos-wordpress-para-la-semana-02-17/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"
		
		
		
		
		
				

		
		
				
			
		
		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Eventos WordPress para la semana\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://es.wordpress.org/2016/12/19/eventos-wordpress-para-la-semana-51/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://es.wordpress.org/2016/12/19/eventos-wordpress-para-la-semana-51/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 19 Dec 2016 09:14:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"General\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://es.wordpress.org/?p=1037\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:390:\"Meetups Estas próximas dos semanas tendremos muy pocas reuniones debido a las fiestas de navidad y fin de año. Os dejamos los detalles de las Meetups para estos días: 19/12 &#8211; Sevilla &#8211; Conclusiones WCSevilla2016 20/12 &#8211; Las Palmas de Gran Canaria &#8211; Iniciación a WordPress: Instalación y primeros pasos 22/12 &#8211; Asturias &#8211; Seguridad Básica [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Mauricio Gelves\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3175:\"<h2>Meetups</h2>
<p>Estas próximas dos semanas tendremos muy pocas reuniones debido a las fiestas de navidad y fin de año. Os dejamos los detalles de las Meetups para estos días:</p>
<ul>
<li>19/12 &#8211; <strong>Sevilla</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Sevilla/events/236216761/\" target=\"_blank\">Conclusiones WCSevilla2016</a></li>
<li>20/12 &#8211; <strong>Las Palmas de Gran Canaria</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/Las-Palmas-de-Gran-Canaria-WordPress-Meetup/events/235506741/\" target=\"_blank\">Iniciación a WordPress: Instalación y primeros pasos</a></li>
<li>22/12 &#8211; <strong>Asturias</strong> &#8211; <a href=\"https://www.meetup.com/es-ES/WordPress-Asturias/events/236130561/\" target=\"_blank\">Seguridad Básica en WordPress</a></li>
</ul>
<hr />
<h2>WordCamps</h2>
<p>Sigue de cerca la organización de los próximos WordCamps que se celebrarán en España durante el 2017.</p>
<ul>
<li><strong>WordCamp Madrid 22-23 de Abril 2017</strong> – <a href=\"https://2017.madrid.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-patrocinadores-call-for-sponsors/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.madrid.wordcamp.org/llamada-a-ponentes-call-for-speakers/\" target=\"_blank\">Llamada a ponentes</a></li>
<li><strong>WordCamp Bilbao 12-14 de Mayo 2017</strong> – <a href=\"https://2017.bilbao.wordcamp.org/\" target=\"_blank\">Web</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-patrocinadores/\" target=\"_blank\">Llamada a patrocinadores</a> | <a href=\"https://2017.bilbao.wordcamp.org/llamada-a-ponentes/\" target=\"_blank\">Llamada a ponentes</a>.</li>
</ul>
<hr />
<h2><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f384.png\" alt=\"🎄\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />¡Feliz Navidad!<img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f384.png\" alt=\"🎄\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f389.png\" alt=\"🎉\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f384.png\" alt=\"🎄\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></h2>
<p><a href=\"https://es.wordpress.org/files/2015/12/wapmas-wapuu.png\"><img class=\"alignleft wp-image-747\" src=\"https://es.wordpress.org/files/2015/12/wapmas-wapuu-273x300.png\" alt=\"\" width=\"59\" height=\"65\" srcset=\"https://es.wordpress.org/files/2015/12/wapmas-wapuu-273x300.png 273w, https://es.wordpress.org/files/2015/12/wapmas-wapuu.png 300w\" sizes=\"(max-width: 59px) 100vw, 59px\" /></a>Desde WordPress España os deseamos que paséis una feliz navidad junto a vuestros familiares y seres queridos y que la magia de esa noche os llene de una alegría sin igual, os traiga amor, paz y prosperidad para todos.</p>
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://es.wordpress.org/2016/12/19/eventos-wordpress-para-la-semana-51/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:30:\"https://es.wordpress.org/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 21 Feb 2017 12:38:21 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Tue, 21 Feb 2017 09:07:48 GMT\";s:4:\"link\";s:61:\"<https://es.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20170109145931\";}","no");
INSERT INTO `wp_options` VALUES("8061","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1487723901","no");
INSERT INTO `wp_options` VALUES("8062","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"


\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"
	
	
	
	




















































\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"WPTavern: Solving the Mystery of How People Actually Use WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65557\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wptavern.com/solving-the-mystery-of-how-people-actually-use-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9727:\"<p>I’m in favor of <a href=\"https://wptavern.com/wordpress-telemetry-proposal-addresses-long-standing-privacy-concerns-as-gdpr-compliance-deadline-looms#comment-208658\">WordPress collecting more anonymized usage data</a> that could help make informed decisions on changes or improvements to core, such as tracking changes to the WordPress user interface, which buttons or settings are used most often, etc.</p>
<p>A good example of when this data could have come in handy is the recent <a href=\"https://wptavern.com/wordpress-4-7-removes-the-underline-and-justify-buttons-from-the-editor\">removal of the justify and underline buttons</a> from the editor in WordPress 4.7. During <a href=\"https://core.trac.wordpress.org/ticket/27159#comment:82\">the discussion</a> on whether they should be removed or not, a number of people questioned if there was any user data available that would indicate how much they’re used and help gauge the impact of removing them.</p>
<p>The only data available to help make an informed decision was provided by Mel Choyce. Choyce <a href=\"https://core.trac.wordpress.org/ticket/27159#comment:29\">shared statistics</a> from WordPress.com and its variety of editor interfaces that indicated Bold, Italic, and Links are used the most while Lists and Blockquotes are the second most used buttons.</p>
<p>The Center and Left alignment buttons are used often, but the data doesn’t determine if people are using them to align text or images. Information on which headings are used most was not available. The team did not have any usage data specific to the WordPress core editor.</p>
<p>In the ticket, Andrew Ozz, who maintains the TinyMCE component, <a href=\"https://core.trac.wordpress.org/ticket/27159#comment:103\" rel=\"nofollow\">chimed in</a> and agreed that good user data is needed.</p>
<p>In an effort to obtain usage data before removing the buttons, Ozz <a href=\"https://core.trac.wordpress.org/ticket/27159#comment:104\">created a small plugin</a> to perform testing with five existing and first-time users. Interestingly, he discovered that both types of users clicked on the kitchen sink button to display the second row of buttons and didn&#8217;t click the button to hide them again.</p>
<p>Ozz also shared other results from his limited testing.</p>
<blockquote><p>I know these test results are extremely limited and cannot be used when making a decision, but they are an indication of what &#8216;real&#8217; testing may reveal. In this case it shows that moving buttons to the bottom row will have no effect on the usage of these buttons as they will still be visible at all times.</p>
<p>This super limited testing also indicated another (much bigger) problem: somebody mentioned this some time ago (think it was @mor10), around 20% of the WordPress users don’t even know there is a second editor toolbar, and some feel &#8216;pretty stupid&#8217; after discovering it. I think this is bad UX and something that can be fixed easily by having the second toolbar open by default, and fixing it is more important and will improve the UX for these 20% of users a lot.</p></blockquote>
<p>Imagine how useful it would be for core developers or others if there was usage data like this on a grander scale that could fuel rapid improvements and help discover and eliminate pain points.</p>
<p>Matt Mullenweg, co-creator of the WordPress project, has <a href=\"https://core.trac.wordpress.org/ticket/38418\">closed the ticket</a> with the Telemetry Proposal as it&#8217;s not within the <a href=\"https://wptavern.com/state-of-the-word-2016-mullenweg-pushes-calypso-as-future-of-wordpress-interface-proposes-major-changes-to-release-cycle\">three project focus areas</a> for 2017.</p>
<p>&#8220;There is no part of current or potential WP development that is being held back by the lack of this existing, as there are easy and current ways to answer questions with data to the extent it would inform our decisions,&#8221; Mullenweg said.</p>
<p>Morten Rand-Hendriksen <a href=\"https://core.trac.wordpress.org/ticket/38418#comment:11\">responded to the closure</a> saying that the quantitative user testing falls squarely within the Customizer focus area.</p>
<p>&#8220;I would argue since the release of the Customizer some years back, it has gone through a multi-year large-scale quantitative user test with incremental tweaks and improvements,&#8221; Rand-Hendriksen said.</p>
<p>&#8220;This is in line with standard agile development. At this juncture, the Customizer can be considered mature, and moving a mature solution forward requires hard data on usage, use cases, and user needs. This goes beyond standard user testing to large-scale data collection, which is what this ticket aims at addressing.&#8221;</p>
<h2>Perspective From a WordPress Release Lead</h2>
<p>There are WordPress core developers who have shown interest in a similar system. At the start of the WordPress 4.7 development cycle, Drew Jaynes, who led the WordPress 4.2 release cycle, <a href=\"https://make.wordpress.org/core/2016/08/17/wordpress-4-7-whats-on-your-mind/#comment-30573\">expressed interest</a> in creating an opt-in data collection system.</p>
<p>The idea received positive feedback that included people offering to help. I asked Jaynes what his thoughts are on such a system and how it could benefit core development.</p>
<p>&#8220;There&#8217;s some discussion about what form that collection should take initially, but I think there&#8217;s consensus that it should be opt-in, and take one of two forms (or a hybrid of the two): active (surveys in the admin) or passive (anonymized usage) data collection,&#8221; Jaynes said.</p>
<p>&#8220;Either way, I think having this data available would benefit the entire community, regardless of the obvious practicable application within core development.</p>
<p>&#8220;All of that data can and should be used to inform decision-making in WordPress going forward. The core team really needs to hit the reset button on the concept of the 80/20 rule, including what and whom it represents.</p>
<p>&#8220;We should be building modern WordPress for the modern WordPress user, and resting on Matt&#8217;s instincts coupled with the core team&#8217;s experience is no longer enough to maintain positive forward momentum.&#8221;</p>
<p>Jaynes cites the editor as an example of where having the data would be helpful and that without it, pursuing an idealized &#8216;modern editor&#8217; in WordPress is premature. The data could also help provide insight into improving the new user experience.</p>
<p>&#8220;A common complaint is that the WordPress admin can be really overwhelming to new users,&#8221; Jaynes said. &#8220;Having real data about how frequently the various core screens are used could really inform decisions about maybe paring it down, or hiding some things over time that are used less and less.&#8221;</p>
<p>While collecting data could help with making informed decisions, he doesn&#8217;t think it should stop the core team from experimentation.</p>
<p>&#8220;I think having real, citable data could really reduce the amount of backlash we&#8217;ve seen with a few releases in the last couple of years,&#8221; Jaynes said. &#8220;Areas where core team decisions left some group of users feeling jilted.&#8221;</p>
<p>&#8220;It&#8217;s worth mentioning that there&#8217;s absolutely value in allowing the core team to experiment, as long as we&#8217;re careful not to latch onto something that got merged as the only way we&#8217;ll ever need to solve that problem; that&#8217;s where we get into trouble.&#8221;</p>
<h2>Who Are The 80/20 Users of WordPress?</h2>
<p>The most striking statement in Rand-Hendriksen&#8217;s proposal is that WordPress development is occurring without having any idea who the 80% or 20% of users are.</p>
<p>&#8220;During the development of WordPress 4.7, I was involved in several conversations centered around <em>assumed use</em> of features,&#8221; Rand-Hendriksen said.</p>
<p>&#8220;The general argument was that based on the 80/20 rule, certain features should be added while others should be removed. I kept bringing up the well-known fact we don’t have a clue what features 80%, or even 20%, of WordPress users actually use so any claim of validity in the 80/20 rule is guesswork at best.&#8221;</p>
<p>Collecting usage data is standard practice. Microsoft Windows, Mozilla Firefox, Chrome, iOS, and a number of other software projects have opt-in data collection systems that are used to improve the product. They also provide insight into how customers are using their products.</p>
<p>WordPress development on the other hand relies on the support forums, data collected from WordPress.com, limited user testing, verbal feedback at WordCamps, and other small data points. Collecting usage data from WordPress could show trends and provide evidence for changes related to the <a href=\"https://wordpress.org/about/philosophy/\">decisions not options philosophy</a> of WordPress development.</p>
<p>Collecting usage data isn&#8217;t going to solve all of WordPress&#8217; woes but having it available to make more informed decisions is better than not having any data at all. Although an opt-in data collection system in WordPress won&#8217;t be a core focus any time soon, it&#8217;s encouraging to see the idea has merit and is something some core developers are interested in seeing become a reality.</p>
<p>I&#8217;d gladly opt-in and share my usage data with WordPress.org as long as it was anonymized and displayed publicly in aggregate. Would you?</p>
Note: There is a poll embedded within this post, please visit the site to participate in this post\'s poll.
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Feb 2017 02:07:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"WPTavern: BuddyPress 2.8 Boosts Minimum PHP Requirement, Adds Twenty Seventeen Companion Stylesheet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://wptavern.com/buddypress-2-8-boosts-minimum-php-requirement-adds-twenty-seventeen-companion-stylesheet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2774:\"<p><a href=\"https://buddypress.org/2017/02/buddypress-2-8-0-san-matteo/\" target=\"_blank\">BuddyPress 2.8</a> “San Matteo,” was released last week, led by long-time BuddyPress contributor Slava Abakumov. The release was named for <a href=\"http://www.sanmatteopanuozzo.com/\" target=\"_blank\">San Matteo Panuozzo</a>, an NYC pizza restaurant that specializes in panuozzo, a more portable pizza-sandwich hybrid. Following suit with the previous release, 2.8 focuses on improvements for developers and site builders, the project&#8217;s new target audience as of 2016.</p>
<p>As part of an effort to modernize the plugin&#8217;s codebase and prepare it for better integration with the BP REST API project, this release <a href=\"https://codex.buddypress.org/getting-started/buddypress-2-8-will-require-php-5-3/\" target=\"_blank\">boosts the minimum PHP requirement to 5.3</a>. In BuddyPress versions 2.7+, the plugin will display a notice in the dashboard if it detects that the server doesn&#8217;t meet the minimum requirements for running 2.8. The change is not likely to affect many BuddyPress sites as only a small sliver (5.7%) of WordPress sites are running on PHP 5.2.</p>
<p>This release also adds a companion stylesheet for <a href=\"https://wordpress.org/themes/twentyseventeen/\" target=\"_blank\">Twenty Seventeen</a>. This stylesheet is important for providing a good first impression of BuddyPress for those who are trying try out the plugin with WordPress&#8217; latest default theme. A <a href=\"https://codex.buddypress.org/themes/bp-theme-compatibility-and-the-wordpress-default-themes/twenty-seventeen-theme/\" target=\"_blank\">new BP codex page</a> gives sample code for changing Twenty Seventeen&#8217;s default two-column layout to be a full-width layout.</p>
<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/02/buddypress-twenty-seventeen.png?ssl=1\"><img /></a></p>
<p>The 2.8 release brings improvements to the “Activate Pending Accounts” screen, making it easier for site managers to confirm or reject new registrants. Clicking on the username of a pending account will now display profile data that the user entered at signup.</p>
<p>Other improvements for developers include the following:</p>
<ul>
<li>New filters and actions for the Messages component</li>
<li>Support for List-Unsubscribe header in emails</li>
<li>More flexible Group search</li>
<li>New filter enables choice of which PHPMailer should be used when sending BuddyPress emails</li>
</ul>
<p>BuddyPress 2.8 was made possible by 44 volunteer contributors. For a full list of all the changes in this release, check out the official <a href=\"https://codex.buddypress.org/releases/version-2-8-0/\" target=\"_blank\">2.8.0 changelog</a>.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 Feb 2017 00:33:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Composing a WordPress Development Environment with Docker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66335\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/composing-a-wordpress-development-environment-with-docker\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6432:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2015/03/petersuhm.jpeg?ssl=1\"><img /></a>This post was contributed by guest author <a href=\"http://petersuhm.com/\" target=\"_blank\">Peter Suhm</a>. Peter is a web developer from the Land of the Danes. He is the creator of <a href=\"https://wptavern.com/wp-pusher-aims-to-provide-pain-free-deployment-of-wordpress-themes-and-plugins-from-github\" target=\"_blank\">WP Pusher</a> and a huge travel addict, bringing his work along with him as he goes.<br />
&nbsp;</p>
<hr />
<p>In the last few years, a wave of virtualization technologies have swept through our WordPress development environments. The one that&#8217;s sounded the most promising to me has been Docker: lightweight and flexible. Yet, until recently, getting Docker up and running was an overwhelming task &#8211; especially on a non-Linux machine. If you managed to get it up and running in a virtual machine (using Vagrant or similar), getting port-forwarding to work would make you give up and just use Vagrant instead.</p>
<p>Now it&#8217;s different.</p>
<p>With (a stable) Docker for Mac and Windows and <a href=\"https://docs.docker.com/compose/\" target=\"_blank\">Docker Compose</a> at hand, getting Docker up and running is easy and pain-free. With Docker Compose you can tell Docker exactly what you want your WordPress development environment to look like and it will take care of it.</p>
<h3>What is Docker?</h3>
<p>Docker is a technology that makes it really simple to create isolated containers for your applications and websites to run in. These containers can be combined and modified to fit the needs of your applications. Docker is utilizing the Linux Containers technology (LXC) where multiple isolated environments can share the same Linux kernel &#8211; making it very lightweight compared to something like Vagrant.</p>
<p>The Docker ecosystem is built around containers. In the Docker Hub, you can find an endless number of containers that other people have built or you can build your own using a Dockerfile. When building your own, you can start from scratch using the base Ubuntu image or extend someone else&#8217;s image.</p>
<p>You can share local directories with your containers and link the networks, so they can talk to each other &#8211; just like you know it from other virtualization technologies. However, this is where it gets complicated which leads me to Docker Compose:</p>
<h3>What is Docker Compose?</h3>
<p>Docker Compose is what makes Docker available to mortals like you and me. As the name implies, Docker Compose is a tool for composing Docker containers. That means defining your services (containers), setting up the network between them, sharing local directories with them, and a few more things.</p>
<p>With Docker Compose you create a simple file in the root of your project that describes the setup required by your application/website. For a WordPress theme that might mean a container to run WordPress, a container to run MySQL and a container to run Gulp or Grunt. This can very easily be defined in a docker-compose.yml file that can then be shared with your team members. This means that you can now share your WordPress theme, including an isolated WordPress environment to run it in. Hurray for virtualization!</p>
<h3>Why use Docker?</h3>
<p>There are a few reasons why Docker is an attractive technology for me. Here are the most important requirements I have for my development environment and how Docker solves them:</p>
<ul>
<li><strong>Clean Mac:</strong> In an ideal world, I prefer not to install anything related to my development environment directly on my Mac. I work on so many different projects that this gets unmanageable. When one thing works, another doesn&#8217;t. I also travel a lot and should something happen to my computer, I want to be able to set up a new machine in minutes.</li>
<li><strong>Shareable:</strong> I often work in teams, so sharing my development environment with teammates is crucial. This is possible with Vagrant, but it&#8217;s still very tricky to keep environments in sync across teams.</li>
<li><strong>Lightweight:</strong> This is important, especially when on the road. Try running a few Vagrant boxes compared to a few Docker containers and see what I mean.</li>
<li><strong>Extendable:</strong> Extending Docker is very easy. For example, I could extend the official WordPress container and build it with WP Pusher pre-installed, since I (obviously) always use it.</li>
<li><strong>Mirror production:</strong> My development environment needs to be as close to production as possible. With Docker this is easy, since Docker can be used in production as well.</li>
</ul>
<h3>My Docker development environment</h3>
<p>This is the very simple Docker setup I use for development of my WP Pusher plugin: A WordPress and a MySQL container. Both of them use the official Docker Hub images, so setting it up is very easy.</p>
<p>My <code>docker-compose.yml</code> file looks like this:</p>
<p></p>
<p>It describes two services: a MySQL 5.7 database and WordPress running on PHP 5.6 and Apache. The database is using a volume on my local machine, so data will be persisted every time I shut off the container. My current directory (in this case a plugin) is mounted into the <code>wp-content/plugins</code> directory. This allows me to work on my plugin in a completely isolated WordPress environment &#8211; without installing anything, besides Docker, on my Mac. The WordPress container forwards port 80 to my local machine, so I can access it as &#8220;localhost&#8221; in my browser.</p>
<p>If you want to try it for yourself, and have Docker installed on your machine, just add the file to your plugin (or theme) and run:</p>
<p><code>$ docker-compose up -d</code></p>
<p>In order to see which containers are running, just run:</p>
<p><code>$ docker ps</code></p>
<p>This a very simple setup that is easy to extend and build upon.</p>
<p>I hope this post made you curious about Docker and WordPress. Thanks for reading along!</p>
<h3>Links</h3>
<ul>
<li><a href=\"https://docs.docker.com/compose/\" target=\"_blank\">Docker Compose</a></li>
<li><a href=\"https://hub.docker.com/\" target=\"_blank\">Docker Hub</a></li>
<li><a href=\"https://blog.wppusher.com/the-easiest-way-to-use-docker-for-wordpress-development/\" target=\"_blank\">My Docker setup for WP Pusher</a></li>
</ul>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 20 Feb 2017 18:23:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:115:\"WPTavern: Disqus Hits Sites with Unwanted Advertising, Plans to Charge Large Publishers a Monthly Fee to Remove Ads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66098\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"https://wptavern.com/disqus-hits-sites-with-unwanted-advertising-plans-to-charge-large-publishers-a-monthly-fee-to-remove-ads\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7974:\"<p>When Disqus <a href=\"https://blog.disqus.com/our-plans-for-2017\" target=\"_blank\">announced</a> it would be releasing new, subscription-based versions later this year, users didn&#8217;t expect to have the new advertising model injected into their sites without notice. Disqus CEO Daniel Ha said the company would release finalized pricing and provide more details well in advance of its planned March release, but users are reporting that the advertising has already been forced into their comments without warning.</p>
<blockquote class=\"twitter-tweet\">
<p lang=\"en\" dir=\"ltr\">Why did <a href=\"https://twitter.com/disqus\">@disqus</a> just add a bunch of ads to my site without my permission? <a href=\"https://t.co/CzXTTuGs67\">https://t.co/CzXTTuGs67</a> <a href=\"https://t.co/y2QbFFzM8U\">pic.twitter.com/y2QbFFzM8U</a></p>
<p>&mdash; Harry Campbell (@TheRideShareGuy) <a href=\"https://twitter.com/TheRideShareGuy/status/826921387273052160\">February 1, 2017</a></p></blockquote>
<p></p>
<p>&#8220;We are one of the lucky 5% who now has to pay if we don&#8217;t want really irrelevant and horribly spammy links just plopped on our site with zero warning,&#8221; BabyCenter Social Media Manager Dina Vernon Freeman said. &#8220;Unless our users (mainly millennial parents) should care about overpaying for dentures! We&#8217;re looking for other platforms ASAP.&#8221;</p>
<p>Brian O&#8217;Neill, who manages Slugger O&#8217;Toole, a site with more than 70,000 readers, was also hit with unwanted advertising on his site.</p>
<p>&#8220;Disqus has started to put ads into our comments section of our site without even telling us,&#8221; O&#8217;Neill said in a <a href=\"https://sluggerotoole.com/2017/02/02/bear-with-us-as-we-try-to-remove-those-terrible-disqus-ads-from-the-comments-area/\" target=\"_blank\">post</a> explaining the new ads to the site&#8217;s readers. &#8220;As you can imagine I am extremely annoyed at this – I hate crappy online ads as much as you do. Supposedly we can remove the ads if we pay them $10 a month, but as yet there is no mechanism on their site to do this.&#8221; O&#8217;Neill said he is also exploring alternative commenting systems if he is unable to remove the advertising.</p>
<p>Disqus responded to user complaints with a post to clarify that <a href=\"https://blog.disqus.com/advertising-will-remain-optional-for-over-95-of-sites-on-disqus\" target=\"_blank\">advertising will remain optional for more than 95% of the sites on Disqus</a>.</p>
<p>&#8220;Larger, commercial, sites that elect to use the free version of Disqus will be supported by configurable advertising and have the option to earn revenue through the Reveal program,&#8221; Disqus Marketing Manager Mario Paganini said. &#8220;For small, non-commercial sites, advertising will be optional. These sites will be able to use Disqus’ ads-optional subscription, free of charge.&#8221;</p>
<p>Publishers asked in the comments when the option to pay to remove ads will become available, as an option to pay isn&#8217;t currently in place.</p>
<p>&#8220;Larger sites will be able to run a paid subscription version of Disqus that includes the ability to remove ads along with additional features,&#8221; Paganini said. &#8220;We are aiming to have this available in the next couple of months. We will be making periodic updates on our blog and talking to publishers in the meantime.&#8221;</p>
<p>Disqus is moving to focus on its larger publishers but has already attracted angry criticism from publishers that were not properly informed of the changes. Over the years the company has experimented with different ways of monetizing the commenting platform, often frustrating users in the process of making important changes.</p>
<p>In 2014, Disqus began experimenting with advertising in the form of &#8220;Sponsored Comments&#8221; that users could not turn off without contacting support. This move drew <a href=\"https://ma.tt/2014/11/disqus-spam-ads/\" target=\"_blank\">criticism from WordPress co-founder Matt Mullenweg</a> who essentially called out the ads as little more than comment spam. After a negative reaction from its community, Disqus quietly discontinued the Sponsored Comments and scrubbed the <a href=\"https://blog.disqus.com/heads-up-were-testing-a-new-form-of-advertising\" target=\"_blank\">announcement post</a> from the internet.</p>
<h3>Disqus Delivers Low-Quality Ads</h3>
<p>Disqus has struggled to land on an effective advertising model that will convince users to get on board. Its <a href=\"https://help.disqus.com/customer/portal/articles/2069645-reveal-f-a-q-\" target=\"_blank\">Reveal advertising program</a> is notorious for serving low-quality ads and has inspired little confidence in users who have tried it. The following is one of the tamer examples:</p>
<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/02/disqus-ads.png?ssl=1\"><img /></a></p>
<p>&#8220;I think if you had somewhat decent advertising you might convince people that it&#8217;s worth it, but I had to yank it from one of my sites because it was all &#8216;Ron Paul wants you to buy gold!&#8217; and &#8217;22 times the photos showed too much!\'&#8221; Paul King, an author who writes for multiple publications, commented on Disqus&#8217; most recent advertising announcement. &#8220;Just put in a tier of non-spam advertising that&#8217;s actually relevant or charge based on comments or something.&#8221;</p>
<p>Twitter is filled with complaints from users who are dissatisfied with the questionable quality of Disqus&#8217; advertising. Many are searching for alternatives.</p>
<blockquote class=\"twitter-tweet\">
<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/disqus\">@disqus</a> We\'ve disabled ads straight away (they are literally ALL scams) &#8211; if you force those ads on us, we\'re dropping you like a hot potato</p>
<p>&mdash; That\'s Nonsense (@thatsnonsense) <a href=\"https://twitter.com/thatsnonsense/status/828739990486208512\">February 6, 2017</a></p></blockquote>
<p></p>
<blockquote class=\"twitter-tweet\">
<p lang=\"en\" dir=\"ltr\">Why <a href=\"https://twitter.com/disqus\">@disqus</a> think it\'s acceptable to serve disgusting, misogynistic ads (OR ANY ADS) on people\'s blogs without asking is beyond me.</p>
<p>&mdash; Rosie (@RosieLondoner) <a href=\"https://twitter.com/RosieLondoner/status/828642646478426112\">February 6, 2017</a></p></blockquote>
<p></p>
<blockquote class=\"twitter-tweet\">
<p lang=\"en\" dir=\"ltr\">I\'m removing <a href=\"https://twitter.com/hashtag/disqus?src=hash\">#disqus</a> from <a href=\"https://t.co/PSlovlA6Tm\">https://t.co/PSlovlA6Tm</a> since they\'ve suddenly turned on (notably creepy) ads with no warning.</p>
<p>&mdash; James Britt <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f3a7.png\" alt=\"🎧\" class=\"wp-smiley\" /> (@jamesbritt) <a href=\"https://twitter.com/jamesbritt/status/826922670407172096\">February 1, 2017</a></p></blockquote>
<p></p>
<p>This recent move to turn on advertising without publishers&#8217; permission is another communication blunder in the same vein as the previous attempt at Sponsored Comments. Disqus has failed to find a communication strategy that respects users&#8217; content while leading the company towards its goals at the same time. With spam-quality ads deploying network-wide, the company can certainly expect that some users will be willing to pay the $10/month to turn them off. Sadly, the experience of paying to turn off offensive ads feels more like getting mugged on your way to work than upgrading your service.</p>
<p>The <a href=\"https://wordpress.org/plugins/disqus-comment-system/\" target=\"_blank\">Disqus Comment System</a> plugin has been hovering around 200,000 active sites for the past two years and its ratings continue to plummet on WordPress.org. Unless Disqus is able to dramatically improve its advertising network before its official March release, we may see a mass exodus to other commenting systems.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 18 Feb 2017 00:16:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: How to Check if Installed Plugins Are No Longer in the Plugin Directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66106\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/how-to-check-if-installed-plugins-are-no-longer-in-the-plugin-directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9904:\"<p>When we wrote about <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\">why plugins sometimes disappear</a> from the WordPress plugin directory, it generated a healthy discussion in the comments. One of the topics of discussion brought up is whether or not <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory#comment-209733\">users should be notified</a> when a plugin disappears and if so, how?</p>
<p>Currently, when a plugin is hidden on the directory, users are not notified. If it&#8217;s removed due to a security vulnerability and the author chooses not to fix it or move the plugin somewhere else such as <a href=\"https://github.com/\">GitHub</a>, users are left in the dark.</p>
<p>Donna Cavalier shared a <a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/\">recent example</a> of why users should be notified. Contact Form DB is a popular plugin that saves contact form submissions from many popular Contact Forms plugins to the database. As of <a href=\"https://web.archive.org/web/20161030050515/https://wordpress.org/plugins/contact-form-7-to-database-extension/\">October 30th, 2016</a>, it was actively installed on more than 400K sites.</p>
<p>Approximately <a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/\">one month ago</a>, the plugin was hidden due to a security vulnerability. Instead of releasing a patch, Michael Simpson, creator of Contact Form DB, moved the plugin <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases\">to GitHub</a> and subsequently released a <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases/tag/v2.10.30\">new version</a> that patched the vulnerability. Simpson says the person on the plugin review team that he spoke with was condescending, unprofessional, and rubbed him the wrong way.</p>
<p>&#8220;I’m happy to address any issues and meet any standards, but I’m at the limit of my patience,&#8221; Simpson said.</p>
<p>&#8220;I try to be a good citizen and give back to the community. I’ve put in countless hours for close to seven years now. When I’m treated like this, it seems WordPress doesn’t value me or my contribution to its community.</p>
<p>&#8220;Anyway, I put the code on GitHub and I will continue to support it. But at this point I’m not sure I want to deal with people like this to re-list the plugin on this site. I don’t need the frustration.&#8221;</p>
<p><strong>If you use Contact Form DB, please <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases/tag/v2.10.30\">update to 2.10.30</a> as soon as possible as it contains the aforementioned security fix.</strong></p>
<p>It&#8217;s impossible for Contact Form DB users to automatically install updates from GitHub without installing an <a href=\"https://wptavern.com/github-updater-4-1-to-add-remote-installation-for-wordpress-plugins-and-themes\">updater plugin</a>. This leaves thousands of sites at risk.</p>
<h2>How to Know When Installed Plugins Are No Longer in the Directory</h2>
<p>In the comments of <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\">our article</a>, Tavern reader Central Geek <a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory#comment-209776\">shared links</a> to a couple of plugins aimed at providing useful information such as, whether a <a href=\"https://wordpress.org/plugins/vendi-abandoned-plugin-check/\">plugin has been abandoned</a> and <a href=\"https://wordpress.org/plugins/better-plugin-compatibility-control/\">better plugin compatibility information</a>.</p>
<p>One of the plugins he mentions is called <a href=\"https://wordpress.org/plugins/no-longer-in-directory/\">No Longer in Directory, </a>developed by <a href=\"https://profiles.wordpress.org/whitefirdesign/\">White Fir Design</a>. The plugin adds a page to the WordPress backend that informs users if any of the plugins that are installed are available in the plugin directory. It also separately lists installed plugins that haven&#8217;t been updated in two years or more.</p>
<p><img /></p>
<p>The check is performed using the plugin directory&#8217;s folder name. The author notes that this could lead to plugins that have never been in the plugin directory to be flagged if they use the same name as a plugin that was in the directory in the past. If you encounter this situation, you&#8217;re encouraged to create a new thread on the <a href=\"https://wordpress.org/support/plugin/no-longer-in-directory\">plugin&#8217;s support forum</a>.</p>
<p>So far, No Longer in Directory is actively installed on more than 1K sites. Out of a total of <a href=\"https://wordpress.org/support/plugin/no-longer-in-directory/reviews/\">six reviews</a>, its average rating is 4.8 out of 5 stars. I tested the plugin with WordPress 4.8 alpha and didn&#8217;t encounter any issues.</p>
<p>If this is a feature you&#8217;d like to see implemented in WordPress, consider <a href=\"https://wordpress.org/ideas/topic/alert-when-installed-plugins-have-been-removed-from-the-plugin-directory\">voting for it</a>. So far, the idea has 43 votes with a five-star average rating. <a href=\"https://profiles.wordpress.org/ipstenu\">Mika Epstein</a>, Plugin Directory Representative, <a href=\"https://wordpress.org/ideas/topic/alert-when-installed-plugins-have-been-removed-from-the-plugin-directory#post-22481\">responded to the idea</a> four years ago noting that it was being worked on.</p>
<p>As Epstein mentioned in our previous article, explaining WHY a plugin has been closed is complex.</p>
<p>“Obviously the last thing we want are people getting hacked, but it presents us with a few options and they all have flaws,&#8221; she said.</p>
<p>&#8220;We’ve not been able to determine a way to tell people ‘This plugin is gone, don’t use it’ and ‘This plugin is gone, but use it if you want.’ without putting users at risk.”</p>
<h2>If a Plugin Is Permanently Removed From the Directory, Users Should Be Notified</h2>
<p>I believe users should be informed if a plugin is permanently removed from the directory. It doesn&#8217;t make sense to notify users if it&#8217;s temporarily hidden due to violating a guideline or a security issue. Plus, between upgrade and admin notices, users are receiving enough notifications as it is.</p>
<p>I&#8217;m unsure if the notification should be an admin notice as we&#8217;ve <a href=\"https://wptavern.com/please-stop-abusing-wordpress-admin-notices\">already documented</a> how plugin authors are using them to advertise. Users are increasingly getting annoyed by them and they&#8217;re usefulness is in decline.</p>
<p>There&#8217;s also the question as to who is responsible for informing users. This responsibility should fall squarely on the plugin author. If I was a plugin author and not interested in someone <a href=\"https://wptavern.com/adopt-me-plugin-tag-is-now-in-use-on-wordpress-org\">adopting my plugin</a> and wanted it removed from the directory, I&#8217;d do so by pushing out one last update.</p>
<p>I&#8217;d explain in the plugin&#8217;s description and changelog that support and updates would no longer occur and that users should seek alternatives. I might even suggest a few that come to mind. Then, after about a month, I&#8217;d submit a request to the plugin review team to permanently remove it.</p>
<p>This would give users a heads up and plenty of time to seek out an alternative. The Post Template plugin is a good example of this idea in action. Here is the notice it displayed on all of its settings pages before it disappeared.</p>
<blockquote><p><strong>Since version 4.0.0, the plugin has been released under a commercial license. New features such as addition of custom fields to the templates have been added. Furthermore, this version is discontinued, which means that no further bug fixes, new features and compatibility fixes for new WordPress versions will be implemented. If you want to buy the latest version of Post Template, please visit the plugin web page.</strong></p></blockquote>
<p>By notifying users ahead of time, the responsibility shifts to the user to find an alternative.</p>
<p><a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/page/2/#post-8726059\">Simpon </a>said he&#8217;ll work to get the plugin re-listed but it may take some time as he&#8217;s swamped with work. At the time of publishing, <a href=\"https://wordpress.org/plugins/contact-form-7-to-database-extension/\">the plugin</a> is not available on WordPress.org.</p>
<h2>An Unfortunate Situation for Users of Contact Form DB</h2>
<p>While <a href=\"https://wordpress.org/support/topic/plugin-is-missing-on-the-wordpress-org-directory/page/2/\">users sympathized</a> with Simpson over his decision, I think it&#8217;s partly irresponsible. If a plugin has a security vulnerability, patching it and making it available as soon as possible should take precedence over how one feels about a situation.</p>
<p>Instead of putting aside differences and pushing out an update to patch a security vulnerability, Simpson chose to move the plugin and the patched version to GitHub. The decision not to work with the plugin review team has put thousands of sites at risk with no easy way for users to update.</p>
<p>Hopefully, Simpson will work with the team to get a patched version of Contact Form DB back onto the directory as soon as possible. Until then, if you use Contact Form DB, please <a href=\"https://github.com/mdsimpson/contact-form-7-to-database-extension/releases/tag/v2.10.30\">update to 2.10.30</a> manually as it patches the security vulnerability.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 17 Feb 2017 08:52:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"WPTavern: WPWeekly Episode 263 – Plugins Disappearing, WordCamp Miami, and OSTraining\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=66103&preview=true&preview_id=66103\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"https://wptavern.com/wpweekly-episode-263-plugins-disappearing-wordcamp-miami-and-ostraining\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3129:\"<p>In this episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I discuss the news making headlines including, WordCamp Miami in its 9th year, OSTraining partnering with GoDaddy to release training videos, and why plugins sometimes disappear from the WordPress plugin directory. We also provide an update on the REST API vulnerability that is actively being exploited to deface webpages.</p>
<h2>Stories Discussed:</h2>
<p><a href=\"https://wptavern.com/wordpress-rest-api-vulnerability-exploits-continue\">WordPress REST API Vulnerability Exploits Continue</a><br />
<a href=\"https://wptavern.com/google-changes-the-wording-of-its-wordpress-update-notifications\">Google Webmaster Tools Fixes Confusing Messages About Updating WordPress</a><br />
<a href=\"https://wptavern.com/wordcamp-miami-2017-to-host-javascript-track-ama-spots-and-2-day-kids-camp\">WordCamp Miami 2017 to Host JavaScript Track, AMA Spots, and 2-Day Kids’ Camp</a><br />
<a href=\"https://wptavern.com/ostraining-partners-with-godaddy-to-launch-free-wordpress-beginner-course-on-youtube\">OSTraining Partners with GoDaddy to Launch Free WordPress Beginner Course on YouTube</a><br />
<a href=\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\">Why Plugins Sometimes Disappear From the WordPress Plugin Directory</a></p>
<h2>Plugins Picked By Marcus:</h2>
<p><a href=\"https://wordpress.org/plugins/mobile-featured-image/\">Mobile Featured Image</a> allows users to add a featured image specifically for mobile devices. The new image can be a resized version of your featured image or an entirely new image targeted especially at mobile viewers.</p>
<p><a href=\"https://wordpress.org/plugins/fb-messenger-bot/\">FB Messenger Bot for WooCommerce</a> automatically messages clients from your Facebook page, WooCommerce, or Gravity Forms. The plugin creates a &#8216;send to Facebook&#8217; button at the end of the WooCommerce Sales process or on the Gravity Forms thank you page.</p>
<p><a href=\"https://wordpress.org/plugins/restrict-new-users-by-domain/\">Restrict New Users by Domain </a>makes it easy to whitelist or blacklist email domains that new users can use when registering. If using the whitelist, only new users who enter an email domain on the whitelist will be allowed to create an account. If using the blacklist, a user who enters an email domain on the blacklist will be unable to register.</p>
<h2>WPWeekly Meta:</h2>
<p><strong>Next Episode:</strong> Wednesday, February 22nd 3:00 P.M. Eastern</p>
<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Listen To Episode #263:</strong><br />
</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Feb 2017 23:01:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Post Status: LoopConf in review\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://poststatus.com/?post_type=poststatus_notes&p=33889\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://poststatus.com/loopconf/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:46039:\"<p><a href=\"https://loopconf.com/\">LoopConf</a> is a developer centric conference, and LoopConf &#8220;2.1&#8221; took place in Salt Lake City in early February. This second iteration of the event was a great one, with informative, diverse talks, a laid back atmosphere, and it was very well organized &#8212; which is especially impressive considering the challenges that mother nature caused. As an added bonus, you can now <a href=\"https://www.youtube.com/playlist?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">watch all the talks for free</a>.</p>
<p>Originally planned for Miami last year, LoopConf was postponed due to a hurricane in southern Florida &#8212; hence the &#8220;.1&#8221; above &#8212; and rescheduled closer to organizer Ryan Sullivan&#8217;s home in Salt Lake City. Despite the postponement, most attendees were still able to make it, and some folks (like me) could only go to the newly scheduled event.</p>
<p>Salt Lake City was unseasonably warm, making it a pleasant few days, mixed with great food and company. It was also a pleasure to be able to meet more people from local companies, including the newly minted BlueHost and MOJO headquarters downtown.</p>
<p>Post Status was at LoopConf as a media partner, and <a href=\"https://poststatus.com/profiles/brian-richards/\">Brian Richards</a> and I took a lot of pictures, as well as several video interviews.</p>
<h3>What to know about LoopConf</h3>
<p>In our first video interview, Ryan talked about the origins of LoopConf, and described what he hoped attendees would get out of the event:</p>
<p></p>
<p>I hope to see a future LoopConf 3, and I think the venue and atmosphere worked really well in Salt Lake City.</p>
<h3>A small sampling of valuable talks</h3>
<p>There were many great talks. I didn&#8217;t attend them all, as I was working on other stuff for much of the two days, but the feedback was pretty universally positive, and every talk I did attend, I found valuable.</p>
<h4>The competitive landscape for WordPress</h4>
<p><img /></p>
<p>The first day kicked off with a great talk by Pantheon co-founder Josh Koenig, who spoke on the <a href=\"https://youtu.be/BsKkFf4vDyw?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">competitive landscape for WordPress</a>, including opportunities and risks. It was a really excellent start to the event.</p>
<h4>Empathetic communication</h4>
<p><img /></p>
<p>I met Sharon Steed prior to her talk, and she spoke about <a href=\"https://www.youtube.com/watch?v=Ke9hfBKebxc\">empathetic communication</a>. And due to her own journey as a communicator, going through life with a stutter, it has impacted how she thinks about communication and how she advises her clients.</p>
<p>There were two quotes I loved: &#8220;Technology cannot replace the social aspect of face-to-face communication.&#8221; And, &#8220;Silence kills collaboration.&#8221; I think greater empathy in our ecosystem and society in general is pivotal.</p>
<h3>Put an &#8220;S&#8221; on it</h3>
<p><img /></p>
<p>I don&#8217;t know anyone who knows more about HTTPS than Zack Tollman, who directed the effort to make WIRED&#8217;s website fully HTTPS. They learned many lessons, and he <a href=\"https://youtu.be/McAzEj2iXaA?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">shares them in his outstanding talk</a>.</p>
<h4>Bootstrapping a WordPress business</h4>
<p><img /></p>
<p>The <a href=\"https://poststatus.com/jason-cohen-wp-engine-founder/\">most recent podcast</a> episode featured a video interview and extended audio interview with <a href=\"https://wpengine.com\">WP Engine</a> founder and LoopConf keynote speaker Jason Cohen, which I highly recommend you check out. Jason is full of knowledge, and my interview with him pairs well with his keynote talk.</p>
<p>Jason&#8217;s talk will certainly get you thinking about whether you should raise your prices, that&#8217;s for sure.</p>
<h4>Watch them all!</h4>
<p>Don&#8217;t take my word for which talks to see. I just feature these because I got a lot out of them in the moment. However, in general I found this lineup to be one of the most proficient groups of speakers I&#8217;ve seen yet at a WordPress event.</p>
<p>Check out <a href=\"https://www.youtube.com/playlist?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">the whole playlist</a>.</p>
<h3>Pictures</h3>
<p>Here are pictures from the three days of workshops and talks.</p>

<a href=\"https://poststatus.com/loopconf/loopconf2-0004/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0004-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0008/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0008-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0011/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0011-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0017/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0017-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0018/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0018-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0019/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0019-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0021/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0021-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0028/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0028-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0033/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0033-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0036/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0036-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0039/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0039-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0051/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0051-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0052/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0052-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0053/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0053-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0056/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0056-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0057/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0057-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0062/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0062-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0063/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0063-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0068/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0068-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0075/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0075-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0077/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0077-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0079/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0079-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0086/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0086-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0087/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0087-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0088/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0088-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0091/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0091-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0115/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0115-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0129/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0129-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0135/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0135-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0136/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0136-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0146/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0146-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-0149/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-0149-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1735/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1735-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1746/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1746-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1757/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1757-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1775/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1775-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1778/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1778-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1795/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1795-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1808/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1808-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1809/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1809-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1812/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1812-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1818/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1818-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1819/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1819-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1824/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1824-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1826/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1826-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1831/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1831-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1836/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1836-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1841/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1841-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1854/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1854-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1856/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1856-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1862/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1862-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1868/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1868-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1894/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1894-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1897/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1897-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1911/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1911-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1921/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1921-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1928/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1928-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1936/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1936-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1937/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1937-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1954/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1954-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1968/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1968-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1978/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1978-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1979/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1979-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1983/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1983-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1986/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1986-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1991/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1991-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-1996/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-1996-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2005/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2005-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2015/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2015-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2030/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2030-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2042/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2042-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2043/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2043-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2049/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2049-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2062/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2062-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2079/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2079-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2080/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2080-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2093/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2093-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2103/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2103-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2106/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2106-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2119/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2119-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2151/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2151-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2163/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2163-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2172/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2172-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2180/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2180-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2194/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2194-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2215/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2215-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2240/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2240-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2253/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2253-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2290/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2290-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2291/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2291-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2293/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2293-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2311/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2311-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2330/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2330-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2334/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2334-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2370/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2370-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2377/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2377-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2380/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2380-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2390/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2390-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2413/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2413-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2447/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2447-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2466/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2466-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2487/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2487-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2511/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2511-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2515/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2515-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2517/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2517-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2521/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2521-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2528/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2528-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2531/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2531-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2532/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2532-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2533/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2533-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2536/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2536-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2538/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2538-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2541/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2541-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2542/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2542-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2546/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2546-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2561/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2561-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2570/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2570-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2590/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2590-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2597/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2597-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2599/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2599-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2615/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2615-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2617/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2617-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-2652/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-2652-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9825/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9825-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9826/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9826-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9828/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9828-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9830/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9830-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9831/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9831-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9833/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9833-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9835/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9835-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9837/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9837-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9839/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9839-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9846/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9846-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9848/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9848-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9850/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9850-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9851/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9851-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9859/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9859-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9863/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9863-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9866/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9866-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9868/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9868-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9876/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9876-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9879/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9879-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9885/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9885-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9887/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9887-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9888/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9888-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9892/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9892-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9895/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9895-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9904/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9904-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9905/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9905-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9911/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9911-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9914/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9914-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9929/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9929-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9933/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9933-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9940/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9940-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9941/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9941-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9949/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9949-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9953/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9953-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9956/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9956-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9960/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9960-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9962/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9962-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9965/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9965-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9967/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9967-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9969/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9969-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9970/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9970-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9971/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9971-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9976/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9976-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9993/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9993-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9986/\"><img width=\"100\" height=\"150\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9986-100x150.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>
<a href=\"https://poststatus.com/loopconf/loopconf2-9981/\"><img width=\"150\" height=\"100\" src=\"https://cdn.poststatus.com/wp-content/uploads/2017/02/loopconf2-9981-150x100.jpg\" class=\"attachment-thumbnail size-thumbnail\" alt=\"\" /></a>

<p>You are welcome to use these pictures however you wish. If you&#8217;d like to credit Brian Richards or myself, or Post Status, we&#8217;d appreciate it &#8212; but it&#8217;s not required. Pictures he took show Canon 6D in the meta description, and pictures I took show Canon 70D in the description.</p>
<h3>More interviews from LoopConf</h3>
<p>I&#8217;ll have more interviews from LoopConf over the coming days and weeks. I chatted with several core contributors and developers about specific experiences they&#8217;ve had with WordPress. Keep an eye out for those!</p>
<h3>A fun, niche event with a lot of value</h3>
<p>LoopConf was pretty laid back, and did a lot of things really well.</p>
<p>For one, I&#8217;m super jealous of how quickly they got the videos uploaded, and they&#8217;ve generously made them available for free for everyone. Also, there were no noticeable event hiccups, and the team was always available to help with whatever attendees may need.</p>
<p>The venue itself was really nice, as you can hopefully see in the pictures, and the whole place was laid out in a way that made both the talks and the hallway track highly accessible. And sponsors were in the center of the whole event, which was great.</p>
<p>I found that the size of the event (I&#8217;d guess around 200 people) made it so that conversations were easy to have, and we were able to go in-depth. And because everything from breakfast to dinner to the after party were at the venue, it made everything super convenient.</p>
<p>If and when there&#8217;s a LoopConf 3, you should go! I&#8217;ve also found this general theme to be true at other niche WordPress events &#8212; including <a href=\"https://adayofrest.hm\">A Day of REST</a> (specific to the REST API in WordPress, which you should go to next month!) and <a href=\"https://pressnomics.com\">PressNomics</a> (a WordPress business event, which you should go to in April!), and even my own <a href=\"https://poststatus.com/publish\">Publish</a> event (which may have a second iteration later this year).</p>
<p>To learn more about LoopConf, <a href=\"https://loopconf.com/\">check out the website</a>. And definitely take advantage of all of those <a href=\"https://www.youtube.com/playlist?list=PLod7ww284cBH0DZshlVXRR5XtpaIZXfTF\">free videos</a>!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 16 Feb 2017 20:00:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:125:\"WPTavern: Matt Mullenweg Responds to Security Rant: Digital Signatures for WordPress Updates Are Important but Not a Priority\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66076\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:135:\"https://wptavern.com/matt-mullenweg-responds-to-security-rant-digital-signatures-for-wordpress-updates-are-important-but-not-a-priority\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8422:\"<p>Scott Arciszewski, Chief Development Officer for Paragon Initiative Enterprises, who is most widely known for his <a href=\"https://paragonie.com/blog/2017/02/cryptographically-secure-php-development\">cryptography engineering work</a>, published a post on Medium criticizing Matt Mullenweg, co-creator of the WordPress open-source software project, for not caring enough about security. Arciszewski has since retracted the post but you can <a href=\"http://web.archive.org/web/20170214062414/https://medium.com/@CiPHPerCoder/stopmullware-on-the-security-of-27-of-the-websites-on-the-internet-298a7e5b6871\">read it</a> via the Wayback Machine.</p>
<p>Arciszewski is working on a project known as <a href=\"https://download.libsodium.org/doc/\">libsodium</a>, a core extension to PHP 7.2 which allows for encryption, decryption, signatures, password hashing and more. Its goal is to enable developers to build higher-level cryptographic tools.</p>
<p>WordPress&#8217; automatic update system is handled through api.wordpress.org. Since updates do not have a digital signature, if api.wordpress.org were compromised, attackers could send malicious updates to thousands or millions of sites. This scenario was at the forefront of people&#8217;s minds late last year after Wordfence <a href=\"https://www.wordfence.com/blog/2016/11/hacking-27-web-via-wordpress-auto-update/\">published details</a> of a complex security vulnerability that could have compromised the update servers.</p>
<p>Arciszewski suggests offline code signing and elliptic curve cryptography as solutions, &#8220;The key that can produce a valid signature for a file isn’t stored on the server (only the file itself and a valid signature are), so even if the server gets hacked, attackers can’t just add trojan horse malware to the file,&#8221; he said.</p>
<p><a href=\"http://php.net/manual/en/book.openssl.php\">OpenSSL</a> is an extension of PHP and is commonly used as public-key cryptography but it only supports RSA which Arciszewski deems inadequate. Since WordPress is written in PHP and supports versions 5.2-7+, Arciszewski needed to create a solution that was as compatible. This inspired him to create <a href=\"http://web.archive.org/web/20170214062414/https://github.com/paragonie/sodium_compat\">sodium_compat</a> that adds <a href=\"https://ed25519.cr.yp.to/\">Ed25519 signature verification</a> to WordPress&#8217; automatic updater.</p>
<p>Arciszewski submitted a number of patches to WordPress but was told by Dion Hulse, WordPress core developer, that the sodium_compat library could not be merged into core until it passed a security audit by a third-party. Audits can cost a lot of money so Arciszewski&#8217;s plan was to see if Automattic could take on some of the cost or crowd-source the funds. However, his project was put on hold after Mullenweg informed Hulse to stop working on the feature as it&#8217;s not related to the three core focus areas of the Editor, Customizer, and the REST API.</p>
<p>Arciszewski described the decision as irresponsible and that every user has a reason to be alarmed, &#8220;The WordPress team has shown that they are not responsible enough to govern their impressive ownership of the Internet (with the exception of some folks powerless to correct the organization’s course),&#8221; he said. &#8220;This act of negligence <em class=\"markup--em markup--p-em\">will</em> put the rest of the web in harm’s way.&#8221;</p>
<h2>Update Signing is Important but Not a Priority</h2>
<p>Mullenweg <a href=\"https://medium.com/@photomatt/wordpress-and-update-signing-51501213e1\">responded to the post</a> on Medium.com with one of his own and reiterated the WordPress development team&#8217;s commitment to security.</p>
<p>&#8220;Everyone involved takes their responsibility very seriously, and the growth of WordPress has meant many thoughtful, hard-working people have gotten involved and think of the security of WP sites holistically, from every angle,&#8221; he said.</p>
<p>Mullenweg also clarified what attacks would be stopped by implementing digital signatures to WordPress updates.</p>
<p>&#8220;It could stop a man in the middle attack, where someone modifies the update files on the network in between your blog and WordPress.org, or it could stop a situation where the part of .org that serves the update is compromised but the signing part isn’t, and someone decided to send out updates even though they know they’ll be rejected,&#8221; he said.</p>
<p>The team is unaware of any WordPress sites that have been attacked this way. While the possibility exists, the extent of the damage would likely be limited. The update servers are monitored around the clock and since many large webhosting companies automatically scan their customer&#8217;s sites for malware, the malicious update would likely be discovered quickly.</p>
<p>Mullenweg describes what would happen if an update server was compromised.</p>
<p>&#8220;We would turn it off really quickly, notify the world there was an issue, fix the problem, turn it back on, and notify the specific sites or hosts as able,&#8221; he said. Although WordPress <a href=\"https://w3techs.com/technologies/details/cm-wordpress/all/all\">powers 27.5%</a> of the top 10 million sites tracked by Alexa, it&#8217;s highly unlikely that number of sites would be compromised.</p>
<p>He goes on to say that there are easier ways to compromise a WordPress site and listed the biggest issues to WordPress security based on impact.</p>
<ol class=\"postList\">
<li id=\"6e1f\" class=\"graf graf--li graf-after--p\">Sites not updating core.</li>
<li id=\"8121\" class=\"graf graf--li graf-after--li\">Sites not updating plugins.</li>
<li id=\"9cf6\" class=\"graf graf--li graf-after--li\">Sites not updating themes.</li>
<li id=\"0f5b\" class=\"graf graf--li graf-after--li\">Weak passwords, without brute-force protection or two-factor authentication.</li>
<li id=\"9601\" class=\"graf graf--li graf-after--li\">Hosts (professional or ad-hoc) not scanning and fixing sites.</li>
<li id=\"3b2e\" class=\"graf graf--li graf-after--li\">Hypothetical issues not seen in practice, which distract from the above existing priorities.</li>
</ol>
<p>Mullenweg confirms that he offered to donate to the audit of sodium_compat a day before Arciszewski published his post. Even if the library passed an audit, the code couldn&#8217;t immediately be added to core, &#8220;You would also need to do some significant work on the server-side to isolate the signing from the update server, so it’s worthwhile in the first place,&#8221; he said.</p>
<p>And if the code were added to core, only the sites that updated to the version that has the cryptographic library and the update checking would be able to take advantage of it. WordPress.org would still need to send updates to older versions that don&#8217;t have update checking. These sites would still be vulnerable to receiving a malicious update.</p>
<p>Mullenweg says that digital signatures and update signing will end up in WordPress eventually but it&#8217;s not a priority as there are other security issues in front of it, &#8220;We are prioritizing those issues above a nice-to-have, defense in-depth effort,&#8221; he said.</p>
<p>&#8220;A good approach would be to build the server-side first, because doing that properly, say with an <a href=\"https://en.wikipedia.org/wiki/Hardware_security_module\">HSM</a>, is the difficult and important part; then get the packages signed; then test out verification in a plugin because we don’t want to break auto-updates; and then finally merge into core and set the client to reject non-signed updates. On the client side we need to pick a cryptography library, and get it audited.&#8221;</p>
<p>Mullenweg ended his post explaining why he published his response on Medium instead of his <a href=\"http://ma.tt\">personal site</a>. &#8220;Seems to be the most popular place for rants like this. I also wanted to try out the famous Medium editor,&#8221; he said.</p>
<h2>What&#8217;s Next For sodium_compat</h2>
<p>While the prospects don&#8217;t look good for his library being added to WordPress in 2017, Arciszewski says there are plenty of other PHP projects that could benefit from it, &#8220;For their sake, I’m still strongly inclined to pursue an independent third-party cryptography audit, and attempt to crowd-fund the cost,&#8221; he said.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Feb 2017 23:48:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"BuddyPress: BuddyPress 2.8.0 – “San Matteo”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=263791\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://buddypress.org/2017/02/buddypress-2-8-0-san-matteo/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8634:\"<p>BuddyPress 2.8.0 &#8220;San Matteo&#8221; is now available for download from the WordPress.org plugin repository, or right from your WordPress Dashboard. &#8220;San Matteo&#8221; focuses on various improvement for developers, site builders and site managers.</p>
<h2 class=\"headline-title\">For Developers &amp; Site Builders</h2>
<h3 class=\"headline-title\">Modernizing the Codebase</h3>
<p>To continue the migration of legacy code to modern standards and techniques necessary for the <code>BP REST API</code> project and other new features moving forward, <a href=\"https://codex.buddypress.org/getting-started/buddypress-2-8-will-require-php-5-3/\">BuddyPress 2.8 requires at least PHP 5.3</a>. This will allow us to build better, robust, and secure code, benefiting developers and users now and in the future.</p>
<h3 class=\"feature-title\">More helpful &#8220;Activate Pending Accounts&#8221; screen</h3>
<p><img class=\"size-full wp-image-263800 aligncenter\" src=\"https://buddypress.org/wp-content/uploads/1/2017/02/pending-accounts.png\" alt=\"\" width=\"800\" height=\"500\" /></p>
<p>When you click on the username on the &#8220;Users &gt; Manage Signups&#8221; page, you can now view profile data entered by the user at the time of registration.</p>
<h3 class=\"feature-title\">Support for <code>List-Unsubscribe</code> header in emails</h3>
<p><img class=\"size-full wp-image-263802 aligncenter\" src=\"https://buddypress.org/wp-content/uploads/1/2017/02/list-unsubscribe.png\" alt=\"\" width=\"800\" height=\"500\" /></p>
<p>Allow users to unsubscribe from BuddyPress email notifications in some email clients such as Gmail (web), when properly configured.</p>
<h3 class=\"feature-title\">Twenty Seventeen Companion Style sheet</h3>
<p><img class=\"size-full wp-image-263803 aligncenter\" src=\"https://buddypress.org/wp-content/uploads/1/2017/02/twenty-seventeen.png\" alt=\"\" width=\"800\" height=\"500\" /></p>
<p>BuddyPress looks great in WordPress&#8217;s latest default theme with the new Twenty Seventeen companion style sheet.</p>
<p>To change the default two-column page layout to a full-width layout as seen in the image, add the <a href=\"https://codex.buddypress.org/themes/bp-theme-compatibility-and-the-wordpress-default-themes/twenty-seventeen-theme/\">following code</a> to the <code>functions.php</code> file of your Twenty Seventeen child theme.</p>
<h4 class=\"feature-title\">More hooks for Messages</h4>
<p>We&#8217;ve added new filters and actions for different methods throughout the Messages component.</p>
<h4 class=\"feature-title\">A more flexible Group search</h4>
<p>The new <code>search_column</code> parameter allows developers to specify which columns should be matched, as well as where wildcard characters should be placed, when searching via <code>BP_Groups_Group::get()</code>.</p>
<h4 class=\"feature-title\">Alphabetical sorting for Groups widget</h4>
<p>The groups widget can now be sorted alphabetically, in addition to sorting the results by recently active, popular, and newest groups.</p>
<h4 class=\"feature-title\">Enable choice of <code>PHPMailer</code></h4>
<p>Developers can specify which <code>PHPMailer</code> should be used when sending BuddyPress with a new filter.</p>
<h4 class=\"title\">Localization Improvements</h4>
<p>We continue to improve our localization internals, making it easier for translation editors to ensure that BuddyPress will be available for everyone in their own language.</p>
<h4 class=\"title\">Developer Reference</h4>
<p>Regular updates to inline code documentation make it easier for developers to understand how BuddyPress works.</p>
<h4 class=\"title\">Accessibility Upgrades</h4>
<p>Continued improvements for universal access help make BuddyPress back- and front-end screens usable for everyone (and on more devices).</p>
<p><strong>…and much more!</strong></p>
<p>Read about all the bug fixes and feature enhancements introduced in BuddyPress 2.8.0 at our <a href=\"https://codex.buddypress.org/releases/version-2-8-0/\">official 2.8.0 changelog</a>.</p>
<p><strong>Thank You to Our Contributors</strong></p>
<p>Many, many thanks to all those who contributed during this development cycle. This is a volunteer-run project, and these contributors freely gave of their time and expertise to make BuddyPress better than ever:</p>
<p><a href=\"https://profiles.wordpress.org/dontdream/\">Andrea Tarantini (dontdream)</a>, <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta (ankit-k-gupta)</a>, <a href=\"https://profiles.wordpress.org/angeljs/\">angeljs</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone B Gorges (boonebgorges)</a>, <a href=\"https://profiles.wordpress.org/thebrandonallen/\">Brandon Allen (thebrandonallen)</a>, <a href=\"https://profiles.wordpress.org/bhargavbhandari90/\">Bunty (bhargavbhandari90)</a>,<a href=\"https://profiles.wordpress.org/ketuchetan/\">chetansatasiya (ketuchetan)</a>, <a href=\"https://profiles.wordpress.org/chiragpatel/\">Chirag Patel (chiragpatel)</a>, <a href=\"https://profiles.wordpress.org/danbp/\">danbp</a>, <a href=\"https://profiles.wordpress.org/dcavins/\">David Cavins (dcavins)</a>, <a href=\"https://profiles.wordpress.org/wpdennis/\">Dennis (wpdennis)</a>, <a href=\"https://profiles.wordpress.org/Dianakc/\">Diana K. Cury (Dianakc)</a>, <a href=\"https://profiles.wordpress.org/finzend/\">finzend</a>, <a href=\"https://profiles.wordpress.org/hnla/\">Hugo (hnla)</a>,<a href=\"https://profiles.wordpress.org/jdgrimes/\">J.D. Grimes (jdgrimes)</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby (johnjamesjacoby)</a>, <a href=\"https://profiles.wordpress.org/jonas-lundman/\">Jonas Lundman (jonas-lundman)</a>, <a href=\"https://profiles.wordpress.org/jonieske/\">jonieske</a>, <a href=\"https://profiles.wordpress.org/jreeve/\">jreeve</a>, <a href=\"https://profiles.wordpress.org/lakrisgubben/\">lakrisgubben</a>, <a href=\"https://profiles.wordpress.org/Offereins\">Laurens Offereins (Offereins)</a>, <a href=\"https://profiles.wordpress.org/lgreenwoo/\">lgreenwoo</a>,<a href=\"https://profiles.wordpress.org/maccast/\">maccast</a>, <a href=\"https://profiles.wordpress.org/imath/\">Mathieu Viet (imath)</a>, <a href=\"https://profiles.wordpress.org/mchansy/\">mchansy</a>, <a href=\"https://profiles.wordpress.org/mercime/\">mercime</a>, <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith (tw2113)</a>, <a href=\"https://profiles.wordpress.org/modemlooper/\">modemlooper</a>, <a href=\"https://profiles.wordpress.org/m_uysl/\">Mustafa Uysal (m_uysl)</a>, <a href=\"https://profiles.wordpress.org/nickmomrik/\">Nick Momrik (nickmomrik)</a>, <a href=\"https://profiles.wordpress.org/DJPaul/\">Paul Gibbs (DJPaul)</a>,<a href=\"https://profiles.wordpress.org/pareshradadiya/\">paresh.radadiya (pareshradadiya)</a>, <a href=\"https://profiles.wordpress.org/petya/\">Petya Raykovska</a>, <a href=\"https://profiles.wordpress.org/r-a-y/\">r-a-y</a>, <a href=\"https://profiles.wordpress.org/rekmla/\">rekmla</a>, <a href=\"https://profiles.wordpress.org/espellcaste/\">Renato Alves (espellcaste)</a>, <a href=\"https://profiles.wordpress.org/rogercoathup/\">Roger Coathup (rogercoathup)</a>, <a href=\"https://profiles.wordpress.org/DarkWolf/\">Salvatore (DarkWolf)</a>,<a href=\"https://profiles.wordpress.org/sanket.parmar/\">Sanket Parmar (sanket.parmar)</a>, <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov (slaffik)</a>, <a href=\"https://profiles.wordpress.org/stagger-lee/\">Stagger Lee (stagger-lee)</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar (netweb)</a>, <a href=\"https://profiles.wordpress.org/mahype/\">Sven Wagener (mahype)</a>, <a href=\"https://profiles.wordpress.org/wordpressrene/\">wordpressrene</a>.</p>
<h2>PanuozzoPress</h2>
<p>BuddyPress 2.8 is called &#8220;San Matteo&#8221; after <a href=\"http://www.sanmatteopanuozzo.com/\">a great pizza restaurant</a> in New York City. San Matteo specializes in the &#8220;panuozzo&#8221;, a pizza-sandwich hybrid native to Salerno, Italy. The proprietor of San Matteo is a friendly fellow who insists on speaking Italian even to customers who don&#8217;t understand a word of it. If you find yourself in the neighborhood, be sure to stop by for a great pizza.</p>
<h2>Time to Go Get 2.8.0!</h2>
<p>Grab BuddyPress 2.8.0 &#8220;San Matteo&#8221; from the <a href=\"https://wordpress.org/plugins/buddypress/\">wordpress.org plugin repository</a>, or right from your WordPress Dashboard.</p>
<p><strong>Questions, comments, feature requests, or bug reports?</strong> Please use our <a href=\"https://buddypress.org/support/\">support forums</a> or our <a href=\"https://buddypress.trac.wordpress.org/\">development tracker</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Feb 2017 22:38:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Slava Abakumov\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"HeroPress: Not every hero wears a cape\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1605\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://heropress.com/essays/not-every-hero-wears-cape/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8188:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/02/021517-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Sometimes the biggest heroes are the people who notice that someone else feels out of place, extend their hand, and welcome them in.\" /><h3>I almost didn’t go to my first WordCamp</h3>
<p>I started working with WordPress in 2010. A client requested I use WordPress and a Revolution theme they’d purchased to build their new site. When I was done, I submitted it to the theme showcase, and Brian Gardner reached out to tell me how much he’d liked it.</p>
<p>I continued working with Brian and his themes as Revolution became Revolution 2, and then StudioPress and Genesis. That led to me designing and developing Family Tree, one of the first commercial themes targeted at women entrepreneurs. It was released in May of 2011.</p>
<p>Right around the release of my first theme, Brian asked if I was going to be at WordCamp San Francisco. There was going to be a Genesis Connect event there, and he wanted me to be there. I really wanted to go, but didn’t know how I was going to pull it off.</p>
<p>See, after a years long struggle I had recently been diagnosed with bipolar disorder.</p>
<blockquote><p>I was trying to rebuild my design career with WordPress, but I was really struggling.</p></blockquote>
<p>I felt like flying to San Francisco to see my internet friends was a luxury I couldn’t afford.</p>
<p>But when I mentioned it to my wife, she told me we’d find a way. She started hitting travel sites and found a cheap airline ticket. Then she went on AirBnB and booked me a couch in the lobby of an art gallery in the Tenderloin&#8211;it was the cheapest thing we could find. I left on August 11, 2011, three days before my 40th birthday.</p>
<h3>My first day of WordCamp SF was a nightmare</h3>
<p>I have pretty severe social anxiety, so my plan was to maintain a low profile and keep to myself until I could meet up with some of my Genesis friends. About 20 minutes into the first talk I went to I was totally lost, so I thought I’d sneak out and hit lunch early. It seemed like a solid plan.</p>
<p>My foot had fallen asleep during the presentation, though, and as I stood up to sneak out my ankle buckled and I fell. Every head in the auditorium whipped around to stare at me slowly rolling down the aisle. It was painfully obvious to me that not only did I not belong, but I had just made a very public ass of myself and was mortified.</p>
<h3>Then the WordPress Community stepped in</h3>
<p>There was already a huge crowd in the courtyard when I managed to slink out of the auditorium. I felt like someone had dropped me back into my junior high cafeteria. I stood in the massive line, wanting nothing more than to find a quiet corner to nurse my wounded pride, call my wife, maybe cry a little, and tell her that coming had been a huge waste of time and money.</p>
<blockquote><p>If that’s how my day had panned out, my WordPress story might have been a lot different. Instead, I ran into my first ambassador of the WordPress community.</p></blockquote>
<p>This kind of goofy guy in front of me started chatting me up.</p>
<p>I told him it was my first WordCamp. He asked me where I was from, and we discovered we lived maybe an hour away from each other: me in San Diego, him in Orange County. He invited me to eat lunch with his group. And that’s how I wound up sitting at a table eating lunch with Steve Zehngut and his crew.</p>
<p>These people were more like me: marketers and designers, theme authors and SEO specialists, food bloggers and digital nomads. I started to feel like I might belong there, after all. The phone call I made to my wife after lunch was about how much fun I was having, and how many cool people I was meeting.</p>
<p>Later that day I went to dinner with the crew from Genesis and met even more amazing people I’d only known online. After that, there was a huge Genesis Connect happy hour. The more people I met and talked to, the more friends I made. On Sunday, before one of the final presentations, an auditorium of my new friends sang “Happy Birthday” to me. (I won’t lie&#8211;it was cool but also almost as embarrassing as falling down the first day, lol!)</p>
<h3>One person can make a difference</h3>
<p>If Steve hadn’t asked me to eat lunch with his group that day, I might have never gone to another WordCamp. Instead, when WordCamp San Diego 2012 came around Dre Armeda encouraged me to submit a speaker application, and I gave my first talk. For six years now I’ve spoken at every local WordCamp that’s accepted my speaker application, trying to inspire other people to get and stay involved in our community.</p>
<p>I spent some time looking at the 2011 WCSF attendees list when I was writing this essay. Some of my best friends (and best WordCamp stories) can be directly linked to that list. Even the people I may not have met at that event came into my life because of that event.</p>
<h3>Six degrees of a lunch invitation</h3>
<p>I don’t remember whether or not I met Alex Vasquez in San Francisco, but he’s one of the people who actually wants an honest answer when he asks how I’ve been. I’m pretty sure I didn’t meet Andy Stratton there, but I eventually travelled to Baltimore to speak at the WordCamp he and Drew Poland organized. I’m positive I didn’t cross paths with Karim Marucchi, but he eventually became my boss, mentor, and go-to puppy picture friend. And those are just the connections from one event that happened 6 years ago.</p>
<blockquote><p>WordCamp San Francisco taught me that being a hero doesn’t have to be a huge, dramatic thing.</p></blockquote>
<p>Sometimes the biggest heroes are the people who notice that someone else feels out of place, extend their hand, and welcome them in. Of all of the lessons I’ve learned in WordPress, that’s the most important one. Thanks, Steve!</p>
<p><em>(P.S. If anyone knows where I can find some adult Superman Underoos in stock, LMK. WordCamp San Diego is coming up at the end of March, and I never got Steve a proper thank you gift.)</em></p>
<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Not every hero wears a cape\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Not%20every%20hero%20wears%20a%20cape&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fnot-every-hero-wears-cape%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Not every hero wears a cape\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fnot-every-hero-wears-cape%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fnot-every-hero-wears-cape%2F&title=Not+every+hero+wears+a+cape\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Not every hero wears a cape\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/not-every-hero-wears-cape/&media=https://heropress.com/wp-content/uploads/2017/02/021517-150x150.jpg&description=Not every hero wears a cape\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Not every hero wears a cape\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/not-every-hero-wears-cape/\" title=\"Not every hero wears a cape\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/not-every-hero-wears-cape/\">Not every hero wears a cape</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 15 Feb 2017 12:00:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Chris Ford\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: Open Source Leadership Summit to Live Stream Keynote Sessions February 14-16\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/open-source-leadership-summit-to-live-stream-keynote-sessions-february-14-16\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1865:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/02/open-source-leadership-summit.png?ssl=1\"><img /></a></p>
<p>The Linux Foundation&#8217;s <a href=\"http://events.linuxfoundation.org/events/open-source-leadership-summit\" target=\"_blank\">Open Source Leadership Summit</a> is happening in Lake Tahoe, CA, February 14-16, 2017. The invitation-only event brings together open source technology leaders to collaborate across different projects and share best practices.</p>
<p>The organizers will be live streaming all of the <a href=\"https://osleadershipsummit2017.sched.com/overview/type/Keynote\" target=\"_blank\">keynote sessions</a> for free throughout the three-day event for a total of 17 presentations. A few sample topics and speakers include:</p>
<ul>
<li>State of the Union &#8211; Jim Zemlin, Executive Director of the Linux Foundation</li>
<li>A Conversation with Linus Torvalds (with Jim Zemlin)</li>
<li>State of Blockchain &#8211; Christopher Ferris, CTO of Open Technology, IBM</li>
<li>Security and Privacy in a Hyper-connected World &#8211; Bruce Schneier, Security Expert</li>
<li>Building and Motivating Engineering Teams &#8211; Camille Fournier, Senior Thinker and Raconteur</li>
<li>How Cross-Foundation Collaboration is a Win for Open Source &#8211; Abby Kearns, Executive Director, Cloud Foundry Foundation</li>
</ul>
<p>Anyone who wants to join the keynote sessions via live stream will need to <a href=\"http://events.linuxfoundation.org/events/open-source-leadership-summit/program/live-video-stream\" target=\"_blank\">sign up</a> ahead of the event. The keynotes will be broadcast in Pacific Daylight Time and viewers can return to the signup page to watch live. Viewers are encouraged to use the event&#8217;s official #lfosls hashtag to tweet about the sessions as they are watching.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Feb 2017 06:32:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: Why Plugins Sometimes Disappear From the WordPress Plugin Directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66033\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"https://wptavern.com/why-plugins-sometimes-disappear-from-the-wordpress-plugin-directory\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4548:\"<p>Nearly 50K publicly available plugins call the <a href=\"https://wordpress.org/plugins/\">WordPress plugin directory</a> home but once in awhile a few of them seem to disappear. There is usually a good reason for why this happens but the only information available to the public is a page that says the plugin cannot be found. If the plugin is popular enough, concerned users will <a href=\"https://wptavern.com/contact-me\">contact us</a> and ask to investigate what happened.</p>
<p><a href=\"https://profiles.wordpress.org/ipstenu\">Mika Epstein</a>, Plugin Directory Representative, says there are a number of reasons for why a plugin can end up hidden from view, &#8220;The most well-known, but not the most common, is security issues,&#8221; Epstein said.</p>
<p>&#8220;Plugins are removed and, by default, hidden mostly because we&#8217;re on bbPress 1.0 and there is not as granular a control with post statuses when compared to WordPress itself.&#8221;</p>
<p>The plugin review team has three options to choose from when altering a plugin&#8217;s visibility, active, closed, and disabled. Although rarely used, when a plugin is disabled, it is hidden from view but updates are able to be pushed out.</p>
<p>I asked Epstein why there&#8217;s not more detailed information when a plugin is hidden and the answer is complex, &#8220;The lack of information is partly technical as bbPress 1.0 is limited and partly because we can&#8217;t all agree on the <em>right</em> way to disclose, when to disclose, and when <em>not</em> to disclose,&#8221; she said.</p>
<p>&#8220;Obviously the last thing we want are people getting hacked, but it presents us with a few options and they all have flaws. We&#8217;ve not been able to determine a way to tell people &#8216;This plugin is gone, don&#8217;t use it&#8217; and &#8216;This plugin is gone, but use it if you want.&#8217; without putting users at risk.&#8221;</p>
<p>Epstein uses WooCommerce and Jetpack as examples, &#8220;Let&#8217;s say I close Jetpack today and tell people &#8216;WordPress decided not to support it anymore.&#8217; But tomorrow I close WooCommerce and tell people &#8216;I can&#8217;t tell you why.&#8217; That means an intelligent person knows that WooCommerce is <em>probably</em> vulnerable.&#8221;</p>
<p>It&#8217;s a conundrum without an easy solution. The team typically closes plugins which makes the plugin&#8217;s page disappear. This has the added benefit of making it more difficult to determine if the plugin ever existed. Then the team contacts and works with the developer directly.</p>
<p>Most closures are done with the knowledge of the plugin author as they are often the ones who request that their plugins be closed.</p>
<h2>The New WordPress Plugin Directory Will Modernize Plugin Administration</h2>
<p><a href=\"https://wptavern.com/new-wordpress-plugin-directory-now-in-open-beta\">Announced</a> at WordCamp Europe 2016, the WordPress plugin directory redesign has been in <a href=\"https://wordpress.org/plugins-wp/\">open beta</a> for about eight months.</p>
<img />WordPress Plugin Directory Redesign
<p>In addition to bringing a fresh new look to plugin pages, the migration away from bbPress to WordPress will help make the plugin review team&#8217;s job easier, &#8220;Like far too many things in Plugin Land, everything depends on modernizing the backend to something that is functional.&#8221; Epstein said.</p>
<p>&#8220;Once the new directory is out and I have some more people trained to do reviews properly, then we&#8217;ll have the bandwidth to sit down and really figure out a <strong>best</strong> solution.</p>
<p>&#8220;A stopgap might be making the page say &#8216;This plugin is no longer available.&#8217; But I&#8217;m personally not sure if that would make FUD better or worse.&#8221;</p>
<p>If you discover that a plugin you rely on has suddenly vanished from the directory, don&#8217;t panic. Depending on the issue, plugins usually reappear within a week unless the author has requested that it be closed.</p>
<p>To learn what&#8217;s involved and how the plugin review team does its job, listen to <a href=\"https://wptavern.com/wpweekly-episode-231-an-inside-look-at-the-plugin-review-process-with-mika-epstein\">episode 231</a> of WordPress Weekly. I also encourage you to read our <a href=\"https://wptavern.com/behind-the-scenes-in-the-wordpress-plugin-directory-with-mika-epstein\">detailed interview</a> with Epstein published in 2014, in which most of the information is still accurate.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 14 Feb 2017 03:37:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"WPTavern: WordPress REST API Vulnerability Exploits Continue\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=66011\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wptavern.com/wordpress-rest-api-vulnerability-exploits-continue\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:10607:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2014/04/emergency.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://flic.kr/p/dLUWMb\">Code &#038; Martini</a> by <a href=\"https://www.flickr.com/photos/ivanavasilj/\">Ivana Vasilj</a> &#8211; cc license
<p>It has been nearly two weeks since the WordPress security team <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/\" target=\"_blank\">disclosed</a> an unauthenticated privilege escalation vulnerability in a REST API endpoint in 4.7 and 4.7.1. The vulnerability was patched silently and disclosure was delayed for a week to give WordPress site owners a head start on updating to 4.7.2. Last week <a href=\"https://wptavern.com/wordpress-rest-api-vulnerability-is-being-actively-exploited-hundreds-of-thousands-of-sites-defaced\" target=\"_blank\">hundreds of thousands of vulnerable sites had already been defaced</a> and the damage reports are still rolling in.</p>
<p>Over the weekend the attacks increased and WordPress security firms have seen more attempts blocked by their firewalls. <a href=\"https://sucuri.net/\" target=\"_blank\">Sucuri</a>, the website security firm that reported the vulnerability to WordPress, was tracking the &#8220;Hacked by w4l3XzY3&#8221; campaign last week and estimated 66,000 defacements. That particular campaign has now passed 260,000 pages indexed by Google. It is one of nearly two dozen defacement campaigns targeting the vulnerability.</p>
<p>&#8220;During the past 24 hours we have seen an average growth in defaced pages per campaign of 44%,&#8221; Wordfence CEO Mark Maunder <a href=\"https://www.wordfence.com/blog/2017/02/rapid-growth-in-rest-api-defacements/\" target=\"_blank\">said</a> on Friday. &#8220;The total number of defaced pages for all these campaigns, as indexed by Google has grown from 1,496,020 to 1,893,690. That is a 26% increase in total defaced pages in just 24 hours.&#8221;</p>
<p>Maunder referenced a <a href=\"https://www.google.com/trends/explore?date=2017-01-01%202017-12-31&q=%22Hacked%20By%20MuhmadEmad%22,%22Hacked%20By%20SA3D%20HaCk3D%22,%22by%20w4l3XzY3%22,%22Hacked%20By%20Imam%22,%22Hacked%20By%20BALA%20SNIPER%22\" target=\"_blank\">Google Trends chart</a> which he said demonstrates the success the defacement campaigns have had over the past week. The spike began on the day WordPress disclosed the vulnerability.</p>
<p> &q;</p>
<p>However, White Fir Design, another company that offers security services, <a href=\"https://www.whitefirdesign.com/blog/2017/02/10/unreliable-claim-that-1-5-million-wordpress-pages-defaced-is-reminder-of-the-terribleness-of-security-companiesjournalists/\" target=\"_blank\">disputes Wordfence&#8217;s claims</a> that 1.8 million pages were hacked. The ~2  million pages figure is cited in reports from <a href=\"http://www.bbc.com/news/technology-38930428\" target=\"_blank\">BBC</a>, <a href=\"http://www.theinquirer.net/inquirer/news/3004423/wordpress-hacking-spree-sees-15-million-web-pages-defaced\" target=\"_blank\">The Enquirer</a>, <a href=\"https://arstechnica.com/security/2017/02/virally-growing-attacks-on-unpatched-wordpress-sites-affects-2m-pages/\" target=\"_blank\">Ars Technica</a>, <a href=\"http://www.cio.com/article/3168761/security/recent-wordpress-vulnerability-used-to-deface-1-5-million-pages.html\" target=\"_blank\">CIO.com</a>, and other publications. White Fir Design contends that the hacked pages that have been indexed by Google are not an accurate representation.</p>
<p>Sucuri CTO Daniel Cid also does not fully agree with Wordfence&#8217;s assessment of the situation. After doing some research over the weekend, Sucuri estimates more than 50,000 sites hacked with 20-30 pages per site defaced. This would be roughly a million on the lower end of the estimate and ranges up to 1.5 million.</p>
<p>Sucuri is also starting to see more serious attempts on the REST API vulnerability in the form of <a href=\"https://blog.sucuri.net/2017/02/rce-attempts-against-the-latest-wordpress-rest-api-vulnerability.html\" target=\"_blank\">remote code execution (RCE) attacks</a> on sites using plugins that allow for PHP execution from within posts and pages. One such campaign attempts to inject a PHP include to add content from a compromised site and then inject a backdoor hidden in /wp-content/uploads.</p>
<p>&#8220;Defacements don’t offer economic returns, so that will likely die soon,&#8221; Cid said. &#8220;What will remain are attempts to execute commands (RCE) as it gives the attackers full control of a site – and offers multiple ways to monetize – and SPAM SEO / affiliate link / ad injections. We are starting to see them being attempted on a few sites, and that will likely be the direction this vulnerability will be misused in the coming days, weeks and possibly months.&#8221;</p>
<p>Hackers are targeting any sites that haven&#8217;t updated to 4.7.2 &#8211; there doesn&#8217;t seem to be any pattern among them. A quick look at the Google results for the most active campaigns shows that compromised sites include blogs, media, government, education, sports, medical, and technology websites.</p>
<h3>Why the REST API is Enabled by Default</h3>
<p>The WordPress REST API is enabled by default, as the plan is for more admin and plugin functionality to rely on the REST API in the future. After the recent attacks, several users <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/#comment-32110\" target=\"_blank\">commented</a> on the vulnerability disclosure to ask why it is enabled by default.</p>
<p>&#8220;The security issue is in a feature I do not use on any of my sites (REST API) and yet still, this feature is first enabled by default and second since WordPress 4.7 you even need a plugin – which could introduce further security issues – to disable the feature?&#8221; one user (@helios2121) <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/#comment-32123\" target=\"_blank\">commented</a> on the post. &#8220;Please rethink your approach to security. Make features that not everyone needs opt-in. Or <em>at least</em> give a way to opt out without requiring additional plugins.&#8221;</p>
<p>Morten Rand-Hendriksen opened a trac ticket to discuss <a href=\"https://core.trac.wordpress.org/ticket/39806#ticket\" target=\"_blank\">disabling the REST API by default</a> and only enabling it when the site admin requests it, or a theme or plugin is dependent on it.</p>
<p>Core Committer Sergey Biryukov confirmed that the plan is to introduce more core functionality that relies on REST API. &#8220;Turning off the REST API is like turning off admin-ajax.php — both will break your site,&#8221; Biryukov said.</p>
<p>Rand-Hendriksen asked why the content endpoints cannot be protected by default while allowing the REST API to be on by default for admin purposes. Another user asked why the Users endpoint isn&#8217;t protected by default (i.e. <a href=\"https://news.microsoft.com/wp-json/wp/v2/users\" target=\"_blank\">https://news.microsoft.com/wp-json/wp/v2/users</a> or <a href=\"https://www.obama.org/wp-json/wp/v2/users\" target=\"_blank\">https://www.obama.org/wp-json/wp/v2/users</a>), which &#8220;makes it easier than ever to get all the usernames&#8221; on any site using 4.7+.</p>
<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/02/users-endpoint.png?ssl=1\"><img /></a></p>
<p>&#8220;If you really want to disable the REST API on your site(s), this is our current recommendation: restrict it to authenticated users,&#8221; Core Committer James Nylen said. &#8220;However, we want to continue to increase adoption and usage of the REST API, and I expect that even this modification will break more and more WP functionality as time goes on, such as API-driven themes and embeds.&#8221;</p>
<p>Nylen recommends the <a href=\"https://wordpress.org/plugins/disable-json-api/\" target=\"_blank\">Disable JSON API</a> plugin for those who want to follow that recommendation on sites using WordPress 4.7+. The plugin currently has more than 10,000 active installs.</p>
<p>The WordPress security team worked diligently to mitigate the attacks by helping hosts and security firms put protections in place before the issue was made public. However, the <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/\" target=\"_blank\">full disclosure of the vulnerability</a> was buried on the Make/Core blog, a site that is not widely read among regular WordPress site owners. The link to the disclosure was published as an addendum to <a href=\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\" target=\"_blank\">the previous post</a> on the WordPress news blog a week later.</p>
<p>&#8220;While I appreciate the responsible disclosure of this issue and the effort to resolve it, I hope you consider making future announcements via a new post on the WordPress News site, rather than just appending an update to a previous post,&#8221; user @johnrork <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/#comment-32105\" target=\"_blank\">commented</a> on the official disclosure. &#8220;I am probably not the only one who could have avoided being compromised had this shown up as a new item in my RSS reader on Wednesday.&#8221;</p>
<p>Those who read the Make blogs had a head start on fixing their own sites and/or their clients&#8217; sites. Those who depend on the WordPress news blog for information on security updates probably read the post when it was initially published and never returned to see the update a week later. An issue this severe warranted WordPress&#8217; transparency in a new post on its news blog. This would have also automatically sent out a tweet to more than half a million followers on the official WordPress account and the Facebook account which has more than a million likes.</p>
<p>Fortunately, the number of vulnerable sites that also have plugins that could allow attackers to piggyback on this vulnerability is a much smaller number. Defaced sites are embarrassing but easy to fix. In most cases administrators need only update to 4.7.2 and roll back the defaced posts to the most recent revision. Most site owners have no idea how fast exploits begin to pop up after public disclosure, but this situation provided a gentle reminder of the importance of updating WordPress and the benefit of leaving automatic updates on.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 13 Feb 2017 22:59:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: 10up Unveils ElasticPress.io: Elasticsearch as a Service for WordPress Sites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65981\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"https://wptavern.com/10up-unveils-elasticpress-io-elasticsearch-as-a-service-for-wordpress-sites\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7053:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/elasticpress-logo.png?ssl=1\"><img /></a></p>
<p><a href=\"https://10up.com\" target=\"_blank\">10up</a> launched <a href=\"https://www.elasticpress.io/\" target=\"_blank\">ElasticPress.io</a> this week, its new Elasticsearch SaaS product with plans starting at $299/month. <a href=\"https://github.com/elastic/elasticsearch\" target=\"_blank\">Elasticsearch</a> is an open source, distributed search engine that speeds up searching by using JSON documents to store data in indices. The indices store mapping fields to the corresponding documents and the engine searches the index instead of a site&#8217;s entire database.</p>
<p>Elasticsearch can perform near-real-time searches and is highly scalable, but the setup is technically demanding. It is used by many large companies, such as GitHub, Soundcloud, Etsy, Netflix, Cisco, and Samsung. It is also one of the most popular enterprise search engines for WordPress sites, as searching WordPress tables with thousands or even millions of records is simply not going to be fast.</p>
<p>The WordPress plugin directory has a dozen plugins for using and extending Elasticsearch but 10up&#8217;s <a href=\"https://wordpress.org/plugins/elasticpress/\" target=\"_blank\">ElasticPress</a> is by far the most popular with more than a thousand installs. After supporting the plugin for several years, along with many enterprise clients using Elasticsearch, 10up decided to create a hosted service that integrates with ElasticPress.</p>
<p>&#8220;The reason we created this solution for our clients, and that we’re now making this public, is that we don’t think anyone has provided a super easy, end-to-end (plugin to hosted service) that offers all of the benefits of Elasticsearch and our ElasticPress plugin, while being completely agnostic to your site hosting,&#8221; 10up founder Jake Goldman said.</p>
<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/elasticpress.png?ssl=1\"><img /></a></p>
<p>ElasticPress.io is an end-to-end solution that is specifically tailored for those using the ElasticPress plugin. This is one of the key differences between managing your own Elasticsearch infrastructure with a service like AWS. ElasticPress.io controls both the hosting and the plugin, allowing the service to optimize performance for both.</p>
<p>&#8220;There are a number of really neat use cases for ElasticPress on our roadmap that add either risk (security) or headaches (complicated setup and management procedures) if you can’t control both ends,&#8221; Goldman said. &#8220;For instance, there are optional Elasticsearch modules (just like there are optional Apache and Nginx modules) for features like indexing media that many hosted Elastic services don’t enable by default or support. We also want to be able to index and handle content that isn’t public, and many hosted Elastic services aren’t locked down / secured end-to-end with the website by default.&#8221;</p>
<h3>How ElasticPress.io&#8217;s Pricing Compares to Competitors</h3>
<p><a href=\"https://www.elastic.co/\" target=\"_blank\">Elastic</a>, the creators of Elasticsearch were one of the first companies to launch Elasticsearch as a service in 2012. Two years later the company raised $70 million in a Series C funding round. Dozens of other Elasticsearch as a service companies have sprouted up since then, with pricing ranging from under $20 to tens of thousands of dollars depending on the resources offered.</p>
<p>The ElasticPress.io service is the first of its kind in the WordPress ecosystem. Most hosting companies do not have it built into their enterprise level plans. WordPress.com VIP is one of the few that offers Elasticsearch for sites on its <a href=\"https://vip.wordpress.com/our-services/#hosting-plans\" target=\"_blank\">plans</a> which range from $5,000 &#8211; $25,000 per month. WP Engine has an Elasticsearch solution as part of its <a href=\"https://wpengine-labs.com/\" target=\"_blank\">Labs program</a>, which is based on a fork of ElasticPress. However, the solution has not yet been officially added to the company&#8217;s enterprise plans.</p>
<blockquote class=\"twitter-tweet\">
<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/10up\">@10up</a> <a href=\"https://twitter.com/mgibbs189\">@mgibbs189</a> <a href=\"https://twitter.com/cabgfx\">@cabgfx</a> <a href=\"https://twitter.com/sbangnielsen\">@sbangnielsen</a> <a href=\"https://twitter.com/SearchWP\">@SearchWP</a> ElasticPress plus lower cost providers is still extremely powerful for under $12 a month</p>
<p>&mdash; Scott Kingsley Clark (@scottkclark) <a href=\"https://twitter.com/scottkclark/status/830165095045033984\">February 10, 2017</a></p></blockquote>
<p></p>
<p>For the most part, developers who have to implement Elasticsearch for a WordPress site are faced with hosting their own instance and managing it themselves. This is the most cost effective option but comes with a great deal more responsibility.</p>
<p>&#8220;Elasticsearch is a quickly evolving platform, and they don’t exactly have the same commitment to infinite backwards compatibility that WordPress has these days,&#8221; Goldman said. &#8220;Major Elasticsearch upgrades can break old integrations. That means the site owner needs to either worry about automatic version upgrades breaking their site, or has to manage their upgrades carefully. By controlling the integration with Elastic on the website site and controlling the hosting, we can carefully handle version upgrades for customers while making sure nothing breaks.&#8221;</p>
<p>10up is aiming at the higher end of the market where customers are looking for convenience and access to the creators of ElasticPress for support. Goldman anticipates many of those customers will be similar to the product&#8217;s existing customers who simply need a robust keyword search or related content engine that will &#8220;just work.&#8221; ElasticPress.io is also targeting smaller and mid-tier businesses that are experiencing performance bottlenecks with WordPress&#8217; native query engine.</p>
<p>&#8220;Those customers are typically relying on rather complicated faceting / filtering of content, the classic use-case being a WooCommerce store where customers are constantly filtering on a handful of unique (unique = hard to cache) meta data all the time,&#8221; Goldman said. &#8220;That’s where ElasticPress really shines: our native WooCommerce support and optimization take those very taxing queries and makes them lightning fast.&#8221;</p>
<p>As the service is fairly unique in the WordPress space, ElasticPress.io&#8217;s <a href=\"https://www.elasticpress.io/#pricing\" target=\"_blank\">pricing</a> has room to evolve as 10up learns from its customers. The plans currently range from $299 &#8211; $999 per month with increasing storage space and tiered support response times. Goldman said they haven&#8217;t ruled out other pricing points and may explore more pricing options in the future.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Feb 2017 06:33:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"Post Status: Jason Cohen, founder of WP Engine, on growing your company well — Draft Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=33802\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://poststatus.com/jason-cohen-wp-engine-founder/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2499:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. In this episode, I interview <a href=\"https://twitter.com/asmartbear\">Jason Cohen</a>, the founder of WP Engine and current CTO.</p>
<p>I talked to Jason about a whole lot of things, mostly to do with growing well. Whether you&#8217;re growing revenue, company size, or personal development &#8212; this is a conversation about growth, and how to do it well.</p>
<p>Unlike many entrepreneurs in the WordPress space, WP Engine isn&#8217;t Jason&#8217;s first business. He&#8217;s done this before, and made plenty of mistakes. He talks about what he&#8217;s done differently at WP Engine and how its made him a happier person.</p>
<p>This interview took place at LoopConf, and <a href=\"https://www.youtube.com/watch?v=b_CmkUT25BE\">Jason was a keynote presenter</a>. His LoopConf talk pairs well with our discussion.</p>
<p>You can catch the first segment on video, and the entire conversation is on the audio podcast.</p>
<p></p>
<!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->
<a href=\"https://audio.simplecast.com/60233.mp3\">https://audio.simplecast.com/60233.mp3</a>
<p><a href=\"https://audio.simplecast.com/60233.mp3\">Direct Download</a></p>
<h3>Links</h3>
<ul>
<li><a href=\"https://wpengine.com/\">WP Engine</a></li>
<li><a href=\"https://loopconf.com/\">LoopConf</a></li>
<li><a href=\"https://blog.asmartbear.com/\">Jason&#8217;s blog</a></li>
</ul>
<h3>Sponsor: iThemes</h3>
<p>This episode is sponsored by <a href=\"https://ithemes.com/?utm_source=post_status&utm_medium=banner&utm_campaign=ps_ads\">iThemes</a>. The team at iThemes offers WordPress plugins, themes and training to help take the guesswork out of building, maintaining and securing WordPress websites. For more information, check out their <a href=\"https://ithemes.com/?utm_source=post_status&utm_medium=banner&utm_campaign=ps_ads\">website</a> and thank you to iThemes for being a Post Status partner.</p>
<p><em>Photo by Brian Richards for Post Status</em></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 Feb 2017 04:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"WPTavern: In Case You Missed It – Issue 17\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=65984&preview=true&preview_id=65984\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wptavern.com/in-case-you-missed-it-issue-17\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:8994:\"<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png?ssl=1\" rel=\"attachment wp-att-50955\"><img /></a>photo credit: <a href=\"http://www.flickr.com/photos/112901923@N07/16153818039\">Night Moves</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>There’s a lot of great WordPress content published in the community but not all of it is featured on the Tavern. This post is an assortment of items related to WordPress that caught my eye but didn’t make it into a full post.</p>
<h2>Interviewed for WordPress.tv</h2>
<p>A few weeks ago, Marcus Couch and I were interviewed by John Parkinson. Parkinson is a volunteer moderator and performs community outreach for WordPress.tv. In the interview, we discuss the benefits of WordPress.tv, the WordPress community, WordCamps, and more. I encourage you to check out his <a href=\"https://blog.wordpress.tv/tag/interview/\">other community interviews</a> as well.</p>
<p></p>
<h2 class=\"selectionShareable\">WooCommerce and WordPress Used to Sell Stress Cubes</h2>
<p>CNBC has <a href=\"http://www.cnbc.com/2017/01/30/a-24-year-old-made-345000-by-beating-kickstarters-to-market.html\">an interesting story</a> that features a 24-year-old who made $345K in two months selling <a href=\"https://stresscube.com/\">Stress Cubes</a>, a knock-off of the Fidget Cube. The Fidget Cube raised <a href=\"https://www.kickstarter.com/projects/antsylabs/fidget-cube-a-vinyl-desk-toy\">nearly 6.5M dollars</a> in crowdfunding money.</p>
<p>The Fidget Cube experienced significant delays in shipping due to manufacturing issues. The 24-year-old contacted suppliers in China, purchased 1,000 plastic cubes, created a similar product, and shipped it to market before the Fidget Cube had a chance to reach backers. He used WordPress and WooCommerce to sell Stress Cubes grossing him nearly $350K in two months.</p>
<h2>Why WordPress in Education</h2>
<p>Jared Bennett <a href=\"https://dev.commons.hwdsb.on.ca/2017/02/08/why-wordpress-in-education/\">explains</a> how the <a href=\"http://www.hwdsb.on.ca/\">Hamilton Wentworth District School Board</a> uses WordPress.  &#8220;We run over 100 individual school websites on a WordPress Multisite Network, and back in May of 2011, we launched the HWDSB Commons: a second Multisite Network which now hosts over 8,000 blogs for over 30,000 users,&#8221; Bennett said.</p>
<p>Bennett <a href=\"https://github.com/hwdsbcommons/\">shares links</a> to plugins the team created to solve specific issues such as comment moderation in BuddyPress and blocking specific modules in Jetpack. Since WordPress is free as in beer, it allows his school board to spend public money in a more responsible way.</p>
<p>&#8220;In the WordPress ecosystem we operate in, I pay for functionality to be developed, and I share it openly on platforms like the WordPress plugin repository, or on sites like <a href=\"https://github.com/hwdsbcommons/\">Github,</a>&#8221; Bennett said.</p>
<p>&#8220;The money you would have spent to enable the previously developed functionality, you can now spend on something else, something that I might benefit from. Think about how much more responsible this model is, particularly when we are talking about spending public money.</p>
<p>&#8220;We are all contributing; and the community benefits from those contributions; and our money — and the functionality of our platforms — improves exponentially faster than if we were all spending our money paying the private company over and over for code that has already been paid for by previous customers.&#8221;</p>
<p>To learn more about WordPress in education, listen to <a href=\"https://wptavern.com/wpweekly-episode-261-wordpress-for-schools-with-cameron-barrett\">episode 261</a> of WordPress Weekly where we interview Cameron Barrett, founder of <a href=\"http://schoolpress.co/\">SchoolPresser, LLC</a>. Barrett explains how he negotiated and helped migrate Newark New Jersey’s public school system from a proprietary CMS to WordPress.</p>
<h2>WP101 Plugin Now Has WooCommerce and Jetpack Videos</h2>
<p>The <a href=\"https://wp101plugin.com/\">WP101 plugin</a> has added Jetpack and WooCommerce training videos. This is in addition to the Yoast SEO and WordPress training videos.</p>
<blockquote class=\"twitter-tweet\">
<p lang=\"en\" dir=\"ltr\">Huge update for our WP101 Plugin! It now includes WooCommerce and Jetpack videos. That’s 90 videos for your clients! <a href=\"https://t.co/6jtzj1JgkC\">https://t.co/6jtzj1JgkC</a> <a href=\"https://t.co/CByYvd61Xi\">pic.twitter.com/CByYvd61Xi</a></p>
<p>&mdash; WordPress 101 (@WP101) <a href=\"https://twitter.com/WP101/status/829455708802408452\">February 8, 2017</a></p></blockquote>
<p></p>
<h1 class=\"entry-title\">Adding Meta Fields to a Widget Sidebar Section</h1>
<blockquote class=\"twitter-tweet\">
<p lang=\"en\" dir=\"ltr\">Example for how to add meta fields/controls to a widget sidebar section in the customizer: <a href=\"https://t.co/aMadLioQn6\">https://t.co/aMadLioQn6</a> <a href=\"https://twitter.com/hashtag/javascript?src=hash\">#javascript</a> <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a></p>
<p>&mdash; Weston Ruter ⚡ (@westonruter) <a href=\"https://twitter.com/westonruter/status/829799276976828417\">February 9, 2017</a></p></blockquote>
<p></p>
<h2>WP Sessions Developer Survey</h2>
<p>WP Sessions is conducting a <a href=\"http://wpsessions.com/developer-survey/\">developer survey</a> to find out about the tools developers use. Results will be anonymized and shared in aggregate in a few weeks.</p>
<h2>Widget Logic Has a New Maintainer</h2>
<p><a href=\"https://wordpress.org/plugins/widget-logic/\">Widget Logic</a>, a popular plugin actively installed on more than 300K sites, has a <a href=\"https://profiles.wordpress.org/wpchefgadget/\">new maintainer</a> named <a href=\"https://profiles.wordpress.org/wpchefgadget/#content-plugins\">WPChef</a>. The plugin was created nine years ago by <a href=\"https://profiles.wordpress.org/alanft/\">Alanft</a>. Prior to WPChef gaining commit access, the last time Widget Logic was updated was <a href=\"https://plugins.trac.wordpress.org/browser/widget-logic/tags/0.57?rev=1592418\">two years ago</a>.</p>
<p>After gaining access, WPChef released Widget Logic 5.7.0. This version fixed a PHP 7 compatibility issue, a conflict with WPML, added a new default load logic point, and a Ukrainian translation. In addition to bug fixes, a global admin notice to install Limit Login Attempts Reloaded was also added. Limit Login Attempts Reloaded is a separate plugin owned and maintained by WPChef.</p>
<p><img />Limit Login Attempts Reloaded Admin NoticeThe wording of the notice and appearing globally caused some users to <a href=\"https://wordpress.org/support/topic/incorrect-widget-logic-team-security-recommendation/\">be concerned</a> or upset. Some users responded to the update by <a href=\"https://wordpress.org/support/plugin/widget-logic/reviews/?filter=1\">writing 1-star reviews</a>. After a user <a href=\"https://wordpress.org/support/topic/taking-over-and-forking-this-plugin/#post-8781763\">described the notice</a> as sounding like fake news, WPChef changed it.</p>
<h2>From SupportPress to Help Scout!</h2>
<p>The WordPress.org community team is moving away from <a href=\"https://supportpress.com/\">SupportPress</a> to Help Scout. The move opens up a number of possibilities as Help Scout offers a lot of features that are non-existent in SupportPress.</p>
<blockquote class=\"wp-embedded-content\"><p><a href=\"https://make.wordpress.org/community/2017/02/09/moving-from-supportpress-to-help-scout/\">Moving from SupportPress to Help Scout</a></p></blockquote>
<p></p>
<h2>Plush Wapuu!</h2>
<p>In what is a traditional part of this series, I end each issue by featuring a Wapuu design. For those who don&#8217;t know, Wapuu is the <a href=\"http://wapuu.jp/2015/12/12/wapuu-origins/\">unofficial mascot</a> of the WordPress project.</p>
<blockquote class=\"twitter-tweet\">
<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/hashtag/Wapuu?src=hash\">#Wapuu</a> army is taking over <a href=\"https://twitter.com/hashtag/WordCamp?src=hash\">#WordCamp</a> US <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f60d.png\" alt=\"😍\" class=\"wp-smiley\" /><a href=\"https://twitter.com/hashtag/wcus?src=hash\">#wcus</a> <a href=\"https://twitter.com/hashtag/wcus2016?src=hash\">#wcus2016</a> <a href=\"https://t.co/Giyt3KFsnF\">pic.twitter.com/Giyt3KFsnF</a></p>
<p>&mdash; Musannif (@mzahir) <a href=\"https://twitter.com/mzahir/status/805133225127510016\">December 3, 2016</a></p></blockquote>
<p></p>
<p>This plush Wapuu which was given away at WordCamp US 2016 as part of the event&#8217;s swag was a huge hit with attendees and their children. I have one myself and the quality is superb.</p>
<p>That&#8217;s it for issue seventeen. If you recently discovered a cool resource or post related to WordPress, please share it with us in the comments.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Feb 2017 22:16:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"BuddyPress: BuddyPress 2.8.0 Release Candidate 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=263679\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://buddypress.org/2017/02/buddypress-2-8-0-release-candidate-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1158:\"<p>BuddyPress 2.8.0 Release Candidate 1 is now available for testing. Please <a href=\"https://downloads.wordpress.org/plugin/buddypress.2.8.0-RC1.zip\">download the 2.8.0-RC1 zip</a> or get a copy via our Subversion repository.</p>
<p>This is our last chance to find any bugs that slipped through the beta process. So please test with your themes and plugins. We plan to release BuddyPress 2.8.0 next Wednesday, February 15.</p>
<p>A detailed changelog will be part of our official release notes, but you can get a quick overview by reading the post about the <a href=\"https://buddypress.org/2017/01/buddypress-2-8-0-beta-1/\">2.8.0 Beta 1</a> release.</p>
<p>Release Candidate means we are in string freeze, so translators should feel confident in finishing their BuddyPress translations in <a href=\"https://translate.wordpress.org/projects/wp-plugins/buddypress\">GlotPress</a>.</p>
<p>Let us know of any issues you find in <a href=\"https://buddypress.org/support\">the support forums</a> and/or on <a href=\"https://buddypress.trac.wordpress.org\">our development tracker</a>.</p>
<p>Thanks in advance for giving the release candidate a test drive!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Feb 2017 20:51:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Slava Abakumov\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"WPTavern: Creative Commons’ New Search Tool is Now in Beta, Pulls CC Images from Multiple Sources\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65809\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:106:\"https://wptavern.com/creative-commons-new-search-tool-is-now-in-beta-pulls-cc-images-from-multiple-sources\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5467:\"<p>If you&#8217;ve been wearing out Unsplash images on your blog, it&#8217;s time to take another look at Creative Commons. The site has just <a href=\"https://creativecommons.org/2017/02/07/new-cc-search/\" target=\"_blank\">launched the beta</a> of its new multi-source search interface. Unlike the <a href=\"https://search.creativecommons.org/\" target=\"_blank\">current search tool</a>, which will only search one source by sending the visitor offsite, <a href=\"https://ccsearch.creativecommons.org/\" target=\"_blank\">CC Search</a> loads the results from multiple sources onsite.</p>
<p>The Commons includes approximately 1.1 billion works in various formats &#8211; literary works, videos, photos, audio, scientific research, and other formats. As half of these works are estimated to be images, the prototype for the new search tool focuses on this format.</p>
<p>&#8220;Our goal is to cover the whole commons, but we wanted to develop something people could test and react to that would be useful at launch,&#8221; Creative Commons CEO Ryan Merkley said. &#8220;To build our beta, we settled on a goal to represent one percent of the known Commons, or about 10 million works, and we chose a vertical slice of images only, to fully explore a purpose-built interface that represented one type but many providers.&#8221;</p>
<p>CC Search currently pulls CC-licensed images from Rijksmuseum, Flickr, 500px, the New York Public Library, and the Metropolitan Museum of Art. This includes 200,000 new images from the collection of <a href=\"https://creativecommons.org/2017/02/07/met-announcement/\" target=\"_blank\">375,000 digital works that the Met released under CC0</a> this week.</p>
<p>In addition to the new search interface, the beta includes social tools that allow users to curate and share their own lists, add tags and favorites, and save searches. One-click attribution is built in, making it easy for users to properly attribute the works.</p>
<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/cc-search.png?ssl=1\"><img /></a></p>
<p>As Creative Commons is a small organization and fairly lean on resources, the new search was built by a single contractor over seven months. Software engineer Liza Daly was selected to <a href=\"https://hackernoon.com/cc-search-developer-notes-and-reflection-418271194682#.6f8mudh02\" target=\"_blank\">research and build a proof-of-concept for CC Search</a>, a project which she understood to be &#8220;a front door to the universe of openly licensed content.&#8221;</p>
<p>&#8220;CC Search is meant to make material more discoverable regardless of where it is hosted,&#8221; Daly said. &#8220;For this reason (and for obvious cost-saving objectives), we decided to host only image metadata — title, creator name, any known tags or descriptions — and link directly to the provider for image display and download. A consequence of this is that CC Search only includes images which are currently available on the web; CC is not collecting or archive any images itself.&#8221;</p>
<p>Daly built the search feature on AWS cloud infrastructure using Python, Django, Postgres, and Elasticsearch. The beta has estimated hosting costs of $1,400/month. She opted for Python, because she was most familiar with it.</p>
<p>&#8220;As the prototype evolved, we decided the opportunity for an engaging front door to the Commons lay in curation and personalization,&#8221; Daly said. &#8220;Because of its dedicated maintenance team and frequent patch management, I chose Django as the web framework.&#8221; She chose Elasticsearch over Solr (and other options) primarily because of the AWS’s Elasticsearch-as-a-service.</p>
<p>&#8220;CC Search is not, at this time, a particularly sophisticated search application; image metadata is relatively simple and when dealing with a heterogeneous content set from a diversity of providers, one tends towards a lowest-common-denominator approach — our search can only be as rich as our weakest data source,&#8221; Daly said. &#8220;There is much to be improved here.&#8221;</p>
<p>Daly also described an interesting idea for adding a blockchain-type architecture that would record licensing transactions, sharing, and gratitude in a distributed way. This idea falls outside of the scope of the MVP but may be something the project&#8217;s future developers will consider when implementing the final version.</p>
<p>&#8220;A long-term goal of this project is to facilitate not only search and discovery, but also reuse and &#8216;gratitude,\'&#8221; Daly said. &#8220;A frequent complaint about open licenses in general — both for creative works and software code — is that contributing to the commons can be a thankless task. There are always more consumers than contributors, and there’s no open web equivalent to a Facebook &#8216;like.\'&#8221;</p>
<p>Other future improvements that the team will consider based on user feedback include adding more content partners, more tools for customizing lists, allowing users to search from their own curated material, and giving trusted users the ability to push metadata back into the collection. Search filters may also be expanded to allow for searching by color, drilling down into tags, and searching public lists.</p>
<p>Check out the beta for the new CC Search at <a href=\"https://ccsearch.creativecommons.org/\" target=\"_blank\">ccsearch.creativecommons.org</a>.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 Feb 2017 05:42:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: Google Webmaster Tools Fixes Confusing Messages About Updating WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65787\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"https://wptavern.com/google-changes-the-wording-of-its-wordpress-update-notifications\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4148:\"<p>In 2009, <a href=\"https://webmasters.googleblog.com/2009/11/new-software-version-notifications-for.html\">Google announced</a> it would send notifications via <a href=\"https://www.google.com/webmasters/tools/\">Webmaster Tools</a> to site owners that new versions of software are available E.g. Joomla, Drupal, or WordPress.</p>
<p>WordPress 4.7.2 <a href=\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\">was released</a> at the end of January. It patched a critical security vulnerability with the REST API that is <a href=\"https://wptavern.com/wordpress-rest-api-vulnerability-is-being-actively-exploited-hundreds-of-thousands-of-sites-defaced\">being actively exploited</a> in the wild. Site owners who updated to 4.7.2 are <a href=\"https://productforums.google.com/forum/?hl=en#!category-topic/webmasters/QwkXrbyzKBA\">receiving Google Alerts</a> that their sites are out of date.</p>
<blockquote><p>Recommended WordPress update available for<span dir=\"ltr\"><a>http://www.example.com/</a></span></p>
<div dir=\"ltr\">
<div>
<p>To: Webmaster of <span dir=\"ltr\"><a>http://www.example.com/</a></span>,</p>
<p>Google has detected that your site is currently running WordPress 4.7.0 or 4.7.1, an older version of WordPress. Outdated or unpatched software can be vulnerable to hacking and malware exploits that harm potential visitors to your site. Therefore, we suggest you update the software on your site as soon as possible.</p>
<p>Following are one or more example URLs where we found pages that have outdated software. The list is not exhaustive.</p>
<p dir=\"ltr\"><a href=\"https://www.example.com/123/\" target=\"_blank\" rel=\"nofollow\">https://www.example.com/123/</a></p>
<p dir=\"ltr\"><a href=\"https://www.example.com/456/\" target=\"_blank\" rel=\"nofollow\">https://www.example.com/456/</a></p>
<p dir=\"ltr\"><a href=\"https://www.example.com/789/\" target=\"_blank\" rel=\"nofollow\">https://www.example.com/789/</a></p>
</div>
</div>
</blockquote>
<p dir=\"ltr\">Some of the people who received notices thought the email was a phishing attempt as WordPress is misspelled using a lower-case p. Others <a href=\"https://productforums.google.com/d/msg/webmasters/QwkXrbyzKBA/z_4hg5s5BwAJ\">expressed confusion and anxiety</a> receiving notices despite having already updated their sites.</p>
<p dir=\"ltr\">WordPress powered sites contain a meta generator that Google uses to detect which version is running.</p>
<p dir=\"ltr\">&lt; meta name=&#8221;generator&#8221; content=&#8221;WordPress 4.7.1&#8243; /&gt;</p>
<p dir=\"ltr\">However, Google does not monitor pages in real-time. If a site owner updates to WordPress 4.7.2 but the page indexed by Google is running 4.7.1, they&#8217;ll receive a notice.</p>
<p dir=\"ltr\">Juan Felipe Rincón, Webmaster Outreach at Google, <a href=\"https://productforums.google.com/d/msg/webmasters/QwkXrbyzKBA/25QwebHfBwAJ\">responded </a>to the forum thread and confirmed the issues reported by users, &#8220;Definitely a problem on our end,&#8221; Rincón said.</p>
<p dir=\"ltr\">&#8220;We&#8217;re sorry for causing confusion in the messaging and for the swirl this created for many of you and your users or client base.&#8221;</p>
<p dir=\"ltr\">Google was aware that notices would be sent to site owners who already updated but chose to send them anyway due to the seriousness of the vulnerability.</p>
<p dir=\"ltr\">&#8220;However, we underestimated the number of sites that had already patched, and our messaging gave no room for interpretation or letting website owners know that if they had already upgraded they could ignore the message safely,&#8221; Rincón said.</p>
<p dir=\"ltr\">Google has implemented the following changes to improve its update notification system:</p>
<ul>
<li dir=\"ltr\">Messages have stopped being delivered for now but will resume shortly.</li>
<li dir=\"ltr\">The messages have been reworded to be clearer.</li>
<li dir=\"ltr\">Additional checks have been added to reduce the number of notifications sent to owners who already updated.</li>
</ul>
<p>If you&#8217;ve updated WordPress to 4.7.2, you can safely disregard the notices.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Feb 2017 23:55:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: WordCamp Miami 2017 to Host JavaScript Track, AMA Spots, and 2-Day Kids’ Camp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65831\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:95:\"https://wptavern.com/wordcamp-miami-2017-to-host-javascript-track-ama-spots-and-2-day-kids-camp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4451:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/wordcamp-miami-2017.png?ssl=1\"><img /></a></p>
<p><a href=\"https://2017.miami.wordcamp.org/\" target=\"_blank\">WordCamp Miami</a> is sporting an 80&#8217;s theme this year for its 9th year running. The team of 12 organizers is expecting more than 800 attendees and will host 60+ local and global speakers, including new speakers from India, Australia, Poland, Canada, and other international locations.</p>
<p>As in previous years, WordCamp Miami is a multi-day smorgasbord of WordPress networking and educational opportunities with workshops for all ages. The event is bringing back the two-day Kids&#8217; Camp and Kids&#8217; Panel it hosted last year. David Bisset, one of the organizers, is expecting approximately 50 attendees and said the team is seeing an even greater increase of parents and kids than previous years, based on more kids&#8217; tickets being purchased earlier.</p>
<p>This year the Kids&#8217; Camp will focus on blogging and coding and children will even get their own attendee bags. Kids will also receive free hosting and a free domain name, thanks to a donation from a sponsor. The <a href=\"https://2017.miami.wordcamp.org/2017/01/17/speaker-call-opening-for-kids/\" target=\"_blank\">call for speakers for kids</a> aged 7-18 is now open.</p>
<p>WordCamp Miami will be hosting three workshops on the Friday leading up to the main event: a Beginner&#8217;s workshop, a Freelance workshop, and the WP REST API / BuddyCamp workshop. This is the fifth consecutive year for BuddyCamp and attendees will have the opportunity to learn more about building mobile applications with BuddyPress and the WordPress REST API.</p>
<p>The &#8220;Learn JavaScript Deeply&#8221; track is returning in 2017, featuring local and international JS developers. So far WordCamp Miami is the only camp to have an entire track devoted to JavaScript. Organizers have designed the format of the track to be duplicated by other camps that want to include more JS content.</p>
<p>The event&#8217;s organizers usually attempt to get &#8220;<a href=\"https://2017.miami.wordcamp.org/2017/02/03/why-its-important-for-outside-the-bubble-perspectives-at-wordcamps/\" target=\"_blank\">outside the WordPress bubble</a>&#8221; by inviting speakers with experience in other platforms to share with attendees. This year&#8217;s lineup includes two sessions from members of the Drupal and Joomla communities. Mike Herchel, a front-end web developer at Lullabot, will present a session titled “WordPress &amp; Drupal: Community and Contribution Differences and Lessons.” Aleksander Kuczek, CEO of Perfect Dashboard and a Joomla Extension Directory team member, will be speaking about how Joomla handles plugin contributions.</p>
<p>Other focus topics during the main event include customizing/extending WordPress, e-commerce, mental health, content marketing, and building a better business (from freelancers to agencies). Organizers have also reduced the time for speakers a little in order to introduce some &#8220;AMA&#8221; spots. The new format will feature prominent people in the community who will be available to simply answer questions from attendees. The guests for the AMA spots are still being finalized, but Bisset said one example is a representative from Sucuri and will be available to answer any questions regarding security.</p>
<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/02/rate-my-talk.gif?ssl=1\"><img /></a>WordCamp Miami will also debut the &#8220;<a href=\"http://davidbisset.com/results-of-my-live-rate-my-talk-with-emoji-at-wpcampus/\" target=\"_blank\">Rate My Talk With Emoji</a>&#8221; app that Bisset developed for attendees to give &#8220;live speaker feedback&#8221; while sessions are happening. He said the team is hoping to have the speakers decide on which emoji should be available, but if there are problems with pre-event testing they will pre-select emoji. At this time they are not planning on including any negative ones. Speakers will have access to their results after the conference.</p>
<p>WordCamp Miami would not be possible without the event&#8217;s army of volunteers. Bisset said organizers are still looking for <a href=\"http://davidbisset.us6.list-manage2.com/subscribe?u=8f9242549d66d09eceb714b54&id=046ea0475e\" target=\"_blank\">volunteers</a> to help out before and during the event.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Feb 2017 20:22:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"WPTavern: OSTraining Partners with GoDaddy to Launch Free WordPress Beginner Course on YouTube\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65805\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://wptavern.com/ostraining-partners-with-godaddy-to-launch-free-wordpress-beginner-course-on-youtube\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4409:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/ostraining-logo.png?ssl=1\"><img /></a></p>
<p><a href=\"https://www.ostraining.com\" target=\"_blank\">OSTraining</a> has launched a free <a href=\"https://www.youtube.com/playlist?list=PLtaXuX0nEZk-rRfsl8lclMY5TncDmAUBm\" target=\"_blank\">40-video WordPress Beginner course</a> on YouTube, thanks to a sponsorship from GoDaddy. The open source software education site has created more than 3,000 videos for PHP platforms like WordPress, Joomla, Magento, and Drupal. This particular course, which has all new information for WordPress 4.7, was inspired by the company&#8217;s success in launching a free Drupal 8 course in 2016.</p>
<p>&#8220;The original idea was a happy accident,&#8221; CEO Steve Burge said. &#8220;We did a <a href=\"https://www.kickstarter.com/projects/stevebure/drupal-8-training-videos-help-us-make-drupal-magic\" target=\"_blank\">Kickstarter project</a> based around the launch of Drupal 8. That involved about 200 free videos, spread over several classes. The main class was &#8216;The Drupal 8 Beginner class&#8217; and it went viral, getting over <a href=\"https://www.ostraining.com/blog/news/1-million/\" target=\"_blank\">1 million views in a year</a>.&#8221;</p>
<p>The Kickstarter campaign raised more than $12K towards its $10K funding goal. It was the first time OSTraining produced a free course. Once the videos were released, Burge and his team were amazed by how popular the course became.</p>
<p>&#8220;It led us to re-think our business approach,&#8221; Burge said. &#8220;Rather than putting everything behind a paywall, we realized the power of giving away our best beginner material. From a business perspective, that made sense so long as we could find a sponsor.&#8221;</p>
<p>OSTraining worked with Topher DeRosia to film the WordPress Beginner course after securing a sponsorship from GoDaddy. Although the company has done multiple versions of its beginner class over the years, with updates for changes in each release, WordPress 4.7 presents a new opportunity for content longevity.</p>
<p>&#8220;We hope that by targeting 4.7 this class will last longer than most, because the new release cycle means a new version won&#8217;t be here in a couple of months,&#8221; Burge said.</p>
<p>In addition to beginner topics like how to install WordPress, write posts, and use the media library, the course also includes information on getting started with WordPress plugins like NinjaForms and Jetpack. The last few videos cover more advanced topics like security, spam, staging, and performance.</p>
<p>Although the <a href=\"https://www.youtube.com/channel/UCpJf6LGZ0a4n9Lj4aVt9spg/\" target=\"_blank\">official WordPress YouTube channel</a> doesn&#8217;t have much educational content for beginners, the WordPress community in general is gaining a stronger presence on YouTube. Searching for &#8220;WordPress&#8221; turns up more than five million videos in many different languages. Educational topics like &#8220;How to make a WordPress website&#8221; and other tutorials are the most popular.</p>
<p>WordPress businesses are also starting to see the value of having a solid presence on YouTube. Last year Automattic started beefing up its <a href=\"https://www.youtube.com/channel/UCvP5cfpfIgkb0Dt8o7Qt21A\" target=\"_blank\">channel</a> with a steady stream of new videos, including ads and tutorials for WordPress.com. Other large WordPress companies like <a href=\"https://www.youtube.com/user/iThemescom\" target=\"_blank\">iThemes</a>, <a href=\"https://www.youtube.com/user/wpbeginner/\" target=\"_blank\">WPBeginner</a>, and <a href=\"https://www.youtube.com/user/yoastcom/\" target=\"_blank\">Yoast</a> are publishing hundreds of free videos to YouTube, generating millions of views and thousands of subscribers.</p>
<p>After finding success on YouTube with the free Drupal 8 videos, OSTraining has also launched a free <a href=\"https://www.youtube.com/playlist?list=PLtaXuX0nEZk9eL59JGE3ny-_GAU-z5X5D\" target=\"_blank\">Magento 2</a> course and has a free Joomla course on the way.</p>
<p>&#8220;Getting more than 1 million views of the Drupal class really opened our eyes,&#8221; Burge said. &#8220;It&#8217;s almost like the difference between free, open source software and expensive, closed source software. You can reach so many more people by giving it away free.&#8221;</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Feb 2017 05:48:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"Dougal Campbell: Good Breakdown of Recent WordPress Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"http://dougal.gunters.org/?p=81297\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://dougal.gunters.org/blog/2017/02/08/good-breakdown-of-recent-wordpress-vulnerability/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2977:\"<div class=\"featured-image align-right\"><img width=\"150\" height=\"150\" src=\"http://dougal.gunters.org/wordpress/wp-content/uploads/2008/10/wordpress-wednesday-150x150.png\" class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\" alt=\"\" /></div><p>The <a href=\"https://blog.sucuri.net/\">Sucuri Blog</a> has a good dissection of the recent critical <a href=\"https://blog.sucuri.net/2017/02/content-injection-vulnerability-wordpress-rest-api.html\">WordPress REST API vulnerability</a>. I won&#8217;t rehash the details here, but I did want to point out that this is why developers should remember to follow these two rules of defensive programming:</p>
<ol>
<li>Sanitize inputs as early as possible</li>
<li>Sanitize outputs as late as possible</li>
</ol>
<p>In this case, there was a failure to follow the first rule. There are a couple of different places where this could have been handled better.</p>
<p>For one, unless there is a good reason to allow <strong><code>GET</code></strong> or <strong><code>POST</code></strong> variables to override a URL placeholder parameter, then that should be handled appropriately. If there is a reason for it, then those values should be forced to comply with the regular expression or data type that is expected.</p>
<p>The other failure, beyond simple sanitizing, is that the logic of the <strong><code>update_item_permission_check()</code></strong> method simply didn&#8217;t properly account for the failure to retrieve a valid result from <strong><code>get_post()</code></strong>. This function will return post data either as an object or an array (depending on parameters), or <strong><code>null</code></strong> upon failure. The logic of the first conditional was looking for a valid post <em>and</em> invalid permissions on the post as an error condition:</p>
<pre><code>if ( $post &amp;&amp; ! $this-&gt;check_update_permission( $post ) ) {
    return new WP_Error( \'rest_cannot_edit\', 
        __( \'Sorry, you are not allowed to edit this post.\' ), 
        array( \'status\' =&gt; rest_authorization_required_code() ) );
}</code></pre>
<p>Instead, it should have reversed the valid post logic, and looked for <em>not</em> a valid post, <em>or</em> invalid permissions:</p>
<pre><code>if ( <strong>! $post ||</strong> ! $this-&gt;check_update_permission( $post ) ) {
    return new WP_Error( \'rest_cannot_edit\', 
        __( \'Sorry, you are not allowed to edit this post.\' ), 
        array( \'status\' =&gt; rest_authorization_required_code() ) );
}</code></pre>
<p>And for good measure, it should probably check whether the return value was an instance of <strong><code>WP_Error</code></strong>, for future-proofing. This small change would have detected an invalid post ID, and still performed a valid permissions check for existing posts.</p>
<p>Okay boys and girls, let&#8217;s say it all together now&#8230; &#8220;Security is hard.&#8221;</p>
<p>&nbsp;</p>
<div class=\"yarpp-related-rss yarpp-related-none\">
</div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Feb 2017 01:46:17 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Dougal Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: WPWeekly Episode 262 – Interview With Morten Rand-Hendriksen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=65818&preview=true&preview_id=65818\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/wpweekly-episode-262-interview-with-morten-rand-hendriksen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2668:\"<p>On this episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"https://mor10.com/\">Morten Rand-Hendriksen</a> to discuss his <a href=\"https://mor10.com/the-case-for-wordpress-telemetry/\">WordPress Telemetry proposal</a>. We discuss the potential benefits of having an opt-in usage data collection system that could help core developers and others make informed decisions. Rand-Hendriksen also shares what he&#8217;s learned from <a href=\"https://www.lynda.com/Morten-Rand-Hendriksen/725535-1.html\">teaching WordPress</a> at Lynda.com, on how difficult it is for new users to grasp WordPress.</p>
<h2>Stories Discussed:</h2>
<p><a href=\"https://wptavern.com/blogvault-security-breach-infects-customers-sites-with-malware\">BlogVault Security Breach Infects Customers’ Sites With Malware</a><br />
<a href=\"https://wptavern.com/wordpress-rest-api-vulnerability-is-being-actively-exploited-hundreds-of-thousands-of-sites-defaced\">WordPress REST API Vulnerability is Being Actively Exploited, Hundreds of Thousands of Sites Defaced</a><br />
<a href=\"https://wptavern.com/wp-super-cache-1-4-9-patches-multiple-xss-vulnerabilities\">WP Super Cache 1.4.9 Patches Multiple XSS Vulnerabilities</a></p>
<h2>Plugins Picked By Marcus:</h2>
<p><a href=\"https://wordpress.org/plugins/content-locker/\">Content Locker</a> is a tool that allows you to configure content to be behind a paywall. Visitors can pay for content by liking, sharing, or registering an account.</p>
<p><a href=\"https://wordpress.org/plugins/wp-jump/\">WP Jump</a> allows you to bookmark your site in the admin bar. This plugin is useful if you have several, local or online, WordPress installations.</p>
<p><a href=\"https://wordpress.org/plugins/sidebar-content-clone/\">Sidebar Content Clone</a> is a handy solution for easily duplicating or cloning all widgets from one sidebar to another sidebar. It can also clear all widgets from a sidebar with a single click.</p>
<h2>WPWeekly Meta:</h2>
<p><strong>Next Episode:</strong> Wednesday, February 15th 3:00 P.M. Eastern</p>
<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Listen To Episode #262:</strong><br />
</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 09 Feb 2017 01:03:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: WP Super Cache 1.4.9 Patches Multiple XSS Vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65664\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/wp-super-cache-1-4-9-patches-multiple-xss-vulnerabilities\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2318:\"<p><a href=\"https://wordpress.org/plugins/wp-super-cache/\">WP Super Cache</a> is a <a href=\"https://odd.blog/2007/11/05/wordpress-super-cache-01/\">nearly 10-year-old</a> plugin that is maintained by <a href=\"https://odd.blog/\">Donncha Ó Caoimh</a> and is actively installed on more than a million sites. Releases have been far and few between, but Ó Caoimh <a href=\"https://odd.blog/2017/02/03/wp-super-cache-1-4-9/\">has released</a> WP Super Cache 1.4.9 that patches cross-site-scripting vulnerabilities on the settings page.</p>
<p>&#8220;Those pages are only accessible by admin users so an anonymous visitor to your site can’t come along and enable it to steal your login cookies but along with those fixes come many bug fixes so it’s worth upgrading if you’re using an old version,&#8221; Ó Caoimh said.</p>
<p>In addition to patching security vulnerabilities, this release also contains a number of bug fixes. There&#8217;s <a href=\"https://github.com/Automattic/wp-super-cache/pull/174\">also a fix</a> in this version for those who host a lot of sites that use WP Super Cache and are running into issues with semaphores due to the possibility of users using file locking.</p>
<p>If you&#8217;re running into this issue and need to disable file locking completely, Ó Caoimh suggests setting the WPSC_DISABLE_LOCKING constant in a global config file. &#8220;The file locking simply slowed down how fast cache files were created and is a hold-over from WP Cache when that plugin used to write directly to the cache files,&#8221; Ó Caoimh said.</p>
<p>&#8220;This plugin writes to temporary files before moving to the final cache files so that locking isn’t really needed, but some sites still use it which is why it’s still around.&#8221;</p>
<p>Ó Caoimh is already hard at work on the next version of WP Super Cache with an effort towards <a href=\"https://github.com/Automattic/wp-super-cache/pull/177\">moving legacy cache files</a> into supercache directories. This will improve performance and make the files easier to maintain.</p>
<p>Users are encouraged to update to 1.4.9 as soon as possible. To see a detailed list of changes and bug fixes, visit the <a href=\"https://wordpress.org/plugins/wp-super-cache/changelog/\">plugin&#8217;s changelog</a>.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Feb 2017 04:26:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: WordPress for Android Closes Google+ Community for Beta Testers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65699\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wptavern.com/wordpress-for-android-closes-google-community-for-beta-testers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2616:\"<p>The WordPress mobile app for Android is <a href=\"https://plus.google.com/u/0/+MaximeBiais/posts/8M796fTin9Q?cfem=1\" target=\"_blank\">shutting down its beta testing community</a> that was hosted on Google+ for the past three years. The mobile team switched to a completely open beta last year, enabling them to recruit 1,500 new testers.</p>
<p>The Google+ community, which currently has 1,152 members, has been the main channel for communication to and from the app&#8217;s developers. It was previously used to announce new beta versions and users posted regularly to confirm bugs, leave feedback on their experiences, and ask questions about upcoming features.</p>
<p>&#8220;We kept this Google+ Community opened since then but it became a place for spammers,&#8221; Automattic mobile engineer Maxime Biais said. &#8220;We decided to close it.&#8221;</p>
<p>Beta testers who want to continue participating are encouraged to use the open source project&#8217;s issue tracker on <a href=\"https://github.com/wordpress-mobile/WordPress-Android\" target=\"_blank\">GitHub</a>. Testers can also join the #mobile channel on <a href=\"https://make.wordpress.org/chat/\" target=\"_blank\">WordPress Slack</a>. Any testers who want to lave the beta can visit the app&#8217;s testing page and tap &#8220;<a href=\"https://play.google.com/apps/testing/org.wordpress.android\" target=\"_blank\">Leave the Test</a>,&#8221; followed by uninstalling and then re-installing the app from the Play Store to get the official stable version.</p>
<p>Despite having a healthy troop of beta testers, the open source app rarely receives any contributions from developers outside of Automattic. <a href=\"https://wptavern.com/wordpress-for-android-5-7-adds-path-to-upgrade-wordpress-com-plan\" target=\"_blank\">Recent releases</a> have included an expansion of Automattic&#8217;s monetization path with a link for users to manage and upgrade their WordPress.com plans. This has added fuel to the friction between the needs of self-hosted sites and the presence of WordPress.com features.</p>
<p>Community members who have voiced complaints about the current features and goals of the app are welcome to participate in its development on GitHub. Beta testing is still open to all and new testers can <a href=\"https://play.google.com/apps/testing/org.wordpress.android\" target=\"_blank\">opt in on the Google Play Store testing page</a>. The Google+ Community will close on March 6, 2017, but questions and feedback are welcome in the #mobile Slack channel where the app&#8217;s developers are frequently available.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 08 Feb 2017 03:22:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"WPTavern: Google Updates AMP to Allow Sharing of Canonical URL\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65660\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"https://wptavern.com/google-updates-amp-to-allow-sharing-of-canonical-url\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4925:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2016/04/reading.jpg?ssl=1\"><img /></a><a href=\"https://stocksnap.io/photo/F55691D3FB\">RC Cipriano</a>
<p>One of the main drawbacks of Google <a href=\"https://www.ampproject.org/\" target=\"_blank\">AMP</a> has been brand confusion when viewing and sharing articles. Google launched the AMP project to speed up the mobile web, but in exchange publishers have had to give up control of how their AMP&#8217;d content appears. One of the most irksome aspects of interacting with AMP pages is the convoluted URL structure, which causes users to be hesitant to share the content.</p>
<p>AMP appends google.com/amp/ to the beginning of the URL when copying the link, opening it in a browser, or sharing an article. Visitors who want to find the canonical URL have to return to Google to search for it. To the casual observer, it appears the visitor has landed on and is attempting to share a Google story.</p>
<p>After nearly a year, Google is finally looking to remedy this sharing problem with an update to the AMP Viewer header. In a <a href=\"https://developers.googleblog.com/2017/02/whats-in-amp-url.html\" target=\"_blank\">post</a> on the Google Developers blog, the company officially recognized this problem and announced a change that will allow visitors to share the canonical URL:</p>
<blockquote><p>Many users have requested a way to access, copy, and share the canonical URL of a document. Today, we&#8217;re adding support for this functionality in form of an anchor button in the AMP Viewer header on Google Search. This feature allows users to use their browser&#8217;s native share functionality by long-tapping on the link that is displayed.
</p></blockquote>
<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/02/google-amp-sharing-link.png?ssl=1\"><img /></a>photo credit: Google
<p>The updated header with the anchor button is already available on the iOS Google app and will be coming to the Android app within a few weeks. Google is also working on using the <a href=\"https://developers.google.com/web/updates/2016/10/navigator-share\" target=\"_blank\">Web Share API</a> to let visitors use the platform&#8217;s native sharing flow with the original URL instead of the AMP viewer URL.</p>
<p>&#8220;A thriving ecosystem is very important to us and attribution, user trust, and ownership are important pieces of this ecosystem,&#8221; Alex Fischer, Google software engineer, said.</p>
<p>The ability to share the canonical URL is good news for existing AMP users but is probably not enough to convince skeptical publishers to start AMPing up their pages. Burying the publisher&#8217;s canonical link is just one of many reasons there has been such strong push back against the AMP project.</p>
<p>Kyle Schreiber, whose post on <a href=\"https://80x24.net/post/the-problem-with-amp/\" target=\"_blank\">the problems with AMP</a> inspired discussions on <a href=\"https://news.ycombinator.com/item?id=13414570\" target=\"_blank\">Hacker News</a> and <a href=\"https://www.reddit.com/r/programming/comments/5oggtm/the_problem_with_amp/\" target=\"_blank\">Reddit</a>, believes that &#8220;AMP is bad for the open web and should be changed or eliminated.&#8221;</p>
<p>Schreiber contends that Google has designed AMP to keep the visitor within its own ecosystem. Publishers get locked in when access to Google&#8217;s news carousel is reserved for AMP&#8217;d sites only.</p>
<p>&#8220;Clicking on an AMP link feels like you never even leave the search page, and links to AMP content are displayed prominently in Google’s news carousel,&#8221; Schreiber said.</p>
<p>Last year the <a href=\"https://www.wsj.com/articles/google-amp-gets-mixed-reviews-from-publishers-1477648838\" target=\"_blank\">Wall Street Journal</a> spoke with publishers who were critical with AMP but reluctant to speak publicly for fear of Google&#8217;s retaliation. Their AMP pages were generating around half as much revenue as pageviews on their full mobile sites due to Google&#8217;s limitations on the type of ad units available for AMP pages. Google&#8217;s response was that the company aims to drive more revenue to non-AMP pages but isn&#8217;t quite there yet.</p>
<p>At the end of February the AMP project experiment will have been publicly launched for a year but many smaller publishers are still hesitant to get on board. They are concerned that AMP oversteps its reach without delivering enough value in return. The strategy of taking an absurd amount of control over publishers&#8217; content and then slowly doling it back out (as with the new button for sharing the canonical URL) demonstrates how easily Google has established itself as the de facto arbiter of the mobile web. If publishers continue to yield control of their mobile content, Google will have every incentive to make AMP support the next official ranking signal.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Feb 2017 18:58:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"HeroPress: Hitting Rock Bottom\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1592\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://heropress.com/essays/hitting-rock-bottom/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5441:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/02/020817-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: We all need someone to listen. Someone to remind us that it gets better. That we will make it to tomorrow.\" /><p>I’d never been to The Capital Grille. I’d been to nice steak houses before, but this felt like a big deal. At least it should have. I was too busy freaking out because my wife wasn’t responding to one of my texts. That’s when I knew I hit rock bottom. That mental illness had taken full control. Ruining a $50 steak will make you realize that.</p>
<p>I hit my rock bottom in the middle of WordCamp Orlando 2016. Sitting across from the wonderful Mike Hansen, sharing the best mashed potatoes I’d ever had, I was miserable. Not because Mike was bad company, but because I was so inside my head that I couldn’t control my thoughts. Dark thoughts. Suicidal thoughts. I was a mess, but Mike and the rest of the crew from BlueHost tried to keep me calm and engaged in conversation. I kept apologizing, but they stuck with me. It was pretty obvious I wasn’t okay, and they did their best. That’s what WordPress is. When you hear about “the community,” that’s what we’re really talking about.</p>
<p>The next day, I was originally scheduled to speak, but had already backed out. As an organizer of the event, I felt awful. I know how much of a pain it is to rearrange the schedule last-minute because I’m the one, at least for the past 3 years, has made Orlando’s schedule. But the team rallied around me.</p>
<blockquote><p>They knew I wasn’t okay, and supported me without me needing to ask.</p></blockquote>
<p>But then something amazing happened.</p>
<p>In the confusion of rescheduling speakers &#8211; caused by Hurricane Matthew, not Hurricane Mental Illness &#8211; a replacement speaker for one of our workshops had never actually been notified that he was speaking and didn’t show. Whoops. Even though I’d planned to just lay low in the developer workshop all day, as soon as I got word that a replacement was needed, I grabbed my laptop and headed to the next room. I don’t remember much of what I said, but I gave a talk on themes completely off the top of my head. And then it hit me. I know what I’m doing. I can do this. I’m going to be okay.</p>
<h3>Road To Recovery</h3>
<p>The next day, I went to see my doctor. I was diagnosed as bipolar. The dragon I’d been fighting for 15 years finally had a name. Two prescriptions later and I was on the road to recovery. I’m still on it, but WordPress is helping drive the engine.</p>
<p>Since WordCamp Orlando, my business has taken off. I’ve started and completed more projects in the past 3 months than I did the entire rest of 2016. And all of that was possible because of the support I received that weekend. When we talk about how wonderful the WordPress community really is, we mean it. It saves lives.</p>
<p>There’s a lot more to my story &#8211; coming out as non-binary, a shuttering business partnership to salvage a great friendship &#8211; but I don’t want to ramble.</p>
<blockquote><p>It’s time to pay the support I received forward.</p></blockquote>
<p>We all need someone to listen. Someone to remind us that it gets better. That we will make it to tomorrow.</p>
<p>If you’re struggling, drop me a line on <a href=\"https://twitter.com/adamsoucie\">Twitter</a> or send an email. I’ll be waiting on the other end to lend an ear and a helping hand.</p>
<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Hitting Rock Bottom\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Hitting%20Rock%20Bottom&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fhitting-rock-bottom%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Hitting Rock Bottom\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fhitting-rock-bottom%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fhitting-rock-bottom%2F&title=Hitting+Rock+Bottom\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Hitting Rock Bottom\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/hitting-rock-bottom/&media=https://heropress.com/wp-content/uploads/2017/02/020817-150x150.jpg&description=Hitting Rock Bottom\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Hitting Rock Bottom\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/hitting-rock-bottom/\" title=\"Hitting Rock Bottom\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/hitting-rock-bottom/\">Hitting Rock Bottom</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Feb 2017 12:00:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Adam Soucie\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:110:\"WPTavern: WordPress REST API Vulnerability is Being Actively Exploited, Hundreds of Thousands of Sites Defaced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65651\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:120:\"https://wptavern.com/wordpress-rest-api-vulnerability-is-being-actively-exploited-hundreds-of-thousands-of-sites-defaced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5617:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/needle.jpg?ssl=1\"><img /></a>photo credit: stevendepolo <a href=\"http://www.flickr.com/photos/10506540@N07/3020361085\">hypodermic needle IMG_7418</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>
<p>At the end of January, <a href=\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\" target=\"_blank\">WordPress 4.7.2</a> was released to fix four security issues, three of which were disclosed at the time of the release. These included a SQL injection vulnerability in WP_Query, a cross-site scripting (XSS) vulnerability in the posts list table, and the Press This feature allowing users without permission to assign taxonomy terms. The fourth and most critical issue, an unauthenticated privilege escalation vulnerability in a REST API endpoint, was fixed silently and <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/\" target=\"_blank\">disclosed a week after the release</a>.</p>
<p>Contributors on the release opted to delay disclosure in order to mitigate the potential for mass exploitation, given that any site running 4.7 or 4.7.1 is at risk. This allowed time for users to update manually and for automatic updates to roll out.</p>
<p>&#8220;We believe transparency is in the public’s best interest,&#8221; WordPress Core Security Team Lead Aaron Campbell said. &#8220;It is our stance that security issues should always be disclosed. In this case, we intentionally delayed disclosing this issue by one week to ensure the safety of millions of additional WordPress sites.&#8221;</p>
<p>WordPress worked with <a href=\"https://sucuri.net/\" target=\"_blank\">Sucuri</a>, the company that discovered the issue, along with other WAF vendors and hosting companies to add protections before the vulnerability was publicly disclosed.</p>
<p>The vulnerability has been public for less than a week and is now being actively exploited. Thousands of WordPress sites have been defaced with messages like “<a href=\"https://wordpress.org/support/topic/wordpress-4-7-1-hacked-by-ng689skw/\" target=\"_blank\">Hacked by NG689Skw</a>” or &#8220;Hacked by w4l3XzY3&#8221; or similar. Googling for information about these particular hacks returns thousands of other hacked sites in the results.</p>
<p>Sucuri founder and CTO Daniel Cid said his team saw exploits in the wild less than 24 hours after the disclosure. The attacks are primarily simple defacements so far.</p>
<p>&#8220;There are some good bad guys updating the post excerpt with the message: &#8216;Update WordPress or you will be hacked,&#8217; which is kind weird,&#8221; Cid said. &#8220;But overall we&#8217;re seeing just simple defacement attempts, using modified versions of the exploit that was shared publicly.&#8221;</p>
<h3>Multiple Campaigns Have Defaced Hundreds of Thousands of WordPress Sites</h3>
<p>Sucuri is monitoring multiple defacement campaigns, each with varying degrees of success. The company <a href=\"https://blog.sucuri.net/2017/02/wordpress-rest-api-vulnerability-abused-in-defacement-campaigns.html\" target=\"_blank\">published an update</a> on the active attacks as well as the IP addresses they are originating from.</p>
<p>&#8220;We are currently tracking four different hacking (defacement) groups doing mass scans and exploits attempts across the internet,&#8221; Cid said. &#8220;We see the same IP addresses and defacers hitting almost every one of our honeypots and network.&#8221;</p>
<p>One defacement campaign Sucuri is tracking already has more than 68,000 pages indexed on Google. After perusing the WordPress.org forums, the problem seems to have a much larger reach than Sucuri&#8217;s network has initially detected. For example, &#8220;Hacked by NG689Skw&#8221; returns approximately 200K indexed results. &#8220;Hacked By SA3D HaCk3D&#8221; returns more than 100K results. There are multiple permutations of this defacement in play on WordPress websites across the web.  Not all results that share this same campaign structure are guaranteed to be associated with this vulnerability, but the few listed above were recent posts on the WordPress.org forum from users who failed to update to 4.7.2 in time.</p>
<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/02/hacked-wordpress-sites.png?ssl=1\"><img /></a></p>
<p>&#8220;On our end, we are seeing a big growth on exploit attempts, specially for defacement,&#8221; Cid said. &#8220;But SPAM SEO is slowly growing too.&#8221;</p>
<p>Cid said the vulnerability allows attackers to inject content into a post or page by default, but defacement is the easy first step, along with SEO spam. If a site has a plugin like <a href=\"https://wordpress.org/plugins/insert-php/\" target=\"_blank\">Insert PHP</a> or <a href=\"https://wordpress.org/plugins/php-code-widget/\" target=\"_blank\">PHP Code Widget</a> installed, the vulnerability can lead to remote code execution. These two plugins have more than 300K combined active installs and there are others that perform similar functions.</p>
<p>&#8220;The core of the issue is people not updating,&#8221; Cid said. &#8220;Even with auto and simple updates, people still do not update their sites.&#8221;</p>
<p>Needless to say, if you haven&#8217;t updated to 4.7.2 and your site is running 4.7.0 or 4.7.1, you are at risk for  content injection. For most sites that have been defaced, the simplest solution is to update to the latest version of WordPress and rollback the defaced post(s) to a revision.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Feb 2017 00:36:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: BlogVault Security Breach Infects Customers’ Sites With Malware\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65658\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"https://wptavern.com/blogvault-security-breach-infects-customers-sites-with-malware\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2120:\"<img />photo credit: Anonymous Account <a href=\"http://www.flickr.com/photos/37053322@N00/2291139919\">Code</a> &#8211; <a href=\"https://creativecommons.org/licenses/by/2.0/\">(license)</a>
<p><a href=\"https://blogvault.net/\">BlogVault</a>, a real-time backup and migration service with a <a href=\"https://wordpress.org/plugins/blogvault-real-time-backup/\">WordPress plugin</a> that&#8217;s active on more than 20K sites, <a href=\"https://blogvault.net/security-notification/\">announced</a> over the weekend that it suffered a security breach that exposed data. Akshat Choudhary, founder of BlogVault, <a href=\"https://blogvault.net/help/info\">explains</a> that some customer sites were accessed without authorization and were infected with malware.</p>
<p>BlogVault is contacting customers whose sites are affected and removing malware to secure the data. According to Choudhary, all backups generated by BlogVault are safe. FTP, login credentials, and payment related data is safe. The service doesn&#8217;t store credit card information as payments are processed through <a href=\"https://stripe.com/\">Stripe</a>.</p>
<p>The service has carried out a series of security precautions including, updating <a href=\"https://wordpress.org/plugins/blogvault-real-time-backup/\">the plugin to 1.45</a>, resetting passwords for all customer accounts, and is meticulously analyzing its systems. Customer passwords were encrypted, making them difficult to retrieve.</p>
<p>BlogVault is sharing information about the breach as it becomes available. &#8220;We understand that it can be frustrating for you; as it is for us, to not have all the information,&#8221; Choudhary said. &#8220;We aim to be comprehensive in our response to the issue. Once we have safeguarded our customers’ data, and our investigation is complete we will be able to share more details.&#8221;</p>
<p>Customers are encouraged to update the BlogVault plugin to 1.45 as soon as possible and to keep an eye on the service&#8217;s <a href=\"https://blogvault.net/help/info\">security updates page</a> for new information.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 06 Feb 2017 22:04:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: Content Creation Is About More Than an Editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65626\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wptavern.com/content-creation-is-about-more-than-an-editor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16655:\"<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/02/ReidPeifer.jpeg?ssl=1\"><img /></a>Reid Peifer
<p>This is a guest post written by <span class=\"st\"><a href=\"https://twitter.com/reidpeifer?lang=en\">Reid Peifer</a>, Partner and Art Director at <a href=\"http://tri.be/\">Modern Tribe</a>. In this post, Peifer shares his experience, opinions, and things to consider as the content creation experience in WordPress <a href=\"https://make.wordpress.org/core/2017/01/17/editor-technical-overview/\">is revamped</a>.<br />
</span></p>
<hr />
<p>Let’s imagine a world where the tools that we have don’t limit us, but instead enable us to create unique, contextual, and thoughtful content. We don&#8217;t fight with them, we don&#8217;t quibble over line breaks and margins.</p>
<p>We don&#8217;t argue about whether or not two images should line up. We’re not limited to bold, italic, underline, and bullet points to express our ideas. We’re not limited to taxonomies for our organization and obtuse relational algorithms to determine complementary content.</p>
<p>This is the reality that we should have. Content management should be more than TinyMCE and meta boxes. While WordPress has continued to grow into a mature platform, the focus on what should be its core mission has taken a second seat.</p>
<p>We (the WordPress community at large) have gotten so excited about making WordPress awesome, we lost sight of our charge &#8211; to enable WordPress to make awesome things. To democratize publishing. To get the stories out of people&#8217;s heads and hearts and out to the world.</p>
<p>We forgot about content. Without content, WordPress and all its bits and bobs amount to much ado about nothing. While it’s true that WordPress has grown to an almost unimaginable scale, the content it creates today isn’t going to support the needs of tomorrow’s web.</p>
<p>I couldn’t make it to WordCamp US, but I’ll admit that I sat slack-jawed with joy listening to the <a href=\"https://wordpress.tv/2016/12/07/matt-mullenweg-state-of-the-word-2016/\">video</a> calling for a focus on the editor in 2017.</p>
<p>The <a href=\"https://make.wordpress.org/core/2017/01/17/editor-technical-overview/\">initial discussions</a> happening on make.wordpress.org and within slack are incredibly encouraging. The community has taken this charge and is moving forward with a passion that reflects the importance of the task at hand.</p>
<p>While I absolutely applaud their effort, and think the conversation thus far has been valuable &#8211; it immediately went to the editor itself. What makes a good editor? The discussion is focused on the UI, what format the data should be stored in, should shortcodes be used etc. All good questions, but if we answer them first &#8211; we limit the scope of our inquiry.</p>
<p>The first question should be ‘what makes good content’? What is ‘content’? Does content only live on the post or the page? What are its essential elements? How do those elements interact and relate to each other? What’s the life cycle of content? Where and how does it surface throughout the site? Does content behave differently in different scenarios or positions?</p>
<p>If we start with these questions, their answers become our objectives for the UI. The question &#8216;what makes a good editor&#8217; has a clear answer &#8211; one that makes achieving these goals delightful and effortless.</p>
<h2>The Need for a More Robust Content Creation Tool Is Not New</h2>
<p>Years ago, when ‘magazine layout’ was the new hot thing, we had the privilege of working with some large publications. In our design discovery, we learned how they thought about the presentation of their content, how layouts would change based on the content they were presenting that day.</p>
<p>The rigid templates of the web that we were used to building couldn’t possibly meet the strategy that they had employed for ages in print. The sports, business, and lifestyle sections all needed to be able to leverage different layouts and presentation depending on their immediate needs.</p>
<p>They needed to change day after day. We were going to toss out what we knew about building sites in WordPress. We were going to have to ditch the template hierarchy and start from scratch. The taxonomy term page in the admin wasn’t going to cut it.</p>
<p>Meanwhile, ‘art directed’ or ‘editorial posts’ became a thing. Folks like Jason Santa Maria and Trent Walton were pumping out beautiful, bespoke articles rich in editorial design. I’ve never been more excited about the web’s potential than when I saw those first Jason Santa Maria articles &#8211; I’m a sucker for good content design.</p>
<p>At some point shortly thereafter the NY Times published <a href=\"http://www.nytimes.com/projects/2012/snow-fall/#/?part=tunnel-creek\">Snowfall</a>, and everyone we talked to needed ‘long form’ (even if they had no idea why or what that could mean). I ran my own experiments trying to recreate that functionality in WordPress &#8211; at the time that meant full markup and a reams of custom CSS all cooked into the WYSIWYG. Beautiful output, crappy experience.</p>
<p>These are two really common (and old) examples of how the content needs more than the tool can offer.</p>
<p>We toiled away at these challenges over the years and have solved them for our particular use cases. Every project pushes our own solutions forward. Here’s some of what we learned.</p>
<p><em>(So we’re all talking in the same terms, below when I reference Content Creation I mean the act of creating a new piece of content. When I reference content management, I mean both the content model, and the organization and presentation of content throughout the site.)</em></p>
<h2>We Should Learn From Modular Development &amp; Atomic Design</h2>
<p>We should be applying modular development and atomic design principles to both content creation and content management.</p>
<a href=\"http://bradfrost.com/blog/post/atomic-web-design/\"><img /></a>Atomic Design Principle as Explained by Brad Frost
<p>We’ve adopted a modular and systematic thinking to our coding practices, breaking once monolithic templates into smaller reusable parts. We’ve applied design systems thinking and atomic approaches to our UI/UX and visual design work.</p>
<p>Small pieces come together to create components, which come together to create pages which come together to create full experiences. It’s the LEGO blocks school of design and build. This is a refrain that many of us know well.</p>
<h2>Extending That Philosophy to Content Creation and Management</h2>
<p>While we’ve embraced this idea of systemic thinking in how we design and the infrastructure of what we build &#8211; we haven’t gotten to thinking about how to approach content creation and content management (content strategy) in a similarly modular fashion.</p>
<p>This is primarily because our tools won’t let us apply modular thinking to content creation and management. CMSs, including WordPress, are generally limited to predefined structures and organizational models.</p>
<p>The role of templating in the overall CMS architecture limits the flexibility of our content creators. Today, content strategy occurs before, and then is at the mercy of development. In a better world, our content strategy could use design and development to grow, adapt, and change over time gracefully. Our publishing tools could become the method by which our ongoing content strategy evolves.</p>
<h2>Modular Content Creation</h2>
<p>Let’s think about the idea of content on the web. Much of what we see on the web today is a logical baby step forward from print. Titles and headlines, paragraphs of copy, images, pull quotes. Those pieces are a 1:1 analog. Because it’s a digital medium, and we’re oh so clever, we’ve included videos, image galleries, those dang carousels, and whatnots as well.</p>
<p>For most of you, those elements are plopped onto a webpage using a WYSIWYG editor. You fight with TinyMCE for supremacy. Perhaps your theme or plugin has dedicated meta boxes for special elements. There may be a slide show or gallery at the top of the page.</p>
<p>When we look at most executions of content on the web, they are in fact less interesting, less engaging, and less beautiful than what our print counterparts have been doing for ages (and I mean literal ages).</p>
<p>We have all of the advantages but fail at creating anything more interesting than a preformatted spew of content. Our insistence that content and presentation need to be separate is an overstep &#8211; they are related at their very core. Was there an earth shattering news story yesterday? Too bad, you get the same 400px featured image slot that every other story gets.</p>
<p><strong>I refuse to believe this is the best we can do.</strong></p>
<p><strong>TinyMCE is not the pinnacle of content creation tools.</strong></p>
<p>The platform that can figure out how to make content creation engaging and powerful is the platform that is going to continue to grow. While Calypso is an interesting engineering feat and is a helpful model for future development, it did little to push forward what it actually means to create content within the WordPress framework.</p>
<p><strong>Trying to fight this out in a single WYSIWYG sucks</strong></p>
<p>Our content creation tools should allow us to approach content creation the same way that we think about design. What are the atomic elements of my content strategy? How can I remix, reassemble, and work with those elements to create interesting content?</p>
<p>It must be systemic. All of the elements and components must work as part of an overall structure and strategy to form a coherent whole. Just like our design work, and our development work. Our strategy, design, and development process is focused on identifying and creating patterns.</p>
<p>Throughout the content strategy and design portion of the project, we’re focused on identifying what those patterns are at their very core; how do we break them down into their smallest parts? Then, through design and development, we start putting those pieces together in a way that supports internal objectives and end-user objectives.</p>
<ul>
<li>Elements &#8211; the simplest unit. Strings of text, single images, videos, a form input field or button</li>
<li>Components or blocks &#8211; groupings of elements that form a cohesive unit</li>
<li>Modules &#8211; groupings of complementary components to for a larger whole</li>
<li>Pages (or posts, or CPTS or whatever) &#8211; groupings of modules to form a complete piece of content</li>
</ul>
<p>To push WordPress’ content creation tools forward, we must look at what those elements, components, and modules could be, how they relate to each other. Are they created on the fly, are they opinionated or flexible. Then how do we create them. How do they relate to themes and data sanctity. And on and on.</p>
<h2>Modular Content Management (modular content strategy)</h2>
<p>While there are enough visual references to start to imagine what a modular content creation tool looks like, modular content management is a bit tougher to visualize so hang with me.</p>
<p>Within modern CMSs we’ve got a couple of tools at our disposal. Tags and categories, coupled with parent / child relationships, are the primary organization structures cooked into WordPress. Of course those can be extended to include any number of taxonomical structures imaginable.</p>
<p>Tools like Post to Posts (P2P) provide and create an interesting peer-to-peer layer allowing you to create 1:1, 1:many, or many:many relationships.</p>
<p>That’s pretty much it. The mechanics of relationships are defined and subject to code. I can assign content into those defined buckets. I have fixed templates that display those buckets in predetermined ways. If I want to vary from that, if I want to create relationships and remix content as a content manager or a content creator, I’m outta luck.</p>
<p>Think about the category term screen within WordPress. What sort of content management tools do you have at your disposal there? What can you do? What can you <em>manage</em>? Not much at all. Look back over the history of WordPress releases &#8211; when has that screen changed?</p>
<p>We are not living up to our potential if we stop at a taxonomical organization as the be-all-end-all of content management.</p>
<p>The Loop is one of the central concepts of WordPress content management. While it is incredibly powerful and key to understanding how to think about your content, it’s the beginning, not the end, of content management. We cannot stop at the &#8216;list&#8217; as the pinnacle of our content strategy.</p>
<h3>Needs Change Over Time</h3>
<p>We do a lot of work for universities and schools. Each and every one has a category landing page dedicated to current students. Throughout the year, they want to gather and surface all kinds of different elements, pieces of content, and tools for those students.</p>
<p>In WordPress terms, we’ve got pages, blog posts, events, tools, resources, key dates, applications and files, on top of video galleries and who knows what other CPTs your content strategy has formed.</p>
<p>The needs of those students change through the year &#8211; welcome materials in the fall, midterm information in the winter, job support and internship programs in the spring. If our university friends were tied to templates where those needs were articulated in code, they’d need to go back under the hood to update their content strategy and approach it at least quarterly.</p>
<h3>Relationships Should Be Richer Than Taxonomy Terms</h3>
<p>Real content management would enable content creators to package and present the things they’ve made in thoughtful and unique ways&#8211;where the relationships and connections have value beyond each individual piece. Together they become a cohesive whole. That’s a content strategy that’s worth a damn. If you can’t do that, your content strategy is really just a thoughtful list of categories and tags.</p>
<p>Our content management tools should enable and empower you to gather your content and present it how you need to. You shouldn’t be limited solely by lists and algorithms. We want our clients to be able to create unique cross-sections of content where they need, not where they happen to have pre-baked templates that allow them do so.</p>
<p>An example to help visualize: Sticking with our college student, imagine the registrar publishes a deadline for financial aid application. The residential life department has updated forms for getting a spot in the dorms.</p>
<p>The student life department publishes a list of events for new students to meet each other. Each piece of content lives in its own silo in disparate places on the university website. Now imagine you’re in the communications department, and you’ve been charged with ensuring that new students get the information they need.</p>
<p>Do you <strong>A:</strong> manually type excerpts to those pieces of content in a sidebar widget, hardcode some links trying to apply a specific class that makes the links look like buttons but you can’t remember if it’s .btn_round or .btnround or .round_btn_blue_large, and pray it stays in the same place <strong>OR B:</strong> create a &#8216;Key Info for New Students&#8217; module by referencing each piece of content dynamically and dragging it at the top of the homepage displacing the out of date commencement gallery that you forgot to take down last spring?</p>
<p>Old school is option A. New School option B (and it’s not the cool old school, it’s the lame frustrating old school).</p>
<h3>The Way Forward Is Modular</h3>
<p>If you’re new the concept of atomic design, read <a href=\"http://bradfrost.com/blog/post/atomic-web-design/\">this piece</a> by Brad Frost first. If you want to see how we solved some of these problems specifically &#8211; there’s a couple of WordPress.TV talks where I harp on this stuff <a href=\"https://wordpress.tv/2015/10/26/reid-peifer-reimagining-content-creation/\">here</a> and <a href=\"https://wordpress.tv/2014/05/08/reid-peifer-so-long-fixed-templates-and-thanks-for-all-the-fish-modular-content-with-wordpress/\">here</a>.</p>
<p>We’ve got to strive for more than just an updated WYSIWYG editor. We’ve got to aspire to a bigger and broader understanding of what content is and could be. When we’ve got that vision, we’ll be able to build tools to help realize it.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 04 Feb 2017 05:32:54 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: More Than 50% of Web Traffic is Now Encrypted\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65505\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wptavern.com/more-than-50-of-web-traffic-is-now-encrypted\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6155:\"<a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/lock.jpg?ssl=1\"><img /></a>photo credit: <a href=\"https://stocksnap.io/photo/550FJBDFSW\">Chris Anderson</a>
<p>In October 2016 <a href=\"https://support.mozilla.org/en-US/kb/share-telemetry-data-mozilla-help-improve-firefox\" target=\"_blank\">Mozilla Telemetry</a> showed <a href=\"https://twitter.com/letsencrypt/status/786977436109934592\" target=\"_blank\">more than 50% of page loads were encrypted with HTTPS</a>. This week Let&#8217;s Encrypt is reporting that more than 50% HTTPS page loads is now the norm, a major milestone for HTTPS adoption across the web.</p>
<blockquote class=\"twitter-tweet\">
<p lang=\"en\" dir=\"ltr\">Per <a href=\"https://twitter.com/firefox\">@Firefox</a> Telemetry, more than 50% HTTPS page loads is now the norm! <a href=\"https://t.co/7mo8VPrpbq\">pic.twitter.com/7mo8VPrpbq</a></p>
<p>&mdash; Let\'s Encrypt (@letsencrypt) <a href=\"https://twitter.com/letsencrypt/status/826198258355572736\">January 30, 2017</a></p></blockquote>
<p></p>
<p><a href=\"https://www.google.com/transparencyreport/https/metrics/?hl=en\" target=\"_blank\">Google&#8217;s Transparency Report</a> shows similar numbers for HTTPS usage, confirming that secure browsing has become the norm. Google found that HTTPS is less prevalent on mobile devices than desktop but the percentage of pages loaded over HTTPS is steadily on the rise across the board.</p>
<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/percentage-pages-loaded-over-https.png?ssl=1\"><img /></a></p>
<p>The launch of <a href=\"https://letsencrypt.org/\" target=\"_blank\">Let&#8217;s Encrypt</a>, the new free and open certificate authority, is one of the main factors causing the rapid rise in secure traffic. Thanks to sponsorships and partnerships with hosting companies and services, Let&#8217;s Encrypt closed out 2016 with more than <a href=\"https://wptavern.com/lets-encrypt-passes-20-million-active-certificates-in-2016\" target=\"_blank\">20 million active certificates</a>.</p>
<p>Google&#8217;s influence has also been one of the driving factors in HTTPS adoption after the search engine <a href=\"https://webmasters.googleblog.com/2014/08/https-as-ranking-signal.html\" target=\"_blank\">announced</a> in 2014 that it was starting to use HTTPS as a ranking signal. As of 2017, Google Chrome is<a href=\"https://wptavern.com/chrome-to-add-security-warning-to-http-sites-beginning-2017\" target=\"_blank\"> adding a prominent security warning for HTTP sites</a>.</p>
<p>Throughout 2016 many major publications moved to HTTPS, including the <a href=\"https://www.theguardian.com/info/developer-blog/2016/nov/29/the-guardian-has-moved-to-https\" target=\"_blank\">Guardian</a>, <a href=\"https://developer.washingtonpost.com/pb/blog/post/2015/12/10/moving-the-washington-post-to-https/\" target=\"_blank\">Washington Post</a>, <a href=\"https://www.wired.com/2016/09/wired-completely-encrypted/\" target=\"_blank\">Wired</a>, <a href=\"https://www.engadget.com/2016/06/10/engadget-moved-to-https-because-we-love-you/\" target=\"_blank\">Engadget</a>, <a href=\"https://arstechnica.com/information-technology/2017/01/ars-announces-https-by-default-finally/\" target=\"_blank\">Ars Technica</a>, and <a href=\"https://open.blogs.nytimes.com/2017/01/10/https-on-nytimes-com/?_r=0\" target=\"_blank\">New York Times</a>, to name a few. Nearly all of them publicly documented the challenges and triumphs of their HTTPS transitions.</p>
<p>In July 2016, security researcher Scott Helme crawled the Alexa Top 1 million sites to measure how security is progressing on the web. In his previous scans, which included August 2015 and February 2016, the top million sites saw a 42% increase in HTTPS adoption. <a href=\"https://scotthelme.co.uk/alexa-top-1-million-crawl-aug-2016/\" target=\"_blank\">Helme&#8217;s July 2016 crawl</a> showed a 46% increase from February 2016.</p>
<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/helme-https-adoption-stats.png?ssl=1\"><img /></a></p>
<p>Despite the overall growth, the number of HTTPS-enabled sites is just 13.75% of Alexa&#8217;s top million. However, these are the sites that serve the most traffic: Google, YouTube, Facebook, Amazon, and others. These results are consistent with Electronic Frontier Foundation&#8217;s (EFF) <a href=\"https://www.eff.org/deeplinks/2016/10/lets-encrypt-largest-certificate-authority-web\" target=\"_blank\">reports</a> that HTTPS adoption is growing the fastest with smaller, previously-unencrypted sites.</p>
<p>Let&#8217;s Encrypt&#8217;s launch has also had a ripple effect on commercial certificate authorities who are now moving to offer domain validated SSL certificates for free in order to promote their other security products. Symantec is now partnering with hosting companies to issue free certificates as part of its <a href=\"https://www.symantec.com/content/dam/symantec/docs/other-resources/ee-program-guide-combined-en.pdf\" target=\"_blank\">Encryption Everywhere</a> program. Comodo also <a href=\"https://www.comodo.com/news/press_releases/2016/12/worlds-largest-CA-comodo-and-web-hosting-platform-leader-cPanel.html\" target=\"_blank\">announced</a> a partnership with cPanel in December 2016 to automatically issue SSL certificates at no additional costs to consumers via cPanel&#8217;s AutoSSL feature.</p>
<p>Securing half the web&#8217;s traffic is a major landmark on the road to a fully encrypted web, but encryption advocates will need to continue educating website owners on the benefits of making the switch to HTTPS. With the necessary infrastructure now in place for anyone to get an auto-renewing SSL certificate for free, Let&#8217;s Encrypt director Josh Aas is optimistic about progress on the remaining 50% of the web.</p>
<p>&#8220;As exciting as 2016 was for encryption on the Web, 2017 seems set to be an even more incredible year,&#8221; Aas said &#8220;Much of the infrastructure and many of the plans necessary for a 100 percent encrypted Web really solidified in 2016, and the Web will reap the rewards in 2017. Let’s Encrypt is proud to have been a key part of that.&#8221;</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Feb 2017 23:36:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Donncha: WP Super Cache 1.4.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://odd.blog/?p=89500145\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://odd.blog/2017/02/03/wp-super-cache-1-4-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5137:\"<p>There&#8217;s a new release of <a href=\"https://wordpress.org/plugins/wp-super-cache/\">WP Super Cache</a> out and it&#8217;s a security release to fix XSS problems in the settings pages. Those pages are only accessible by admin users so an anonymous visitor to your site can&#8217;t come along and enable it to steal your login cookies but along with those fixes come many bug fixes so it&#8217;s worth upgrading if you&#8217;re using an old version.</p>
<p>From the Changelog:</p>
<blockquote>
<ul>
<li>Fixed bug when not running sem_remove after sem_release. See <a href=\"https://github.com/Automattic/wp-super-cache/issues/85\" rel=\"nofollow\">https://github.com/Automattic/wp-super-cache/issues/85</a></li>
<li>Fixed a PHP error impacting PHP 7.1.</li>
<li>Fixed a bug where we cached PUT and DELETE requests. We&#8217;re treating them like POST requests now.</li>
<li>Delete supercache cache files, even when supercache is disabled, because mod_rewrite rules might still be active.</li>
<li>Updated the settings page, moving things around. <a href=\"https://github.com/Automattic/wp-super-cache/pull/173\" rel=\"nofollow\">#173</a></li>
<li>Make file locking less attractive on the settings page and fixed the WPSC_DISABLE_LOCKING constant so it really disables file locking even if the user has enabled it already.</li>
<li>Added a WPSC_REMOVE_SEMAPHORE constant that must be defined if sem_remove() is to be used as it may cause problems.  <a href=\"https://github.com/Automattic/wp-super-cache/pull/174\" rel=\"nofollow\">#174</a></li>
<li>Added a &#8220;wpsc_delete_related_pages_on_edit&#8221; filter that on returning 0 will disable deletion of pages outside of page being edited. <a href=\"https://github.com/Automattic/wp-super-cache/pull/175\" rel=\"nofollow\">#175</a></li>
<li>Fixed plugin deleting all cached pages when a site had a static homepage. <a href=\"https://github.com/Automattic/wp-super-cache/pull/175\" rel=\"nofollow\">#175</a></li>
<li>Make sure $cache_path has a trailing slash <a href=\"https://github.com/Automattic/wp-super-cache/pull/77\" rel=\"nofollow\">#177</a></li>
<li>Remove flush() <a href=\"https://github.com/Automattic/wp-super-cache/pull/127\" rel=\"nofollow\">#127</a> but also check if headers are empty and flush and get headers again. <a href=\"https://github.com/Automattic/wp-super-cache/pull/179\" rel=\"nofollow\">#179</a></li>
<li>Add fix for customizer <a href=\"https://github.com/Automattic/wp-super-cache/pull/161\" rel=\"nofollow\">#161</a> and don&#8217;t cache PUT AND DELETE requests <a href=\"https://github.com/Automattic/wp-super-cache/pull/178\" rel=\"nofollow\">#178</a></li>
<li>Check for superglobals before using them. <a href=\"https://github.com/Automattic/wp-super-cache/pull/131\" rel=\"nofollow\">#131</a></li>
</ul>
</blockquote>
<p>You can click through to each of the Github pull requests above to see discussion around each bug fix.</p>
<p>If you&#8217;re hosting many sites that use WP Super Cache and you&#8217;re seeing issues with semaphores it may mean that your users are using file locking. It&#8217;s really not needed and in <a href=\"https://github.com/Automattic/wp-super-cache/pull/174\">#174</a> there&#8217;s a fix that went into this release. You can disable file locking completely by setting the constant &#8220;WPSC_DISABLE_LOCKING&#8221; in a global configuration file. The file locking simply slowed down how fast cache files were created and is a hold-over from WP Cache when that plugin used to write directly to the cache files. This plugin writes to temporary files before moving to the final cache files so that locking isn&#8217;t really needed, but some sites still use it which is why it&#8217;s still around.</p>
<p>I&#8217;ve already been working on the next release with efforts <a href=\"https://github.com/Automattic/wp-super-cache/pull/177\">to move the legacy cache files</a> into the supercache directories. This will make it easier to maintain them and improve performance. We really need to find a better name for this caching method however. It caches everything &#8211; page contents and http headers so it&#8217;s quite useful!<br />
If you&#8217;re going to test that PR, try <a href=\"https://github.com/Automattic/wp-super-cache/pull/176\">#176</a> too. The plugin only deletes index.html type files right now but this chunk of code cleans up various for loops in the plugin and also deletes any file in the named directory. There are some restrictions on it so it won&#8217;t delete anything outside the cache directory.</p>
<p>Thanks to everyone who contributed to this release!</p>

<p><strong>Related Posts</strong><ul><li> <a href=\"https://odd.blog/2008/10/24/wp-super-cache-084-the-garbage-collector/\" rel=\"bookmark\" title=\"Permanent Link: WP Super Cache 0.8.4, the garbage collector\">WP Super Cache 0.8.4, the garbage collector</a></li><li> <a href=\"https://odd.blog/2009/01/09/wp-super-cache-087/\" rel=\"bookmark\" title=\"Permanent Link: WP Super Cache 0.8.7\">WP Super Cache 0.8.7</a></li><li> <a href=\"https://odd.blog/2010/02/08/wp-super-cache-099/\" rel=\"bookmark\" title=\"Permanent Link: WP Super Cache 0.9.9\">WP Super Cache 0.9.9</a></li></ul></p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 03 Feb 2017 17:46:01 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Donncha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"WPTavern: WP-CLI 1.1.0 Released, Project Shifts to Expand Package Index\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65553\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://wptavern.com/wp-cli-1-1-0-released-project-shifts-to-expand-package-index\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2920:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2016/05/wp-cli.png?ssl=1\"><img /></a></p>
<p>WP-CLI <a href=\"https://make.wordpress.org/cli/2017/02/01/version-1-1-0/\" target=\"_blank\">1.1.0</a> is now available, two months after 1.0.0 was released. The project shifted after 1.0.0 to focus on its <a href=\"https://wp-cli.org/package-index/\" target=\"_blank\">package ecosystem</a>, encouraging new features to be built as standalone packages instead of rolling them all into WP-CLI core. Daniel Bachhuber, the project&#8217;s maintainer, moved WP-CLI in this new direction to better distribute the maintenance burden among package maintainers.</p>
<p>Version 1.1.0 includes 23 command improvements, 8 framework enhancements, and dozens of bug fixes. The release had a 16% increase in the number of contributors from 1.0.0. It is the first major release since the project was <a href=\"https://wptavern.com/wp-cli-gets-official-wordpress-org-support\" target=\"_blank\">brought under the umbrella of WordPress.org</a> at the beginning of 2017.</p>
<p><a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/02/wp-cli-handbook.png?ssl=1\"><img /></a></p>
<p>The process of migrating the wp-cli.org website to wordpress.org will take a couple of months, but the website documentation has already found a new home at <a href=\"https://make.wordpress.org/cli/handbook/\" target=\"_blank\">make.wordpress.org/cli/handbook/</a>. Contributors can edit documentation by clicking on the button at the top of any page, which links to the handbook&#8217;s GitHub repository.</p>
<h3>WP-CLI to Expand Package Index</h3>
<p>As part of the new focus on the WP-CLI package ecosystem, Bachhuber has created a GitHub repository for logging <a href=\"https://github.com/wp-cli/ideas\" target=\"_blank\">ideas for new packages</a>. The best ideas will be maintained as canonical community packages.</p>
<p>&#8220;The end goal for the WP-CLI package index is to be a directory of well-maintained, canonical features,&#8221; Bachhuber said. &#8220;Packages will be considered community projects shepherded by one or more maintainers, instead of the domain of a specific author.&#8221;</p>
<p>Bachhuber is looking to hire someone to assist in maintaining the project in a part-time capacity for 5-10 hours per week. This person will work on supporting package maintainers and vetting ideas for new packages.</p>
<p>The next release cycle will focus on <a href=\"https://github.com/wp-cli/wp-cli/issues/3728\" target=\"_blank\">splitting internal commands into separate packages</a> with the goal of having official maintainers for them in the future. Contributors are also planning to create new pages on WordPress.org for the <a href=\"http://wp-cli.org/commands/\" target=\"_blank\">WP-CLI commands</a> directory and <a href=\"http://wp-cli.org/docs/internal-api/\" target=\"_blank\">internal API docs</a>.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Feb 2017 18:16:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Post Status: Editing and customization core focus areas — Draft Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=33385\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://poststatus.com/editing-customization-core-focus-areas-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2085:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"https://play.google.com/music/m/Ih5egfxskgcec4qadr3f4zfpzzm?t=Post_Status__Draft_WordPress_Podcast\">Google Play</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>
<p>In this episode, Joe and Brian talk about two of the three WordPress core focus areas &#8212; the customizer and the editor. There has been some news lately with initial ideas and mockups for each project, and we discuss the importance of these features, as well as what&#8217;s happening with these projects so far.</p>
<a href=\"https://audio.simplecast.com/59336.mp3\">https://audio.simplecast.com/59336.mp3</a>
<p><a href=\"https://audio.simplecast.com/59336.mp3\">Direct Download</a></p>
<h3>Links</h3>
<ul>
<li><a href=\"https://make.wordpress.org/core/2017/01/19/customization-in-2017/\">Customizer opportunities</a></li>
<li><a href=\"https://make.wordpress.org/design/2017/01/25/what-are-little-blocks-made-of/\">Editor mockups</a></li>
<li><a href=\"https://make.wordpress.org/core/2017/01/17/editor-technical-overview/\">Editor technical challenges</a></li>
<li><a href=\"https://commercenotebook.com\">Commerce Notebook</a></li>
</ul>
<h3>Sponsor: Pippin&#8217;s Plugins</h3>
<p>This episode is sponsored by Pippin&#8217;s Plugins. <a href=\"http://pippinsplugins.com/\">Pippin&#8217;s Plugins</a> creates a suite of plugins that work great alone, or together. Whether you need to restrict content, sell downloads, or start an affiliate program, they&#8217;ve got you covered. For more information, check out their <a href=\"http://pippinsplugins.com/\">website</a> and thank you to Pippin&#8217;s Plugins for being a Post Status partner.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Feb 2017 17:49:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: WPWeekly Episode 261 – WordPress for Schools With Cameron Barrett\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=65559&preview=true&preview_id=65559\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wptavern.com/wpweekly-episode-261-wordpress-for-schools-with-cameron-barrett\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2598:\"<p>In this episode, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"http://camworld.org/\">Cameron Barrett</a>, founder of <a href=\"http://schoolpress.co/\">SchoolPresser, LLC</a>. Barrett explains how he negotiated and helped migrate Newark New Jersey&#8217;s public school system from a proprietary CMS to WordPress. He shares the pitfalls he experienced and the amount of money the district is saving since making the switch. Barrett also provides tips and suggestions on how to sell WordPress as a solution to school districts.</p>
<p>We didn&#8217;t dive as deep as we wanted to on the topic but if you&#8217;d like to learn more, please watch the<a href=\"https://wordpress.tv/2016/12/11/cameron-barrett-wordpress-for-schools-3/\"> presentation</a> he did at WordCamp US. In it, he provides more details of the migration, financials, and there&#8217;s a great question and answer session at the end.</p>
<h2>Stories Discussed:</h2>
<p><a href=\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\">WordPress 4.7.2 Security Release</a></p>
<h2>Plugins Picked By Marcus:</h2>
<p><a href=\"https://wordpress.org/plugins/birthday-mails-bp/\">Birthday Mail BP</a> is an automated function for BuddyPress that sends birthday emails to members on their birthday. It&#8217;s a great way to express birthday wishes or to present a coupon or discount code to members.</p>
<p><a href=\"https://wordpress.org/plugins/woo-document-preview/\">WC Document Preview</a> adds a document preview feature to WooCommerce similar to how Amazon allows you to preview books. This is handy for ebooks and digital products that lend themselves to previews.</p>
<p><a href=\"https://wordpress.org/plugins/tm-style-switcher/\">TM Style Switcher</a> allows you to save a theme&#8217;s settings as skins, switch between them, and move skins from one WordPress site to another.</p>
<h2>WPWeekly Meta:</h2>
<p><strong>Next Episode:</strong> Wednesday, February 8th 3:00 P.M. Eastern</p>
<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Listen To Episode #261:</strong><br />
</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Feb 2017 00:30:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"HeroPress: The Joy of Being with WordPress Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1586\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://heropress.com/essays/joy-wordpress-community/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:11955:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/02/020117-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: Above all, the global community of WordPress has been a major inspiration for me.\" /><p>When my friend Mahangu first recommended me to Topher to write an essay for HeroPress, I could not believe his words. Quite confused I asked Topher, he repeated the same ‘Share your story on HeroPress’. It was unbelievable yet a beautiful sentence that left me stunned with pride.</p>
<p>HeroPress has been a place where I occasionally read the stories of the WordPress heroes. Reading the inspiring stories, I have always found new energy for Work every day. Never thought my story would be worth this platform, I was overwhelmed to receive that message from Topher.</p>
<p>I am NO Hero but just another full stack WordPress developer. More than that, I am a 24 years young web dude from Nepal. Nepal is a small country that lies in the foothills of the immense and sensational Himalayas. Moreover, it is the land of incredible natural beauty, adventure, and ancient wisdom and enlightenment. And this land has always inspired me to take tiny steps of truth towards the mountain-high peak.</p>
<p>I could not agree much with Mahangu and Topher but I decided to share my story on this amazing platform. After all, I am not any exceptional but someone who wants to be a hero like (almost) everyone.</p>
<h3>How I started?</h3>
<p>Even though I was highly interested to computer from early childhood, I got one of my own only when I was in the 4th grade. As a curious child, I learned about technical aspects of computer from my senior brother and within a year or so on I started fixing the neighbors and friends computer. Since then I had a will to get things “right” as opposed to just getting things “working”. I vividly recall those days when I used to spend hours of my holiday playing Mario. Honestly, that’s still one of my favourite game. <img src=\"https://s.w.org/images/core/emoji/2.2.1/72x72/1f609.png\" alt=\"😉\" class=\"wp-smiley\" /></p>
<p>Back in those days, computer and internet were limited to few cyber cafes in town. I barely had any idea what they actually meant for except gaming.</p>
<blockquote><p>I thought they were established for the foreigners as they were mostly visited by the international tourists.</p></blockquote>
<p>After SLC examination (10th grade in Nepal), we have 3 months long vacation when students take extra classes such as bridge courses to prepare themselves for college. Since I was from the best school and was quite good at study I didn’t go for classes required for joining college. That was the time when I enrolled in a computer institute for hardware classes as I was quite interested to know how machine work. Thereafter, I joined college with Science faculty. The only motive behind joining the hardware class and choosing ‘Science’ was to prepare myself for mechanical engineering.</p>
<p>But I could not do it. Physics, Chemistry barely made any sense to me and therefore started questioning its applicability in my day to day life. As a result, I failed formal education system.</p>
<blockquote><p>This is how I faced the first and last (till now) “failure” in my life, I dropped down engineering dream right there.</p></blockquote>
<p>Yet I no more worry, destiny had something other stored for me.</p>
<p>Despite all, I had kept myself engaged with particular computer science, technology and web. I had somehow managed to learn basic HTML, CSS and designing stuff. I had made contacts with a number of people mostly senior to me who worked with programming, blogging. And one of them has a great role in shaping me as a ‘programmer’. Simultaneously, I read a lot of articles, followed people who mastered in programming which all supported my ‘new dream’ to become a ‘Programmer’.</p>
<p>As suggested by a friend of mine, I created my first blog in 2010 using Blogger platform. Later, I came to know that WordPress was a better platform with more possibilities and finally switched to WordPress 3.2 after a recommendation from one of my seniors. To my surprise, it was more wonderful than what I actually heard. I loved WordPress. Thereafter, I started tweaking designs and other aspects. Since then, I haven’t looked back.</p>
<h3>My Contributions / Together with WordPress</h3>
<p>Above all, the global community of WordPress has been a major inspiration for me. I am always grateful to the community and millions of WordPress lovers for the generous resources. I have also been actively contributing to the WordPress translation.</p>
<p>Greatly benefited by the works of others, I always wanted to give back to the community. The same instinct led me to the person I am today. Literally, volunteering for making WordPress platform for everyone has given me all the honors including this (feature on HeroPress).</p>
<p>In 2014, among various WordPress possibilities, WooCommerce is the one which intrigued me from the very beginning. With the growing eCommerce market, I knew that it was going to be a excellent piece of software in the future because of its incredible features. Using the plugin and analyzing it from the user’s perspective, I made numerous enhancements on WooCommerce.</p>
<p>I introduced Nepali currency symbol in WooCommerce version 2.2.3 which proved to be a milestone in developing eCommerce in my country Nepal. Additionally, I developed a Nepali payment gateway WooCommerce eSewa plugin without any incentive. The best thing about this whole thing is that, I got great help to deal with product platform from amazing folks like Mike Jolley, Claudio Sanches and James Koster. During the period, I learned so much about WooCommerce and coding in general. Since then, I have been reporting several bugs/issues and enhanced the plugin with 200+ pull requests on WooCommerce Github repository. Moreover I have also contributed to Storefront theme.</p>
<p>Since I was already technical bent, I learned about Vagrant for development environment. My first instinct was to use Varying Vagrant vagrants (VVV). But as a developer, I wanted more flexibility over the stack I used. So I started looking for alternative and found PuPHPet. For those who don’t know, PuPHPet is &#8211; “a simple Vagrant/Puppet GUI”. In order to make it more robust, I started contributing to this project and have also introduced WP-CLI support.</p>
<p>Afterward, I started automating my development approach. Since there was no good grunt package available to compile PO to MO files, I developed grunt-potomo.</p>
<h3>Earning my Living with WordPress</h3>
<p>Desperate as I had dropped from college, I was quite doubtful if I would ever get any job. Web development was at its beginning stage (not established as a job), there was little hope but it proved to be an advantage for me. I got an opportunity to work as a web developer in RealTech Computer Institute which is the same institute where I had learnt hardware and programming. I worked on new and innovative eCommerce sites, finished numerous time sensitive projects, trained new developers in utilizing front-end frameworks like BootStrap, Foundation, jQuery etc.</p>
<p>Later in 2015, I joined a growing team of ThemeGrill as Lead Plugin Developer. Together with ThemeGrill team, I have developed several WordPress plugins. To name a few, Social Icons, RestaurantPress, ThemeGrill Demo Importer are free WordPress plugins I have developed which are available in official WP plugin repository. Additionally, I have built several internal automated tools to improve overall customer support. I am also responsible for troubleshooting production issues, assisting WooCommerce, sales and performance monitoring.</p>
<p>WordPress has made my life much easier!</p>
<h3>WordPress Community in Pokhara</h3>
<p>My hometown Pokhara is 6 to 8 hours of drive from the capital city Kathmandu. I along with few WordPress enthusiast friends used to travel all the way to Kathmandu just to attend WordCamp Kathmandu (formerly WordCamp Nepal). I was fascinated by the awesome presentations by developers and networking opportunities provided there. Within a year or so the number of WordPress lovers grew in Pokhara but we didn’t have any such event there yet.</p>
<blockquote><p>In love with WordPress, I thought of organizing WordPress people in Pokhara under common umbrella &#8211; WordPress Pokhara.</p></blockquote>
<p>By then, I created a Facebook group with some friends, who were involved in WordPress projects. We organized several WordPress meetups and talk about WordPress. The group has grown from 3-4 members to 1000 members in Facebook right now. Mostly I have seen students and professionals coming together and helping each other in projects. Since I am away from Pokhara, Yam B. chetri and team are involved to organize regular WordPress Pokhara meetups. Thanks to his helpful behaviour, we are rapidly growing.</p>
<h3>Wrapping Up</h3>
<p>Since I switched to WordPress, I have been working with a motive to program a better solution for users which is surely a challenging task. So I am taking every small step to climb the cliff and still doing homework to reach the right destination.</p>
<p>To be frank, I don’t want to explore how business work and I am not made for it. But I am quite confident on the fact that I am good at understanding public-facing issues to tackle with a right solution.</p>
<p>This is just an ordinary story like yours as I said in the beginning. And I repeat that I am no hero yet my journey may be somehow different from yours.</p>
<p>Just write to me if you have anything to say. ☺</p>
<p>And thanks to HeroPress and WordPress. Let’s keep rising high as Everest! Together!!</p>
<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: The Joy of Being with WordPress Community\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=The%20Joy%20of%20Being%20with%20WordPress%20Community&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fjoy-wordpress-community%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: The Joy of Being with WordPress Community\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fjoy-wordpress-community%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fjoy-wordpress-community%2F&title=The+Joy+of+Being+with+WordPress+Community\" rel=\"nofollow\" target=\"_blank\" title=\"Share: The Joy of Being with WordPress Community\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/joy-wordpress-community/&media=https://heropress.com/wp-content/uploads/2017/02/020117-150x150.jpg&description=The Joy of Being with WordPress Community\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: The Joy of Being with WordPress Community\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/joy-wordpress-community/\" title=\"The Joy of Being with WordPress Community\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/joy-wordpress-community/\">The Joy of Being with WordPress Community</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Feb 2017 12:00:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Shiva Poudel\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:113:\"WPTavern: WordPress Telemetry Proposal Addresses Long-Standing Privacy Concerns as GDPR Compliance Deadline Looms\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=64798\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"https://wptavern.com/wordpress-telemetry-proposal-addresses-long-standing-privacy-concerns-as-gdpr-compliance-deadline-looms\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14494:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2014/05/paper.jpg?ssl=1\"><img /></a></p>
<p>At the end of October 2016, Morten Rand-Hendriksen created a <a href=\"https://core.trac.wordpress.org/ticket/38418\" target=\"_blank\">proposal on WordPress trac</a> for adding telemetry to core, an opt-in feature that would collect anonymized data on how people are using the software. He proposed that the new feature be displayed on first install or update, disabled by default in the admin with a control available under Settings->General. One option he suggests is shipping it as a plugin that auto-installs on opt-in and auto-uninstalls on opt-out. He also identified a few examples of core data that could be tracked, including number of themes and plugins installed, frequency of use of specific views (Settings, Customizer, etc), current version, update status, locale, and language.</p>
<p>&#8220;WordPress prides itself on being an application built by the user for the user,&#8221; Rand-Hendriksen <a href=\"https://mor10.com/the-case-for-wordpress-telemetry/\" target=\"_blank\">said</a>. &#8220;The problem is with the popularity and reach of WordPress today, the distance between the WordPress 1% (or even .1%) and the average user is becoming so vast we (the people who contribute to WordPress core) know almost nothing about the actual people who use WordPress or how they use the application.&#8221;</p>
<p>During the WordPress 4.7 development cycle, Rand-Hendriksen said he was involved in several conversations where participants assumed the use of features without any data to back up their opinions. He contends that WordPress contributors do not have the necessary data to know how users are interacting with the application and its features.</p>
<p>&#8220;The general argument was that based on the 80/20 rule, certain features should be added while others should be removed,&#8221; Rand-Hendriksen said. &#8220;I kept brining up the well known fact we don’t have a clue what features 80%, or even 20%, of WordPress users actually use so any claim of validity in the 80/20 rule is guesswork at best.&#8221;</p>
<p>His proposal states that all the data collected should be public for transparency and also made available to end-users in the admin and on WordPress.org.</p>
<p>The idea has had a few months to marinate and has generated some discussion about what a prototype would entail. Core committer Ella Van Dorpe created an experimental <a href=\"https://github.com/iseulde/wp-data\" target=\"_blank\">wp-data</a> standalone plugin for tracking a few simple interactions with the editor. Participants in the discussion recommended creating an Elasticsearch/Logstash setup for storing the data, technologies that the WordPress.org systems team have deployed before.</p>
<p>&#8220;I think a good summary is that there are a lot of hurdles in the way and currently no one has time to work on it,&#8221; Greg Brown, a Data Wrangler at Automattic, said in a followup <a href=\"https://core.trac.wordpress.org/ticket/38418#comment:5\" target=\"_blank\">discussion on the ticket</a> three weeks ago. &#8220;Ultimately, I think the biggest blocker is getting someone with the time, inclination, and persistence to work on this. Getting it deployed onto .org is the right thing to do eventually, but I suspect it will take quite a while.&#8221;</p>
<p>WordPress lead developer Dion Hulse <a href=\"https://core.trac.wordpress.org/ticket/38418#comment:6\" target=\"_blank\">confirmed</a> that WordPress is already tracking many of these stats and that creating a prototype on WordPress.org infrastructure would be the best option forward.</p>
<p>&#8220;It would also be valuable to see how our existing stats system can compliment or be replaced by the proposal here though,&#8221; Hulse said. &#8220;I mention this as most of the stats from the original description are already tracked, just not exposed in any form. The only new thing mentioned here is the Frequency of use of specific views (Settings, Customizer, etc) and transparency part (which would still probably only be anonymized summaries, not exact data).&#8221;</p>
<h3>WordPress Telemetry Project Provides a Solution to Long-Standing Privacy Concerns</h3>
<p>Moving WordPress&#8217; current data tracking into a more transparent opt-in feature would also provide a solution to some long-standing privacy concerns raised by contributors in <a href=\"https://core.trac.wordpress.org/ticket/16778\" target=\"_blank\">a six-year-old trac ticket</a>. WordPress tracks the number of blogs and users in a given installation, along with the installation URL in the headers, in order to <a href=\"https://core.trac.wordpress.org/ticket/16778#comment:67\" target=\"_blank\">facilitate update requests</a> that may become problematic, particularly in the case of large multisite installations.</p>
<p>&#8220;Even if a user knows that some data needs to be passed for a version check of core, plugins, or themes, the amount of data passed to remote is obviously more than needed to do the version check,&#8221; one contributor <a href=\"https://core.trac.wordpress.org/ticket/16778#comment:14\" target=\"_blank\">commented</a> on the ticket. &#8220;But users should be made aware upfront so they can freely decide on their own if they want to instead of being forced to support the project with their usage-data. They could be offered an opt-in to do so.&#8221;</p>
<p>&#8220;The number of registered users I have on my site tied to the URL that is sent with tracking request gives out vital information on how well my business could be doing &#8211; information that is mine and mine only,&#8221; WordPress plugin developer Danny van Kooten said. &#8220;At the very least we could make it very clear that WordPress is tracking this information and what exactly it is doing with it. I really do not think there is any excuse for that.&#8221;</p>
<p>Developers can filter the data to satisfy their privacy concerns but it is somewhat inextricable from the update process for larger multisite installations. It&#8217;s also too big of a technical hurdle for most regular users who would be better served by a simple UI allowing them to opt out of data collection.</p>
<p>Rand-Hendriksen&#8217;s WordPress telemetry proposal gives the project an opportunity to formalize what data is being collected, state the purpose behind it, and allow users to choose if they want to be included.</p>
<h3>Europe&#8217;s General Data Protection Regulation (GDPR) May Push WordPress Towards More Transparent Data Collection</h3>
<p>Progress on both the Telemetry project and the ticket regarding privacy concerns has been slow. Neither seem to be a priority among contributors, but Europe&#8217;s <a href=\"http://eur-lex.europa.eu/legal-content/EN/TXT/?uri=OJ%3AL%3A2016%3A119%3ATOC\" target=\"_blank\">General Data Protection Regulation</a> (GDPR) may provide the impetus needed to push WordPress towards more transparent and responsible data collection.</p>
<p>The GDPR is an overhaul of data protection law in Europe with far more stringent requirements than the previous laws. It requires full disclosure for any data collection and standardized privacy notices to help users understand where and how the data is being used. Consent to have data collected must be confirmed and users have the right to access their own data. It also includes the right of erasure or &#8220;the right to be forgotten,&#8221; which allows users to remove their data from the web. The GDPR goes into effect in May 2018.</p>
<p><a href=\"https://webdevlaw.uk/\" target=\"_blank\">Heather Burns</a>, a digital law specialist who consults and speaks extensively on internet laws and policies, encouraged WordPress contributors to frame the discussion regarding privacy concerns in terms of working towards compliance with a specific framework.</p>
<p>&#8220;For the purposes of this discussion, core should work to the GDPR standard for two reasons,&#8221; Burns said. &#8220;The first reason lies in cultural differences. The US does not have a single overarching data protection and privacy regulation, unlike Europe, where we have this data protection regime which applies to all personal data regardless of use, format, or sector. So GDPR gives developers &#8211; even those outside the EU &#8211; a robust, healthy, and very tough set of standards to follow. Given what we have seen coming out of the White House in the past week, GDPR also provides as good a starting point as any for defensive user protection.</p>
<p>&#8220;The second is that GDPR is extraterritorial. It applies to the personal data of anyone in Europe regardless of where the online service is located. If your business is in the US or Australia or Israel but you have European users, you have to protect their data to European GDPR standards.&#8221;</p>
<p>Pricewaterhouse Coopers recently surveyed 200 US-based multinational companies with more than 500 employees and found that <a href=\"https://www.pwc.com/us/en/increasing-it-effectiveness/publications/assets/pwc-gdpr-series-pulse-survey.pdf\" target=\"_blank\">77% plan to spend $1 million or more on GDPR compliance</a>. More than half of those surveyed cited GDPR readiness as the highest priority on their data-privacy and security agendas.</p>
<p>The hefty penalties of noncompliance are one of the driving factors behind American companies spending millions of dollars on satisfying the requirements of this new European regulation.</p>
<p>&#8220;GDPR is a complete overhaul of its dialup-era (1995) predecessor and one of the areas that has been beefed up is its teeth,&#8221; Burns said. &#8220;Businesses which are found to be in noncompliance by a European member state&#8217;s data protection regulator, whether that is your small app studio all the way up to Automattic, could face penalties of up to 4% of the business&#8217;s global annual turnover. Now there’s some solid context for the philosophical discussion.&#8221;</p>
<p>However, not everyone is convinced that the GDPR will be beneficial to consumers. Kitty Kolding, CEO and president of <a href=\"http://www.infocore.com/\" target=\"_blank\">Infocore Inc</a>, an international company that specializes in sourcing market data, told <a href=\"https://www.exchangewire.com/blog/2016/07/07/an-american-perspective-the-three-worst-things-about-the-eu-gdpr/\" target=\"_blank\">ExchangeWire</a> that she believes the GDPR will undermine &#8220;the sanctity of consumers&#8217; data privacy and security&#8221; and hobble marketing and advertising worldwide.</p>
<p>She contends that provisions like the &#8220;right to be forgotten,&#8221; which require customer data to be retained beyond the time that it&#8217;s in active use, will make that data more susceptible to hacking. Additionally, the enforcement body for the new legislation claims authority over companies, with the right to search and seize records, without any oversight or appeals.</p>
<p>&#8220;Every company everywhere that handles data on EU citizens is also automatically subject to this group’s absolute power – though it’s anybody’s guess how the EU believes they can enforce such a broad mandate outside its own borders,&#8221; Kolding said.</p>
<p>Currently, only two trac tickets <a href=\"https://core.trac.wordpress.org/search?q=GDPR\" target=\"_blank\">mention the GDPR</a> so it&#8217;s not yet clear how WordPress core will respond to the requirements of the new legislation. Burns recommends that WordPress core contributors go through the process of conducting a <a href=\"https://ico.org.uk/for-organisations/guide-to-data-protection/privacy-by-design/\" target=\"_blank\">privacy impact assessment</a> to determine the right way forward.</p>
<p>Regardless of WordPress&#8217; response, companies and organizations that depend on the software  will need to assume the responsibility of their own compliance, as these requirements extend far beyond core. The GDPR applies to anything added into a website or app that collects users&#8217; data. For example, many contact form plugins store submissions inside the WordPress database and site owners will want to re-examine how users are notified of this.</p>
<p>&#8220;One of the main changes with GDPR is called the accountability principle,&#8221; Burns said. &#8220;Businesses collecting personal data must be completely transparent and accountable over what data they are collecting, how they are storing it and where, who it is being passed to (such as third parties), who has access to it, and how long it is retained. Users also have the right to request that any data collected about them must be deleted.&#8221;</p>
<p>There&#8217;s no WordPress plugin that will instantly make a site GDPR compatible. Drupal has a <a href=\"https://www.drupal.org/project/gdpr\" target=\"_blank\">GDPR module</a> that aims to make sure the site follows the guidelines and legislation set by the EU, but it doesn&#8217;t cover all requirements. Automating an assessment of privacy impact for a site using a CMS and potentially dozens of third-party extensions is a complex endeavor. This is one regulation that will require business owners to educate themselves and implement privacy practices that put users&#8217; interests first.</p>
<p>With the deadline for compliance closing in, WordPress has an opportunity to re-evaluate how the project handles user privacy and make steps towards greater transparency. If contributors are looking into collecting more data to assist decision-making on features, as outlined in Rand-Hendriksen&#8217;s telemetry proposal, this project provides an avenue for working towards GDPR compliance. These privacy concerns are especially important to address when considering WordPress for government, healthcare, educational institutes, and other data sensitive websites.</p>
<p>Burns views the GDPR&#8217;s compliance deadline as a fresh opportunity for WordPress to build better privacy structures and legal certainty using the regulation as a healthy baseline for all users.</p>
<p>&#8220;Everyone needs to be working in implementations for their own businesses and sites in any case ahead of deadline day, in addition to any changes that need to be made in the WP code,&#8221; Burns said. &#8220;It&#8217;s important to remember that GDPR compliance is not a tick box you can squeeze in next April. This is about your processes, your workflows, and your systems of accountability. Start now.&#8221;</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Feb 2017 00:10:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"WPTavern: Logging Into WooCommerce.com Now Requires a WordPress.com Account\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65488\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://wptavern.com/logging-into-woocommerce-com-now-requires-a-wordpress-com-account\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5935:\"<p>If you logged into <a href=\"https://woocommerce.com/\">WooCommerce.com</a> over the weekend, you may have noticed a distinct change. In order to sign into the site, users are now <a href=\"https://public-api.wordpress.com/oauth2/authorize?response_type=code&client_id=50916&state=26cc0ecf5f249227f5566d9b1bc392db&redirect_uri=https%3A%2F%2Fwoocommerce.com%2Fwc-api%2Fwpcom-signin%3Fnext%3Dmyaccount&blog_id=0&wpcom_connect=1&new-user=1\">required</a> to have a WordPress.com account. The change occurred without warning and surprised those who manage multiple WooCommerce stores for clients.</p>
<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/WooCommerceWPComLoginScreen.png?ssl=1\"><img /></a>WooCommerce Login Screen Requiring a WP.com Account
<p><a href=\"https://twitter.com/bradkgriffin?lang=en\">Brad Griffin</a>, who maintains a number of client sites that run WooCommerce, raised concerns over the change <a href=\"https://www.facebook.com/groups/advancedwp/permalink/1388565454538998/\">in a post</a> on the Advanced WordPress Facebook group.</p>
<p>&#8220;When dealing with businesses, asking someone at a corporate level to take their email address and make a WordPress.com account is a bit problematic,&#8221; Griffin said. &#8220;They&#8217;re confused as to why they need to do this. They don&#8217;t have immediate access to that email address on a Saturday or Sunday.&#8221;</p>
<p>&#8220;So, without warning, without notice, without a heads up or anything else, no one can now access anything in the back-end of the WooCommerce account unless there is a WP.com single sign on account using oAuth.&#8221;</p>
<p>For those not interested in signing in with their WordPress.com account, WooCommerce.com attempts to alleviate concerns <a href=\"https://woocommerce.com/signin-with-wordpress/not-interested/\">in an article</a> that outlines the benefits. The benefits include an option to enable 2-Factor Authentication, access to eCommerce services, and viewing purchase history.</p>
<p>After speaking to Todd Wilkens, Head of WooCommerce at Automattic, Griffin published <a href=\"https://www.youtube.com/watch?v=VXfugcpuD4Y\">video</a>, explaining the change and offers suggestions for those who manage multiple WooCommerce stores for clients. The suggestions are:</p>
<ul>
<li>Make 100% sure that you, your client, your store, your account, or anything else has a WordPress.COM account ~ not just WordPress.org!</li>
<li>Once you&#8217;ve used an email and login and you are setup for WordPress.COM (not .org), make absolutely certain that you are using an incognito browser window when logging into WooCommerce.com.</li>
</ul>
<p>Using a private or incognito browser window won&#8217;t remember the login as the cookie is not saved. If you don&#8217;t use incognito mode and like, comment, or subscribe to items on WordPress.com or any site that uses <a href=\"https://developer.wordpress.com/docs/oauth2/\">WordPress.com&#8217;s oAuth protocol</a>, those actions will occur under the client&#8217;s account. &#8220;<span class=\"_5yl5\">Many users might not fully realize how far-reaching that one little oAuth endpoint <strong>actually is</strong> and the vastly significant number of touch-points it can affect,&#8221; Griffin said. </span></p>
<p>Wilkens <a href=\"https://woocommerce.com/2017/01/woocommerce-requires-wordpress-account/\">published a post</a> on the official WooCommerce blog explaining why the login system was switched, &#8220;We found that a lot of customers were using <i>two accounts</i> to access services from <i>one</i> company,&#8221; he said.</p>
<p>&#8220;To simplify that, we are centralizing on the WordPress.com login. Automattic has done this with previous acquisitions, like Polldaddy, for the same reasons. Now you can use only one login to access all Automattic services, including WooCommerce, Jetpack, VaultPress and more.&#8221;</p>
<p>So far, the WooCommerce team has tracked more than 10K successful logins to the new system and are monitoring feedback on social media. Only a small subset of users have reported issues due to confusion, &#8220;Over half of the 1% of users who opened tickets were confused between having a WordPress.com login vs. the login they use for their self-hosted WordPress install,&#8221; Wilkens said.</p>
<h2>A Better Way to Manage Multiple Client Accounts Is in the Works</h2>
<p>WooCommerce.com joins a growing collection of Automattic services, sites, and products that require a WordPress.com user account. As the number of reasons to have an account increases, perhaps it&#8217;s time for Automattic to create a client management system. A system that allows users to assign people who can act on their behalf, similar to a <a href=\"https://en.wikipedia.org/wiki/Power_of_attorney\">power of attorney</a>.</p>
<p>An example that comes to mind is <a href=\"https://www.godaddy.com/pro#reduce\">GoDaddy Pro</a>. GoDaddy Pro allows consultants to access all of their client&#8217;s products in one place. They can also manage aspects of their hosting and purchase products on their behalf.</p>
<p>The change to WooCommerce.com has emphasized the unfriendliness of the site&#8217;s current system for those who manage multiple client accounts. &#8220;We had already re-prioritized a number of features on our roadmap to make life for developers managing dozens of client accounts much smoother, and hope to have something to be able to announce there soon,&#8221; Wilkens said.</p>
<p>If you manage multiple client accounts and are affected by this change, Wilkens suggests <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">opening a ticket</a> for advice. You can also provide feedback by voting on a poll at the <a href=\"https://woocommerce.com/2017/01/woocommerce-requires-wordpress-account/\">bottom of the post</a> that asks how your experience was switching to a WordPress.com login.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 31 Jan 2017 20:02:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: Micro.blog Project Surges Past $65K on Kickstarter, Gains Backing from DreamHost\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65437\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://wptavern.com/micro-blog-project-surges-past-65k-on-kickstarter-gains-backing-from-dreamhost\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9480:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/micro-blog-logo.png?ssl=1\"><img /></a></p>
<p>With one week remaining on its Kickstarter campaign, the <a href=\"https://wptavern.com/micro-blog-surpasses-kickstarter-funding-goal-set-to-launch-new-social-network-for-independent-microblogs\" target=\"_blank\">Micro.blog indie microblogging project</a> has surged past its original $10K funding goal with $66,710 pledged by 2,381 backers. This puts project creator Manton Reece closer to his <a href=\"https://www.kickstarter.com/projects/manton/indie-microblogging-owning-your-short-form-writing/posts/1785295\" target=\"_blank\">stretch goal of $80K</a>, which would enable him to develop a Safe Replies feature to preemptively combat abuse on the platform and hire a part-time community manager.</p>
<p>Micro.blog also <a href=\"https://www.dreamhost.com/blog/2017/01/24/pitching-support-open-web/\" target=\"_blank\">picked up support from DreamHost</a> this week, pushing the project past the $50K mark. The hosting company pledged $5,000 towards the campaign.</p>
<p>&#8220;What ever happened to the vision of the open web as a distributed network of websites that were owned by their creators?&#8221; said Jonathan LaCour, SVP of Product and Technology at DreamHost. &#8220;We’d like to make it as easy as possible to launch a WordPress-powered microblog on DreamHost that integrates well with Manton’s upcoming Micro.blog service.&#8221;</p>
<p>DreamHost (and all other hosting companies) obviously have a vested interest in getting people to see the need to have their own digital presence. However, the biggest obstacle for WordPress customers is making it convenient to join the IndieWeb. DreamHost is planning to take its support of Micro.blog one step further and create an easy way for customers to get started with independent microblogs.</p>
<p>&#8220;As a followup to our contribution to Manton&#8217;s Kickstarter campaign, we&#8217;re planning on working on making a streamlined, pre-configured Indie microblog with WordPress at DreamHost,&#8221; LaCour said in the <a href=\"https://chat.indieweb.org/2017-01-25#bottom\" target=\"_blank\">#indieweb</a> channel on IRC yesterday. &#8220;I tend to agree that a simplified, pre-packaged WordPress setup would go a long way to driving Indieweb adoption.&#8221;</p>
<p>When asked whether the company would be utilizing Micro.blog or some other service, LaCour said it has not been decided yet. He said the idea is that people could create an independent microblog hosted at DreamHost that is compatible with Micro.blog and other indie microblogs.</p>
<p>&#8220;Our major focus at the moment is getting people excited about owning their own website (and entire digital identity),&#8221; LaCour said.</p>
<h3>Micro.blog is Aiming for Incremental Webmention Support</h3>
<p><a href=\"https://webmention.net/draft/\" target=\"_blank\">Webmention</a> is a protocol similar to pingback for notifying a URL when a website links to it and also for requesting notifications when another site mentions one of your URLs. It is an important part of facilitating decentralized communication across the web. On January 12, 2017, the <a href=\"https://www.w3.org/Social/WG\" target=\"_blank\">Social Web Working Group</a> published a <a href=\"https://www.w3.org/TR/2017/REC-webmention-20170112/#w3c-recommendation-12-january-2017\" target=\"_blank\">W3C Recommendation of Webmention</a> with the specification contributed by the <a href=\"https://indieweb.org/\" target=\"_blank\">IndieWeb</a> community.</p>
<p>WordPress doesn&#8217;t natively offer <a href=\"https://webmention.net/draft/\" target=\"_blank\">Webmention</a> support and the core trac <a href=\"https://core.trac.wordpress.org/ticket/35435\" target=\"_blank\">ticket</a> for adding the feature has had little discussion.</p>
<p>During a preliminary <a href=\"https://wordpress.slack.com/archives/core/p1452663582010063\" target=\"_blank\">discussion on Slack</a> last year, WordPress lead developer Dion Hulse said he thought Webmentions would be a great feature plugin and that there are a few people interested in it. There hasn&#8217;t been much movement on this front in core, but a <a href=\"https://wordpress.org/plugins/webmention/\" target=\"_blank\">Webmention plugin</a> is available in the directory.</p>
<p>Reece is working on incorporating IndieWeb protocols into Micro.blog but said it will likely launch with incremental support for Webmention.</p>
<p>&#8220;It might take a little while to get everything IndieWeb in there, but that&#8217;s the eventual goal,&#8221; Reece <a href=\"https://chat.indieweb.org/2017-01-25#t1485379721875000\" target=\"_blank\">said</a>. &#8220;I&#8217;m committed to Micropub and microformats and still exploring how best to support Webmention. (It might be partial support with more later.)&#8221;</p>
<p>Micro.blog doesn&#8217;t currently handle mentions and replies using Webmention but Reece said his eventual goal is to include it.</p>
<p>&#8220;The first step to me is getting more people their own microblog so that the infrastructure for cross-site replies is even possible,&#8221; Reece said.</p>
<h3>Micro.blog Puts the Focus on Indie Microblogging, Instead of Replacing Twitter</h3>
<p>Reece also <a href=\"http://www.manton.org/2017/01/microblogging-community-on-slack.html\" target=\"_blank\">launched a Slack community</a> where the project&#8217;s backers can discuss Micro.blog and other microblogging topics. He said he initially had reservations with starting something on Slack but was surprised to see the community has already grown to more than 300 members.</p>
<p>&#8220;I didn’t want to distract from any posts that should happen in the open on blogs,&#8221; Reece said. &#8220;Some discussion just fits better in chat, though. There’s an emerging community of indie microbloggers. Having a place to share tips, tools, and ask questions about Micro.blog just makes sense.&#8221;</p>
<p>Many of the project&#8217;s backers are eager to create a community of their own and are interested in using Micro.blog as a Twitter replacement. Other services have attempted to provide alternatives to posting directly on Twitter but none have caught on enough to significantly push IndieWeb adoption forward. <a href=\"http://app.net\" target=\"_blank\">App.net</a>, one of the most promising ad-free, microblogging networks, went into maintenance mode in 2014 and will be shutting down March 15, 2017.</p>
<p>Reece, who was an early fan of App.net, <a href=\"http://www.manton.org/2017/01/thank-you-to-app-net.html\" target=\"_blank\">published a thank you note</a> to the service&#8217;s creators for trying something risky and creating a community around their ideas. He believes it&#8217;s the right time for another open platform to emerge.</p>
<p>&#8220;We don’t need just another Twitter or Facebook clone,&#8221; Reece said. &#8220;We need a new platform that encourages blogging on the open web.&#8221;</p>
<p>Nevertheless, Reece is preparing Micro.blog from the outset to be capable of replacing Twitter&#8217;s functionality, which is one of the reasons he is focusing so heavily on ensuring the platform <a href=\"https://twitter.com/manton2/status/821084145782759425\" target=\"_blank\">doesn&#8217;t get overrun with abuse</a>. Reece wants to avoid the pitfalls that have contributed to some of the more negative aspects of Twitter, but his focus is on encouraging people to blog from their own space.</p>
<p>&#8220;Micro.blog is a success if more people blog,&#8221; Reece <a href=\"https://twitter.com/manton2/status/820372146375524359\" target=\"_blank\">said</a>. &#8220;To provide value it doesn’t need to replace Twitter, but it can.&#8221;</p>
<p>The project&#8217;s mobile app is key to making it convenient for users to read other people&#8217;s posts and post directly to their own websites from the same interface. Reece shared another <a href=\"https://www.kickstarter.com/projects/manton/indie-microblogging-owning-your-short-form-writing/posts/1783438\" target=\"_blank\">preview of the iPhone and iPad app</a> that will be ready at launch and said he hopes there will be other apps developed by the community.</p>
<p>&#8220;Most RSS traditional readers can&#8217;t post,&#8221; Reece said. &#8220;I think this makes for a more complete experience, and because it&#8217;s just a blog I can still use other apps and platforms to post.&#8221; He plans to give Micro.blog a 280 character limit before truncating the post.</p>
<p>Keeping the timeline fast and making posting convenient will be critical to the platform&#8217;s success as an alternative to the dominant social media silos. Polling blogs for new content is not very aggressive in the current prototype but Reece is tuning this to provide a better experience. The platform uses rssCloud and WebSub (formerly PubSubHubbub) to provide a more Twitter-like, real-time experience.</p>
<p>Micro.blog seems to be landing at the right time, as the idea has already resonated with more than 2,300 people willing to back the project. The service hasn&#8217;t even launched but the concept behind it is already attracting a supportive community eager to explore better ways of powering microblogging on the web.</p>
<p>&#8220;You don’t replace Twitter overnight, or even try to,&#8221; Reece said. &#8220;But step by step, we’re going to end up with a better web, and I think independent microblogging is part of that.&#8221;</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Jan 2017 22:56:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"Dev Blog: WordPress 4.7.2 Security Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4676\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2017/01/wordpress-4-7-2-security-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2141:\"<p>WordPress 4.7.2 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>
<p>WordPress versions 4.7.1 and earlier are affected by three security issues:</p>
<ol>
<li>The user interface for assigning taxonomy terms in Press This is shown to users who do not have permissions to use it. Reported by David Herrera of <a href=\"https://www.alleyinteractive.com/\">Alley Interactive</a>.</li>
<li><code>WP_Query</code> is vulnerable to a SQL injection (SQLi) when passing unsafe data. WordPress core is not directly vulnerable to this issue, but we&#8217;ve added hardening to prevent plugins and themes from accidentally causing a vulnerability. Reported by <a href=\"https://github.com/mjangda\">Mo Jangda</a> (batmoo).</li>
<li>A cross-site scripting (XSS) vulnerability was discovered in the posts list table. Reported by <a href=\"https://iandunn.name/\">Ian Dunn</a> of the WordPress Security Team.</li>
<li>An unauthenticated privilege escalation vulnerability was discovered in a REST API endpoint. Reported by <a href=\"https://twitter.com/MarcS0h\">Marc-Alexandre Montpas</a> of Sucuri Security. *</li>
</ol>
<p>Thank you to the reporters of these issues for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>
<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.7.2</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.7.2.</p>
<p>Thanks to everyone who contributed to 4.7.2.</p>
<p>* Update: An additional serious vulnerability was fixed in this release and public disclosure was delayed. For more information on this vulnerability, additional mitigation steps taken, and an explanation for why disclosure was delayed, please read <a href=\"https://make.wordpress.org/core/2017/02/01/disclosure-of-additional-security-fix-in-wordpress-4-7-2/\">Disclosure of Additional Security Fix in WordPress 4.7.2</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 26 Jan 2017 19:34:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Aaron D. Campbell\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"HeroPress: Screw the Blueprint. Design Your Own Path to Fulfillment.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1579\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://heropress.com/essays/screw-blueprint-live-life-terms/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9274:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/01/012517-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"Pull Quote: I wasn\'t following the blueprint, but I was having success and felt secure in the ways that mattered to me.\" /><p>Growing up, I bought into society’s notion of what made for a successful and rewarding life. For me, the blueprint for finding fulfillment looked something like this:</p>
<p>Step 1. Get good grades in school.</p>
<p>Step 2. Attend a nice college.</p>
<p>Step 3. Land a secure job with an attractive salary and benefits.</p>
<p>Step 4. Find a nice man that would make a good husband and father…and marry him.</p>
<p>Step 5. Have children.</p>
<p>Step 6. Die peacefully at an old age. (ha!)</p>
<p>I was convinced that if I simply followed this blueprint, I’d find security and acceptance. And with the exception of Step #6 (a step I’m hoping to postpone for some time), I was able to accomplish everything I’d set out to do. My grades in school were outstanding, which set me up to pursue a degree in mechanical engineering at the University of Illinois. After graduating in 2000, I was presented with several job opportunities. Ultimately, I accepted a position at Procter &amp; Gamble as an engineer for Charmin. Within a year of starting that job, I met my future husband. We married in 2004 and had our first child in 2007. Another child followed in 2008. I was right on track with my blueprint!</p>
<p>And then everything fell apart.</p>
<h2><strong>A breakdown wasn’t in the plan</strong></h2>
<p>In 2008, I suffered my first real breakdown. I spent several weeks doing my best to get through each day, doing what I needed to as an employee, wife, and mom and trying hard not to let other people down. I fought back tears when I needed to, only letting them flow in private. While the kids were sleeping, I’d escape into the world of TV sitcoms. I knew that something wasn’t right.</p>
<p>While I had followed the blueprint for security, success, and happiness, I didn’t feel like I had achieved any of these things. I felt isolated at work. At home, I felt valued only if I were functioning as the perfect wife and mom. At the time, the solution seemed clear—quit my corporate job and focus 100% on my family. This, I was certain, would lead to ultimate happiness. So I took two extended maternity leaves, eventually leaving the corporate world to focus on being a stay-at-home mom.</p>
<h2><strong>Who the hell am I?</strong></h2>
<p>Being home with kids full-time, no matter how wonderful your kids may be, is by far the most challenging job. While I was grateful that I had the choice to be a stay-at-home-mom, being at home left me feeling alienated. I didn’t really know who I was anymore or how to get back to “myself.”</p>
<p>So I started experimenting with things I simply felt like doing. These things weren’t part of any blueprint, and there was no guarantee of success or happiness. I just followed my heart.</p>
<p>I needed something challenging to occupy my mind, so I dug out my sports card collection with the intent of finally organizing it. Looking through my old cards felt both nostalgic and therapeutic, and my head started spinning with other ideas. Business ideas. My dad had a successful e-bay business that seemed like a bit of fun, so I thought: <em>why not try selling sports cards on e-bay?</em> I didn’t want to sacrifice my personal collection, so over the course of a few months, I purchased nearly a million sports cards on Craigslist. After repackaging them into 1000-count boxes, I sold them for $10/box, doubling my money in a short period of time. I learned a lot about buying and selling on the Internet but more importantly, I felt like I had discovered something that was really “me.” It was challenging in a new and exciting way, and it fit in with my hectic mom schedule.</p>
<p>This venture into the world of online business opened my eyes in a significant way. I started following entrepreneurs such as Gary Vaynerchuk and Chris Brogan, and flew to Houston for a Mom 2.0 Summit. I loved every blog post I read and all the people I was meeting. It was a whole new world filled with risk and uncertainty but grounded in the values of helping people and living a good life. THIS WAS PERFECT FOR ME.</p>
<h2><strong>And then came WordPress</strong></h2>
<p>In my newfound fascination with all things Internet-related, it wasn’t surprising that I stumbled upon this thing called WordPress. I had always wanted to build a website, and with the popularity of mom bloggers exploding, I naturally gravitated toward this “easy” platform for my blog. I started the ChicagoActons blog as a way to share our family adventures with others. Building the site was something I enjoyed more than I anticipated. It fed my love of problem solving and I felt great satisfaction in seeing something that I built on the Internet. And I could do it in between changing dirty diapers and cuddling with my kids.</p>
<p>After building ChicagoActons and sharing it via social channels, I started to get requests to build sites for others. Some were paid assignments and some were not, but I was falling in love with using this tool and my brain to help others further efforts they were passionate about. I was finding myself again, and I felt happy.</p>
<h2><strong>Where were WordCamps all my life?</strong></h2>
<p>By 2010, two years into freelance WordPress development, I was ready to expand my horizons and see what others were doing with the platform. I heard about WordCamp Chicago, and bought a ticket to the event that would confirm that the path I was paving was the right one for me.</p>
<p>At WordCamp Chicago 2010, I learned a great deal about developing with WordPress, but even more life changing were the people I met. They were such a diverse group and so different than I was, yet we all shared the same passion: to support one another in our pursuits to help others. And we all used WordPress as the tool to get the job done.</p>
<p>The feeling of acceptance and growth that I experienced at my first WordCamp was the impetus I needed to continue down the path as a WordPress-based business entrepreneur. I wasn’t following a blueprint anymore, but I was finding success and security in ways that mattered to me.</p>
<p>I was happy.</p>
<h2><strong>Living my own blueprint</strong></h2>
<p>Fast-forward to today. I couldn’t be more thankful for the life journey I’m on. My kids survived having me as a stay-at-home parent, and as a WordPress-based business entrepreneur, I feel challenged every day to be better at helping others build their passion-driven interests. I would not have gotten here had it not been for WordPress and the WordPress community, which emboldened me to abandon a blueprint for happiness that simply wasn’t working for me and instead embrace life on my own terms.</p>
<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Screw the Blueprint. Design Your Own Path to Fulfillment.\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Screw%20the%20Blueprint.%20Design%20Your%20Own%20Path%20to%20Fulfillment.&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fscrew-blueprint-live-life-terms%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Screw the Blueprint. Design Your Own Path to Fulfillment.\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fscrew-blueprint-live-life-terms%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fscrew-blueprint-live-life-terms%2F&title=Screw+the+Blueprint.+Design+Your+Own+Path+to+Fulfillment.\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Screw the Blueprint. Design Your Own Path to Fulfillment.\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/screw-blueprint-live-life-terms/&media=https://heropress.com/wp-content/uploads/2017/01/012517-150x150.jpg&description=Screw the Blueprint. Design Your Own Path to Fulfillment.\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Screw the Blueprint. Design Your Own Path to Fulfillment.\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/screw-blueprint-live-life-terms/\" title=\"Screw the Blueprint. Design Your Own Path to Fulfillment.\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/screw-blueprint-live-life-terms/\">Screw the Blueprint. Design Your Own Path to Fulfillment.</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Jan 2017 12:00:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Heather Acton\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:41;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: WordCamp Europe 2017 to Experiment with Sponsors Workshops\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65117\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/wordcamp-europe-2017-to-experiment-with-sponsors-workshops\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12145:\"<p><a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/wordcamp-europe-2017.png?ssl=1\"><img /></a></p>
<p>WordCamp Europe 2017 <a href=\"https://2017.europe.wordcamp.org/2016/12/29/wordcamp-europe-2017-call-for-sponsors-is-now-open-wceu/\" target=\"_blank\">opened its call for sponsors</a> at the end of 2016. The organizing team is embracing the challenge of delivering value to sponsors with workshops for those purchasing the two highest sponsorship levels:</p>
<blockquote><p>This year, for the first time, we are introducing a third track during both conference days. The third track will be solely dedicated to sponsors, giving you the possibility to either hold a talk or a workshop. Like the other two tracks, the sponsor track will have a dedicated space (capacity for approx. 200 people), where the audience would have the opportunity to hear more about your business and product. You can decide whether you would like to use your time to talk more about your business, or to showcase.</p></blockquote>
<p>The sponsors track has since been renamed to sponsors workshops, but the concept of a dedicated track remains the same. According to WCEU Sponsors Team coordinator Noel Tock, WordCamp Central&#8217;s transition into a public benefet corporation affords WordCamps more flexibility than previously allowed.</p>
<p>&#8220;This means we’d like to experiment with different concepts — seeking a higher return on investment for sponsors whilst at the same time protecting the core experience of the WordCamp itself,&#8221; Tock said.</p>
<p>The new sponsors workshops target large companies, but WCEU organizers have also created a new concept for small businesses. Those that made less than one million Euro in 2016 will qualify for an affordable booth in the middle of the event.</p>
<p>&#8220;Similar to TechCrunch’s Startup Alley, we want to help highlight smaller companies or ones that have just started out,&#8221; Tock said. &#8220;Simply seeking out sponsorship funds the fastest way possible would not be fair to attendees. This helps makes the conversations and experiences a lot more diverse and balanced.&#8221;</p>
<p>The sponsors workshops will not need to go through an approval process. They are perks belonging to the Super Admin and Admin sponsorship tiers and these top-level sponsors will have different options for how they want to use their slots.</p>
<p>&#8220;They can run user workshops, pass on their slot to smaller players (plugin and theme authors) or find other creative session ideas,&#8221; Tock said. &#8220;The workshops will be clearly labeled and we’ll seek to provide an agenda/schedule on the same timeline as regular speakers.&#8221;</p>
<h3>The Challenge of Delivering Value to Sponsors Without Stifling the Spirit of WordCamps</h3>
<p>WordCamps are traditionally locally-organized, informal events that bring together attendees from all walks of life. Affordability is one of the hallmarks of a WordCamp, and ticket prices normally range from $20-50. The low cost of entry makes the events more inclusive, keeping the camps from becoming relegated only to elites and those who work for large companies. At a WordCamp, one can meet anyone &#8211; core developers, educators, CEOs of multi-million dollar companies, new users, developers, bloggers, and e-commerce store owners.</p>
<p>To give you an idea of how uncommonly low WordCamp ticket prices are in comparison to other tech conferences, DrupalCon ranges from $450-600 per person. PHP UK tickets for the conference days are in the neighborhood of $500 and <a href=\"https://world.phparch.com/\" target=\"_blank\">PHP[World]</a> is nearly double that at $900. <a href=\"http://blog.cssconf.eu/2016/12/07/cssconfeu-tickets-2017/\" target=\"_blank\">CSSconf EU</a> tickets are $430. <a href=\"https://www.react-europe.org/#tickets\" target=\"_blank\">ReactEurope</a>, which is also being held in Paris, released its first round of tickets in the range of $680. WordCamp Europe <a href=\"https://2017.europe.wordcamp.org/tickets/\" target=\"_blank\">tickets</a> are €40.00 (approximately $43) because the vast majority of the cost of attendance is subsidized by sponsors.</p>
<p>Now that WordCamp Europe has been running successfully for five years, Tock said it is easier to get sponsors on board. Sponsorship cost per attendee is one of the contributing factors. In 2016 WordCamp Europe sold 2,199 tickets and organizers expect to sell more than 3,000 this year.</p>
<p>&#8220;If you compare the perks and size of the audience, you’ll find that WordCamp Europe can be anywhere from 20% to 50% cheaper then comparable WordCamps,&#8221; Tock said. &#8220;The bang for buck has meant we have a lot of returning sponsors.&#8221;</p>
<p>However, as WCEU attendance and the event&#8217;s financial requirements have grown, so has the challenge to deliver value to sponsors who are contributing greater sums of money.</p>
<p>&#8220;Asking potential sponsors for a few thousand a couple years back was easy enough,&#8221; Tock said. &#8220;Now that we’re looking for 50k+ Euros from certain sponsors, we need to up our game with it. This means early communication, well-defined packages, and more creative perks.&#8221; This year those perks include 360° booths, 30-second ads between talks, after-party branding, and the new sponsor workshops.</p>
<p>I spoke to several other organizers of comparably large WordCamps and all of them were intrigued by the idea of sponsor workshops and interested to see how the experiment turns out.</p>
<p>&#8220;I think on the surface it could be considered a controversial idea, but in reality it&#8217;s just giving sponsors a different kind of voice,&#8221; WordCamp Miami organizer David Bisset said. &#8220;If it&#8217;s done in a way that treats all sponsors fairly and is a voluntary track, then in some ways it doesn&#8217;t differ from a sponsor area, outside of narrowing the spotlight.&#8221;</p>
<p>Bisset said he&#8217;s interested to see how successful this approach is but notes that it probably would only work for the largest WordCamps.</p>
<p>&#8220;I honestly don&#8217;t know which side of the fence this lies on in regards the spirit of WordCamps,&#8221; Bisset said. &#8220;There have been controversial issues and challenges regarding sponsors and WordCamps in the past. It&#8217;s a challenge to give sponsors the most bang for their buck, treat everyone fairly, and be a model WordCamp. The jury is still out.&#8221;</p>
<p>WordPress Orlando organizer Lisa Melegari thinks the idea of sponsor workshops may bring some legitimacy to what is known as the &#8220;hallway track,&#8221; where attendees congregate when not attending a session.</p>
<p>&#8220;I think it&#8217;s a really interesting concept,&#8221; Melegari said. &#8220;There&#8217;s already the joke out there that there&#8217;s a phantom extra track at most WordCamps &#8211; the Hallway Track. I think this would take that and actually give some legitimacy to the myth.&#8221;</p>
<p>Melegari said WordCamp Orlando organizers have seen a significant shift in sponsor availability and enthusiasm in the past few years, especially after WordCamp US launched. She said their local camp lost several past sponsors to the larger WordCamp US. Other sponsors have decided to just focus on local camps and some have dropped sponsorship altogether.</p>
<p>&#8220;I really think we need to give our sponsors more opportunity to benefit their businesses, since their success allows them to continue to support our camps,&#8221; Melegari said. &#8220;Is it worth an entire extra track? Maybe not. That would put an unfair burden on camps that already have difficulty getting space and could deter sponsors from supporting a camp that cannot offer that accommodation.&#8221;</p>
<p>Melegari said she likes the idea of allowing sponsors to have a more prominent demo opportunity as long as it doesn&#8217;t overshadow the speakers, who volunteer their time.</p>
<p>&#8220;Having been a speaker with a very low attendance at a few talks, it&#8217;s disheartening, but understandable that another speaker&#8217;s talk is more popular,&#8221; she said. &#8220;I would be afraid the sponsor track would take away the spotlight on speakers.&#8221; From an organizer&#8217;s perspective, she is interested to see how sponsor workshops can deliver a better value for sponsorship.</p>
<p>&#8220;We really do need to provide a better case for WordCamp sponsorship besides exposure, because many of our recurring sponsors have a smaller and smaller pool of new eyes every camp,&#8221; Melegari said. &#8220;If we are going to keep growing in camp numbers, we&#8217;re going to have to figure out something to keep all the camps financially afloat.&#8221;</p>
<p>Alx Block, WordCamp US 2015-16 Organizer, understands the importance of sponsors and volunteers, who covered the bulk of the $516 actual cost per person for the most recent event.</p>
<p>&#8220;I think that we’re at an impasse when it comes to adding value for sponsors, especially at the larger camps,&#8221; Block said. &#8220;On the one hand, each sponsorship is really a <em>scholarship</em> for attendees, allowing each camp to greatly reduce the ticket price so that more people can attend and get value from the camp. On the other hand, there’s limited value for the sponsors in terms of ROI. We’ve never thought of it as a business investment, but it’s certainly time to think about that more.&#8221;</p>
<p>Keeping ticket prices low, putting on a quality event, and offering an array of perks for sponsorship is a tremendous balancing act for organizers. WordCamp Europe is one of fastest-growing camps that has experimented with doing this at a larger scale every year.</p>
<p>&#8220;When you get into the larger dollar amounts that larger camps ask, it’s a different kind of ballgame, and I think that we need to revisit the value that a business receives as part of their sponsorship,&#8221; Block said.</p>
<p>&#8220;I think something like sponsor workshops is a really neat idea. I can imagine that it doesn’t come with much overhead in terms of actual planning, and will give the sponsors something solid that they can plan for in terms of being able to pitch their product or service.&#8221;</p>
<p>Historically, workshops have been events that are ancillary to the main tracks. WordCamp Europe&#8217;s plan to run them alongside speaker sessions is a bold experiment. Sponsors will have a great deal of flexibility with how they can utilize their workshop slots, so it will be interesting to see if they choose to incentivize attendance in some way or opt to pass them along to other speakers as a sponsored talk.</p>
<p>&#8220;I think there’s a line between a sponsor &#8216;track&#8217; and sponsor &#8216;workshops,&#8217; which WCEU hasn’t clearly defined yet,&#8221; Block said. &#8220;I’m sure that their intention isn’t to have 1/3 of the talks be by people who paid to be there. From what I understand, the intention is to have the top-tier sponsors (maybe 4-6 of them) present on a smaller stage in a kind of rolling fashion, to supplement the full tracks &#8211; meaning, it would be a great place for an attendee to go during a time when neither of the other sessions appeals to them, or they’re interested in learning more about a specific product.&#8221;</p>
<p>Block said he has seen this type of sponsor perk at other non-WordPress conferences and has sat in on sessions that piqued his interest.</p>
<p>&#8220;But this is the real question in my mind: Can we offer something like this without turning WordCamps into a trade show?&#8221; Block said.</p>
<p>&#8220;I think now that we’re growing so much with these large camps, it’s the perfect time to ask these questions and figure out exactly what type of event WordCamp is. We grow as the community grows, and WordCamp should always reflect the community’s interest. If there’s interest in giving sponsors a place to talk about their wares, I’m all about it, but I’d always want the community to come first.&#8221;</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 24 Jan 2017 20:38:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:42;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"WPTavern: Wix Removes GPL-Licensed WordPress Code from Mobile App, Forks Original MIT Library\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65143\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:103:\"https://wptavern.com/wix-removes-gpl-licensed-wordpress-code-from-mobile-app-forks-original-mit-library\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14743:\"<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2014/06/ForkedFeaturedImage.png?ssl=1\"><img /></a>photo credit: <a href=\"http://www.flickr.com/photos/winterofdiscontent/3301816514/\">winterofdiscontent</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>
<p>In October 2016, <a href=\"https://ma.tt/2016/10/wix-and-the-gpl/\" target=\"_blank\">Matt Mullenweg called out Wix</a> for using GPL-licensed code from the WordPress mobile app and distributing it in its proprietary app. After identifying a path for Wix to comply with the license, Mullenweg <a href=\"https://wptavern.com/mullenweg-takes-aim-at-wix-over-gpl-abuses-wix-response-fails-to-address-licensing-issue\" target=\"_blank\">confirmed he would be willing to go to court to protect the GPL</a>.</p>
<p>Wix CEO Avishai Abrahami&#8217;s <a href=\"http://www.wix.com/blog/2016/10/dear-matt-mullenweg-an-open-letter-from-wix-coms-ceo-avishai-abrahami/\" target=\"_blank\">response</a> to the allegations failed to address the issue of licensing, dodging the question with references to other open source contributions. Abrahami seemed to indicate that Wix would open source its mobile app but was not clear whether it would be GPL licensed:</p>
<p>&#8220;We always shared and admired your commitment to give back, which is exactly why we have those 224 open source projects, and thousands more bugs/improvements available to the open source community and we will release the app you saw as well,&#8221; Abrahami said.</p>
<p>The Wix Twitter account also gave the impression that the entire app would be released under the GPL:</p>
<blockquote class=\"twitter-tweet\">
<p lang=\"en\" dir=\"ltr\"><a href=\"https://twitter.com/yairwein\">@yairwein</a> We\'ll release the code on Github, where we also shared our previous projects: <a href=\"https://t.co/FBhp2Kd5wn\">https://t.co/FBhp2Kd5wn</a></p>
<p>&mdash; Wix.com (@Wix) <a href=\"https://twitter.com/Wix/status/792656290854174721\">October 30, 2016</a></p></blockquote>
<p></p>
<p>Publicly communicating these intentions bought the company time to educate its developers on the implications of the GPL and find another path forward for the app.</p>
<p>The app has not been released under the GPL and Wix has discontinued development on the GPL-licensed repositories. On November 1, 2016, Wix changed the license on the <a href=\"https://github.com/wix/react-native-wordpress-editor\" target=\"_blank\">react-native-wordpress-editor</a>, the repository that was forked from the WordPress mobile app, to GPLv2. The next day, they began work on <a href=\"https://github.com/wix/react-native-zss-rich-text-editor/\" target=\"_blank\">react-native-zss-rich-text-editor</a>, a new repository forked from the original MIT-licensed library that the WordPress mobile app code built upon.</p>
<p>It appears that Wix never planned on complying with the GPL, since the company immediately began working on an alternative approach. Wix has since released updates to its mobile apps and presumably has incorporated its own editor component that is based on the original MIT-licensed library.</p>
<p>It is not clear whether Wix completely started over with its fork or if the company&#8217;s developers incorporated some of the commits previously made in the WordPress mobile app&#8217;s GPL-licensed fork. Wix has not responded to numerous attempts to contact them for an official statement.</p>
<h3>Wix Invents Its Own &#8220;Enhanced&#8221; MIT License for the Forked Library</h3>
<p>Here&#8217;s where the story takes an odd turn. Instead of distributing the new editor code under a <a href=\"https://opensource.org/licenses\" target=\"_blank\">standard open source library</a>, Wix has written its own license, which it is calling the <a href=\"https://github.com/wix/react-native-zss-rich-text-editor/blob/master/LICENSE\" target=\"_blank\">&#8220;Enhanced&#8221; MIT license (EMIT)</a>. It explicitly prohibits relicensing under the GPL and requires the developer to license modifications under the EMIT:</p>
<blockquote><p>This license is exactly like the MIT License, with one exception – Any distribution of this source code or any modification thereof in source code format, must be done under the Enhanced MIT license and not under any other licenses, such as GPL.</p></blockquote>
<p>Furthermore, the license prohibits the code being redistributed under any copyleft license:</p>
<blockquote><p>when the Software is distributed as source code, the licensee is prohibited to change the license of the Software to any “viral” copyleft-type license, such as, inter alia: GPL, LGPL, EPL, MPL, etc.</p></blockquote>
<p>Wix explained the reason behind the creation of the new license in its introduction, citing what it calls a &#8220;bug&#8221; in the MIT license. The MIT permits developers to re-license their modifications as GPL. The text of the &#8220;Enhanced&#8221; MIT license characterizes this practice as bullying:</p>
<blockquote><p>We believe MIT license has a bug since it allows others to use it against its nature. Our belief is that the MIT license is intended to make source code available to anyone who wants to use it without additional obligations, but we have found cases where someone takes a project licensed under MIT license, adds a few lines of source code to it, and then changes the licensing to a different, more restrictive license which is against the nature and the intent of the MIT license. By doing so, the source code released under the original MIT is no longer a true “free/open” source code, thus undermining the intention of the original creator of the source code.</p>
<p>The concept of this Enhanced MIT license is simple and more robust – you can do what you want with this source code, exactly like any other MIT license, but if you release it again as open source (even if modified), you must release it under this Enhanced MIT license – to be clear, this is not a “viral” license, it only refers to the actual source code released under this license and not to other components interacting with it. If GPL is a viral license, this license can be described as a “robust” one as it prevents licensing changes that are against its nature and it defends its own licensing principles. The essence of the Enhanced MIT license is to prevent bullies from using open source code that is truly free and open under the MIT License and turning it into other viral and more restrictive licenses – such as GPL.</p></blockquote>
<p>The license has only ever been used in this particular instance and does not appear to have been written by a lawyer or someone who has studied copyright and licensing issues professionally. I contacted the Free Software Foundation&#8217;s <a href=\"http://www.fsf.org/licensing\" target=\"_blank\">licensing and compliance team</a> regarding the legitimacy of Wix&#8217;s &#8220;Enhanced&#8221; MIT license. FSF copyright and licensing associate Donald Robertson III said the team is currently reviewing it and may require legal counsel before making a definitive comment. When they have completed the review, they will publish a statement and list the license in the <a href=\"https://www.gnu.org/licenses/license-list.html\" target=\"_blank\">FSF directory of free and non-free software licenses</a>. These are also broken down into copyleft and GPL-compatible classifications.</p>
<p>&#8220;As you can see from the <a href=\"https://www.gnu.org/licenses/license-list.html#GPLIncompatibleLicenses\" target=\"_blank\">GPL-incompatible licenses</a>, there are plenty of free software licenses that are incompatible with the GPL, and many of those licenses would be incompatible with other copyleft licenses on the same basis,&#8221; Robertson said. &#8220;So it is possible for a license to be free even if it doesn&#8217;t work well with the GPL. We&#8217;ll have to do some review on this particular license before we can make any comment specific to it.&#8221;</p>
<p>Wix has not submitted its EMIT license to the Open Source Initiative, a community-recognized organization that acts as stewards of the Open Source Definition (OSD) and also reviews and approves licenses as OSD-conformant. OSI has not yet responded to my inquiry about the legitimacy of the license, but I spoke with <a href=\"https://opentechstrategies.com/\" target=\"_blank\">Karl Fogel</a>, an open source specialist who consults with organizations on open source licensing and the implications of using it in business.</p>
<p>&#8220;This so-called &#8216;Enhanced MIT&#8217; license is poorly drafted and internally inconsistent,&#8221; Fogel said. &#8220;I feel on safe ground in saying that were it ever submitted to the OSI for approval, it would be rejected quickly.&#8221;</p>
<p>Fogel also commented on the inherent contradictions in the license&#8217;s introduction and permissions.</p>
<p>&#8220;An obvious internal inconsistency is that in the Introduction, it says that redistribution in source code format &#8216;must be done under the Enhanced MIT license and not under any other licenses, such as GPL,\'&#8221; Fogel said. &#8220;But then later, in point (2) of the conditional permissions grant, it says &#8216;when the Software is distributed as source code, the licensee is prohibited to change the license of the Software to any &#8216;viral&#8217; copyleft-type license, such as, inter alia: GPL, LGPL, EPL, MPL, etc.&#8217;</p>
<p>&#8220;So the Introduction is saying that redistribution is not permitted under <strong>any</strong> other open source license, but then the permissions grant section only bars redistribution under copyleft licenses, leaving open the possibility to distribute under other non-copyleft licenses. Which is it?&#8221;</p>
<p>According to OSI, <a href=\"https://opensource.org/faq#copyleft\" target=\"_blank\">copyleft</a> &#8220;refers to licenses that allow derivative works but require them to use the same license as the original work.&#8221; In requiring the EMIT to be used for derivative works, the license adopts the viral nature Wix ostensibly wanted to avoid with the GPL. This emasculates the MIT, robbing it of its essential freedoms. For this reason and many others, the EMIT appears to be an illegitimate variant of the MIT.</p>
<p>&#8220;A larger issue is that the reasoning in the Introduction about how the standard MIT license supposedly has a &#8216;bug&#8217; makes no sense,&#8221; Fogel said. &#8221; It asserts that redistribution under an open source copyleft license would somehow be more restrictive than not doing source redistribution at all (e.g., as with a standard proprietary license).  There is no sensible definition of the word &#8216;restrictive; in which releasing code under a copyleft license would restrict someone&#8217;s use of that code more than <em>not having the code in the first place</em> would restrict them.&#8221;</p>
<p>Fogel does not think the EMIT is a valid derivative of the MIT license and is not convinced that it can be considered a license at all.</p>
<p>&#8220;It is very clear that a lawyer did not write this license,&#8221; Fogel said. &#8220;I think Abrahami must have written it himself. I hesitate to even call it a license; it&#8217;s not clear what a judge would do with it, except perhaps sell tickets.&#8221;</p>
<h3>Wix&#8217;s EMIT License is a Hostile Reaction to the Call for GPL Compliance</h3>
<p>The EMIT license not only takes shots at the GPL but also injects a moral pronouncement against all those who subscribe to the tenets of copyleft licensing. The restrictions in the EMIT effectively &#8220;weaponize the license&#8221; against other open source projects, as one Reddit user said in a<a href=\"https://www.reddit.com/r/opensource/comments/5n7km9/wix_abandons_the_wordpress_editor_forks_original/\" target=\"_blank\">comment</a> on the situation. This encompasses a large portion of the open source community.</p>
<p>Wix may not be able to publicly admit its violation of the GPL, as it has not yet answered for the past infringement of distributing the code in its mobile app. In looking back over the timeline of events, Wix&#8217;s public communication that implied it would comply with the GPL was disingenuous, as the team was scrambling behind the scenes to fork the original library and slap a new &#8220;anti-copyleft&#8221; license on it. The company has no respect for the GPL and, in fact, has communicated its disdain for the license in the language of its new EMIT license.</p>
<p>&#8220;I remember reading this exchange when it happened,&#8221; Fogel said. &#8220;This is not a case of gray areas or &#8216;the truth lies somewhere in the middle.&#8217; Matt Mullenweg of WordPress is 100% right, and Wix CEO Avishai Abrahami is, quite simply, wrong. Mullenweg was extremely direct about what the problem was and how to fix it. Abrahami&#8217;s response was an evasive mishmash of brazen non sequiturs and willful refusal to acknowledge Mullenweg&#8217;s point, which was simply that if Wix is going to use WordPress code that is distributed under the GNU General Public License, then Wix has to follow the terms of the GPL like anyone else.</p>
<p>&#8220;Abrahami&#8217;s poor behavior could only have been intentional,&#8221; Fogel said. &#8220;I just don&#8217;t see any other way to interpret it, given how easy to understand Mullenweg&#8217;s letter is, and how clear the issues are here.&#8221;</p>
<p>Wix&#8217;s illegal use of GPL code in a proprietary app could easily be chalked up to ignorance or an oversight if the company had simply attempted to comply. Instead, they wrote a license that swipes back at copyleft proponents everywhere. The EMIT actually manages to trivialize both the GPL and the MIT in one fell swoop.</p>
<p>&#8220;The GPL is not a disease,&#8221; said <a href=\"http://www.rosenlaw.com/\" target=\"_blank\">Lawrence Rosen</a> in a document titled <a href=\"http://www.rosenlaw.com/html/GPL.pdf\" target=\"_blank\">The Unreasonable Fear of Infection</a>. &#8220;It is designed to satisfy certain philosophical and economic objectives that are widely shared by many members of the open source community.&#8221;</p>
<p>In writing its own &#8220;Enhanced&#8221; MIT license Wix has demonstrated a careless disregard for open source licensing and  hostility towards those who use copyleft licenses to guarantee user freedoms.</p>
<p>Although some onlookers in the open source community disapproved of the two CEO&#8217;s handling the disagreement in open letters, there are plenty more who appreciate that the issue is being hammered out in public. Fogel said he hopes the situation &#8220;will draw some attention to the fact that the GPL actually means something and can be enforced.&#8221;</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 21 Jan 2017 00:04:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:43;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"WPTavern: Obama Foundation Launches New Website Powered by WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://wptavern.com/obama-foundation-launches-new-website-powered-by-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1987:\"<p>The <a href=\"https://www.obama.org/\" target=\"_blank\">Obama Foundation</a> launched its new WordPress-powered website today. The future presidential center, which will be located in Chicago, will manage projects both in the city and other places around the world.</p>
<p>&#8220;More than a library or a museum, it will be a living, working center for citizenship,&#8221; President Obama said. &#8220;That&#8217;s why we want to hear from you. Tell us what you want this project to be and tell us what&#8217;s on your mind.&#8221;</p>
<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/obama-foundation-screenshot-e1484927287947.png?ssl=1\"><img /></a></p>
<p>The website integrates the <a href=\"https://www.typeform.com/\" target=\"_blank\">Typeform</a> service for collecting feedback from citizens on their hopes and dreams, as well as the people and organizations that inspire them.</p>
<p>WordPress developers were excited to see that the former President is using the WP REST API introduced in WordPress 4.7.</p>
<blockquote class=\"twitter-tweet\">
<p lang=\"in\" dir=\"ltr\">Oh hai WP REST API <a href=\"https://t.co/EBGDexNwRA\">pic.twitter.com/EBGDexNwRA</a></p>
<p>&mdash; Daniel Bachhuber (@danielbachhuber) <a href=\"https://twitter.com/danielbachhuber/status/822459669104889856\">January 20, 2017</a></p></blockquote>
<p></p>
<p>The custom theme for the Obama Foundation is built using <a href=\"http://foundation.zurb.com/\" target=\"_blank\">ZURB&#8217;s Foundation</a> as its front-end framework. It integrates the <a href=\"http://jquery.malsup.com/cycle/\" target=\"_blank\">jQuery Cycle Plugin</a> for galleries.</p>
<p>The website was created by <a href=\"http://www.bluestatedigital.com\" target=\"_blank\">Blue State Digital</a>, an agency that got its start on the campaign trail and now focuses on serving causes and brands.</p>
<p>President Obama is the first president to select WordPress for his presidential center website.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Jan 2017 17:39:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:44;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"BuddyPress: BuddyPress 2.8.0 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://buddypress.org/?p=263023\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://buddypress.org/2017/01/buddypress-2-8-0-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2965:\"<p>BuddyPress 2.8.0 Beta 1 is packed with new features and enhancements and is now available for testing. You can download the <a href=\"https://downloads.wordpress.org/plugin/buddypress.2.8.0-beta1.zip\">BP 2.8.0-beta1</a> zip or get a copy via our Subversion repository. We&#8217;d love to have your feedback and testing help.</p>
<p>BuddyPress 2.8.0 requires PHP 5.3+, and will not be activated on a server with a lower version of PHP. We also remind you that BuddyPress 2.8.0 will require <a href=\"https://bpdevel.wordpress.com/2016/11/17/2349/\" target=\"_blank\">at least WordPress 4.3</a>.</p>
<p>A detailed changelog will be part of our official release notes, but, until then, here’s a list of some of our favorite changes. (Check out <a href=\"https://buddypress.trac.wordpress.org/query?status=closed&group=resolution&milestone=2.8\">this report</a> on Trac for the full list.)</p>
<ul>
<li>BP Email: Allow end user to specify which PHPMailer should be used <a href=\"https://buddypress.trac.wordpress.org/ticket/7286\">#7286</a></li>
<li>Companion Stylesheet &#8211; Twentyseventeen <a href=\"https://buddypress.trac.wordpress.org/ticket/7338\">#7338</a></li>
<li>Minimum PHP version is 5.3 <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7325\">#7325</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7299\">#7299</a></li>
<li>Support List-Unsubscribe header in emails <a href=\"https://buddypress.trac.wordpress.org/ticket/7390\">#7390</a></li>
<li>Make group search more flexible <a href=\"https://buddypress.trac.wordpress.org/ticket/7418\">#7418</a> and other groups improvements, like <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7419\">#7419</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7399\">#7399</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7388\">#7388</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7386\">#7386</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/7375\">#7375</a></li>
<li>Lots of new filters in various parts of the code, like <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/6667\">#6667</a>, <a class=\"closed\" title=\"View ticket\" href=\"https://buddypress.trac.wordpress.org/ticket/5193\">#5193</a></li>
<li>Lots of inline documentation tweaks and other fixes and improvements</li>
</ul>
<p>BP 2.8.0 is almost ready, but please do not run it in a production environment just yet. Let us know of any issues you find in the <a href=\"https://buddypress.org/support/\">support forums</a> and/or <a href=\"https://buddypress.trac.wordpress.org/\">development tracker</a>.</p>
<p>Thanks everyone for all your help to date. We are excited to release BuddyPress 2.8.0 in February!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jan 2017 23:03:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Slava Abakumov\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:45;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Post Status: Shaping a vision of success\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=32469\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://poststatus.com/shaping-success-wordcamps/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14728:\"<p><em><strong>Editor&#8217;s note</strong></em>: This guest post is written by <a href=\"https://poststatus.com/profiles/jenny-beaumont/\">Jenny Beaumont</a>, a co-organizer of WordCamp Paris and WordCamp Europe. She&#8217;s spent the last two decades building things in and around the web, writes a <a href=\"http://www.jennybeaumont.com/subscribe/\">terrific newsletter</a>, and lives in France.</p>
<p>One of the highlights of my year, and a fitting end to 2016 as my <a href=\"http://www.jennybeaumont.com/celebrating-15-years-of-freelancingwith-a-sabbatical/\">sabbatical</a> drew to a close, was attending the 2nd annual <a href=\"https://poststatus.com/photos-post-status-publish-wordcamp-us-2016/\">WordCamp US</a>, held December 2-4 in Philadelphia, Pennsylvania.</p>
<p>The trip met my expectations in every way, from the warm-hearted nature of the locals to the super-sized portions at every delicious meal, and from the diversity of attendees to all of the extraordinary conversations I had during that short week I was in town.</p>
<p>“You might have noticed that this year’s programming at WordCamp US had some more of a human side, in addition to just the technical that we’ve had before,” said Matt Mullenweg, co-founder of WordPress and CEO of Automattic, during his much-anticipated <a href=\"https://poststatus.com/matt-mullenweg-state-word-2016/\">State of the Word</a>.</p>
<p>“I think that a lot of our opportunities to grow over the coming year are on the human side, and understanding the humanity of an open source project and working together and creating the code that’s going to touch humanity as well.”</p>
<p>Moving into 2017, ready for new opportunities and with the next edition of <a href=\"https://2017.europe.wordcamp.org/\">WordCamp Europe</a> on the horizon, I find myself thinking about growth past and present, and about what success might look like for all of us in this new year.</p>
<h3>Growth and competition for WordPress</h3>
<p>“It’s really all about pie,” replied Mullenweg when asked about the future of a WordPress entrepreneur, stating that as long as the pie continues to grow, everyone can get a piece.</p>
<p>He talked about how the new focuses of the WordPress project—the REST API, the Editor and the Customizer—along with an inclusive design-lead approach, should allow WordPress to reach new audiences.</p>
<p>WordPress has seen incredible growth in recent years, now representing over <a href=\"https://w3techs.com/technologies/overview/content_management/all\">27% of websites</a>, a full 20% ahead of competing platforms. This translates to 58.5% market share of all monitored content management systems, <a href=\"https://www.rarst.net/wordpress/powers-internet/\">when looking</a> at the top 10 million sites.</p>
<p>This doesn’t mean that the competition isn’t trying to close the gap. Mullenweg reported that the top proprietary platforms, such as Squarespace and Wix, spent upwards of 320 million in advertising dollars in 2016, often directly targeting search engine queries for WordPress.</p>
<p>“I think that in the past WordPress got by on a lot of sort marketing by happenstance,” he said, admitting the need to look at the marketing of WordPress in new ways, and hopefully pooling the resources of the community to do so.</p>
<p>“I think we have a real opportunity especially as the businesses around WordPress grow larger and larger, to actually coordinate a bit […] there’s no one company in the WordPress ecosystem that’s large enough to match 300 million dollars, and spend on telling people the WordPress story. But no one company needs to be large enough, because we’re a community.”</p>
<p>All in all, he painted a bright picture for the future for the WordPress ecosystem, the community of people who come together around a common purpose and ideal—the WordPress project and its mission to democratize publishing—and in so doing create a new paradigm for work and the web, the byproduct of which is a flourishing economy.</p>
<p>I can’t help but wonder, how big can the pie get? And while we concentrate on growth and competition, how do we measure the success of our mission? How will we know when we’ve democratized publishing? Can or should WordPress achieve this goal alone?</p>
<h3>The numbers game for WordCamps</h3>
<p>“We must tilt our hat and bow down to Europe, which beat us this year,” Mullenweg capitulated as he wrapped up his report on community growth, expressed in the number of events and event attendance worldwide.</p>
<p>Growth is an indication that we’re doing something right. An increase in the numbers tells us that more people are interested and getting involved. This is what an open source project needs to reach a wider audience, stay competitive and accomplish its mission: people to make it happen.</p>
<p>But should success be measured solely in numbers? Is it healthy to think that there can be winners and losers when it comes to the success of our community as a whole?</p>
<p>In its first three years, WordCamp Europe grew at a slow and predictable rate. Then last year, for some reason, it exploded. We sold our initial batch of 1500 tickets practically overnight, and ended up selling nearly 2200 tickets in total.</p>
<p>What happened? Did WordCamp Europe’s reputation catch up with itself, creating this burgeoning interest? Was Vienna simply an incredibly attractive destination for a lot of people? Or was it the organizing team that did an outstanding job at marketing and outreach?</p>
<p>WordCamp US was in its second year, and we can ask similar questions about why they didn’t see the growth they were expecting. Is the event, with its transition from the long-standing WordCamp San Francisco, still in its infancy, so that slow growth is to be expected? Was going to the same destination two years in a row not as appealing to attendees? Did the team do an adequate job of communicating around the event?</p>
<p>In my mind, both WordCamp Europe and WordCamp US were successful events. Each did a lot of things well, and some other things less well. Attendees I encountered, whether speakers, sponsors, volunteers or the general public, seemed to have a rewarding experience and their expectations met.</p>
<p>Because that’s why we put these events on, right? Not to “get the numbers” or “win”, but to create an enriching experience.</p>
<h3>Bigger is not necessarily better</h3>
<p>So, how big do we let ourselves get? This has been an ongoing question for us on the WordCamp Europe team since things took on a new dimension in Vienna.</p>
<p>When I asked <a href=\"https://paolo.blog/\">Paolo Belcastro</a>, WordCamp Europe local team lead in 2016 and global team lead for 2017, what he thought about growth he said, “For me a successful event is when we have one ticket left over. It should be our goal to make sure that everyone who wants to attend, can.”</p>
<p>This is a philosophy that I stand beside. It reflects our focus on attendees and on inclusiveness, so that it doesn’t matter whether we have 1000, 2000 or 3000 people, it only matters that we do our best to accommodate everyone and put on a great event for however many show up.</p>
<p>It does not, however, answer the question.</p>
<p>It’s exciting to run a popular event, and it’s easy to get carried away with that excitement and sense of accomplishment knowing that so many people want to attend, that so many people are being impacted in positive ways. When we focus solely on the numbers, and adopt a “bigger is better” mentality, it’s also easy to lose sight of some important consequences of growth.</p>
<h4>Professional level of production</h4>
<p>Keep in mind that we didn’t originally plan an event for 2200 people last year, and so we had to improvise, which meant a significant budget increase and a lot of extra work for the organizing team.</p>
<p>It also catapulted us into a new level of production. Putting on a large event is not the same as putting on a smaller one, and once you get up above 2000 attendees, it has a trickle down effect. It means organizing a speakers dinner for upwards of 300 volunteers, and an after party for 1500. These are events in and of themselves. We’re brought to collaborate with professionals in the events world—caterers, vendors, venues—while we’re still volunteers working in our “spare time”, some of us with more experience than others at making this all happen.</p>
<h4>Increased cost of WordCamps</h4>
<p>While the average ticket price per day has gone down, from $20 to $15.79, the cost of putting on a WordCamp has increased. Mullenweg reported that the cost of WordCamp US was $516 per person, while attendees continue to pay a mere $40 for entry to the two-day event, including lunch both days, free-flowing coffee, access to the contributor day and after party, not to mention the <a href=\"https://poststatus.com/photos-post-status-publish-wordcamp-us-2016/#jp-carousel-31176\">great swag</a>, which included both a t-shirt and an adorable Wapuu plushy this year.</p>
<p>The additional 90% of this cost falls to sponsors. Sponsors are not volunteers running a non-profit, they are businesses. As we ask more and more of them, they understandably are <a href=\"https://wptavern.com/the-value-of-sponsoring-a-wordcamp-from-a-business-perspective\">starting to question</a> what they get in return. Our response has typically been, “you’re supporting the community and gaining exposure,” but is that enough and for how long? How much is too much to ask?</p>
<h4>Setting expectations for sponsors and attendees</h4>
<p>How much is too much to ask of anyone? As we ask more of sponsors they expect more in return. As we grow, try to predict growth and to outdo ourselves every year, the task for organizers becomes more demanding. As we create bigger and better events, attendees expect to find the same elsewhere.</p>
<p>An event with 10,000 attendees would be amazing. We probably couldn’t call it a WordCamp, though. It would be a WordPalooza, and would require a full-time staff and a new approach to programming, sponsorship and organization on the whole. Does an event have to grow into order to be successful? Can maintaining a certain level of participation and quality also be considered a success?</p>
<p>Because it’s also possible that WordCamp US and WordCamp Europe will simply plateau at a certain capacity. The world may not be ready for a WordPalooza.</p>
<h3>Competition and success</h3>
<p>“One of the reasons why I think WordPress has such a collaborative community, when you see competitors hanging out with each other and getting drinks […] is that it’s a growing pie. So everyone’s slice of that pie can grow alongside. If it were shrinking or a static pie, the only way to grow would be taking some pie from someone else.”</p>
<p>Competition is widely considered good for business. It pushes companies to innovate and guard against complacency. It encourages a focus on customer service and helps protect consumers through competitive pricing. Competition in the marketplace confirms there is a market to be had, that demand is strong for the products or services being offered. It seeks to establish a basis for fairness, while letting companies vie for market share, sales and profit margins.</p>
<p>The friendly, collaborative nature of the WordPress community is born out of the open source philosophy of contribution and sharing. It is, in my mind, our greatest strength. Support within the community is unparalleled. We consistently root for one another, learn from one another, share our triumphs and our difficulties, through mergers, acquisitions, hirings, firings, career changes and even the occasional drama.</p>
<p>How big can WordPress get? Arriving at 100% market share is neither a likely nor a desirable scenario, if you believe in the benefits of competition and fair trade. The pie is not likely to grow exponentially, but rather will turn into something else entirely as the technology, the world and the web evolve, and the project along with them.</p>
<h3>Success and expectations</h3>
<p>“When we are candid about our shortcoming, it allows us to be better towards going to the future,” Mullenweg said in talking about the WordPress Editor.</p>
<p>This is a sentiment we can apply across the board, to ensure that our philosophy and our mission are reflected in our words and actions as we bring new users to our platform and welcome newcomers to our community.</p>
<p>Healthy competition, whether inside or outside of the community, helps us strive to be the best we can be. Raising the bar can produce some extraordinary results, allowing us to be inspired by one another, taking on ideas that we might find valuable for our audiences, customers, clients. Healthy competition allows us to learn, have fun, grow and share that wealth of knowledge around us.</p>
<p>Unhealthy competition causes us to lose sight of our goals, focusing on numbers instead of the people affected by them. In a community such as ours that prides itself on inclusiveness, we can only succeed or fail together.</p>
<p>In this coming year I’d like to see success shaped through managing expectations and staying true to our purpose. I’d like to see it shaped by people, not numbers, by the humanity of this open source project that brings us together, allows us to create, to innovate, to provide for ourselves and our families.</p>
<p>I’d like to think that a future vision of success could be when growth is neither the goal, nor our limitation, when we’re no longer looking to a growing pie, but rather to a renewable spring or self-sustaining garden. I’d like to think that one day we will be able to say that we’ve succeeded in democratizing publishing, and if and when we do, I doubt that we will have done it alone. And that’s a good thing.</p>
<h3>See you in Paris</h3>
<p>I have no idea how many people will show up to WordCamp Europe in June, but I do know that it will be another fantastic event. I also know that you can help make it a success by participating. You can apply to <a href=\"https://2017.europe.wordcamp.org/2016/11/28/join-us-as-a-speaker-at-wordcamp-europe/\">speak</a>, to <a href=\"https://2017.europe.wordcamp.org/2016/10/06/wordcamp-europe-2017-call-for-volunteers-is-now-open/\">volunteer</a>, to <a href=\"https://2017.europe.wordcamp.org/2016/12/29/wordcamp-europe-2017-call-for-sponsors-is-now-open-wceu/\">sponsor</a>, and/or <a href=\"https://2017.europe.wordcamp.org/tickets/\">buy a ticket</a>. So many ways to be a part of making it happen. So, see you there? Wait, let me rephrase: see you there!</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jan 2017 06:02:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Jenny Beaumont\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:46;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Jetpack 4.5 Expands Monetization with WordAds Integration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65273\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"https://wptavern.com/jetpack-4-5-expands-monetization-with-wordads-integration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:16477:\"<p><a href=\"https://i1.wp.com/wptavern.com/wp-content/uploads/2017/01/wordads.jpg?ssl=1\"><img /></a></p>
<p>Jetpack is starting 2017 with a major release that is heavy on enhancements and improvements. <a href=\"https://jetpack.com/2017/01/17/jetpack-4-5-monetize-your-site-brand-new-videopress-and-many-many-new-shortcodes/#comments\" target=\"_blank\">Version 4.5</a> includes more than a dozen new shortcodes and widgets, along with revamped support for VideoPress. One of the most intriguing new features announced in this release, however, is the integration with <a href=\"https://wordads.co/\" target=\"_blank\">WordAds</a>, WordPress.com&#8217;s advertising program.</p>
<p>Jetpack users are required to be on the <a href=\"https://wordpress.com/jetpack/connect/premium\" target=\"_blank\">Premium plan</a> ($9.00/month or $99/year) in order to sign on with WordAds. The feature is then available within the Engagement tab along with settings for adjusting ad placement.</p>
<p>Eligibility for WordAds was previously limited to sites that had thousands of page views per month, but this requirement is lifted for those who have purchased a Premium or Professional Jetpack plan. Unlike Adsense, which pays for clicks, WordAds pays based on the number of impressions combined with many other factors. According to Derek Springer, an Automattic employee who has worked on WordAds for several years, the traffic requirement was given to set earnings expectations and to ensure support resources were adequately available.</p>
<h3>How Much Can Publishers Earn through WordAds?</h3>
<p>It&#8217;s difficult to to gauge how much a publisher can earn using WordAds, and Automattic doesn&#8217;t publish any sample earnings. The WordAds network has <a href=\"https://wordads.co/2016/10/14/google-adsense-facebook-ads-and-dozens-more-buying-from-wordads/\" target=\"_blank\">more than 60 partners</a> bidding for advertising space in realtime, including Google&#8217;s AdSense, Google, AdX, Facebook Ads, AOL, Yahoo, and Amazon. <a href=\"https://dailypost.wordpress.com/2013/02/14/wordads/\" target=\"_blank\">WordPress.com&#8217;s Daily Post blog</a> likened the network to a stock market with prices rising and falling as available space changes.</p>
<p>When asked about the average return for every 1,000 impressions, Derek Springer said it&#8217;s challenging to estimate due to the complex set of factors influencing the revenue publishers can earn. These include location and number of ads, geography of viewer, percentage of viewers with ad blockers, and other factors.</p>
<p>&#8220;Generally speaking, a site with majority US views with high-quality content can expect to earn the most, while non-English language, low-quality (copied content, nsfw, spam, purchased traffic) sites can expect to earn very little (if anything),&#8221; Springer said. &#8220;Our network over the past year or so has gotten pretty good at appropriately rewarding high-quality sites with high-quality traffic (and penalizing the inverse).&#8221;</p>
<p>For years, bloggers have traded stats and earning records, speculating on what influences WordAds&#8217; unpredictable payouts. In 2014, the Human Breed Blog <a href=\"https://humanbreeds.com/2014/10/13/wordads-advertising-on-wordpress/\" target=\"_blank\">published</a> a collection of data from blogs that made their WordAds earnings publicly available. The data demonstrated inconsistency in earnings for many publishers, including the author&#8217;s own blog, where earnings varied wildly from 2014-2015:</p>
<blockquote><p>My earnings have dropped down to half (From $22.55 in October 2014 to $11.77 in May 2015) despite my page views being higher than 20,000 views per month. The return per 1,000 Ad Impression (CPM) has dropped from $2.25 in October 2014 to $1.17 in May 2015 and the return per 1,000 Page views (CPV) has dropped from $1.39 in October 2014 to $0.51 in May 2015.</p></blockquote>
<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/the-human-breed-blog-wordads-earnings.png?ssl=1\"><img /></a>The Human Breed Blog 2014-2015 WordAds Earnings
<p>This example is representative of the experience of many WordAds publishers in 2014-2016.</p>
<p>&#8220;On my blog SQLwithManoj.com, for the months May, June, and July, the &#8216;Ad Impressions&#8217; were around ~10k and earnings were in the range of $25 to $48 respectively each month,&#8221; <a href=\"https://humanbreeds.com/2014/10/13/wordads-advertising-on-wordpress/#comment-4468\" target=\"_blank\">said</a> Manoj Pandey, blogger at SQLwithManoj.com. &#8220;But in the month of August the &#8216;Ad Impressions&#8217; were showing ~100k, i.e. ~10 times the previous months, but earnings are still in the same range.&#8221;</p>
<p>For many publishers participating in WordAds, there seems to be little correlation between impressions and payouts from month to month. Numerous publishers have reported progressively lower earnings despite having higher traffic numbers than previous months. Clarissa&#8217;s Blog, included in the collection of public earnings above, <a href=\"https://clarissasblog.com/2016/01/30/wordad-earnings-an-important-update/\" target=\"_blank\">published stats</a> from June 2014 to December 2015 that show a dramatic decrease in the amount paid for impressions.</p>
<p>&#8220;You have no way of knowing where the &#8216;ad impressions&#8217; figure comes from and why it varies from one month to another,&#8221; Clarissa said. &#8220;You will have to trust WordPress on that. I experimented with placing the maximum amount of ads as opposed to a moderate amount of ads and that had absolutely no impact on the number of ad impressions.&#8221;</p>
<p>Things started changing in 2016 for Clarissa who now <a href=\"https://clarissasblog.com/2016/01/30/wordad-earnings-an-important-update/#comment-289600\" target=\"_blank\">reports</a> that earnings are increasing. &#8220;I have no idea why but the payments seem to have returned to the higher rates,&#8221; Clarissa said. &#8220;Right now is a good time to do WordAds.&#8221;</p>
<p>Others continue to <a href=\"https://en.forums.wordpress.com/topic/is-wordads-on-decline?replies=3#post-2842453\" target=\"_blank\">report</a> declines on the WordPress.com forums as recently as this week.</p>
<p>&#8220;I used to get $800 for 800K impressions,&#8221; said the owner of rebirthonlineworld.com. &#8220;A few months ago I got $100 for more than 2 million impressions. Last month, only $90 for 500K impressions. This is a big problem for me.&#8221;</p>
<h3>WordAds Vastly Overpaid for Low-Quality Traffic During Its First Years</h3>
<p>In 2013 WordAds paid out $1 million to publishers on its network. According to Derek Springer, earnings since then have been &#8220;pretty flat the past year&#8221; due to industry-wide declining ad rates.</p>
<p>&#8220;We’ve been slowly clawing our way back from the trough of early 2015, which was a historical low for us,&#8221; Springer said. &#8220;So more folks were paid out, but rates as a whole were at their lowest point in 2015. We’ve been steadily increasing our rates and paying out less to low-quality content/traffic, so if you’re a high quality site it’s likely your rates haven’t fallen too much.&#8221;</p>
<p>Behind the scenes, WordAds was quietly evolving its network to better distinguish sites that would deliver more value to its advertising partners, which accounts for many of the dramatic declines in earnings.</p>
<p>&#8220;Pre-<a href=\"https://wordads.co/2015/11/02/introducing-wordads-2-0/\" target=\"_blank\">WordAds 2.0</a> our network didn&#8217;t have the precision to distinguish between high-quality and low-quality (spam, nsfw, bot views, etc) traffic and we had to make some coarse estimations on how to chop the earnings value up,&#8221; Springer said. &#8220;The net effect was that we vastly overpaid low-quality traffic for the first handful of years.&#8221;</p>
<p>Since WordAds 2.0 the program is gotten better at paying users for high-quality content and traffic. The team has more information on the traffic the network is getting and buyers have more information about the content they are bidding on.</p>
<p>&#8220;The net effect is that advertisers refuse to bid on low-quality content and traffic and those sites that were previously earning lots are now getting pennies on the dollar,&#8221; Springer said. &#8220;I would estimate that after investigation 95% of the time the folks complaining about low payout have something kinda scammy going on, usually copied content or paid traffic (and frequently both).&#8221;</p>
<p>&#8220;Paid traffic&#8221; in this instance refers to users who have paid a service to send bots to a page to refresh constantly in order to artificially inflate pageviews. One recent highly publicized incident of this kind of fraud is a case where <a href=\"http://www.wsj.com/articles/russian-hackers-stole-millions-from-video-advertisers-ad-fraud-company-says-1482272717\" target=\"_blank\">Russian hackers stole more than $3 million per day from video advertisers</a> using nonhuman bot traffic. Similar tactics have been used on WordAds, motivated by a misconception that pageviews are equal to ad views.</p>
<h3>The Decline of the Advertising Industry</h3>
<p>Another factor contributing to lower earnings over the past few years is the general decline of the advertising industry. A 2015 <a href=\"http://www.cjr.org/analysis/reuters_digital_news_report.php\" target=\"_blank\">Reuters Institute Digital News survey</a> indicates that nearly half of US internet users have some form of ad blocking software installed. Reuters Institute&#8217;s latest predictions <a href=\"http://www.digitalnewsreport.org/publications/2017/journalism-media-technology-predictions-2017/\" target=\"_blank\">forecast a 24% increase</a> in US users with ad blocking in 2017. Advertisers have to fight harder to get the attention of the remaining half of consumers and many companies have decided to allocate those funds elsewhere.</p>
<p>According to the Interactive Advertising Bureau&#8217;s latest Internet Advertising Revenue report, <a href=\"http://adage.com/article/digital/iab-digital-ad-revenue-breaks-record/306557/\" target=\"_blank\">search advertising on desktop declined for the first time in 2016</a>, falling 12% to $8.9 billion. However, mobile advertising grew 105% from $3.6 billion to $7.4 billion. Mobile search is having an increasingly strong impact in shaping a site&#8217;s traffic.</p>
<p>These factors are outside of WordAds&#8217; control but they weigh heavily on how many impressions publishers will receive. If the vast majority of a site&#8217;s visitors are using ad-blockers and the site isn&#8217;t easily found via mobile search, it is likely to suffer earning declines on any ad network.</p>
<p>&#8220;Ad rates industry wide have fallen over the past few years,&#8221; Springer said. &#8220;Ad buyers just aren&#8217;t paying what they used to and more users are using ad blockers. They heyday of the late aughts/early twenty-teens may never return as ad buyers realized they just aren&#8217;t getting the return they were expecting.&#8221;</p>
<h3>WordAds Needs More Transparency Around Partners and Reporting</h3>
<p>It is difficult for publishers to improve their strategies for generating ad revenue when earnings fluctuate wildly without any explanation beyond changes in advertising rates. After reviewing the product&#8217;s forums, many are requesting more transparency around why their earnings have dropped despite higher numbers of impressions. They want to know if advertising rates have dropped for the month, if partners have dropped out of the network, or if their content failed to connect with visitors on certain days.</p>
<p>WordAds users have experienced <a href=\"https://en.forums.wordpress.com/topic/earnings-from-wordads-account?replies=111\" target=\"_blank\">problems</a> with incorrect reporting, record low payouts, and blank banner displays. In the past there have also been considerable delays in publishers receiving their monthly earnings. Springer said improving the reporting process is a top priority for the team this year.</p>
<p>&#8220;The flip-side/challenge of working with dozens of networks is that none of them pay us very consistently,&#8221; Springer said. &#8220;In the past there was no unified collection process on our end, so we would have to wait to collect from each partner and then split it up and send folks earnings out in one batch. However, for the past year and a half or so we&#8217;ve been working with a company called <a href=\"http://www.iponweb.com/\" target=\"_blank\">IPONWEB</a> to unify our earnings, reporting, and ad buying process (this is what powers WordAds 2.0). We&#8217;re at the point where we can begin to provide closer to real-time earnings reporting.&#8221;</p>
<h3>Automattic is Optimistic about Expanding the <br />WordAds Program with Jetpack</h3>
<p>The number of WordAds sites are up 111% year over year. WordAds currently has a few thousand self-hosted sites running <a href=\"https://wordpress.org/plugins/radcontrol/\" target=\"_blank\">AdControl/Jetpack Ads</a> and Springer said the team is expecting that number to grow considerably now that integration has been added to Jetpack. The AdControl plugin is still available for non-Premium Jetpack users but the standard application and traffic requirements apply. Springer said they plan to phase out the plugin at some point in the future but there are no definite plans yet.</p>
<p>&#8220;Tens of thousands of WP.com sites are approved WordAds (meaning they applied and were approved) out of many tens of thousands more total applications,&#8221; Springer said. &#8220;Additionally, every freemium WordPress.com site is running our ad network, though we naturally keep all the revenue from those sites.&#8221;</p>
<p>With a gaggle of new publishers joining WordAds through Jetpack, one might imagine that rates and payouts for existing users would decrease as more advertising space becomes available. However, this isn&#8217;t how advertising networks work.</p>
<p>&#8220;Generally speaking, advertisers want to display more ads than most publishers are able to provide (known as inventory), so adding more publishers/inventory to a network is a net benefit to advertisers and is what attracts the bigger, higher paying ad buyers,&#8221; Springer said. &#8220;If we can tell our ad partners &#8216;We have 10,000,000,000 pageviews available this month across our network,&#8221; then that attracts much more lucrative buyers than if a user has to try to attract them on their own. Advertisers also like that they can cut one deal for a million sites as opposed to having to cut them piecemeal and are generally willing to give us better deals. The whole &#8216;powers 27% of the web&#8217; is a pretty tasty morsel for ad networks.&#8221;</p>
<h3>Advice for Publishers New to WordAds: Keep Expectations Realistic</h3>
<p>Seamless advertising is a major incentive for Jetpack users to sign up for the Premium plan, which also includes backups, one-click restores, security scanning, and 13GB video storage. The prospect of being able to flip the switch to turn on ads and potentially start earning money is very compelling, especially for users who have struggled with other forms of advertising that were not WordPress-compatible.</p>
<p>The general outlook for WordAds is improving, as the product has evolved to reward higher quality content. As advertisers receive a better return on their investments, their confidence in bidding should increase. However, most publishers should expect to see fluctuations on earnings.</p>
<p>WordPress.com&#8217;s <a href=\"https://dailypost.wordpress.com/2013/02/14/wordads/\" target=\"_blank\">Daily Post Blog</a> advises new publishers to temper their expectations with the knowledge that they would need &#8220;hundreds of thousands of pageviews to generate meaningful earnings.&#8221; For most average bloggers, the ad revenue may not buy more than a decent cup of coffee.</p>
<p>Mortiz Linder, an owner of traveluxblog.com, <a href=\"https://traveluxblog.com/2016/10/29/my-experience-with-wordads/\" target=\"_blank\">published his earnings</a> and described his experience as &#8220;rather average.&#8221;</p>
<p>&#8220;It&#8217;s a nice idea to gain something without effort, to get at least something back for all the work we put into traveluxblog each day,&#8221; Moritz said.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 19 Jan 2017 01:40:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:47;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"WPTavern: WPWeekly Episode 260 – SiteGround, Affiliate Summit Recap, and New Security Czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wptavern.com?p=65327&preview=true&preview_id=65327\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wptavern.com/wpweekly-episode-260-siteground-affiliate-summit-recap-and-new-security-czar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2802:\"<p>In this episode of WordPress Weekly, <a href=\"http://www.marcuscouch.com/\">Marcus Couch</a> recaps his trip to Affiliate Summit 2017 held in Las Vegas, Nevada last weekend. Based on the vendors that were on the expo floor, mobile is the e-commerce platform of the future. We discuss the news of the week and share how you can get involved in the <a href=\"http://make.wordpress.org/marketing\">WordPress Marketing Group</a>. We end the show with Marcus&#8217; plugin picks of the week.</p>
<h2>Stories Discussed:</h2>
<p><a href=\"https://wptavern.com/aaron-d-campbell-replaces-nikolay-bachiyski-as-wordpress-security-czar\">Aaron D. Campbell Replaces Nikolay Bachiyski as WordPress’ Security Czar</a><br />
<a href=\"https://wptavern.com/postmatic-basic-rebrands-as-replyable-moves-two-way-email-commenting-to-saas-product\">Postmatic Basic Rebrands as Replyable, Moves Two-Way Email Commenting to SaaS Product</a><br />
<a href=\"https://wptavern.com/siteground-auto-issues-lets-encrypt-certificates-for-new-domains\">SiteGround Auto-Issues Let’s Encrypt Certificates for New Domains</a></p>
<h2>Plugins Picked By Marcus:</h2>
<p><a href=\"https://wordpress.org/plugins/background-image-cropper/\">Background Image Cropper</a> adds cropping to background images for parity with header images. This feature is starting out as a plugin to gauge user interest and to determine if it improves the user experience of background images.</p>
<p><a href=\"https://wordpress.org/plugins/woo-product-remover/\">Woo Product Remover</a> allows you to remove all WooCommerce products from your site. It removes products, their metadata, relationships, as well as product variations and their related meta data from the database.</p>
<p><a href=\"https://wordpress.org/plugins/wp-tasks-after-install/\">WP Tasks After Install</a> completes a series of tasks most commonly performed after WordPress is installed. These tasks include, removing the default Hello World post, setting permalinks to %postname%, activating Akismet, and more. The plugin will automatically deactivate itself when the tasks are completed.</p>
<h2>WPWeekly Meta:</h2>
<p><strong>Next Episode:</strong> Wednesday, January 25th 3:00 P.M. Eastern</p>
<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"https://wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>
<p><strong>Listen To Episode #260:</strong><br />
</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jan 2017 22:59:37 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:48;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"HeroPress: Living A Better Life Thanks To WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=1571\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://heropress.com/essays/living-better-life-thanks-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12009:\"<img width=\"960\" height=\"480\" src=\"http://20094-presscdn.pagely.netdna-cdn.com/wp-content/uploads/2017/01/011817-1024x512.jpg\" class=\"attachment-large size-large wp-post-image\" alt=\"My experience as a remote worker lets me have greater foreight which in turn allows me to carry out so many activities.\" /><p>To me, as well as many others, WordPress is more than a technical choice, it’s a lifestyle choice. I didn’t see it as such right away. Looking at the last 4 years of my life, I can fully appreciate its impact.</p>
<p>Aspiring to a life full of adventures and whimsy; I never really fit the mold. American TV series and movies that taught me my dreams could be achieved if I worked hard enough. Armed with that knowledge (and without a fancy diploma to my name), I worked bank, police, IT, supply chain jobs until I discovered the joy of making websites.</p>
<p>My newfound passion (and many sleepless nights of work) helped me become a webdesigner. At the time, Joomla!, Spip and Typo 3 were the big names out there (in France). After achieving the role of Artistic Director as a freelancer; it took me a few years to open my own web agency. That moment changed my thinking: it was no longer ME but WE. And when a client asked us to use WordPress, we got to experience the CMS and its community.</p>
<h3>Focusing on WordPress</h3>
<p>Our team quickly realized that WordPress could do much more than “just blogs”. In France, the CMS kept having a reputation as a blog only platform. Complex websites were not made in WordPress. Our agency decided to convince clients otherwise. To achieve our mission and hone our skills, we decided to get closer to the WordPress community. I naively offered my help in evangelization efforts to the Paris WordCamp organizers. Except that there was one clear hurdle in our path: we had never contributed anything to the community before! This meant that we were relatively unknown. Needless to say that the feedback we received wasn’t what we expected.</p>
<h3>Contributions: It’s About Helping Others</h3>
<p>Contributing meant one thing: bring something to the WordPress ecosystem to help improve it. The WordCamp association’s president asked us to answer questions on the French forum as a token of our goodwill, to show our commitment.</p>
<p>I started to answer questions right away but felt like an imposter. All the questions on the forum seemed so technical. I didn’t know how to contribute since I wasn’t a developer. It wasn’t like I was going to create a theme or plugin anytime soon. I kept obsessing over ways I could provide value to the community. I thought about my skills but couldn’t come up with something that would make a real difference.</p>
<blockquote><p>Sure I could speak English, but translating documents was not something I felt comfortable doing.</p></blockquote>
<p>So I turned to the previous WordCamp Paris conference and took a closer look at the participants. There, I found my first clue: a marketing expert! I reached out to him to see if I could interview him. As Marketing Director of a press group, he had lead a big WordPress project for his company. Interviewing him brought me two things: an article for our blog discussing what could be done with WordPress and a solid understanding of how the inner workings of the French WordPress community. He gave me an idea of the path one would take to end up giving a conference at the WordCamp. I didn’t realize it at the time, but by picking a name on a conference program, I would meet one of the key players in my WordPress story: Benjamin.</p>
<p>Meanwhile, I continued to write articles about projects made with WordPress, sometimes ours, sometimes the competition’s. Good WordPress knows no bounds so it was necessary for me to showcase all the amazing websites made with this CMS. It’s also how I discovered my main competitors (before meeting them in the flesh later at various events).</p>
<p>A white paper detailing the success of WordPress as a CMS got my name out. This allowed me to gain the courage to pitch my first conference. Providing feedback on projects allowed me to find my place in the WordPress community. Focusing on my experience and helping others didn’t require developer skills. My contribution was in writing and not in coding.</p>
<h3>My First WordPress Conference As A Speaker</h3>
<p>My first conference topic was on how to create a multilingual, multi-site project with WordPress in 3 months. Needless to say that I was nervous. I mean, speaking in front of 300 people is not something I had done while working at a bank, or in the police force or in any other job really. Adventure: here I come!</p>
<blockquote><p>The WordPress community was very kind to me and my first conference experience was a memorable one.</p></blockquote>
<p>During this conference, I wanted to highlight the plugins we used for this project. I mentioned a French startup that had launched a premium plugin as its first product. I found their approach interesting, so I thought I would give them a little visibility. Showcasing good WordPress websites, themes and plugins was already a habit of mine by then. The French team were happy to be mentioned and happened to be present at the event. They came to talk to me after my conference. Turns out, we had a lot to talk about. The company’s name: WP Media. They would open a new chapter of my WordPress story.</p>
<p>During the closing night, I also met a lot of people. Some of them, just like Benjamin were going to have a big impact on my life. Many became great friends as well as mentors like Jenny Beaumont.</p>
<p>Once I got started, there was no stopping me! I continued to speak at events (WordCamp Lyon, WP Tech Nantes), attended meetups, continued writing articles to highlight WordPress projects.</p>
<p>The following year, I joined the organizing team of WordCamp Paris.</p>
<p>Meanwhile, I go to my first WordCamp Europe which was a major new turn.</p>
<h3>WordCamp Europe 2014 Changed My Life</h3>
<p>Going to the WordCamp Europe changed my life. It’s an experience I highly recommend. If you can, go to the next WordCamp Europe!</p>
<p>The organizers managed to pack so many international speakers that my head was spinning. Speakers were coming from all over the world. The quality of the talks (and speakers) along with the breadth of subjects covered open so many possibilities. You could end up changing your approach to WordPress or finding a new method of working with your peers.</p>
<p>I attended a conference by Noel Tock named Beyond the code where he explained how he managed his life working in remote while traveling at the same time. He also gave insights as to how to monitor your time and how to optimize it.</p>
<blockquote><p>Realizing that such a life was possible; that you could achieve this time of freedom by reclaiming your time was a massive discovery.</p></blockquote>
<p>The second eye-opening conference for me was Simon&#8217;s lecture on Running an open source. He explained that that undertaking Open Source also meant contributing and collaborating with a community, including your competitors. Simon showed us for 30 minutes that working with competitors was not only beneficial for us agencies, but also for the customer, and for the WordPress community as a whole.</p>
<h3>Professional WordPress</h3>
<p>Becoming a strong voice in the professionalisation of WordPress in France and encouraging web agencies to contribute and to exchange more had become priority subjects.</p>
<p>I have launched a WP Next association for professionals</p>
<ul>
<li>To ensure the promotion of WordPress, mainly with professionals, managers of information system, internet director, new media, &#8230; and more generally all IT decision makers.</li>
<li>To enhance the skills of WordPress professionals with decision-makers,</li>
<li>Promote French know-how around the WordPress CMS, associated technologies and services</li>
</ul>
<p>I also launched with Deborah Donnier a documentary project Think WP to make known WordPress and its community.</p>
<h3>A new turn</h3>
<p>With these activities I gradually moved away from the creation of websites. Having so many opportunities tied to WordPress available to me, I decided to take a new turn. During the Wordcamps across Europe, I took great pleasure in exchanging with WP Media. We had kept contact since our first meeting. My profile and experience seemed to like a great fit for a new role in the WP Media adventure. I took a leap and became COO of the startup about a year ago. I manage my agency in parallel.</p>
<p>I now work 100% remotely and so does a great portion of my agency. As for WP Media, everyone works remotely. Being a remote worker frees me from constraints that are inherent when you live in the Paris region (it’s a city and province in France). Time spent on commuting is used for other activities.</p>
<p>My experience as a remote worker lets me have greater foresight which in turn allows me to carry out so many activities.</p>
<p>Today, I can proudly say that I attended the US WordCamp last year and am helping organize this year’s WordCamp Europe with Jenny and Benjamin.I feel like I belong in a global community that thrives thanks to its members and their desire to improve WordPress.</p>
<p>WordPress helped me along the path to a life full of adventures and long lasting friendships. It offers so many opportunities to forge beautiful projects, stories and more.</p>
<p>I hope that my story will inspire someone else to get started and find the courage to persevere on the way to a life full of adventures (with or without WordPress). Give yourself time and open yourself to other points of view to help build the life you aspire to.</p>
<p>Thank you for reading my story and see you at WordCamp Europe 2017!</p>
<div class=\"rtsocial-container rtsocial-container-align-right rtsocial-horizontal\"><div class=\"rtsocial-twitter-horizontal\"><div class=\"rtsocial-twitter-horizontal-button\"><a title=\"Tweet: Living A Better Life Thanks To WordPress\" class=\"rtsocial-twitter-button\" href=\"https://twitter.com/share?text=Living%20A%20Better%20Life%20Thanks%20To%20WordPress&via=heropress&url=https%3A%2F%2Fheropress.com%2Fessays%2Fliving-better-life-thanks-wordpress%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-fb-horizontal fb-light\"><div class=\"rtsocial-fb-horizontal-button\"><a title=\"Like: Living A Better Life Thanks To WordPress\" class=\"rtsocial-fb-button rtsocial-fb-like-light\" href=\"https://www.facebook.com/sharer.php?u=https%3A%2F%2Fheropress.com%2Fessays%2Fliving-better-life-thanks-wordpress%2F\" rel=\"nofollow\" target=\"_blank\"></a></div></div><div class=\"rtsocial-linkedin-horizontal\"><div class=\"rtsocial-linkedin-horizontal-button\"><a class=\"rtsocial-linkedin-button\" href=\"https://www.linkedin.com/shareArticle?mini=true&url=https%3A%2F%2Fheropress.com%2Fessays%2Fliving-better-life-thanks-wordpress%2F&title=Living+A+Better+Life+Thanks+To+WordPress\" rel=\"nofollow\" target=\"_blank\" title=\"Share: Living A Better Life Thanks To WordPress\"></a></div></div><div class=\"rtsocial-pinterest-horizontal\"><div class=\"rtsocial-pinterest-horizontal-button\"><a class=\"rtsocial-pinterest-button\" href=\"https://pinterest.com/pin/create/button/?url=https://heropress.com/essays/living-better-life-thanks-wordpress/&media=https://heropress.com/wp-content/uploads/2017/01/011817-150x150.jpg&description=Living A Better Life Thanks To WordPress\" rel=\"nofollow\" target=\"_blank\" title=\"Pin: Living A Better Life Thanks To WordPress\"></a></div></div><a rel=\"nofollow\" class=\"perma-link\" href=\"https://heropress.com/essays/living-better-life-thanks-wordpress/\" title=\"Living A Better Life Thanks To WordPress\"></a></div><p>The post <a rel=\"nofollow\" href=\"https://heropress.com/essays/living-better-life-thanks-wordpress/\">Living A Better Life Thanks To WordPress</a> appeared first on <a rel=\"nofollow\" href=\"https://heropress.com\">HeroPress</a>.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Jan 2017 12:00:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Emilie Lebrun\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:49;a:6:{s:4:\"data\";s:13:\"
	
	
	
	
	
	
\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: How to Add Users to BuddyPress Groups in Bulk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=65283\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://wptavern.com/how-to-add-users-to-buddypress-groups-in-bulk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3220:\"<p>On a site I&#8217;m working on that runs BuddyPress, I created a new group and wanted to add nearly 400 registered users to it. Unfortunately, adding users to BuddyPress groups in bulk is not a core feature. I searched Google for a solution and while the <a href=\"http://www.youngtechleads.com/buddypress-members-import/\">BuddyPress Members Import</a> plugin is recommended in many of the support threads, the feature alone is not worth spending $49.</p>
<p>Continuing my search, I discovered a <a href=\"https://gist.github.com/rohmann/6151699\">code snippet</a> published by <a href=\"https://premium.wpmudev.org/profile/alexander_rohmann/\">Alexander</a> on the <a href=\"https://premium.wpmudev.org/forums/topic/bulk-adding-buddypress-group-members?replies=14&utm_expid=3606929-94.Ie3dH-CaRwe6MU3VrZsdvw.0&utm_referrer=https%3A%2F%2Fwordpress.org%2Fsupport%2Ftopic%2Fimport-with-buddypress-groups%2F#post-484834\">WPMU DEV forums</a> that works perfectly. To use it, copy the code and add it to a custom WordPress plugin or paste it to your theme&#8217;s functions.php file. I added the code to the top of my theme&#8217;s functions.php file.</p>
<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/CodeSnippetInThemeFunctionsPHPFile.png?ssl=1\"><img /></a>Code Snippet at the Top of my Theme&#8217;s Functions.php File
<p>The JavaScript portion of the snippet adds a new item to the Bulk Actions drown-down menu named Add to BP Group.</p>
<a href=\"https://i0.wp.com/wptavern.com/wp-content/uploads/2017/01/AddToBPGroup.png?ssl=1\"><img /></a>Add to BP Group Bulk Action Menu Item
<p>Select the users you want to add to a group and select Add to BP Group. A prompt appears asking for the Buddy Group ID you want to assign the users to.</p>
<a href=\"https://i2.wp.com/wptavern.com/wp-content/uploads/2017/01/EnterBuddyPressGroupIDPrompt.png?ssl=1\"><img /></a>BuddyPress Group ID Prompt
<p>To locate the Group ID, click on the Groups admin menu and click on the group&#8217;s name. The URL will look something like this admin.php?page=bp-groups&amp;gid=357&amp;action=edit and the ID is the number that appears after gid=. After entering the ID number, click the Ok button. All of the users you selected will be assigned to that group.</p>
<p>In the comments of the code snippet on GitHub, <a href=\"https://gist.github.com/rohmann/6151699#gistcomment-1580235\">Strand-C said</a> he wasn&#8217;t able to move 165 users at a time and had to move 50 instead. I tested this theory by moving nearly 400 registered users at the same time to a new BuddyPress group and didn&#8217;t encounter any issues. Keep in mind that the site I&#8217;m working on is relatively new, is running WordPress 4.7, and has very little traffic which could explain why I didn&#8217;t have a problem.</p>
<p>Being able to manage BuddyPress groups in bulk should be a core feature. There is at least one <a href=\"https://buddypress.trac.wordpress.org/ticket/6161\">open ticket on BuddyPress trac</a> to add Bulk Edit options to Groups. Until these features make their way into BuddyPress, the code snippet above is a free work-around that makes adding users to groups in bulk a lot more convenient.</p>
<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 17 Jan 2017 22:23:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 21 Feb 2017 12:38:21 GMT\";s:12:\"content-type\";s:8:\"text/xml\";s:14:\"content-length\";s:6:\"438190\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:13:\"last-modified\";s:29:\"Tue, 21 Feb 2017 12:15:17 GMT\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";s:13:\"accept-ranges\";s:5:\"bytes\";}s:5:\"build\";s:14:\"20170109145931\";}","no");
INSERT INTO `wp_options` VALUES("8076","wpseo_sitemap_shop_order_cache_validator","3NZ9","no");
INSERT INTO `wp_options` VALUES("1278","wc_dgallery_gallery_height_type","fixed","yes");
INSERT INTO `wp_options` VALUES("3730","_transient_wc_related_63","a:15:{i:0;s:2:\"43\";i:1;s:2:\"68\";i:2;s:2:\"73\";i:3;s:2:\"78\";i:4;s:2:\"83\";i:5;s:2:\"88\";i:6;s:2:\"93\";i:7;s:2:\"98\";i:8;s:3:\"103\";i:9;s:3:\"108\";i:10;s:3:\"113\";i:11;s:3:\"118\";i:12;s:3:\"231\";i:13;s:3:\"236\";i:14;s:3:\"241\";}","no");
INSERT INTO `wp_options` VALUES("1213","product_compare_id","273","yes");
INSERT INTO `wp_options` VALUES("4282","wpseo_sitemap_93_cache_validator","56uSy","no");
INSERT INTO `wp_options` VALUES("930","_transient_timeout_wc_cbp_754d15685185b65281e17b6da176a663","1478799390","no");
INSERT INTO `wp_options` VALUES("931","_transient_wc_cbp_754d15685185b65281e17b6da176a663","a:6:{i:0;i:43;i:1;i:43;i:2;i:88;i:3;i:91;i:4;i:88;i:5;i:91;}","no");
INSERT INTO `wp_options` VALUES("946","widget_simpleimage","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO `wp_options` VALUES("1937","loadgo_options","a:9:{s:17:\"loadgo-visibility\";s:3:\"all\";s:15:\"loadgo-progress\";s:5:\"false\";s:21:\"loadgo-progress-color\";s:7:\"#000000\";s:14:\"loadgo-message\";s:5:\"false\";s:14:\"loadgo-bgcolor\";s:7:\"#FFFFFF\";s:11:\"loadgo-size\";i:30;s:14:\"loadgo-opacity\";d:0.5;s:16:\"loadgo-direction\";s:2:\"lr\";s:12:\"loadgo-image\";s:71:\"http://localhost:8080/ecommerce/wp-content/uploads/2016/10/sentra-1.png\";}","yes");
INSERT INTO `wp_options` VALUES("2048","ws_menu_editor","a:19:{s:22:\"hide_advanced_settings\";b:1;s:16:\"show_extra_icons\";b:0;s:11:\"custom_menu\";a:3:{s:4:\"tree\";a:31:{s:9:\"index.php\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:10:\">index.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:19:\"index.php>index.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Inicio\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"index.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:9:\"index.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:19:\"index.php>index.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"index.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:25:\"index.php>update-core.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:188:\"Actualizaciones <span class=\'update-plugins count-22\' title=\'1 Actualización WordPress, 18 actualizaciones de plugins, 3 Actualizaciones temas\'><span class=\'update-count\'>22</span></span>\";s:12:\"access_level\";s:11:\"update_core\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:15:\"update-core.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:9:\"index.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:25:\"index.php>update-core.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:15:\"update-core.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Escritorio\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"index.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";s:43:\"menu-top menu-top-first menu-icon-dashboard\";s:8:\"hookname\";s:14:\"menu-dashboard\";s:8:\"icon_url\";s:19:\"dashicons-dashboard\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:10:\">index.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:9:\"index.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"separator_4\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:12:\">separator_4\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"separator_4\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:12:\">separator_4\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:8:\"edit.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:9:\">edit.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:4:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:17:\"edit.php>edit.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:18:\"Todas las entradas\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"edit.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:17:\"edit.php>edit.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:8:\"edit.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"edit.php>post-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:13:\"Añadir nueva\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:12:\"post-new.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"edit.php>post-new.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:12:\"post-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=category\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Categorías\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:31:\"edit-tags.php?taxonomy=category\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=category\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"edit-tags.php?taxonomy=category\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=post_tag\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Etiquetas\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:31:\"edit-tags.php?taxonomy=post_tag\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:8:\"edit.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:40:\"edit.php>edit-tags.php?taxonomy=post_tag\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"edit-tags.php?taxonomy=post_tag\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Entradas\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:8:\"edit.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";s:37:\"menu-top menu-icon-post open-if-no-js\";s:8:\"hookname\";s:10:\"menu-posts\";s:8:\"icon_url\";s:20:\"dashicons-admin-post\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:9:\">edit.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:8:\"edit.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}s:10:\"upload.php\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:11:\">upload.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"upload.php>upload.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Biblioteca\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"upload.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"upload.php>upload.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"upload.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:24:\"upload.php>media-new.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:13:\"Añadir nuevo\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:13:\"media-new.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:10:\"upload.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:24:\"upload.php>media-new.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:13:\"media-new.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:6:\"Medios\";s:12:\"access_level\";s:12:\"upload_files\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"upload.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";s:24:\"menu-top menu-icon-media\";s:8:\"hookname\";s:10:\"menu-media\";s:8:\"icon_url\";s:21:\"dashicons-admin-media\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:11:\">upload.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:10:\"upload.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:23:\"edit.php?post_type=page\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:24:\">edit.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:47:\"edit.php?post_type=page>edit.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:18:\"Todas las páginas\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"edit.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:23:\"edit.php?post_type=page\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:47:\"edit.php?post_type=page>edit.php?post_type=page\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"edit.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:51:\"edit.php?post_type=page>post-new.php?post_type=page\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:13:\"Añadir nueva\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:27:\"post-new.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:23:\"edit.php?post_type=page\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:51:\"edit.php?post_type=page>post-new.php?post_type=page\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:27:\"post-new.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Páginas\";s:12:\"access_level\";s:10:\"edit_pages\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"edit.php?post_type=page\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";s:23:\"menu-top menu-icon-page\";s:8:\"hookname\";s:10:\"menu-pages\";s:8:\"icon_url\";s:20:\"dashicons-admin-page\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:24:\">edit.php?post_type=page\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:23:\"edit.php?post_type=page\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:17:\"edit-comments.php\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:18:\">edit-comments.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:1:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:35:\"edit-comments.php>edit-comments.php\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:21:\"Todos los comentarios\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"edit-comments.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:17:\"edit-comments.php\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:35:\"edit-comments.php>edit-comments.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"edit-comments.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:90:\"Comentarios <span class=\"awaiting-mod count-0\"><span class=\"pending-count\">0</span></span>\";s:12:\"access_level\";s:10:\"edit_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:17:\"edit-comments.php\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";s:27:\"menu-top menu-icon-comments\";s:8:\"hookname\";s:13:\"menu-comments\";s:8:\"icon_url\";s:24:\"dashicons-admin-comments\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:18:\">edit-comments.php\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:17:\"edit-comments.php\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:33:\"edit.php?post_type=dslc_downloads\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:34:\">edit.php?post_type=dslc_downloads\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:4:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:67:\"edit.php?post_type=dslc_downloads>edit.php?post_type=dslc_downloads\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Downloads\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:33:\"edit.php?post_type=dslc_downloads\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:33:\"edit.php?post_type=dslc_downloads\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:67:\"edit.php?post_type=dslc_downloads>edit.php?post_type=dslc_downloads\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:33:\"edit.php?post_type=dslc_downloads\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:71:\"edit.php?post_type=dslc_downloads>post-new.php?post_type=dslc_downloads\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:17:\"Add Download Item\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:37:\"post-new.php?post_type=dslc_downloads\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:33:\"edit.php?post_type=dslc_downloads\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:71:\"edit.php?post_type=dslc_downloads>post-new.php?post_type=dslc_downloads\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:37:\"post-new.php?post_type=dslc_downloads\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:105:\"edit.php?post_type=dslc_downloads>edit-tags.php?taxonomy=dslc_downloads_cats&amp;post_type=dslc_downloads\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Categories\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:71:\"edit-tags.php?taxonomy=dslc_downloads_cats&amp;post_type=dslc_downloads\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:33:\"edit.php?post_type=dslc_downloads\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:105:\"edit.php?post_type=dslc_downloads>edit-tags.php?taxonomy=dslc_downloads_cats&amp;post_type=dslc_downloads\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:67:\"edit-tags.php?taxonomy=dslc_downloads_cats&post_type=dslc_downloads\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:105:\"edit.php?post_type=dslc_downloads>edit-tags.php?taxonomy=dslc_downloads_tags&amp;post_type=dslc_downloads\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:4:\"Tags\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:71:\"edit-tags.php?taxonomy=dslc_downloads_tags&amp;post_type=dslc_downloads\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:33:\"edit.php?post_type=dslc_downloads\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:105:\"edit.php?post_type=dslc_downloads>edit-tags.php?taxonomy=dslc_downloads_tags&amp;post_type=dslc_downloads\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:67:\"edit-tags.php?taxonomy=dslc_downloads_tags&post_type=dslc_downloads\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Downloads\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:33:\"edit.php?post_type=dslc_downloads\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";s:33:\"menu-top menu-icon-dslc_downloads\";s:8:\"hookname\";s:25:\"menu-posts-dslc_downloads\";s:8:\"icon_url\";s:18:\"dashicons-download\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:34:\">edit.php?post_type=dslc_downloads\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:33:\"edit.php?post_type=dslc_downloads\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}s:33:\"edit.php?post_type=dslc_galleries\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:34:\">edit.php?post_type=dslc_galleries\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:67:\"edit.php?post_type=dslc_galleries>edit.php?post_type=dslc_galleries\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Galleries\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:33:\"edit.php?post_type=dslc_galleries\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:33:\"edit.php?post_type=dslc_galleries\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:67:\"edit.php?post_type=dslc_galleries>edit.php?post_type=dslc_galleries\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:33:\"edit.php?post_type=dslc_galleries\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:71:\"edit.php?post_type=dslc_galleries>post-new.php?post_type=dslc_galleries\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Add Gallery\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:37:\"post-new.php?post_type=dslc_galleries\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:33:\"edit.php?post_type=dslc_galleries\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:71:\"edit.php?post_type=dslc_galleries>post-new.php?post_type=dslc_galleries\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:37:\"post-new.php?post_type=dslc_galleries\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:105:\"edit.php?post_type=dslc_galleries>edit-tags.php?taxonomy=dslc_galleries_cats&amp;post_type=dslc_galleries\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Categories\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:71:\"edit-tags.php?taxonomy=dslc_galleries_cats&amp;post_type=dslc_galleries\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:33:\"edit.php?post_type=dslc_galleries\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:105:\"edit.php?post_type=dslc_galleries>edit-tags.php?taxonomy=dslc_galleries_cats&amp;post_type=dslc_galleries\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:67:\"edit-tags.php?taxonomy=dslc_galleries_cats&post_type=dslc_galleries\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Galleries\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:33:\"edit.php?post_type=dslc_galleries\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";s:33:\"menu-top menu-icon-dslc_galleries\";s:8:\"hookname\";s:25:\"menu-posts-dslc_galleries\";s:8:\"icon_url\";s:24:\"dashicons-format-gallery\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:34:\">edit.php?post_type=dslc_galleries\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:33:\"edit.php?post_type=dslc_galleries\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:32:\"edit.php?post_type=dslc_partners\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:33:\">edit.php?post_type=dslc_partners\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:65:\"edit.php?post_type=dslc_partners>edit.php?post_type=dslc_partners\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Partners\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:32:\"edit.php?post_type=dslc_partners\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:32:\"edit.php?post_type=dslc_partners\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:65:\"edit.php?post_type=dslc_partners>edit.php?post_type=dslc_partners\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"edit.php?post_type=dslc_partners\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:69:\"edit.php?post_type=dslc_partners>post-new.php?post_type=dslc_partners\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Add Partner\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:36:\"post-new.php?post_type=dslc_partners\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:32:\"edit.php?post_type=dslc_partners\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:69:\"edit.php?post_type=dslc_partners>post-new.php?post_type=dslc_partners\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"post-new.php?post_type=dslc_partners\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:102:\"edit.php?post_type=dslc_partners>edit-tags.php?taxonomy=dslc_partners_cats&amp;post_type=dslc_partners\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Categories\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:69:\"edit-tags.php?taxonomy=dslc_partners_cats&amp;post_type=dslc_partners\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:32:\"edit.php?post_type=dslc_partners\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:102:\"edit.php?post_type=dslc_partners>edit-tags.php?taxonomy=dslc_partners_cats&amp;post_type=dslc_partners\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:65:\"edit-tags.php?taxonomy=dslc_partners_cats&post_type=dslc_partners\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Partners\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:32:\"edit.php?post_type=dslc_partners\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";s:32:\"menu-top menu-icon-dslc_partners\";s:8:\"hookname\";s:24:\"menu-posts-dslc_partners\";s:8:\"icon_url\";s:16:\"dashicons-groups\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:33:\">edit.php?post_type=dslc_partners\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"edit.php?post_type=dslc_partners\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:32:\"edit.php?post_type=dslc_projects\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:9;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:33:\">edit.php?post_type=dslc_projects\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:65:\"edit.php?post_type=dslc_projects>edit.php?post_type=dslc_projects\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Projects\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:32:\"edit.php?post_type=dslc_projects\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:32:\"edit.php?post_type=dslc_projects\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:65:\"edit.php?post_type=dslc_projects>edit.php?post_type=dslc_projects\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"edit.php?post_type=dslc_projects\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:69:\"edit.php?post_type=dslc_projects>post-new.php?post_type=dslc_projects\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Add Project\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:36:\"post-new.php?post_type=dslc_projects\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:32:\"edit.php?post_type=dslc_projects\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:69:\"edit.php?post_type=dslc_projects>post-new.php?post_type=dslc_projects\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"post-new.php?post_type=dslc_projects\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:102:\"edit.php?post_type=dslc_projects>edit-tags.php?taxonomy=dslc_projects_cats&amp;post_type=dslc_projects\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Categories\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:69:\"edit-tags.php?taxonomy=dslc_projects_cats&amp;post_type=dslc_projects\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:32:\"edit.php?post_type=dslc_projects\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:102:\"edit.php?post_type=dslc_projects>edit-tags.php?taxonomy=dslc_projects_cats&amp;post_type=dslc_projects\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:65:\"edit-tags.php?taxonomy=dslc_projects_cats&post_type=dslc_projects\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:8:\"Projects\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:32:\"edit.php?post_type=dslc_projects\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:9;s:6:\"parent\";N;s:9:\"css_class\";s:32:\"menu-top menu-icon-dslc_projects\";s:8:\"hookname\";s:24:\"menu-posts-dslc_projects\";s:8:\"icon_url\";s:18:\"dashicons-feedback\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:33:\">edit.php?post_type=dslc_projects\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:32:\"edit.php?post_type=dslc_projects\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:29:\"edit.php?post_type=dslc_staff\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:10;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:30:\">edit.php?post_type=dslc_staff\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:59:\"edit.php?post_type=dslc_staff>edit.php?post_type=dslc_staff\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Staff\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:29:\"edit.php?post_type=dslc_staff\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:29:\"edit.php?post_type=dslc_staff\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:59:\"edit.php?post_type=dslc_staff>edit.php?post_type=dslc_staff\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"edit.php?post_type=dslc_staff\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:63:\"edit.php?post_type=dslc_staff>post-new.php?post_type=dslc_staff\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Add Staff\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:33:\"post-new.php?post_type=dslc_staff\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:29:\"edit.php?post_type=dslc_staff\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:63:\"edit.php?post_type=dslc_staff>post-new.php?post_type=dslc_staff\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:33:\"post-new.php?post_type=dslc_staff\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:93:\"edit.php?post_type=dslc_staff>edit-tags.php?taxonomy=dslc_staff_cats&amp;post_type=dslc_staff\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Categories\";s:12:\"access_level\";s:17:\"manage_categories\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:63:\"edit-tags.php?taxonomy=dslc_staff_cats&amp;post_type=dslc_staff\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:29:\"edit.php?post_type=dslc_staff\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:93:\"edit.php?post_type=dslc_staff>edit-tags.php?taxonomy=dslc_staff_cats&amp;post_type=dslc_staff\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:59:\"edit-tags.php?taxonomy=dslc_staff_cats&post_type=dslc_staff\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:5:\"Staff\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:29:\"edit.php?post_type=dslc_staff\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:10;s:6:\"parent\";N;s:9:\"css_class\";s:29:\"menu-top menu-icon-dslc_staff\";s:8:\"hookname\";s:21:\"menu-posts-dslc_staff\";s:8:\"icon_url\";s:12:\"dashicons-id\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:30:\">edit.php?post_type=dslc_staff\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"edit.php?post_type=dslc_staff\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:36:\"edit.php?post_type=dslc_testimonials\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:11;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:37:\">edit.php?post_type=dslc_testimonials\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:3:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:73:\"edit.php?post_type=dslc_testimonials>edit.php?post_type=dslc_testimonials\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:12:\"Testimonials\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:36:\"edit.php?post_type=dslc_testimonials\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:36:\"edit.php?post_type=dslc_testimonials\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:73:\"edit.php?post_type=dslc_testimonials>edit.php?post_type=dslc_testimonials\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"edit.php?post_type=dslc_testimonials\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:77:\"edit.php?post_type=dslc_testimonials>post-new.php?post_type=dslc_testimonials\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:15:\"Add Testimonial\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:40:\"post-new.php?post_type=dslc_testimonials\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:36:\"edit.php?post_type=dslc_testimonials\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:77:\"edit.php?post_type=dslc_testimonials>post-new.php?post_type=dslc_testimonials\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:40:\"post-new.php?post_type=dslc_testimonials\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:114:\"edit.php?post_type=dslc_testimonials>edit-tags.php?taxonomy=dslc_testimonials_cats&amp;post_type=dslc_testimonials\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:10:\"Categories\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:77:\"edit-tags.php?taxonomy=dslc_testimonials_cats&amp;post_type=dslc_testimonials\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:36:\"edit.php?post_type=dslc_testimonials\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:114:\"edit.php?post_type=dslc_testimonials>edit-tags.php?taxonomy=dslc_testimonials_cats&amp;post_type=dslc_testimonials\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:73:\"edit-tags.php?taxonomy=dslc_testimonials_cats&post_type=dslc_testimonials\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:12:\"Testimonials\";s:12:\"access_level\";s:13:\"publish_posts\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:36:\"edit.php?post_type=dslc_testimonials\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:11;s:6:\"parent\";N;s:9:\"css_class\";s:36:\"menu-top menu-icon-dslc_testimonials\";s:8:\"hookname\";s:28:\"menu-posts-dslc_testimonials\";s:8:\"icon_url\";s:22:\"dashicons-format-quote\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:37:\">edit.php?post_type=dslc_testimonials\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"edit.php?post_type=dslc_testimonials\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"ninja-forms\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:12;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:12:\">ninja-forms\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:7:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:38:\"ninja-forms>admin.php?page=ninja-forms\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:21:\"Todos los Formularios\";s:10:\"menu_title\";s:21:\"Todos los Formularios\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:26:\"admin.php?page=ninja-forms\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:11:\"ninja-forms\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:38:\"ninja-forms>admin.php?page=ninja-forms\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"admin.php?page=ninja-forms\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:50:\"ninja-forms>admin.php?page=ninja-forms&form_id=new\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:13:\"Añadir Nuevo\";s:10:\"menu_title\";s:13:\"Añadir Nuevo\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:38:\"admin.php?page=ninja-forms&form_id=new\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:11:\"ninja-forms\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:50:\"ninja-forms>admin.php?page=ninja-forms&form_id=new\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:38:\"admin.php?page=ninja-forms&form_id=new\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:37:\"ninja-forms>edit.php?post_type=nf_sub\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:10:\"Sumisiones\";s:10:\"menu_title\";s:10:\"Sumisiones\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:25:\"edit.php?post_type=nf_sub\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:11:\"ninja-forms\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:37:\"ninja-forms>edit.php?post_type=nf_sub\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:25:\"edit.php?post_type=nf_sub\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:28:\"ninja-forms>nf-import-export\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:17:\"Importar/Exportar\";s:10:\"menu_title\";s:17:\"Importar/Exportar\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"nf-import-export\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:11:\"ninja-forms\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:28:\"ninja-forms>nf-import-export\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=nf-import-export\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:23:\"ninja-forms>nf-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:7:\"Ajustes\";s:10:\"menu_title\";s:7:\"Ajustes\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"nf-settings\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";s:11:\"ninja-forms\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:23:\"ninja-forms>nf-settings\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"admin.php?page=nf-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:28:\"ninja-forms>nf-system-status\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:13:\"Obtener Ayuda\";s:10:\"menu_title\";s:13:\"Obtener Ayuda\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:16:\"nf-system-status\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:5;s:6:\"parent\";s:11:\"ninja-forms\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:28:\"ninja-forms>nf-system-status\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:31:\"admin.php?page=nf-system-status\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"ninja-forms>nf-addons\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:12:\"Complementos\";s:10:\"menu_title\";s:12:\"Complementos\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"nf-addons\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:6;s:6:\"parent\";s:11:\"ninja-forms\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"ninja-forms>nf-addons\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"admin.php?page=nf-addons\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:11:\"Formularios\";s:10:\"menu_title\";s:11:\"Formularios\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"ninja-forms\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:12;s:6:\"parent\";N;s:9:\"css_class\";s:34:\"menu-top toplevel_page_ninja-forms\";s:8:\"hookname\";s:25:\"toplevel_page_ninja-forms\";s:8:\"icon_url\";s:18:\"dashicons-feedback\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:12:\">ninja-forms\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"admin.php?page=ninja-forms\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"woocommerce\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:13;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:12:\">woocommerce\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:9:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:41:\"woocommerce>edit.php?post_type=shop_order\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:7:\"Pedidos\";s:10:\"menu_title\";s:7:\"Pedidos\";s:12:\"access_level\";s:16:\"edit_shop_orders\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:29:\"edit.php?post_type=shop_order\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:11:\"woocommerce\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:41:\"woocommerce>edit.php?post_type=shop_order\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:29:\"edit.php?post_type=shop_order\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:42:\"woocommerce>edit.php?post_type=shop_coupon\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:7:\"Cupones\";s:10:\"menu_title\";s:7:\"Cupones\";s:12:\"access_level\";s:17:\"edit_shop_coupons\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:30:\"edit.php?post_type=shop_coupon\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:11:\"woocommerce\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:42:\"woocommerce>edit.php?post_type=shop_coupon\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"edit.php?post_type=shop_coupon\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"woocommerce>wc_cancel\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:9:\"WC Cancel\";s:10:\"menu_title\";s:9:\"WC Cancel\";s:12:\"access_level\";s:18:\"manage_woocommerce\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"wc_cancel\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:11:\"woocommerce\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"woocommerce>wc_cancel\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"admin.php?page=wc_cancel\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:31:\"woocommerce>woo-dynamic-gallery\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:15:\"Dynamic Gallery\";s:10:\"menu_title\";s:15:\"Dynamic Gallery\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:19:\"woo-dynamic-gallery\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:11:\"woocommerce\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:31:\"woocommerce>woo-dynamic-gallery\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:34:\"admin.php?page=woo-dynamic-gallery\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:22:\"woocommerce>wc-reports\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:8:\"Informes\";s:10:\"menu_title\";s:8:\"Informes\";s:12:\"access_level\";s:24:\"view_woocommerce_reports\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:10:\"wc-reports\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";s:11:\"woocommerce\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:22:\"woocommerce>wc-reports\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:25:\"admin.php?page=wc-reports\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:5;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:5;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:23:\"woocommerce>wc-settings\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:22:\"Ajustes de WooCommerce\";s:10:\"menu_title\";s:7:\"Ajustes\";s:12:\"access_level\";s:18:\"manage_woocommerce\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"wc-settings\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:5;s:6:\"parent\";s:11:\"woocommerce\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:23:\"woocommerce>wc-settings\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"admin.php?page=wc-settings\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:6;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:6;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"woocommerce>wc-status\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:21:\"Estado de WooCommerce\";s:10:\"menu_title\";s:18:\"Estado del sistema\";s:12:\"access_level\";s:18:\"manage_woocommerce\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"wc-status\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:6;s:6:\"parent\";s:11:\"woocommerce\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"woocommerce>wc-status\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"admin.php?page=wc-status\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:7;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:7;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:21:\"woocommerce>wc-addons\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:28:\"Extensiones para WooCommerce\";s:10:\"menu_title\";s:11:\"Extensiones\";s:12:\"access_level\";s:18:\"manage_woocommerce\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:9:\"wc-addons\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:7;s:6:\"parent\";s:11:\"woocommerce\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:21:\"woocommerce>wc-addons\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:24:\"admin.php?page=wc-addons\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:8;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:8;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:35:\"woocommerce>custom_related_products\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:23:\"Custom Related Products\";s:10:\"menu_title\";s:23:\"Custom Related Products\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:23:\"custom_related_products\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:8;s:6:\"parent\";s:11:\"woocommerce\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:35:\"woocommerce>custom_related_products\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:38:\"admin.php?page=custom_related_products\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:11:\"WooCommerce\";s:10:\"menu_title\";s:11:\"WooCommerce\";s:12:\"access_level\";s:18:\"manage_woocommerce\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"woocommerce\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:13;s:6:\"parent\";N;s:9:\"css_class\";s:52:\"menu-top menu-icon-generic toplevel_page_woocommerce\";s:8:\"hookname\";s:25:\"toplevel_page_woocommerce\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:12:\">woocommerce\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:11:\"woocommerce\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}s:26:\"edit.php?post_type=product\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:14;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:27:\">edit.php?post_type=product\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:5:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:53:\"edit.php?post_type=product>edit.php?post_type=product\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Productos\";s:12:\"access_level\";s:13:\"edit_products\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:26:\"edit.php?post_type=product\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:26:\"edit.php?post_type=product\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:53:\"edit.php?post_type=product>edit.php?post_type=product\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"edit.php?post_type=product\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:57:\"edit.php?post_type=product>post-new.php?post_type=product\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:16:\"Añadir producto\";s:12:\"access_level\";s:13:\"edit_products\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:30:\"post-new.php?post_type=product\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:26:\"edit.php?post_type=product\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:57:\"edit.php?post_type=product>post-new.php?post_type=product\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:30:\"post-new.php?post_type=product\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:2;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:2;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:83:\"edit.php?post_type=product>edit-tags.php?taxonomy=product_cat&amp;post_type=product\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:11:\"Categorías\";s:12:\"access_level\";s:20:\"manage_product_terms\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:56:\"edit-tags.php?taxonomy=product_cat&amp;post_type=product\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:2;s:6:\"parent\";s:26:\"edit.php?post_type=product\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:83:\"edit.php?post_type=product>edit-tags.php?taxonomy=product_cat&amp;post_type=product\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:52:\"edit-tags.php?taxonomy=product_cat&post_type=product\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:3;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:3;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:83:\"edit.php?post_type=product>edit-tags.php?taxonomy=product_tag&amp;post_type=product\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Etiquetas\";s:12:\"access_level\";s:20:\"manage_product_terms\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:56:\"edit-tags.php?taxonomy=product_tag&amp;post_type=product\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:3;s:6:\"parent\";s:26:\"edit.php?post_type=product\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:83:\"edit.php?post_type=product>edit-tags.php?taxonomy=product_tag&amp;post_type=product\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:52:\"edit-tags.php?taxonomy=product_tag&post_type=product\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:4;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:4;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:45:\"edit.php?post_type=product>product_attributes\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:9:\"Atributos\";s:10:\"menu_title\";s:9:\"Atributos\";s:12:\"access_level\";s:20:\"manage_product_terms\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:18:\"product_attributes\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:4;s:6:\"parent\";s:26:\"edit.php?post_type=product\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:45:\"edit.php?post_type=product>product_attributes\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:50:\"edit.php?post_type=product&page=product_attributes\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:9:\"Productos\";s:12:\"access_level\";s:13:\"edit_products\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:26:\"edit.php?post_type=product\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:14;s:6:\"parent\";N;s:9:\"css_class\";s:26:\"menu-top menu-icon-product\";s:8:\"hookname\";s:18:\"menu-posts-product\";s:8:\"icon_url\";s:20:\"dashicons-admin-post\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:27:\">edit.php?post_type=product\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:26:\"edit.php?post_type=product\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}s:29:\"required_capability_read_only\";N;}s:28:\"woocommerce-checkout-manager\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:15;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:29:\">woocommerce-checkout-manager\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:2:{i:0;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:0;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:57:\"woocommerce-checkout-manager>woocommerce-checkout-manager\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:11:\"WooCheckout\";s:10:\"menu_title\";s:11:\"WooCheckout\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:28:\"woocommerce-checkout-manager\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:0;s:6:\"parent\";s:28:\"woocommerce-checkout-manager\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:57:\"woocommerce-checkout-manager>woocommerce-checkout-manager\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:43:\"admin.php?page=woocommerce-checkout-manager\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}i:1;a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:1;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:50:\"woocommerce-checkout-manager>wooccm-advance-export\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:6:\"Export\";s:10:\"menu_title\";s:6:\"Export\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:21:\"wooccm-advance-export\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:1;s:6:\"parent\";s:28:\"woocommerce-checkout-manager\";s:9:\"css_class\";s:0:\"\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:50:\"woocommerce-checkout-manager>wooccm-advance-export\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:36:\"admin.php?page=wooccm-advance-export\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:1;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:11:\"WooCheckout\";s:10:\"menu_title\";s:11:\"WooCheckout\";s:12:\"access_level\";s:14:\"manage_options\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:28:\"woocommerce-checkout-manager\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:15;s:6:\"parent\";N;s:9:\"css_class\";s:51:\"menu-top toplevel_page_woocommerce-checkout-manager\";s:8:\"hookname\";s:42:\"toplevel_page_woocommerce-checkout-manager\";s:8:\"icon_url\";s:21:\"dashicons-businessman\";s:9:\"separator\";b:0;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:29:\">woocommerce-checkout-manager\";s:14:\"is_plugin_page\";b:1;s:6:\"custom\";b:0;s:3:\"url\";s:43:\"admin.php?page=woocommerce-checkout-manager\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:11:\"separator_5\";a:31:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:16;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:1;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template_id\";s:12:\">separator_5\";s:14:\"is_plugin_page\";N;s:6:\"custom\";b:0;s:3:\"url\";N;s:16:\"embedded_page_id\";N;s:21:\"embedded_page_blog_id\";N;s:5:\"items\";a:0:{}s:12:\"grant_access\";a:0:{}s:7:\"missing\";b:0;s:6:\"unused\";b:0;s:6:\"hidden\";b:0;s:17:\"hidden_from_actor\";a:0:{}s:24:\"restrict_access_to_items\";b:0;s:24:\"had_access_before_hiding\";N;s:8:\"defaults\";a:22:{s:10:\"page_title\";s:0:\"\";s:10:\"menu_title\";s:0:\"\";s:12:\"access_level\";s:4:\"read\";s:16:\"extra_capability\";s:0:\"\";s:4:\"file\";s:11:\"separator_5\";s:12:\"page_heading\";s:0:\"\";s:8:\"position\";i:16;s:6:\"parent\";N;s:9:\"css_class\";s:17:\"wp-menu-separator\";s:8:\"hookname\";s:0:\"\";s:8:\"icon_url\";s:23:\"dashicons-admin-generic\";s:9:\"separator\";b:1;s:6:\"colors\";b:0;s:14:\"is_always_open\";b:0;s:7:\"open_in\";s:11:\"same_window\";s:13:\"iframe_height\";i:0;s:11:\"template_id\";s:12:\">separator_5\";s:14:\"is_plugin_page\";b:0;s:6:\"custom\";b:0;s:3:\"url\";s:0:\"\";s:16:\"embedded_page_id\";i:0;s:21:\"embedded_page_blog_id\";i:1;}}s:10:\"themes.php\";a:32:{s:10:\"page_title\";N;s:10:\"menu_title\";N;s:12:\"access_level\";N;s:16:\"extra_capability\";N;s:4:\"file\";N;s:12:\"page_heading\";N;s:8:\"position\";i:17;s:6:\"parent\";N;s:9:\"css_class\";N;s:8:\"hookname\";N;s:8:\"icon_url\";N;s:9:\"separator\";b:0;s:6:\"colors\";N;s:14:\"is_always_open\";N;s:7:\"open_in\";N;s:13:\"iframe_height\";N;s:11:\"template