<?php
/**
 * My Addresses
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/my-address.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$customer_id = get_current_user_id();

if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) {
	$get_addresses = apply_filters( 'woocommerce_my_account_get_addresses', array(
		'billing' => __( 'Billing Address', 'woocommerce' ),
		'shipping' => __( 'Shipping Address', 'woocommerce' )
	), $customer_id );
} else {
	$get_addresses = apply_filters( 'woocommerce_my_account_get_addresses', array(
		'billing' =>  __( 'Billing Address', 'woocommerce' )
	), $customer_id );
}

$oldcol = 1;
$col    = 1;
?>

<p style="margin-left: 10px;">
	<?php echo apply_filters( 'woocommerce_my_account_my_address_description', __( '
En esta sección puedes editar, agregar <i class="fa fa-plus-circle" aria-hidden="true"></i> ó eliminar <i class="fa fa-trash" aria-hidden="true"></i> tus distintas direcciones, y antes de finalizar tu compra podrás elegir a que dirección deseas que se realice la facturación y el envío.', 'woocommerce' ) ); ?>
</p>

<div class="bg-info" style="padding-left: 25px;padding-right: 25px;padding-top: 15px;margin-left: 10px;margin-right: 10px;border-radius: 5px;">
<p style="margin-bottom: 80px;padding-bottom: 15px;"><i class="fa fa-info-circle" aria-hidden="true" style="margin-right: 5px;"></i>
Para conservar los cambios realizados debes hacer click en el boton <b>"GUARDAR DIRECCIONES"</b> ubicado en la parte inferior de esta página, al finalizar todas tus operaciones.
</p>
</div>


<?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) echo '<div class="u-columns woocommerce-Addresses col2-set addresses adress-config-content">'; ?>


<?php echo  do_shortcode('[woocommerce_multiple_shipping_addresses]'); ?>



<!-- Modulo de direcciones por defecto (OCULTO) -->

<div class="hide">
<?php foreach ( $get_addresses as $name => $title ) : ?>

	<div class="u-column<?php echo ( ( $col = $col * -1 ) < 0 ) ? 1 : 2; ?> col-<?php echo ( ( $oldcol = $oldcol * -1 ) < 0 ) ? 1 : 2; ?> woocommerce-Address">
		<header class="woocommerce-Address-title title">
			<h3><?php echo $title; ?></h3>
			<a href="<?php echo esc_url( wc_get_endpoint_url( 'edit-address', $name ) ); ?>" class="edit"><?php _e( 'Editar <i class="fa fa-pencil" aria-hidden="true"></i>', 'woocommerce' ); ?></a>
		</header>
		<address>
			<?php
				$address = apply_filters( 'woocommerce_my_account_my_address_formatted_address', array(
					'first_name'  => get_user_meta( $customer_id, $name . '_first_name', true ),
					'last_name'   => get_user_meta( $customer_id, $name . '_last_name', true ),
					'company'     => get_user_meta( $customer_id, $name . '_company', true ),
					'address_1'   => get_user_meta( $customer_id, $name . '_address_1', true ),
					'address_2'   => get_user_meta( $customer_id, $name . '_address_2', true ),
					'city'        => get_user_meta( $customer_id, $name . '_city', true ),
					'state'       => get_user_meta( $customer_id, $name . '_state', true ),
					'postcode'    => get_user_meta( $customer_id, $name . '_postcode', true ),
					'country'     => get_user_meta( $customer_id, $name . '_country', true )
				), $customer_id, $name );

				$formatted_address = WC()->countries->get_formatted_address( $address );

				if ( ! $formatted_address )
					_e( 'You have not set up this type of address yet.', 'woocommerce' );
				else
					echo $formatted_address;
			?>

		</address>
	</div>

<?php endforeach; ?>
</div>

<!-- <a class="direcciones-btn" href="../direcciones/"><div>configurar</div></a> -->



<?php if ( ! wc_ship_to_billing_address_only() && wc_shipping_enabled() ) echo '</div>'; ?>
